<?php

use Pheanstalk\Pheanstalk;
use Pheanstalk\PheanstalkInterface;

class Queue
{
	private $Pheanstalk;
	private $Prefix;
	private $Job;

	/**
	 * Constructor
	 * 
	 */
	public function __construct($prefix="resrequest", $principalPrefix=false)
	{
		global $principal_id;

		try {
			$this->Pheanstalk = new Pheanstalk('127.0.0.1');
		} catch(Exception $e) {
			// TODO implement monitoring
			error_log("Unable to connect to Beanstalk queue");
		}
		$this->Prefix = $prefix . "_";
		if($principalPrefix) {
			$this->Prefix .= $principal_id . "_";
		}
	}

	public function watch($tube)
	{
		try {
			$this->Pheanstalk
				->watch($this->Prefix . $tube)
				->ignore('default');
		} catch(Exception $e) {
			// TODO implement monitoring
			error_log("Unable to watch to Beanstalk queue");
			return false;
		}
	}

	public function next()
	{
		try {
			if($this->Job = $this->Pheanstalk->reserve()) {
				return json_decode($this->Job->getData(),true);
			} else {
				return false;
			}
		} catch(Exception $e) {
			// TODO implement monitoring
			error_log("Unable to fetch job from Beanstalk queue");
			return false;
		}
	}

	public function delete()
	{
		try {
			if($this->Job) {
				return $this->Pheanstalk->delete($this->Job);
			} else {
				return false;
			}
		} catch(Exception $e) {
			// TODO implement monitoring
			error_log("Unable to delete job from Beanstalk queue");
			return false;
		}
	}

	public function release($delay=0)
	{
		try {
			$this->Pheanstalk->release($this->Job, PheanstalkInterface::DEFAULT_PRIORITY, $delay);
			$this->Job = false;
		} catch(Exception $e) {
			// TODO implement monitoring
			error_log("Unable to release job from Beanstalk queue");
			return false;
		}

		return true;
	}

	public function create($tube, $data)
	{
		try {
			return $this->Pheanstalk->useTube($this->Prefix . $tube)->put(json_encode($data));
		} catch(Exception $e) {
			// TODO implement monitoring
			error_log("Unable to add job to Beanstalk queue");
			return false;
		}
	}

	public function stats()
	{
		try {
			return $this->Pheanstalk->stats();
		} catch(Exception $e) {
			error_log("Unable to get Beanstalk stats");
			return false;
		}
	}
}
