<?php

/**
 * class.rate.abstract.php - Common rates code class
 */

class AbstractRate
{
	var $AccommTypeId;

	var $ArriveDate;
	var $DepartDate;
	var $EndDate;
	var $Nights;

	var $People;
	var $Units;

	var $Optionals;
	var $Override;
	var $ReservationId;
	var $RateTypeId;
	var $Commission;
	var $Exchange;
	var $Deduct;

	var $Generated;
	var $PeriodSplit;
	var $PeriodSplitDefault;
	var $PeriodSplitSingleDay;
	
	var $RateGroups;
	var $Periods;

	function SetAccommTypeId($sAccommTypeId)
	{
		$this->AccommTypeId = $sAccommTypeId;
		$this->ResetData();
	}

	function SetArriveDate($sArriveDate)
	{
		if(empty($sArriveDate)) {
			$this->ArriveDate = date("Y-m-d");
		} else {
			$this->ArriveDate = $sArriveDate;
		}
		$this->ResetData();
	}

	function SetDepartDate($sDepartDate)
	{
		if(empty($sDepartDate)) {
			$dateArray = explode("-",$this->ArriveDate);
			$this->DepartDate = date("Y-m-d",mktime(0,0,0,$dateArray[1],$dateArray[2]+1,$dateArray[0]));
		} else {
			$this->DepartDate = $sDepartDate;
		}

		$dateArray = explode("-",$this->DepartDate);
		$this->EndDate = date("Y-m-d",mktime(0,0,0,$dateArray[1],$dateArray[2]-1,$dateArray[0]));

		$this->ResetData();
	}
	
	function SetNights()
	{
		$this->Nights = dateSubtract($this->DepartDate, $this->ArriveDate);

		$this->ResetData();
	}	

	function SetRateTypeId($sRateTypeId)
	{
		global $lDB;

		if(empty($sRateTypeId)) {
			$sRateTypeId = "";
			if($_SESSION['userStatusId'] < 2) {
				if($GLOBALS['calAgentId'] != "0") {
					$rateList = $lDB->get("
						SELECT
							pr_agent_rate.rt_rate_type_id
						FROM
							pr_agent_rate
						WHERE
							pr_agent_rate.pr_agent_id = '$GLOBALS[calAgentId]'
						ORDER BY
							pr_agent_rate.pr_agent_rate_default_yn DESC
					",3);
					if(sizeof($rateList) > 0) {
						$sRateTypeId = $rateList[0];
					}
				}
			} else if($_SESSION['userStatusId'] > 1) {
				$sRateTypeId = trim($lDB->get("SELECT rt_rate_type_id FROM rf_default",4));
			}
			if($sRateTypeId == "") {
				$rateList = $lDB->get("SELECT rf_default_rate_id FROM rf_default_rate",4);
			}
			$this->RateTypeId = $sRateTypeId; // FIXME: Needs to find the default
		} else {
			$this->RateTypeId = $sRateTypeId;
		}		
		$this->ResetData();				
	}

	function SetOptionals($sOptionals)
	{
		if(!is_array($sOptionals)) {
			$sOptionals = array();
		}

		$this->Optionals = array();
		foreach($sOptionals as $rt_component_id) {
			if(db_rt_component_exists($rt_component_id)) {
				array_push($this->Optionals,$rt_component_id);
			}
		}
	}

	function SetOverride($overide)
	{
		// Expected structure of $overide
		// 	"level"		=> "1",
		//	"amounts"	=> array(
		//		"stay"			=>	"500.00",
		//		"rate_group"	=>	array(
		//			"RS1"	=>	"450.00",
		//			"RS2"	=>	"350.00",
		//			"RS3"	=>	"300.00"
		//		)
		//	)
	
		if(empty($overide)) {
			$this->Override = false;
		} elseif(is_array($overide)) {
			$hasValue = false;
			foreach($overide['amounts'] as $group) {
				if(is_array($group)) {
					foreach($group as $rateGroupAmt) {
						if($rateGroupAmt != "") {
							$hasValue = true;
						}
					}	
				} else {
					if($group != "") {
						$hasValue = true;
					}				
				}
			}

			if($hasValue) {
				$this->Override = $overide;
			} else {
				$this->Override = false;
			}
		}
	
	}

	function SetReservationId($sReservationId,$sRateTypeId,$sCommission,$sExchange,$sDeduct)
	{
		global $lDB;

		$this->SetRateTypeId($sRateTypeId);
		$this->SetCommission($sCommission);
		$this->SetExchange($sExchange);
		$this->SetDeduct($sDeduct);		
		if($sReservationId !== false && db_rv_reservation_exists($sReservationId)) {
			$this->ReservationId = $sReservationId;
			$itemInfo = $lDB->get("
				SELECT
					rv_reservation.rv_commission_perc,
					rv_reservation.rv_commission_deduct_yn,
					rv_reservation.rv_exchg_rate,
					rv_reservation.rt_rate_type_id
				FROM
					rv_reservation
				WHERE
					rv_reservation.rv_reservation_ix = '$sReservationId'
			",1);
			if($sRateTypeId === false) {
				$this->SetRateTypeId($itemInfo['rt_rate_type_id']);
			}
			if($sCommission === false) {
				$this->SetCommission($itemInfo['rv_commission_perc']);
			}
			if($sExchange === false) {
				$this->SetExchange($itemInfo['rv_exchg_rate']);
			}
			if($sDeduct === false) {
				$this->SetDeduct($itemInfo['rv_commission_deduct_yn']);
			}
		} else {
			$this->ReservationId = false;
		}
	}

	function SetCommission($sCommission)
	{
		global $lDB;

		if($sCommission === false) {
			if($GLOBALS['calAgentId'] != "0") {
				$this->Commission = $lDB->get("SELECT pr_agent_commission_perc FROM pr_agent WHERE pr_agent_id = '$GLOBALS[calAgentId]'",4);
			} else {
				$this->Commission = 0;
			}
		} else {
			$this->Commission = $sCommission;
		}
		$this->ResetData();				
	}

	function SetExchange($sExchange)
	{
		if(empty($sExchange)) {
			$this->Exchange = 1;
		} else {
			$this->Exchange = $sExchange;
		}
		$this->ResetData();				
	}

	function SetDeduct($sDeduct)
	{
		global $lDB;

		if($sDeduct === false || trim($sDeduct) == "") {
			$sDeduct = $lDB->get("SELECT pr_agent_comm_deduct_yn FROM pr_agent WHERE pr_agent_id = '$GLOBALS[calAgentId]'",4);
		}

		if(empty($sDeduct)) {
			$this->Deduct = "gross"; // 0
		} else {
			$this->Deduct = "nett"; // 1
		}
	}

	
	function ResetData()
	{
		global $lDB;

		$this->Generated = false;
		$this->PeriodSplit = $this->PeriodSplitDefault;
		$this->Periods = array();
	}

	function Generate()
	{

		if($this->Generated) {
			return;
		}

		$this->BuildPeriod();
		
		$this->BuildComponent();
		$this->BuildCharge();

		$this->Generated = true;
	}

	function IsTBA()
	{
		$this->Generate();
		$isTBA = false;
		if(sizeof($this->Periods) == 0) {
			$isTBA = true;
		} else {
			foreach($this->Periods as $period) {
				if(sizeof($period['components']) == 0) {
					$isTBA = true;
				}
			}
		}
		return $isTBA;
	}

	function ToPeriods()
	{
		$this->Generate();

		return $this->Periods;
	}

	function ToTotal($type="payable")
	{
		$this->Generate();

		if($this->IsTBA()) {
			return "tba";
		} else {
			$total = 0;
			foreach($this->Periods as $period) {
				$total += $period['rv_item_amt_'.$type];
			}
			return $total;
		}
	}
	
	function ToRateGroups()
	{
		return $this->RateGroups;
	}		

	function ToPeople()
	{
		return $this->People;
	}
	
}
