<?php

require_once(__DIR__ . '/class.form.php');
require_once(__DIR__ . '/class.report.param.php');
require_once(__DIR__ . '/functions.profile.php');
require_once(__DIR__ . '/functions.report.php');
require_once(__DIR__ . '/class.newrelic.php');

class Report {
    var $Form;
    var $Name;
    var $Title;
    var $Profile;
    var $InfoTag;
    var $Generated;
    var $Render;
    var $FilterWidths;
    var $Params;
    var $ArgTotal;
    var $State;
    var $Data;
    var $CustomHTML;
    var $Scripts;
    var $Validations;
    public $newRelic;
    public $class;

    function __construct($form,$name,$title) {
        $this->Form = $form;
        $this->Name = $name;
        $this->Title = $title;
        $this->InfoTag = "info_".$name.__DIR__ . "/../../../public/html/.htm";
        $this->ArgTotal = 0;
        $this->FilterWidths = array('label'=>"100",'button'=>"100");
        $this->Params = array();
        $this->Fields = array();
        $this->Joins = array();
        $this->State = "uninitialised";
        $this->Data = false;
        $this->RenderOptions =array("openCSV");
        $this->CustomHTML = "";
        $this->Scripts = array();
        $this->Validations = array();
        $this->newRelic = new NewRelic();
        $this->class = static::class;
    }

    function Config() {
        die("Error: Config() undefined. This function configures the report and builds up the paramaters.");
    }

    function Init() {
        if($this->State == "uninitialised") {
            // Configure the report
            $this->Config();

            // Use the POSTed URL if available to avoid hitting the maximum URL length
            importURL();

            // Check if generated based on the number of items in the URL
            $this->Generated = $_SERVER['argc'] > 1;

            // Check that all parameters are valid and correctly set up
            $this->ParamCheck();

            // Allocate argv's to each parameter
            $this->ParamArg();

            // Set up the report profile
            $this->Profile = reportProfile($this->Title,$this->Name,$this->GetParamProfile());

            if($this->Profile !== false) {
                if(!empty($this->Profile['pf_option_title'])) {
                    $title = $this->Profile['pf_option_title'] . " (" . $this->Title . ")";
                } else {
                    $title = $this->Title;
                    if(!empty($this->Profile['pf_option_name'])) {
                        $title .= " (" . $this->Profile['pf_option_name'] . ")";
                    }
                }
                $this->Title = $title;
                $GLOBALS['temp']['title'] = $title;
                unset($title);
            }

            // Initialise parameters
            $this->ParamInit();

            // Create form object
            createFormObject($this->Form,__DIR__ . "/../../../public/html/rep_template.htm");


            $this->State = "initialised";
        } else {
            die("Error: Report already initialised");
        }
    }

    function Build() {
        die("Error: Build() undefined. This function takes the final report parameters and uses returns an array of data for rendering.");
    }

    function HTML() {
        die("Error: HTML() undefined. This function takes the report data and returns an HTML representation of the data.");
    }

    function CSV() {
        die("Error: CSV() undefined. This function takes the report data and returns a CSV representation.");
    }

    function PDF() {
        die("Error: PDF() undefined. This function takes the report data and returns a PDF representation.");
    }

    function Render() {
        // Initialise the Report, this reads in the various parameters that have been set and runs some automated checks
        if($this->State == "uninitialised") {
            $this->Init();
        }

        if($this->State == "initialised") {
            // Populate global template values
            $GLOBALS['temp']['mainWindowPage'] = $this->Name;
            $GLOBALS['temp']['filterLabelWidth'] = $this->FilterWidths['label'];
            $GLOBALS['temp']['filterButtonWidth'] = $this->FilterWidths['button'];

            // Set info tag
            if(file_exists($this->InfoTag)) {
                $GLOBALS['temp']['infoTagCol'] = "<col width=\"25\" />";
                $GLOBALS['temp']['infoTag'] = "
					<td align=\"center\" class=\"outDk\">
						<img src=\"/resource/Resrequest/Application/public/img/info_std.gif\" width=\"18\" height=\"18\" class=\"imgLink\" onMouseOver=\"openInfoPop('$report[infoTag]',event,500,370)\" onMouseOut=\"cancelTimer()\" alt=\"\" />
					</td>
				";
            } else {
                $GLOBALS['temp']['infoTagCol'] = "";
                $GLOBALS['temp']['infoTag'] = "";
            }

            // Display relevant export buttons
            $exportHTML = "";
            foreach ($this->RenderOptions as $renderOption){
                switch ($renderOption){
                    case "openCSV":
                        $exportHTML .= "<button type=\"button\" class=\"button txtc\" onclick=\"openCSV();\" id=\"btnOpenCSV\" >
										<span>Export CSV</span>
									</button>";
                        break;
                    case "openPDF":
                        $exportHTML .= "<button type=\"button\" class=\"button txtc\" onclick=\"openPDF();\" id=\"btnOpenPDF\" >
										<span>Open as PDF</span>
									</button>";
                        break;
                    case "emailSelected":
                        $exportHTML .= "<button type=\"button\" class=\"button txtc\" onclick=\"emailSelected();\" id=\"btnEmailSelected\" >
										<span>Email Selected</span>
									</button>";
                        break;
                }
            }
            $GLOBALS['temp']['export_buttons'] = $exportHTML;

            //
            // <input type="button" id="emailPdf" onclick="sendPDF()" class="button bEmail" style="width: 110px; height: 20px;" value="Email as PDF" />&nbsp;&nbsp;
            // <input type="button" id="emailCsv" onclick="sendCSV()" class="button bEmail" style="width: 110px; height: 20px;" value="Email as XLS" />&nbsp;&nbsp;
            // <input type="button" id="showExportMenu" onclick="showExportMenu(event,1);"  class="button bDropDown" style="width: 110px; height: 20px; background-position: right right;" value="Export Results">
            //

            // Render all parameters
            $this->ParamRender();

            // If the report is being generated, render the data output
            if($this->Generated) {
                $this->Build();
                /*			if(!function_exists("repData")) {
                                die("Error: repData() undefined. This function takes the final report parameters as input and returns an array of data for rendering.");
                            }
                $data = repData($report); */
                $render =& $this->GetParam("render");
                if($render->Mode == "html") {

                    $GLOBALS['temp']['reportGenerated'] = "";
                    $GLOBALS['temp']['showHideButtonText'] = ">> Show Filters";
                    $GLOBALS['temp']['filterStatus'] = "collapse printCollapse";

                    $GLOBALS['temp']['makeReport'] = "";
                    setLastReport("reservation.php?" . join("+",$_SERVER['argv']));
                    $GLOBALS['temp']['output'] = $this->HTML();
                    $GLOBALS['temp']['customHTML'] = $this->CustomHTML;

                    $generalNotification = "";
                    if (isset($this->GeneralNotification) && !empty($this->GeneralNotification)) {
                        $generalNotification = is_array($this->GeneralNotification) ? "<li> " . join("</li><br><li> ", array_unique($this->GeneralNotification)) . "</li>" : $this->GeneralNotification;
                        $generalNotification = '<div style="padding: 10px; background-color: #fff6ee; width:750px; margin-bottom: 3px; text-align: left;">
                            <p>' . $generalNotification . '</p>
                        </div>';
                    }
                    $GLOBALS['temp']['generalNotification'] = $generalNotification;
                }
                if ($render->Mode == "csv" ) {
                    $csv = $this->CSV();
                    repOutputCSV($this->Title . " generated on " . date("Y-m-d"),$csv);
                }
                if($render->Mode == "pdf") {
                    $pdf = $this->PDF();
                }
            } else {
                $GLOBALS['temp']['reportGenerated'] = " class=\"collapse printCollapse\" ";
                $GLOBALS['temp']['showHideButtonText'] = "<< Hide Filters";
                $GLOBALS['temp']['filterStatus'] = "";
                $GLOBALS['temp']['customHTML'] = $this->CustomHTML;
            }
            $this->State = "rendered";
        } else {
            die("Error: Report already rendered");
        }
    }

    function AddParam($param) {
        $param->Report =& $this;
        $this->Params[] = $param;
    }

    function AddParams($params) {
        foreach($params as $param) {
            $this->AddParam($param);
        }
    }

    function &GetParam($name) {
        $param = false;
        foreach($this->Params as $k=>$i) {
            $param =& $this->Params[$k]->GetParam($name);
            if($param !== false) {
                $returnValue = $param;
                return $returnValue;	// function needs to return a valid variable
            }
        }
        $returnValue = false;
        return $returnValue;	// function needs to return a valid variable
    }

    function &GetParamValue($name) {
        $param =& $this->GetParam($name);
        return $param->Value;
    }

    function &GetParamSQL($name) {
        $param =& $this->GetParam($name);
        $result = $param->SQL();
        return $result;
    }

    function &ConcatParamValues($names=array(),$join="\n") {
        $values = array();
        foreach($names as $name) {
            $values[] = $this->GetParamValue($name);
        }
        return join($join,$values);
    }

    function &ConcatParamSQL($names=array(),$join=array()) {
        $values = array();
        foreach($names as $name) {
            $values[] = $this->GetParamSQL($name);
        }
        if(is_array($join)) {
            return $values;
        } else {
            return join($join,$values);
        }
    }

    function ArgAlloc() {
        $this->ArgTotal++;
        return $this->ArgTotal;
    }

    function GetParamNames() {
        $names = array();
        foreach($this->Params as $k=>$param) {
            $names = array_merge($names,$this->Params[$k]->GetNames());
        }
        return $names;
    }

    function GetParamProfile() {
        $names = $this->GetParamNames();
        $profile = array();
        foreach($names as $name) {
            $param =& $this->GetParam($name);
            if($param->Arg !== false) {
                if($param->Profile) {
                    $profile[$param->Arg] = $name;
                } else {
                    $profile[$param->Arg] = "";
                }
            }
        }
        return $profile;
    }

    function ParamCheck() {
        $names = array_count_values($this->GetParamNames());
        foreach($names as $name=>$check) {
            if(!empty($name) && $check > 1) {
                die("Error: Duplicate name '$name' in report parameters");
            }
        }
    }

    function ParamArg() {
        $this->AddParam(new ReportParamRender("render"));
        foreach($this->Params as $k=>$param) {
            $this->Params[$k]->GetArg();
        }
    }

    function ParamInit() {
        foreach($this->Params as $k=>$param) {
            $this->Params[$k]->Init();
        }
    }

    function ParamRender() {
        $params = "";
        $scripts = $this->Scripts;
        foreach($this->Params as $k=>$param) {
            $params .= $this->Params[$k]->RenderAll();
            $scripts = array_merge($scripts,$this->Params[$k]->RenderScripts());
        }
        $scripts = array_unique($scripts);
        $scriptHTML = "";
        foreach($scripts as $script) {
            $scriptHTML .= "<script type=\"text/javascript\" src=\"/resource/Resrequest/Application/public/include/js/$script\"></script>\n";
        }

        $validations = "<script>var validations = ";
        if(sizeof($this->Validations) > 0) {
            $validations .= json_encode($this->Validations);
        } else {
            $validations .= "[]";
        }
        $validations .= ";</script>";

        $filters = $scriptHTML . $validations . $params;
        $GLOBALS['temp']['filters'] = $filters;
    }

    function AddScript($script) {
        $this->Scripts[] = $script;
    }

    function AddValidation($validation) {
        $this->Validations[] = $validation;
    }
}

class ReportSQL {
    var $Select;
    var $From;
    var $Where;
    var $Group;
    var $Order;
    var $Distinct;

    function __construct($select=array(), $from=array(), $where=array(), $group=array(), $order=array(), $distinct=false) {
        $this->Select = $select;
        $this->From = $from;
        $this->Where = $where;
        $this->Group = $group;
        $this->Order = $order;
        $this->Distinct = $distinct;
    }

    function AddSelect($select) {
        if(is_array($select)) {
            foreach($select as $item) {
                $this->Select[] = $item;
            }
        } else {
            $this->Select[] = $select;
        }
    }

    function AddFrom($from) {
        if(is_array($from)) {
            foreach($from as $item) {
                $this->From[] = $item;
            }
        } else {
            $this->From[] = $from;
        }
    }

    function AddWhere($where) {
        if(is_array($where)) {
            foreach($where as $item) {
                $this->Where[] = $item;
            }
        } else {
            $this->Where[] = $where;
        }
    }

	function AddGroup($group) {
        if(is_array($group)) {
            foreach($group as $item) {
                $this->Group[] = $item;
            }
        } else {
            $this->Group[] = $group;
        }
	}

    function AddOrder($order) {
        if(is_array($order)) {
            foreach($order as $item) {
                $this->Order[] = $item;
            }
        } else {
            $this->Order[] = $order;
        }
    }

    function Merge($sql) {
        $this->AddSelect($sql->Select);
        $this->AddFrom($sql->From);
        $this->AddWhere($sql->Where);
    }

    function Run($debug=false) {
        global $lDB;

        $this->Select = array_unique($this->Select);
        $this->From = array_unique($this->From);
        $this->Where = array_unique($this->Where);
        $this->Group = array_unique($this->Group);
        $this->Order = array_unique($this->Order);
        $distinct = ($this->Distinct) ? "DISTINCT" : "";

        $sql = "
			SELECT $distinct
				".join(",\n",$this->Select)."
			FROM
				".join("\n",$this->From)."
		";

        if(sizeof($this->Where) > 0) {
            $sql .= "
				WHERE
					1
					".join("\n",$this->Where)."
			";
        }

        if(sizeof($this->Group) > 0) {
            $sql .= "
				GROUP BY
					".join(",\n",$this->Group)."
			";
        }

        if(sizeof($this->Order) > 0) {
            $sql .= "
				ORDER BY
					".join(",\n",$this->Order)."
			";
        }

        return $lDB->get($sql,6,($debug?1:0));
    }

    function setDistinct($distinct) {
        $this->Distinct = $distinct;
    }
}

function ReportSQLBuilderOrderCompare($a, $b) {
    if ($a['order'] == $b['order']) {
        return 0;
    }
    return ($a['order'] < $b['order']) ? -1 : 1;
}


class ReportSQLBuilder {
    var $Builder;
    var $Fields;
    var $Joins;
    var $Extras;

    function __construct($builder=array(),$fields=array(),$joins=array(),$extras=array()) {
        $this->Builder = $builder;
        $this->Fields = $fields;
        $this->Joins = $joins;

        $active = array();

        if($builder !== false) {  // Disable use of the report builder completely
            foreach($fields as $field) {
                $name = $field['name'];
                if(isset($this->Builder[$name]['active']) && $this->Builder[$name]['active'] == "1") {
                    $active[$name] = array_merge($field,$builder[$name]);
                }
            }
            uasort($active, "ReportSQLBuilderOrderCompare");
        }

        if($extras !== false) {
            if(is_array($extras)) {
                $this->Extras = $extras;
            } else {
                $this->Extras = array($extras);
            }
            foreach($this->Extras as $extra) {
                $found = false;
                foreach($fields as $field) {
                    if($field['name'] == $extra) {
                        $active[$extra] = $field;
                        $found = true;
                    }
                }
                if(!$found) {
                    $active[$extra] = array('name'=>$extra,'fields'=>array($extra));
                }
            }
        }

        if($builder === false && $extras === false) {
            // Include ALL fields
            foreach($fields as $field) {
                $active[$field['name']] = $field;
            }
        }

        $this->Fields = $active;
    }

    function SQL() {
        $select = array();
        $from = array();
        $order = array();

        foreach($this->Fields as $name=>$item) {
            if(isset($item['type']) && $item['type'] == "external") continue;

            $fields = $this->getFieldList($item['fields']);
            if(array_key_exists("key",$item)) {
                if(!is_array($item['key'])) {
                    array_push($fields,$item['key']);
                } else {
                    $fields = array_merge($fields,$item['key']);
                }
            }

            foreach($fields as $field) {
                $tableName = isset($item['table']) ? $item['table'] : $this->getFieldTable($field);
                $isCompound = isset($item['isCompound']) ? $item['isCompound'] : $this->getFieldTable($field);
                if($this->inJoin($tableName) && !in_array($field,$select)) {
                    array_push($select,$field);
                    $joins = $this->getJoins($tableName, []);
                    if($joins) {
                        $from = array_merge($from, $joins);
                    }
                }
            }

        }
        $select = array_unique($select);
        $from = array_unique($from);

        return new ReportSQL($select, $from);
    }

    function getFields() {
        return $this->Fields;
    }

    /*
     * This function retrieves the table, field, and alias from a field. If the field is in
     * the format table.field then the field will be returned simply as 'field'. This could cause a problem in cases where
     * multiple field selections have the same field name e.g. agent_persona.pr_name_first and originator_persona.pr_name_first.
     * This could cause invalid data to be retrieved and filtered as both selects would simply register as pr_name_first. A workaround
     * to this problem would be to alias those fields: agent_persona.pr_name_first AS agent_first_name or even
     * agent_persona.pr_name_first AS agent_persona.pr_name_first.
     */
    function getFieldArray($field) {
        $pattern = '/^(?P<field>.*?(?P<table>\b\w*\b)\.(?P<subfield>\b\w*\b).*?)(?: as (?P<alias>.+))?$/i';
        preg_match($pattern, $field, $matches);
        $table = $matches['table'];
        $field = $matches['field'];
        $subField = $matches['subfield'];
        if(trim($field) == trim($table.'.'.$subField)) {
            $field = $subField;
        }
        $alias = '';
        if(array_key_exists('alias', $matches)) {
            $alias = $matches['alias'];
        }
        return array('table'=>$table, 'field'=>$field, 'alias'=>$alias);
    }

    function getFieldName($field) {
        $fieldArray = $this->getFieldArray($field);
        if($fieldArray['alias'] != "") {
            return $fieldArray['alias'];
        } else {
            return $fieldArray['field'];
        }
    }

    function getFieldTable($field) {
        $fieldArray = $this->getFieldArray($field);
        return $fieldArray['table'];
    }

    function getFieldList($fields) {
        if(is_array($fields)) {
            return $fields;
        } else {
            return array($fields);
        }
    }

    function inJoin($alias) {
        foreach($this->Joins as $join) {
            if( (isset($join['alias']) && $join['alias'] == $alias) || (isset($join['table']) && $join['table'] == $alias) ) {
                return true;
            }
        }
        return false;
    }

    /*
     * @param alias - The table that the joins should be retrieved for.
     * @param $joined - The list of tables that have been joined to avoid infinite recursion.
     */
    function getJoins($alias, $joined) {
        if(in_array($alias, $joined)) {
            return false;
        }
        foreach($this->Joins as $join) {
            if( (isset($join['alias']) && $join['alias'] == $alias) || ( (!isset($join['alias']) || $join['alias'] == "") && (isset($join['table']) && $join['table'] == $alias) ) ) {
                if(!array_key_exists("type",$join)) {
                    return array($join['table']);
                } else {
                    if( (!isset($join['alias']) || $join['alias'] == "") || (isset($join['alias']) && isset($join['table']) && $join['alias'] == $join['table']) ) {
                        $result = array("$join[type] JOIN $join[table] ON $join[on]");
                    } else {
                        $result = array("$join[type] JOIN $join[table] AS $join[alias] ON $join[on]");
                    }
                    $joined = array_merge($joined, array($alias));
                    if($join['requires'] != "") {
                        // Allow multiple tables to be required
                        $requires = explode(',', $join['requires']);
                        foreach($requires as $require) {
                            $joins = $this->getJoins($require, $joined);
                            if(!$joins) {
                                continue;
                            }
                            $result = array_merge($joins, $result);
                        }
                        $result = array_unique($result);
                    }
                    if(array_key_exists('includes', $join) && $join['includes'] != "") {
                        // Allow multiple tables to be included
                        $includes = explode(',', $join['includes']);
                        foreach($includes as $include) {
                            $joins = $this->getJoins($include, $joined);
                            if(!$joins) {
                                continue;
                            }
                            $result = array_merge($result, $joins);
                        }
                        $result = array_unique($result);
                        return $result;
                    } else {
                        return $result;
                    }
                }
            }
        }
    }

    function Group(&$data,$groups) {
        $newData = array();
        foreach($data as $item) {
            $keys = array();
            foreach($groups as $grouping) {
                array_push($keys,$item[$grouping . "_key"]);
            }

			$keys = array_reduce($keys, function($carry, $key) {
				$new = [];
				foreach($carry as $carryItem) {
					foreach($key as $keyItem) {
						$newItem = $carryItem;
						array_push($newItem, $keyItem);
						$new[] = $newItem;
					}
				}
				return $new;
			}, [[]]);
			foreach($keys as $keyArray) {
				$key = join("_",$keyArray);
	            if(!array_key_exists($key,$newData)) {
    	            $newData[$key] = array();
        	    }
				$newItem = $item;
				foreach($groups as $groupKey=>$group) {
					if(is_array($newItem[$group . "_key"])) {
						$newItem[$group . "_key"] = $keyArray[$groupKey];
					}
					if(is_array($newItem[$group])) {
						$newItem[$group] = $item[$group][$keyArray[$groupKey]];
					}
					if(array_key_exists($group . "_sort", $newItem) && is_array($newItem[$group . "_sort"])) {
						$newItem[$group . "_sort"] = $item[$group . "_sort"][$keyArray[$groupKey]];
					}
				}
            	$newData[$key][] = $newItem;
			}
        }
        $data = $newData;

        unset($newData);

        $newData = array();
        foreach($data as $key=>$item) {

            $newItem = array();
            foreach($this->Fields as $field) {
                if(!array_key_exists("group",$field) || $field['group'] == "first") {
                    $newItem[$field['name']] = $item[0][$field['name']];
                }

                if(isset($field['group']) && $field['group'] == "last") {
                    $newItem[$field['name']] = $item[sizeof($item)-1][$field['name']];
                }

                if(isset($field['group']) && $field['group'] == "array") {
                    $items = array();
                    foreach($item as $row) {
                        $items[] = $row[$field['name']];
                    }
                    $newItem[$field['name']] = array_unique($items);
                }

                if(isset($field['group']) && $field['group'] == "complex") {
                    if(function_exists($field['group_function'])) {
                        $value = call_user_func_array($field['group_function'],array($item,$field['name']));
                    } else {
                        $value = "NOT IMPLEMENTED";
                    }
                    $newItem[$field['name']] = $value;
                }

                if(array_key_exists("key",$field)) {
                    $newItem[$field['name'] . "_key"] = $item[0][$field['name'] . "_key"];
                }

                if(array_key_exists($field['name'] . "_sort",$item[0])) {
                    $newItem[$field['name'] . "_sort"] = $item[0][$field['name'] . "_sort"];
                }
            }
            $newData[$key] = $newItem;
        }

        $data = $newData;
        unset($newData);
    }

    function Render(&$data,$groups=false) {

        $newData = array();
        foreach($data as $key=>$row) {
            //$item =& $data[$key];
            $item = array();
            foreach($this->Fields as $field) {
                $values = array();

                $fields = $this->getFieldList($field['fields']);

                foreach($fields as $dataField) {
                    $fieldName = $this->getFieldName($dataField);
                    if(array_key_exists($fieldName, $row)){ //Only push to array fields that exists to prevent Oops Error
                        array_push($values,$row[$fieldName]);
                    }
                }

                $sort = false;
                $field['type'] = isset($field['type']) ? $field['type'] : "";
                switch($field['type']) {
                    default:
                    case "external":
                    case "string":
                        $value = trim(str_replace("\r","",join(" ",$values)));
                        break;
                    case "date":
                        $value = "";
                        if($values[0] != "0000-00-00") {
                            if (strlen($values[0]) > 10) {
                                $values[0] = substr($values[0],0,10);	// Remove time portion
                            }
                            $value = chng_date($values[0],"-");
                            $sort = $values[0];
                        }
                        break;
                    case "complex":
                        if(function_exists($field['function'])) {
                            $return = call_user_func_array($field['function'], $values);
                            if (is_array($return)) {
								$value = $return['value'];
								if (array_key_exists("sort", $return)) {
									$sort = $return['sort'];
								}
                            } else {
                                $value = $return;
                            }
                            unset($return);
                        } else {
                            $value = "NOT IMPLEMENTED";
                        }
                        break;
                }
                $item[$field['name']] = $value;
                if($sort !== false) {
                    $item[$field['name'] . "_sort"] = $sort;
                }

                if(array_key_exists("key",$field)) {
                    $key_fields = $this->getFieldList($field['key']);

                    $keys = array();
                    foreach($key_fields as $key_field) {
                        $fieldName = $this->getFieldName($key_field);
                        if(isset($row[$fieldName])){ //Only push to array fields that exists to prevent Oops Error
                            array_push($keys,$row[$fieldName]);
                        }
                    }
                    if(array_key_exists("key_function",$field)) {
                        if(function_exists($field['key_function'])) {
                            $key = call_user_func_array($field['key_function'],array(join("_",$keys),$field));
                        } else {
                            $key = "NOT IMPLEMENTED";
                        }
                    } else {
                        $key = join("_",$keys);
                    }
					if(!is_array($key)) {
						$key = [$key];
					}
	                $item[$field['name'] . "_key"] = $key;
                }

            }
            $newData[] = $item;
            unset($item);
        }

        $data = $newData;
        unset($newData);
        if($groups !== false) {
            $this->Group($data,$groups);
        }
    }
}

/*
class ReportSQLField {
	var $Name;
	var $Type;
	var $Fields;
	var $Function;

	function ReportSQLField($name, $type, $fields=array(), $function=false) {
		$this->Name = $name;
		$this->Type = $type;
		$this->Fields = $fields;
		$this->Function = $function;
	}
}

class ReportSQLJoin {
	var $Name;
	var $Table;
	var $Type;
	var $On;

	function ReportSQLJoin($name,$type=false,$on=false,$table=false) {
		$this->Name = $name;
		$this->Type = $type;
		$this->On = $on;
		if($table === false) {
			$this->Table = $this->Name;
		} else {
			$this->Table = $table;
		}
	}
}
*/
