<?php

require_once(__DIR__ . '/api/rpc/xmlrpc.php');
require_once(__DIR__ . '/api/rpc/jsonrpc.php');

class RPC
{
	private $URL;
	private $Username;
	private $Password;
	private $LinkId;
	private $PrincipalId;
	private $PrincipalUsername;
	private $PrincipalPassword;
	private $Type;
	public $Error;

	/**
	 * Constructor
	 * 
	 */
	public function __construct($url, $username, $password, $linkId="", $principalId="", $principalUsername="", $principalPassword="", $type=false)
	{
		$this->URL = $url;
		$this->Username = $username;
		$this->Password = $password;
		$this->LinkId = $linkId;
		$this->PrincipalId = $principalId;
		$this->PrincipalUsername = $principalUsername;
		$this->PrincipalPassword = $principalPassword;
		if($type !== false) {
			$this->Type = $type;
		} else {
			$this->Type = "JSON";
		}
		$this->Error = false;
	}

	public function Call($method, $data=false)
	{
		if($data === false) {
			$data = array();
		}

		$argc = func_num_args();
		if($argc > 2) {
			$data = func_get_args();
			array_shift($data); // get rid of $method
		} else {
			if(!is_array($data)) {
				$data = array($data);
			}
		}

		$auth = array(
			'bridge_username'=>$this->Username,
			'bridge_password'=>$this->Password,
			'link_id'=>$this->LinkId,
			'principal_id'=>$this->PrincipalId,
			'principal_username'=>$this->PrincipalUsername,
			'principal_password'=>$this->PrincipalPassword
		);
		if($method != "system.multicall") {
			array_unshift($data,$auth);
		} else {
			foreach($data as $callId=>$call) {
				array_unshift($call['params'],$auth);
				$data[$callId]['params'] = $call['params'];
			}				
			$data = array($data);
		}

		$clientClass = strtolower($this->Type)."rpc_client";
		$messageClass = strtolower($this->Type)."rpcmsg";

//		log_message("Start of ".$this->Type."::".$method." test");
		$client = new $clientClass($this->URL);
		if($data !== null) {
			if(is_array($data)) {
				foreach($data as $key=>$value) {
					$data[$key] = php_xmlrpc_encode($value);
				}
			} else {
				$data = array(php_xmlrpc_encode($data));
			}
		}
//		log_message($data);
		$message = new $messageClass($method,$data);
		$message->debug=true;
//		log_message("Message is: " . $message->serialize());
		$client->return_type = 'phpvals';
//		log_message("Return type is: " . $client->return_type);
		$resp = $client->send($message);
		if($resp->faultCode()) {
			$this->Error = $resp->faultString();
			return false;
		} else {
			$output = $resp->value();
			if($method == "system.multicall") {
				foreach($output as $item) {
					if(array_key_exists('faultCode',$item) && $item['faultCode']) {
						$this->Error = $item['faultString'];
						return false;
					}
				}
			}
		}
		
//		log_message("End of ".$this->Type."::".$method." test");
		$this->Error = false;
		return $output;
	}
}
