<?php

require_once(__DIR__ . '/class.financial.interface.php');
require_once(__DIR__ . '/class.financial.options.php');
require_once(__DIR__ . '/class.sage.evolution.journal.export.php');

class SageEvolutionInterface extends FinancialInterface
{

    /**
     * The configuration options supported by the Sage Evolution interface.
     *
     * @var array
     */
    protected $supportedOptions = [
        [
            'id' => FinancialOptions::OPTION_REFERENCE_FORMAT,
            'default' => FinancialOptions::REFERENCE_FORMAT_RES_NUM
        ],
        [
            'id' => FinancialOptions::OPTION_MEMO_FORMAT_PAYMENT,
            'default' => '2,21,20'
        ],
        [
            'id' => FinancialOptions::OPTION_MEMO_FORMAT_INVOICE,
            'default' => '20'
        ]
    ];

    /**
     * Create an instance of the Sage Evolution Interface for the given invoicing unit.
     *
     * @param MySQLDB $lDB The connection to the database.
     * @param string $invoicingUnit The id of the invoicing unit.
     */
    public function __construct($lDB, $invoicingUnit)
    {
        parent::__construct($lDB, $invoicingUnit);
    }

    /**
     * Generates an array of invoices and payments in the format required to be imported into Sage Evolution.
     *
     * @param string $batch The id of the batch to export.
     * @return array An array of the invoices and payments contained within the given batch.
     */
    public function exportJournal($batch)
    {
        $journalExport = new SageEvolutionJournalExport($this->lDB, $this->activeOptions, $batch, $this->invoicingUnit);
        return $journalExport->export();
    }
}