<?php

 /**
  * class.specialmanager.php - SpecialManager
  * Job: 2011
  * Function: 68 (Rates)
  */

class SpecialManager
{

	protected $Reservation = [
		'rv_reservation_id' => '',
		'rv_confirmation_date' => '',
		'rv_date_arrive' => '',
		'rv_date_depart' => '',
		'lead_time_days' => '',
		'properties' => [],
		'accomm_types' => [],
		'rv_commission_perc' => '',
		'itineraries' => []
	];

	protected $QualifyingSpecials = false;
	protected $QualifyingCombos = false;
	protected $QualifyingAll = false;

	protected $UnitRateGroupId;
	protected $PaxRateGroupId;

	public function __construct($rv_reservation_id)
	{
		global $lDB;

		$items = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_item_ix,
				rv_reservation_item.rv_item_accomm_count,
				rv_reservation_item.rv_item_date_added,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation_item.rv_item_date_changed,
				rv_reservation_item.rv_item_nights,
				rv_reservation_item.rv_item_split_yn,
				rv_reservation_item.rt_rate_type_id,
				rv_reservation_item.ac_accomm_type_id,
				rv_reservation_item.pr_business_id,
				rv_reservation_item.rv_item_timestamp
			FROM
				rv_reservation_item
			WHERE
				rv_reservation_item.rv_reservation_id = '" . $lDB->escape($rv_reservation_id) . "'
		",6);

		foreach($items as $key => &$item) {
			$item['rate_groups'] = $lDB->get("
				SELECT
					rv_res_item_rate_grp.rt_rate_group_id,
					rv_res_item_rate_grp.rv_res_item_rate_grp_count
				FROM
					rv_res_item_rate_grp
				WHERE
					rv_res_item_rate_grp.rv_reservation_item_id = '" . $lDB->escape($item['rv_reservation_item_ix']) . "'
			",6);
		};
		unset($item);


		$this->Reservation['itineraries'] = $items;
		$this->Reservation['rv_reservation_id'] = $rv_reservation_id;

		$reservation = $lDB->get("
			SELECT
				rv_commission_perc,
				rv_confirmation_date,
				rv_date_arrive,
				rv_date_depart,
				rt_rate_type_id
			FROM
				rv_reservation
			WHERE
				rv_reservation.rv_reservation_ix = '" . $lDB->escape($rv_reservation_id) . "'
		",1);

		$this->Reservation['rv_commission_perc'] = $reservation['rv_commission_perc'] ?? 0;
		if(!empty($reservation['rv_confirmation_date']) && $reservation['rv_confirmation_date'] != "0000-00-00") {
			$this->Reservation['rv_confirmation_date'] = $reservation['rv_confirmation_date'];
		} else {
			$this->Reservation['rv_confirmation_date'] = date("Y-m-d");
		}
		if(!empty($reservation['rv_date_arrive']) && $reservation['rv_date_arrive'] != "0000-00-00") {
			$this->Reservation['rv_date_arrive'] = $reservation['rv_date_arrive'];
		} else {
			$this->Reservation['rv_date_arrive'] = $this->Reservation['itineraries'][0]['rv_item_date_arrive'] ?? "";
		}
		if(!empty($reservation['rv_date_depart']) && $reservation['rv_date_depart'] != "0000-00-00") {
			$this->Reservation['rv_date_depart'] = $reservation['rv_date_depart'];
		} else {
			$this->Reservation['rv_date_depart'] = $this->Reservation['itineraries'][0]['rv_item_date_depart'] ?? "";
		}

		// Lead time (days)
		$this->Reservation['lead_time_days'] = floor((strtotime($this->Reservation['rv_date_arrive'])-strtotime($this->Reservation['rv_confirmation_date']))/(60*60*24));

		$this->UnitRateGroupId = $lDB->get("
			SELECT
				rt_rate_group_ix
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 1
		",4);

		$this->PaxRateGroupId = $lDB->get("
			SELECT
				rt_rate_group_ix
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 99
		",4);

		foreach($this->Reservation['itineraries'] as $item) {
			$this->Reservation['properties'][] = $item['pr_business_id'];
			$this->Reservation['accomm_types'][] = $item['ac_accomm_type_id'];
		}
		$this->Reservation['properties'] = array_unique($this->Reservation['properties']);
		$this->Reservation['accomm_types'] = array_unique($this->Reservation['accomm_types']);
	}

	public function GetQualifyingSpecials()
	{
		global $lDB;

        $this->QualifyingSpecials = [];

		// First filter specials based on Special header detail
		$specials = $lDB->get("
			SELECT DISTINCT
				sp_special.sp_special_ix
			FROM
				sp_special
				INNER JOIN sp_accomm_type ON sp_accomm_type.sp_special_id = sp_special.sp_special_ix
			WHERE
				(
					(
						sp_special.sp_special_date_from <= '".$this->Reservation['rv_confirmation_date']."'
						AND sp_special.sp_special_date_to >= '".$this->Reservation['rv_confirmation_date']."'
					) OR (
						sp_special.sp_special_date_from = '0000-00-00'
						AND sp_special.sp_special_date_to = '0000-00-00'
						AND sp_special.sp_special_lead_time_ind = 0
						AND sp_special.sp_special_lead_time_amt > '".$this->Reservation['lead_time_days']."'
					) OR (
						sp_special.sp_special_date_from = '0000-00-00'
						AND sp_special.sp_special_date_to = '0000-00-00'
						AND sp_special.sp_special_lead_time_ind = 1
						AND sp_special.sp_special_lead_time_amt < '".$this->Reservation['lead_time_days']."'
					) OR (
						sp_special.sp_special_date_from = '0000-00-00'
						AND sp_special.sp_special_date_to = '0000-00-00'
						AND sp_special.sp_special_lead_time_ind = 0
						AND sp_special.sp_special_lead_time_amt = 0
					)
				) AND (
					sp_special.sp_special_comm_perc > " . $this->Reservation['rv_commission_perc'] . "
					OR sp_special.sp_special_comm_perc = 0
				)
				AND sp_accomm_type.ac_accomm_type_id IN ('".join("','",$this->Reservation['accomm_types'])."')
				AND sp_special.sp_special_inactive_yn != 1
			ORDER BY
				sp_special_priority ASC
		",3);

		if (empty($specials)) {
			return [];
		}

		foreach($specials as $special) {
			// Rate groups at res level
			$specialRateGroups = $lDB->get("
				SELECT
					sp_rate_group_qualify.rt_rate_group_id,
					sp_rate_group_qualify.sp_rate_group_count,
					sp_rate_group_qualify.sp_rate_group_nights,
					sp_rate_group_qualify.sp_rate_group_bed_nights
				FROM
					sp_rate_group_qualify
				WHERE
					sp_rate_group_qualify.sp_special_id = '$special'
			",2);

			// Accomm filter
			$accommFilter = $lDB->get("
				SELECT
					sp_accomm_type.ac_accomm_type_id
				FROM
					sp_accomm_type
				WHERE
					sp_accomm_type.sp_special_id = '$special'
			",3);

			// Rate type filter
			$rateTypeFilter = $lDB->get("
				SELECT
					sp_special_rate_type.rt_rate_type_id
				FROM
					sp_special_rate_type
				WHERE
					sp_special_rate_type.sp_special_id = '$special'
			",3);

			// Period filter
			$specialPeriodFilter = $lDB->get("
				SELECT
					sp_special_period.rt_period_id
				FROM
					sp_special_period
				WHERE
					sp_special_period.sp_special_id = '$special'
			",3);

			$specialNonoptionalProperties = $lDB->get("
				SELECT DISTINCT
					ac_accomm_type.pr_business_id
				FROM
					sp_accomm_type
				INNER JOIN
					ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sp_accomm_type.ac_accomm_type_id
				WHERE
					sp_accomm_type.sp_special_id = '$special'
					AND sp_accomm_type.sp_accomm_type_opt_yn = 0
			",3);

			$specialOptionalProperties = $lDB->get("
				SELECT DISTINCT
					ac_accomm_type.pr_business_id
				FROM
					sp_accomm_type
				INNER JOIN
					ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sp_accomm_type.ac_accomm_type_id
				WHERE
					sp_accomm_type.sp_special_id = '$special'
					AND sp_accomm_type.sp_accomm_type_opt_yn = 1
			",3);

			// Build totals at Reservation level
			$periodFilterMatch = false;
			$rateGroupMatch = true;
			$resRateGroupTotals = [];
			$rooms = 0;
			$rate_groups = [];
			$rate_groups_max = [];
			$rate_groups_bednights = [];
			$date = $this->Reservation['rv_date_arrive'];
			$rateGroupFilterMatch = false;

			while($date < $this->Reservation['rv_date_depart']) {
				$rate_groups[$date] = [];
				foreach ($this->Reservation['itineraries'] as $item) {
					if(!in_array($item['rt_rate_type_id'], $rateTypeFilter)) {
						continue;
					}
					$rateGroupFilterMatch = true;

					if(!in_array($item['ac_accomm_type_id'], $accommFilter)) {
						continue;
					}

					$period_dates = $lDB->get("
						SELECT
							rt_period_ix
						FROM
							rt_period
							INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
						WHERE (
							(
								rt_period_dates.rt_period_from >= '".$date."'
								AND rt_period_dates.rt_period_from < '".$date."'
							) OR (
								rt_period_dates.rt_period_to >= '".$date."'
								AND rt_period_dates.rt_period_to <= '".$date."'
							) OR (
								rt_period_dates.rt_period_from <= '".$date."'
								AND rt_period_dates.rt_period_to >= '".$date."'
							)
						)

					",3);

					$periodFilterMatch = false;
					foreach($period_dates as $period) {
						if(in_array($period, $specialPeriodFilter)) {
							$periodFilterMatch = true;
						}
					}
					if(!$periodFilterMatch) {
						continue;
					}

					if($date < $item['rv_item_date_arrive'] || $date >= $item['rv_item_date_depart']) {
						continue;
					}

					if(!array_key_exists($this->UnitRateGroupId, $rate_groups[$date])) {
						$rate_groups[$date][$this->UnitRateGroupId] = 0;
					}
					$rate_groups[$date][$this->UnitRateGroupId] += $item['rv_item_accomm_count'];
					foreach($item['rate_groups'] as $rate_group) {
						if($rate_group['rt_rate_group_id'] == $this->UnitRateGroupId) {
							continue;
						}

						if(!array_key_exists($rate_group['rt_rate_group_id'], $rate_groups_bednights)) {
							$rate_groups_bednights[$rate_group['rt_rate_group_id']] = 0;
						}
						if(!array_key_exists($rate_group['rt_rate_group_id'], $rate_groups[$date])) {
							$rate_groups[$date][$rate_group['rt_rate_group_id']] = 0;
						}
						if(!array_key_exists($this->PaxRateGroupId, $rate_groups_bednights)) {
							$rate_groups_bednights[$this->PaxRateGroupId] = 0;
						}
						if(!array_key_exists($this->PaxRateGroupId, $rate_groups[$date])) {
							$rate_groups[$date][$this->PaxRateGroupId] = 0;
						}

						$total = $rate_group['rv_res_item_rate_grp_count'] * $item['rv_item_accomm_count'];

						$rate_groups_bednights[$rate_group['rt_rate_group_id']] += $total;
						$rate_groups[$date][$rate_group['rt_rate_group_id']] += $total;
						$rate_groups_bednights[$this->PaxRateGroupId] += $total;
						$rate_groups[$date][$this->PaxRateGroupId] += $total;
					}
				}
				$date = date('Y-m-d', strtotime($date . ' + 1 day'));
			}

			foreach ($rate_groups as $day) {
				foreach ($day as $rate_group=>$total) {
					if(!array_key_exists($rate_group, $rate_groups_max)) {
						$rate_groups_max[$rate_group] = 0;
					}
					if ($rate_groups_max[$rate_group] < $total) {
						$rate_groups_max[$rate_group] = $total;
					}
				}
			}

			// Check if rate groups match special rate group criteria
			foreach($specialRateGroups as $key=>$specialRateGroup) {
				$nightcount = 0;
				$nightcountMax = 0;
				$nightcountNonConsecutive = 0;

				if($specialRateGroup['sp_rate_group_nights'] != 0) {
					foreach($rate_groups as $day=>$resDayRateGroups) {
						foreach($resDayRateGroups as $resRateGroupId=>$resRateGroupQty) {
							if($resRateGroupId != $specialRateGroup['rt_rate_group_id']) {
								continue;
							}
							if($specialRateGroup['sp_rate_group_count'] == 0) {
								// Zero means no limit
								if($resRateGroupQty > 0) {
									$nightcount++;
									$nightcountMax = ($nightcount > $nightcountMax) ? $nightcount : $nightcountMax;
									$nightcountNonConsecutive++;
								} else {
									$nightcount = 0;
								}
							} elseif($resRateGroupQty >= $specialRateGroup['sp_rate_group_count']) {
								$nightcount++;
								$nightcountMax = ($nightcount > $nightcountMax) ? $nightcount : $nightcountMax;
								$nightcountNonConsecutive++;
							} else {
								$nightcount = 0;
							}
						}
					}
				}

				/*
				This has been commented out to allow for non-consecutive nights qualifying for a special. This might be changed in the future.
				if ($nightcountMax < $specialRateGroup['sp_rate_group_nights']){
					$rateGroupMatch = false;
					break;
				}
				*/

				// Check for minimum nights in step 1, non-consecutive
				if($nightcountNonConsecutive < $specialRateGroup['sp_rate_group_nights']){
					$rateGroupMatch = false;
					break;
				}

				if(
					$specialRateGroup['sp_rate_group_bed_nights'] != 0
					&& $specialRateGroup['rt_rate_group_id'] != $this->UnitRateGroupId
					&& (
						!array_key_exists($specialRateGroup['rt_rate_group_id'], $rate_groups_bednights)
						|| $rate_groups_bednights[$specialRateGroup['rt_rate_group_id']] < $specialRateGroup['sp_rate_group_bed_nights']
					)
				) {
					$rateGroupMatch = false;
					break;
				}

				if(
					$specialRateGroup['sp_rate_group_count'] != 0
					&& (
						!array_key_exists($specialRateGroup['rt_rate_group_id'], $rate_groups_max)
						|| $specialRateGroup['sp_rate_group_count'] > $rate_groups_max[$specialRateGroup['rt_rate_group_id']]
					)
				) {
					$rateGroupMatch = false;
					break;
				}
			}


			// Rate groups at property level
			$specialProps = $lDB->get("
				SELECT
					DISTINCT sp_prop_rate_group.pr_business_id
				FROM
					sp_prop_rate_group
				WHERE
					sp_prop_rate_group.sp_special_id = '$special'
			",3);

            $anyPropertyRateGroupsPass = true;
            $propertyRateGroupsPasses = 0;
            $propertyRateGroupsFails= 0;

			// Iterate through each property
			foreach($specialProps as $prop) {
                $propertyRateGroupsPass = true;
                
				$specialRateGroups = $lDB->get("
					SELECT
						sp_prop_rate_group.pr_business_id,
						sp_prop_rate_group.rt_rate_group_id,
						sp_prop_rate_group.sp_rate_group_count,
						sp_prop_rate_group.sp_rate_group_nights,
						sp_prop_rate_group.sp_rate_group_bed_nights
					FROM
						sp_prop_rate_group
					WHERE
						sp_prop_rate_group.sp_special_id = '$special'
						AND sp_prop_rate_group.pr_business_id = '$prop'
				",2);

				// Build totals for current Property
				$rate_groups 			= array();
				$rate_groups_bednights 	= array();
				$rate_groups_max 		= array();
				$date = $this->Reservation['rv_date_arrive'];

				while($date < $this->Reservation['rv_date_depart']) {
					$rate_groups[$date] = [];
					foreach ($this->Reservation['itineraries'] as $item) {
						$hasPropAccomm = in_array($item['ac_accomm_type_id'], $accommFilter) && ($item['pr_business_id'] == $prop);
						if($date < $item['rv_item_date_arrive'] || $date >= $item['rv_item_date_depart']) {
							continue;
						}

						if(!array_key_exists($this->UnitRateGroupId, $rate_groups[$date])) {
							$rate_groups[$date][$this->UnitRateGroupId] = 0;
						}
						$rate_groups[$date][$this->UnitRateGroupId] += $item['rv_item_accomm_count'];
						foreach($item['rate_groups'] as $rate_group) {
							if($rate_group['rt_rate_group_id'] == $this->UnitRateGroupId) {
								continue;
							}

							$total = $rate_group['rv_res_item_rate_grp_count'] * $item['rv_item_accomm_count'];

							if(!array_key_exists($rate_group['rt_rate_group_id'],$rate_groups_bednights)) {
								$rate_groups_bednights[$rate_group['rt_rate_group_id']] = 0;
							}
							if(!array_key_exists($this->PaxRateGroupId,$rate_groups_bednights)) {
								$rate_groups_bednights[$this->PaxRateGroupId] = 0;
							}
							$rate_groups_bednights[$rate_group['rt_rate_group_id']] += $total;
							$rate_groups_bednights[$this->PaxRateGroupId] += $total;

							// Only populate bednights array if the accomm and prop criteria failed
							if($hasPropAccomm) {
								if(!array_key_exists($rate_group['rt_rate_group_id'], $rate_groups[$date])) {
									$rate_groups[$date][$rate_group['rt_rate_group_id']] = 0;
								}
								if(!array_key_exists($this->PaxRateGroupId, $rate_groups[$date])) {
									$rate_groups[$date][$this->PaxRateGroupId] = 0;
								}
								$rate_groups[$date][$rate_group['rt_rate_group_id']] += $total;
								$rate_groups[$date][$this->PaxRateGroupId] += $total;
							}
						}
					}
					$date = date('Y-m-d', strtotime($date . ' + 1 day'));
				}

				foreach($rate_groups as $day) {
					foreach($day as $rate_group=>$total) {
						if(!array_key_exists($rate_group, $rate_groups_max)) {
							$rate_groups_max[$rate_group] = 0;
						}
						if($rate_groups_max[$rate_group] < $total) {
							$rate_groups_max[$rate_group] = $total;
						}
					}
				}

				// Iterate through each Special line
				foreach($specialRateGroups as $key=>$specialRateGroup) {
					if($specialRateGroup['sp_rate_group_nights'] != 0) {
						$nightcount = 0;
						$nightcountMax = 0;
						$nightcountNonConsecutive = 0;

						foreach($rate_groups as $day => $resDayRateGroups) {
							foreach($resDayRateGroups as $resRateGroupId => $resRateGroupQty) {
								if($resRateGroupId == $specialRateGroup['rt_rate_group_id']) {
									if($specialRateGroup['sp_rate_group_count'] == 0) {
										// Zero means no limit
										if($resRateGroupQty > 0) {
											$nightcount++;
											$nightcountMax = ($nightcount > $nightcountMax) ? $nightcount : $nightcountMax;
											$nightcountNonConsecutive++;
										} else {
											$nightcount = 0;
										}
									} else if($resRateGroupQty >= $specialRateGroup['sp_rate_group_count']) {
										$nightcount++;
										$nightcountMax = ($nightcount > $nightcountMax) ? $nightcount : $nightcountMax;
										$nightcountNonConsecutive++;
									} else {
										$nightcount = 0;
									}
								}
							}
						}

						if($nightcountNonConsecutive < $specialRateGroup['sp_rate_group_nights']) {
							if($nightcountMax == 0 && in_array($prop, $specialOptionalProperties)) {
							} else {
								$propertyRateGroupsPass = false;
							}
						}
					}

					if(
						$specialRateGroup['sp_rate_group_bed_nights'] != 0
						&& $specialRateGroup['rt_rate_group_id'] != $this->UnitRateGroupId
						&& $rate_groups_bednights[$specialRateGroup['rt_rate_group_id']] < $specialRateGroup['sp_rate_group_bed_nights']
					) {
						$propertyRateGroupsPass = false;
					}

					if(
						$specialRateGroup['sp_rate_group_count'] != 0
						&& (
							!array_key_exists($specialRateGroup['rt_rate_group_id'], $rate_groups_max)
							|| $specialRateGroup['sp_rate_group_count'] > $rate_groups_max[$specialRateGroup['rt_rate_group_id']]
						)
					) {
						$propertyRateGroupsPass = false;
					}
				}
                if ($propertyRateGroupsPass) {
                    $propertyRateGroupsPasses++;
                } else {
                    $propertyRateGroupsFails++;
                }
			} // End of Iterate through each property

            if ($propertyRateGroupsPasses == 0 && $propertyRateGroupsFails != 0) {
                $anyPropertyRateGroupsPass = false;
            }

			// Min properties match
			$minPropMatch = false;

			$specialProperties = $lDB->get("
				SELECT DISTINCT
					ac_accomm_type.pr_business_id
				FROM
					sp_accomm_type
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sp_accomm_type.ac_accomm_type_id
				WHERE
					sp_accomm_type.sp_special_id = '$special'
			",3);
			$specialMinProperties = $lDB->get("
				SELECT
					sp_special.sp_special_min_properties
				FROM
					sp_special
				WHERE
					sp_special.sp_special_ix = '$special'
			",4);

			$resNumProperties = 0;
			foreach($specialProperties as $specialProperty) {
				if(in_array($specialProperty, $this->Reservation['properties'])) {
					$resNumProperties++;
				}
			}

			if ($resNumProperties >= $specialMinProperties){
				$minPropMatch = true;
			}

			// Non-optional properties match
			$nonoptionalPropMatch = true;
			$resProperties = $this->Reservation['properties'];

			foreach ($specialNonoptionalProperties as $property){
				if (!in_array($property, $resProperties)) {
					$nonoptionalPropMatch = false;
				}
			}

            if (
                $rateGroupFilterMatch && 
                $rateGroupMatch && 
                $periodFilterMatch && 
                $anyPropertyRateGroupsPass &&
                $minPropMatch && 
                $nonoptionalPropMatch
            ) {
                $this->QualifyingSpecials[] = $special;
            }

		}

		return $this->QualifyingSpecials;
	}

	public function GetQualifyingCombos()
	{
		global $lDB;

		if($this->QualifyingSpecials === false) {
			$specials = $this->GetQualifyingSpecials();
		} else {
			$specials = $this->QualifyingSpecials;
		}

		$this->QualifyingCombos = [];

		// Identify potential combos which contain qualifying specials
		$combos = $lDB->get("
			SELECT DISTINCT
				sp_combo_item.sp_combo_id
			FROM
				sp_combo_item
				INNER JOIN sp_combo ON sp_combo.sp_combo_ix = sp_combo_item.sp_combo_id
			WHERE
				sp_combo_item.sp_special_id IN ('" . join("','", $specials) . "')
			ORDER BY
				sp_combo.sp_combo_sort_seq ASC
		",3);

		$qualifyingCombos = [];
		foreach($combos as $sp_combo_id) {
			$comboSpecials = array_intersect($specials, $lDB->get("
				SELECT
					sp_combo_item.sp_special_id
				FROM
					sp_combo_item
				WHERE
					sp_combo_item.sp_combo_id = '" . $lDB->escape($sp_combo_id) . "'
			",3));

			// Ignore combos where only one special is present
			if(sizeof($comboSpecials) < 2) {
				continue;
			}

			$sp_combo_limit = $lDB->get("SELECT sp_combo_limit FROM sp_combo WHERE sp_combo_ix = '" . $lDB->escape($sp_combo_id) . "'",4);
			if(sizeof($comboSpecials) > $sp_combo_limit) {
				$comboSpecials = array_slice($comboSpecials, 0, $sp_combo_limit);
			}

			// Ignore combos where periods do not match
			$comboPeriods = $lDB->get("
				SELECT
					sp_combo_period.rt_period_id
				FROM
					sp_combo_period
				WHERE
					sp_combo_period.sp_combo_id = '" . $lDB->escape($sp_combo_id) . "'
			",3);
			$hasPeriods = true;
			$date = $this->Reservation['rv_date_arrive'];
			while($date < $this->Reservation['rv_date_depart']) {
				$periods = $lDB->get("
					SELECT
						rt_period.rt_period_ix
					FROM
						rt_period
						INNER JOIN rt_period_dates ON rt_period_dates.rt_period_id = rt_period.rt_period_ix
					WHERE (
						(
							rt_period_dates.rt_period_from >= '".$date."'
							AND rt_period_dates.rt_period_from < '".$date."'
						) OR (
							rt_period_dates.rt_period_to >= '".$date."'
							AND rt_period_dates.rt_period_to <= '".$date."'
						) OR (
							rt_period_dates.rt_period_from <= '".$date."'
							AND rt_period_dates.rt_period_to >= '".$date."'
						)
					)
				",3);
				if(sizeof(array_intersect($periods, $comboPeriods)) == 0) {
					$hasPeriods = false;
				}

				$date = date('Y-m-d', strtotime($date . ' + 1 day'));
			}
			if(!$hasPeriods) {
				continue;
			}

			$this->QualifyingCombos[$sp_combo_id] = $comboSpecials;
		}
		return $this->QualifyingCombos;
	}

	public function GetQualifying()
	{
		$specials = $this->GetQualifyingSpecials();
		$combos = $this->GetQualifyingCombos();

		$this->QualifyingAll = [];

		foreach($combos as $sp_combo_id=>$specials) {
			$this->QualifyingAll[] = [
				'type'=>"combo",
				'id'=>$sp_combo_id,
				'specials'=>$specials
			];
		}

		foreach($specials as $special) {
			$this->QualifyingAll[] = [
				'type'=>"single",
				'id'=>$special,
				'specials'=>[$special]
			];
		}

		return $this->QualifyingAll;
	}
}
