<?php
require_once(__DIR__ . '/class.queue.php');
require_once(__DIR__ . '/db.pr_agent.php');
require_once(__DIR__ . '/db.tc_prop_stock_update.php');
require_once(__DIR__ . "/functions.php");

class Stock {
	var $AccommTypeId;
	var $StartDate;
	var $EndDate;
	var $OverrideAgent;
	var $Agent;
	var $AgentFilter;
	var $ExpiredAllocation;
	var $ExcludeItemFilter;
	var $ExcludeBlockFilter;
	var $AllocationFilter;
	var $Cache;

	var $NumberOfDays;
	var $Today;
	var $AgentFilterSQL;
	var $AllocationSQL;
	var $ExcludeItemFilterSQL;
	var $ExcludeBlockFilterSQL;
	var $AllocationFilterSQL;

	var $Generated;

	var $Date;
	var $Accomm;
	var $Block;
	var $Occupancy;
	var $AgentAllocation;

	var $Materialisation;

	function __construct($aAccommTypeId, $aStartDate="0000-00-00", $aEndDate="0000-00-00", $aOverrideAgent=false, $aAgentFilter=false, $aExpiredAllocation=false, $aExcludeItemFilter=false, $aExcludeBlockFilter=false, $aAllocationFilter=false, $aCache=true) {
		$this->SetAccommTypeId($aAccommTypeId);
		$this->SetDateRange($aStartDate, $aEndDate);
		$this->SetOverrideAgent($aOverrideAgent);
		$this->SetAgentFilter($aAgentFilter);
		$this->SetExpiredAllocation($aExpiredAllocation);
		$this->SetExcludeItemFilter($aExcludeItemFilter);
		$this->SetExcludeBlockFilter($aExcludeBlockFilter);
		$this->SetAllocationFilter($aAllocationFilter);
		$this->SetCache($aCache);
	}

	function CheckDate($cDate) {
		if($cDate != "0000-00-00") {
			return $cDate;
		} else {
			return date("Y-m-d");
		}
	}

	function SetAccommTypeId($sAccommTypeId) {
		$this->AccommTypeId = $sAccommTypeId;
		$this->CacheKeyPrefix = "stock_" . date("Y-m-d") . "_" . $this->AccommTypeId;
		$this->ResetData();
	}

	function SetNumberOfDays() {
		$this->NumberOfDays = dateSubtract($this->EndDate, $this->StartDate) + 1;
	}

	function SetStartDate($sStartDate) {
		$this->StartDate = $this->CheckDate($sStartDate);
		$this->ResetData();
	}

	function SetEndDate($sEndDate) {
		$this->EndDate = $this->CheckDate($sEndDate);
		$this->ResetData();
	}

	function SetDateRange($sStartDate, $sEndDate) {
		$this->SetStartDate($sStartDate);
		$this->SetEndDate($sEndDate);
		if($this->EndDate < $this->StartDate) {
			$this->EndDate = $this->StartDate;
		}
	}

	function SetOverrideAgent($sOverrideAgent) {
		if($GLOBALS['userStatusId'] > 1 && db_pr_agent_exists($sOverrideAgent)) {
			$this->OverrideAgent = $sOverrideAgent;
			$this->Agent = $sOverrideAgent;
		} else {
			$this->OverrideAgent = false;
			$this->Agent = $GLOBALS['calAgentId'];
		}
		$this->ResetData();
	}

	function SetAgentFilter($sAgentFilter) {
		$this->AgentFilter = $sAgentFilter;
		$this->ResetData();
	}

	function SetExpiredAllocation($sExpiredAllocation) {
		$this->ExpiredAllocation = $sExpiredAllocation;
		$this->ResetData();
	}

	function SetExcludeItemFilter($sExcludeItemFilter) {
		$this->ExcludeItemFilter = $sExcludeItemFilter;
		$this->ResetData();
	}

	function SetExcludeBlockFilter($sExcludeBlockFilter) {
		$this->ExcludeBlockFilter = $sExcludeBlockFilter;
		$this->ResetData();
	}

	function SetAllocationFilter($sAllocationFilter) {
		$this->AllocationFilter = $sAllocationFilter;
		$this->ResetData();
	}

	function SetCache($sCache) {
		global $lDB;
		$rf_db_cache_stock_yn = $lDB->get("SELECT rf_db_cache_stock_yn FROM rf_database WHERE rf_db_code = '$GLOBALS[dbcode]'",4);

		if($sCache && $rf_db_cache_stock_yn == "1") {
			$this->Cache = true;
		} else {
			$this->Cache = false;
		}
	}

  public static function CacheStock() {
    global $lDB;
    $rf_db_cache_stock_yn = $lDB->get("SELECT rf_db_cache_stock_yn FROM rf_database WHERE rf_db_code = '$GLOBALS[dbcode]'",4);
    return $rf_db_cache_stock_yn == "1";
  }

	function ClearCache($components=false, $date=false, $transfer=false) {
		if($components === false) {
			$components = array('accomm','occupancy','block','agentAllocation');
		}

		if(!is_array($components)) {
			$components = array($components);
		}

		$dates = array();
		if($date === false) {
			$dateArray = explode("-", $this->StartDate);
			for($count = 0; $count < $this->NumberOfDays; $count++) {
				$thisDate = date("Y-m-d", mktime(0, 0, 0, $dateArray[1], $dateArray[2] + $count, $dateArray[0]));
				$dates[] = $thisDate;
			}
		} else {
			if(!is_array($dates)) {
				$dates = array($date);
			} else {
				$dates = $date;
			}
		}

		foreach($components as $component) {
			$tc_prop_stock_type_ind = constant("DB_TC_PROP_STOCK_UPDATE_" . strtoupper($component));
			foreach($dates as $thisDate) {
				if($this->Cache) {
					cacheUnset($this->CacheKey($component,$thisDate), CACHE_MEM_SHARED);
				}
				if(!$transfer) {
					db_tc_prop_stock_update_insert($this->AccommTypeId,$thisDate,$tc_prop_stock_type_ind);
				}
			}
		}

		if($this->Cache && (!$transfer && ($GLOBALS['isWebServer'] || $GLOBALS['envWebOverride']))) {
			$this->NotifyCache($dates);
		}
	}

	function NotifyCache($date=false) {
		$dates = array();
		if($date === false) {
			$dateArray = explode("-", $this->StartDate);
			for($count = 0; $count < $this->NumberOfDays; $count++) {
				$thisDate = date("Y-m-d", mktime(0, 0, 0, $dateArray[1], $dateArray[2] + $count, $dateArray[0]));
				$dates[] = $thisDate;
			}
		} else {
			if(!is_array($dates)) {
				$dates = array($date);
			} else {
				$dates = $date;
			}
		}

		$queue = new Queue();
		$data = array(
			'principal_id'=>$GLOBALS['principal_id'],
			'ac_accomm_type_id'=>$this->AccommTypeId,
			'dates'=>$dates
		);
		$result = $queue->create("stock_change",$data);

		if(empty($result)) {
			// TODO implement monitoring
			error_log("Error queuing stock change for principal " . $GLOBALS['principal_id'] . ", accommodation type " . $this->AccommTypeId . " for dates: " . join(", ", $dates));
		}
	}

	static function EmptyCache() {
		return cacheUnset("stock_*", CACHE_MEM_SHARED);
	}

	function CacheKey($component, $date) {
		if($component == "agentAllocation") {
			$component = $component . "_" . $this->Agent;
		}
		return $this->CacheKeyPrefix . "_" . $component . "_" . $date;
	}

	function GetStatusArray() {
		global $lDB;

		$statusList = $lDB->get("SELECT rf_reservation_status_id FROM rf_reservation_status",3);
		$statusArray = array();
		foreach($statusList as $statusId) {
			$statusArray[$statusId] = 0;
		}

		return $statusArray;
	}

	function ResetData() {
		$this->Generated = false;
		$this->Today = date("Y-m-d");
		$this->SetNumberOfDays();
		if($this->AgentFilter === false || trim($this->AgentFilter) === "") {
			$this->AgentFilterSQL = "";
		} else {
			$this->AgentFilterSQL = " AND rv_reservation.rv_agent_id IN ('" . join("','", explode(":", $this->AgentFilter)) . "') ";
		}
		if($this->AllocationFilter === false || trim($this->AllocationFilter) === "") {
			$this->AllocationFilterSQL = "";
		} else {
			$this->AllocationFilterSQL = " AND rv_reservation.rv_reservation_ix IN ('" . join("','", explode(":", $this->AllocationFilter)) . "') ";
		}
		if($this->ExpiredAllocation) {
			$this->AllocationSQL = "
				rv_reservation.rf_reservation_status_id = '15'
			";
		} else {
			$this->AllocationSQL = "
				rv_reservation.rf_reservation_status_id = '15'
				AND (
					!ignoreAllocationsSQL!
					(
						(
							rv_reservation_item.rv_alloc_expiry_date = '0000-00-00'
							AND (
								(
									rv_reservation.rv_alloc_expiry_date <> '0000-00-00'
									AND rv_reservation.rv_alloc_expiry_date >= '" . $this->Today . "'
								) OR (
									rv_reservation.rv_alloc_expiry_date = '0000-00-00'
									AND rv_reservation.rv_alloc_expiry_days <= !days!
								)
							)
						) OR (
							rv_reservation_item.rv_alloc_expiry_date <> '0000-00-00'
							AND rv_reservation_item.rv_alloc_expiry_date >= '" . $this->Today . "'
						)
					)
				)
			";
		}
		if($this->ExcludeItemFilter !== false && trim($this->ExcludeItemFilter) != "") {
			$this->ExcludeItemFilterSQL = " AND rv_reservation_item.rv_reservation_item_ix NOT IN ('" . join("','", explode(":", $this->ExcludeItemFilter)) . "') ";
		} else {
			$this->ExcludeItemFilterSQL = "";
		}

		if($this->ExcludeBlockFilter !== false && trim($this->ExcludeBlockFilter) != "") {
			$this->ExcludeBlockFilterSQL = " AND ac_accomm_room.ac_accomm_room_ix NOT IN ('" . join("','", explode(":", $this->ExcludeBlockFilter)) . "') ";
		} else {
			$this->ExcludeBlockFilterSQL = "";
		}

		$this->Date = array();
		$this->Accomm = array();
		$this->Block = array();
		$this->Occupancy = array();
		$this->AgentAllocation = array();
		$this->StatusArray = $this->GetStatusArray();
	}

	function GetAllocationSQL($gDate, $ignoreAllocations = array()) {
		$allocationSQL = str_replace("!days!", dateSubtract($gDate, $this->Today), $this->AllocationSQL);
		if (count($ignoreAllocations) > 0) {
			$ignoreAllocationsSQL = "rv_reservation_item.rv_reservation_id IN ('".join("','", $ignoreAllocations)."') OR ";
			$allocationSQL = str_replace("!ignoreAllocationsSQL!", $ignoreAllocationsSQL, $allocationSQL);
		} else {
			$allocationSQL = str_replace("!ignoreAllocationsSQL!", "", $allocationSQL);
		}
		return $allocationSQL;
	}


	function BuildAccomm() {
		global $lDB;

		return $lDB->get("
			SELECT
				ac_accomm_room.ac_accomm_room_inactive_yn,
				ac_accomm_room.ac_accomm_room_inactive_date,
				ac_accomm_room.ac_accomm_room_create_date,
				ac_accomm_type.ac_accomm_type_inactive_yn,
				ac_accomm_type.ac_accomm_type_inactive_date
			FROM
				ac_accomm_room
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
			WHERE
				ac_accomm_type.ac_accomm_type_ix = '" . $this->AccommTypeId . "'
			AND (
				(
					ac_accomm_room.ac_accomm_room_inactive_yn = '0'
					AND ac_accomm_room.ac_accomm_room_create_date <= '".$this->EndDate."'
				) OR (
					ac_accomm_room.ac_accomm_room_inactive_yn = '1'
					AND ac_accomm_room.ac_accomm_room_inactive_date > '".$this->StartDate."'
					AND ac_accomm_room.ac_accomm_room_create_date <= '".$this->EndDate."'
				)
			)
		",2);
	}

	function GetAccomm($gDate) {
		global $lDB;

		$accommCount = 0;
		foreach($this->AccommRaw as $item) {
			if(
				( // if the accommodation type is active, or was active on this date ...
					$item['ac_accomm_type_inactive_yn'] == "0"
					|| (
						$item['ac_accomm_type_inactive_yn'] == "1"
						&& $item['ac_accomm_type_inactive_date'] > $gDate
					)
				) && ( // ... and the room is active and existed on this date ...
					(
						$item['ac_accomm_room_inactive_yn'] == "0"
						&& $item['ac_accomm_room_create_date'] <= $gDate
					) || ( // ... or the room is inactive but existed and was active on this date ...
						$item['ac_accomm_room_inactive_yn'] == "1"
						&& $item['ac_accomm_room_create_date'] <= $gDate
						&& $item['ac_accomm_room_inactive_date'] > $gDate
					)
				)
			) {
				$accommCount++;
			}
		}
		return $accommCount;
	}
	function BuildOccupancy() {
		global $lDB;
		$allocationSQL = $this->GetAllocationSQL($this->EndDate);
		return $lDB->get("
			SELECT
				rv_reservation.rf_reservation_status_id,
				rv_reservation_item.rv_item_accomm_count,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				CASE rv_reservation_item.rv_alloc_expiry_date
					WHEN '0000-00-00' THEN rv_reservation.rv_alloc_expiry_date
					WHEN NULL THEN rv_reservation.rv_alloc_expiry_date
					ELSE rv_reservation_item.rv_alloc_expiry_date
				END AS rv_alloc_expiry_date,
				rv_reservation.rv_alloc_expiry_days
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				LEFT JOIN rv_reservation_item AS res_item ON res_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
				LEFT JOIN rv_reservation AS res ON res.rv_reservation_ix = res_item.rv_reservation_id
			WHERE
				rv_reservation_item.ac_accomm_type_id = '" . $this->AccommTypeId . "'
				$this->AllocationFilterSQL
			AND (
				(rv_reservation_item.rv_item_date_arrive >= '".$this->StartDate."' AND rv_reservation_item.rv_item_date_arrive <= '".$this->EndDate."')
				OR (rv_reservation_item.rv_item_date_depart >= '".$this->StartDate."' AND rv_reservation_item.rv_item_date_depart <= '".$this->EndDate."')
				OR (rv_reservation_item.rv_item_date_arrive < '".$this->StartDate."' AND rv_reservation_item.rv_item_date_depart > '".$this->EndDate."')
			)

			AND (
				rv_reservation.rf_reservation_status_id NOT IN ('15','20','25')
				OR (
					rv_reservation.rf_reservation_status_id = '25'
					AND rv_reservation.rv_create_expiry_date >= '" . date("Y-m-d H:i:s") . "' 
				) OR (
					rv_reservation.rf_reservation_status_id = '20'
					AND rv_reservation.rv_provision_expiry_date >= '" . $this->Today . "'
				) OR (
					$allocationSQL
					AND (
						res.rv_reservation_ix IS NULL
						OR res.rf_reservation_status_id = '30'
						OR (
							res.rf_reservation_status_id = '25'
							AND res.rv_create_expiry_date >= '" . date("Y-m-d H:i:s") . "' 
						) OR (
							res.rf_reservation_status_id = '20'
							AND res.rv_provision_expiry_date >= '" . $this->Today . "'
						)
					)
				)
			)
			" . $this->AgentFilterSQL . "
			" . $this->ExcludeItemFilterSQL . "
		",2);		
	}


	function GetOccupancy($gDate) {
		global $lDB;

		$occupancy = $this->StatusArray;

		if (!empty($this->OccupancyRaw)) {
			foreach($this->OccupancyRaw as $item) {
				if(!array_key_exists($item['rf_reservation_status_id'],$occupancy)) {
					$occupancy[$item['rf_reservation_status_id']] = 0;
				}
				if($item['rv_item_date_arrive'] <= $gDate && $item['rv_item_date_depart'] > $gDate) {
					if($item['rf_reservation_status_id'] == "15" && $item['rv_alloc_expiry_date'] == "0000-00-00") {
						$daysTillExpiry = dateSubtract($gDate, $this->Today);
						if($item['rv_alloc_expiry_days'] <= $daysTillExpiry) {
							$occupancy[$item['rf_reservation_status_id']] += $item['rv_item_accomm_count'];
						}
					} else {
						if ($this->Materialisation) {
							if ($item['rv_item_accomm_count'] > 0) {
								$occupancy[$item['rf_reservation_status_id']] += $item['rv_item_accomm_count'];
							}
						} else {
							$occupancy[$item['rf_reservation_status_id']] += $item['rv_item_accomm_count'];
						}
					}
				}
			}
		}

		return $occupancy;
	}

	function CombineOccupancy($cStatusFilter) {
		$this->Generate();
		$statusList = explode(":", $cStatusFilter);
		$newOccupancy = array();
		foreach($this->Occupancy as $key => $item) {
			$newOccupancy[$key] = 0;
			foreach($statusList as $statusId) {
				if(array_key_exists($statusId,$item)) {
					$newOccupancy[$key] += $item[$statusId];
				}
			}
		}
		return $newOccupancy;
	}

	function GetBlock($gDate) {
		global $lDB;

		return $lDB->get("
			SELECT
				COUNT(DISTINCT ac_accomm_room_ix)
			FROM
				ac_accomm_room_block
				INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = ac_accomm_room_block.ac_accomm_room_id
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_block.ac_accomm_type_id
			WHERE
				ac_accomm_block.ac_accomm_type_id = '" . $this->AccommTypeId . "' 
				AND ac_accomm_block.ac_start_date <= '$gDate'
				AND ac_accomm_block.ac_end_date > '$gDate'
				AND (
					(
						ac_accomm_type.ac_accomm_type_inactive_yn = '0'
					) OR (
						ac_accomm_type.ac_accomm_type_inactive_yn = '1'
						AND ac_accomm_type.ac_accomm_type_inactive_date > '$gDate'
					)
				) AND (
					(
						ac_accomm_room.ac_accomm_room_inactive_yn = '0'
						AND ac_accomm_room.ac_accomm_room_create_date <= '$gDate'
					) OR (
						ac_accomm_room.ac_accomm_room_inactive_yn = '1'
						AND ac_accomm_room.ac_accomm_room_inactive_date > '$gDate'
					)
				)
			" . $this->ExcludeBlockFilterSQL . "
		",4);
	}

	function GetAgentAllocation($gDate) {
		global $lDB;

		if($GLOBALS['userStatusId'] == 1 || !empty($this->OverrideAgent)) {
			// User is an agent			
			$allocationSQL = $this->GetAllocationSQL($gDate);

			return $lDB->get("
				SELECT
					SUM(rv_reservation_item.rv_item_accomm_count)	
				FROM
					rv_reservation_item
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				WHERE
					rv_reservation_item.ac_accomm_type_id = '" . $this->AccommTypeId . "'
					AND rv_reservation_item.rv_item_date_arrive <= '$gDate'
					AND rv_reservation_item.rv_item_date_depart > '$gDate'
					AND ( $allocationSQL )			
					AND rv_reservation.rv_agent_id = '$this->Agent'
			",4);
		} else {
			return 0;
		}
	}

	function Generate() {
		if($this->Generated) {
			return;
		}

		$dateArray = explode("-", $this->StartDate);
		for($count = 0; $count < $this->NumberOfDays; $count++) {
			$thisDate = date("Y-m-d", mktime(0, 0, 0, $dateArray[1], $dateArray[2] + $count, $dateArray[0]));

			array_push($this->Date, $thisDate);
		}

		$components = array(
			'accomm'=>array(),
			'occupancy'=>array(),
			'block'=>array(),
			'agentAllocation'=>array(),
		);
		foreach($components as $key=>&$component) {
			$property = $key;
			$property[0] = strtoupper($property[0]);
			$component['property'] = $property;
			$component['method'] = "Get".$property;
			$component['calculate'] = true;
			$component['cache'] = true;
		}
		unset($property);
		unset($component);

		if($this->Cache) {
			foreach($components as &$component) {
				$component['calculate'] = false;
			}
			unset($component);

			// Do not cache block results if a filter is in use
			if(!empty($this->ExcludeBlockFilterSQL)) {
				$components['block']['calculate'] = true;
				$components['block']['cache'] = false;
			}

			// Do not cache occupancy or agent allocations if expired allocations are included
			if($this->ExpiredAllocation) {
				$components['occupancy']['calculate'] = true;
				$components['occupancy']['cache'] = false;
				$components['agentAllocation']['calculate'] = true;
				$components['agentAllocation']['cache'] = false;
			}

			// Do not cache occupancy if agent, allocation or item filter is in use
			if(!empty($this->AgentFilterSQL) || !empty($this->AllocationFilterSQL || !empty($this->ExcludeItemFilterSQL))) {
				$components['occupancy']['calculate'] = true;
				$components['occupancy']['cache'] = false;
			}

			// todo: add exclusions where incompatible filters are set
			// todo: item filter optimisation

			foreach($components as $key=>&$component) {
				// Ignore cache is component has already been set to calculate or cache disabled
				if(!$component['calculate'] && $component['cache']) {
					foreach($this->Date as $thisDate) {
						$value = cacheGet($this->CacheKey($key,$thisDate), CACHE_MEM_SHARED);
						if(!$component['calculate'] && $value !== false) {
							$this->{$component['property']}[$thisDate] = $value;
						} else {
							$component['calculate'] = true;
						}
					}
				}
			}
			unset($component);
		}

		if($components['accomm']['calculate']) {
			$this->AccommRaw = $this->BuildAccomm();
		}
		if($components['occupancy']['calculate']) {
			$this->OccupancyRaw = $this->BuildOccupancy();
		}

		foreach($components as $key=>&$component) {
			if($component['calculate']) {
				foreach($this->Date as $thisDate) {
					// Calculate date only if not already populated from cache
					if(!array_key_exists($thisDate,$this->{$component['property']})) {
						$method = (string)$component['method'];
						$value = $this->$method($thisDate);
						// Cache only if cache is enabled and component is safe to cache
						// Components are not safe to cache if certain filters are in place
						// See above for exclusions
						if($this->Cache && $component['cache']) {
							cacheSet($this->CacheKey($key,$thisDate),$value, CACHE_MEM_SHARED,"tomorrow");
						}
						$this->{$component['property']}[$thisDate] = $value;
					}
				}
			}
		}
		unset($component);
		$this->Generated = true;
	}

	function ToDate() {
		$this->Generate();
		return $this->Date;
	}

	function ToAccomm() {
		$this->Generate();
		return $this->Accomm;
	}

	function ToProvisional() {
		$this->Generate();
		return $this->CombineOccupancy('20');
	}

	function ToWaitlist() {
		$this->Generate();
		return $this->CombineOccupancy('10');
	}

	function ToBlock() {
		$this->Generate();
		return $this->Block;
	}

	function ToAllocation($agentId="", $materialisation=false) {
		$this->Materialisation = $materialisation;
		$allAllocations = "";
		$agentAllocations = "";

		$this->Generate();

		$allAllocations = $this->CombineOccupancy('15');

		if($agentId != "" && $agentId != "0" ) {
			// Only return allocations for the specified agent ----------------
			$agentAllocations = $this->ToAllocationAgent(true, $agentId);

			foreach($allAllocations as $date => $all) {
				foreach($agentAllocations as $ag) {
					if($ag['total_balance']) {
						if(array_key_exists($date, $ag['total_balance'])) {
							$allAllocations[$date] = $ag['total_balance'][$date];
						} else {
							$allAllocations[$date] = "0";
						}
					}
				}
			}
		}
		return $allAllocations;
	}

	function ToAvailability($tShowProvisional=true, $tShowAllocation=true, $tShowOverbooking=true, $tUnitLimit=false, $tAddAgentAllocation=true) {
		$this->Generate();

		$availArray = array();
		$statusList = "30:25";

		if($tShowProvisional) {
			$statusList .= ":20";
		}

		if($tShowAllocation) {
			$statusList .= ":15";
		}

		$occupancy = $this->CombineOccupancy($statusList);

		if($tUnitLimit === false) {
			if($GLOBALS['limit_yn'] != 0) {
				if($GLOBALS['sc_grp_avail_limit'] < 0) {
					$tUnitLimit = 0;
				} else {
					$tUnitLimit = $GLOBALS['sc_grp_avail_limit'];
				}
			} else {
				$tUnitLimit = 0;
			}
		}
		//		debug($this->AgentAllocation);

		foreach($this->Date as $thisDate) {

			$availArray[$thisDate] = $this->Accomm[$thisDate] - $occupancy[$thisDate] - $this->Block[$thisDate];

			if($tShowAllocation && $tAddAgentAllocation && ($GLOBALS['userStatusId'] == 1 || !empty($this->OverrideAgent))) {
				$availArray[$thisDate] += $this->AgentAllocation[$thisDate];
			}

			if($tUnitLimit > 0) {
				if($availArray[$thisDate] > $tUnitLimit) {
					$availArray[$thisDate] = $tUnitLimit;
				}
			}

			if($availArray[$thisDate] < 0) {
				if(!$tShowOverbooking || $tUnitLimit > 0 || $GLOBALS['limit_yn'] != 0) {
					$availArray[$thisDate] = 0;
				}
			}
		}
		return $availArray;
	}

	/* DB: This function name may change */
	function ToAllocationAgent($groupByAgent=true, $agentId="",$materialisation=false, $ignoreAllocations=array()) {
		$this->Materialisation = $materialisation;
		$this->Generate();
		global $lDB;
		// AgentId limits this output to a single agent. Useful for external users
		$agentSQL = "";
		if ( $agentId != "" && $agentId != "0" ) {
			$agentSQL = " AND rv_reservation.rv_agent_id = '" . $agentId . "' ";
		}

		$allocationAgent = array();

		$allocationSQL = $this->GetAllocationSQL($this->EndDate, $ignoreAllocations);
		$rawAgentList = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				bl_block.bl_block_abbrev,
				rv_reservation.rv_agent_id,
				pr_persona.pr_name_last,
				rv_reservation_item.rv_item_accomm_count AS occupancy_count,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				CASE rv_reservation_item.rv_alloc_expiry_date
					WHEN '0000-00-00' THEN rv_reservation.rv_alloc_expiry_date
					WHEN NULL THEN rv_reservation.rv_alloc_expiry_date
					ELSE rv_reservation_item.rv_alloc_expiry_date
				END AS rv_alloc_expiry_date,
				rv_reservation.rv_alloc_expiry_days
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
				LEFT JOIN rv_reservation_item AS allocated_item ON allocated_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
				LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id
				LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id
			WHERE
				rv_reservation_item.ac_accomm_type_id = '" . $this->AccommTypeId . "'
				$this->AllocationFilterSQL
				AND (
					(rv_reservation_item.rv_item_date_arrive >= '".$this->StartDate."' AND rv_reservation_item.rv_item_date_arrive <= '".$this->EndDate."')
					OR (rv_reservation_item.rv_item_date_depart >= '".$this->StartDate."' AND rv_reservation_item.rv_item_date_depart <= '".$this->EndDate."')
					OR (rv_reservation_item.rv_item_date_arrive < '".$this->StartDate."' AND rv_reservation_item.rv_item_date_depart > '".$this->EndDate."')
				)
				AND allocated_item.rv_reservation_item_ix IS NULL
				AND ( $allocationSQL ) 
				" . $agentSQL . "
			ORDER BY
				pr_persona.pr_name_last 
		",2);
		$rawAgentUsedList = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				bl_block.bl_block_abbrev,
				rv_reservation.rv_agent_id,
				pr_persona.pr_name_last,
				rv_reservation_item.rv_item_accomm_count AS occupancy_count,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
				LEFT JOIN rv_reservation_item AS allocated_item ON allocated_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
				LEFT JOIN rv_reservation AS allocated_res ON allocated_res.rv_reservation_ix = allocated_item.rv_reservation_id
				LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id
				LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id
			WHERE
				rv_reservation_item.ac_accomm_type_id = '" . $this->AccommTypeId . "'
				$this->AllocationFilterSQL
				AND (
					(rv_reservation_item.rv_item_date_arrive >= '".$this->StartDate."' AND rv_reservation_item.rv_item_date_arrive <= '".$this->EndDate."')
					OR (rv_reservation_item.rv_item_date_depart >= '".$this->StartDate."' AND rv_reservation_item.rv_item_date_depart <= '".$this->EndDate."')
					OR (rv_reservation_item.rv_item_date_arrive < '".$this->StartDate."' AND rv_reservation_item.rv_item_date_depart > '".$this->EndDate."')
				)
				AND allocated_item.rv_reservation_item_ix IS NOT NULL
				AND (
					allocated_res.rf_reservation_status_id = '30'
					OR (
						allocated_res.rf_reservation_status_id = '25'
						AND allocated_res.rv_create_expiry_date >= '" . date("Y-m-d H:i:s") . "' 
					) OR (
						allocated_res.rf_reservation_status_id = '20'
						AND allocated_res.rv_provision_expiry_date >= '" . $this->Today . "'
					)
				)
				" . $agentSQL . "
			ORDER BY
				pr_persona.pr_name_last 
		",2);

		foreach($this->Date as $thisDate) {
			$agentList = array();
			$expiryDaysAllowed = dateSubtract($thisDate, $this->Today);
			foreach($rawAgentList as $item) {
				if(
					(
						$item['rv_item_date_arrive'] <= $thisDate 
						&& $item['rv_item_date_depart'] > $thisDate
					) && (
						in_array($item['rv_reservation_ix'], $ignoreAllocations)
						|| (
							$this->ExpiredAllocation
							|| (
								!$this->ExpiredAllocation
								&& (
									(
										$item['rv_alloc_expiry_date'] != "0000-00-00"
										&& $item['rv_alloc_expiry_date'] >= $this->Today
									) || (
										$item['rv_alloc_expiry_date'] == "0000-00-00"
										&& $item['rv_alloc_expiry_days'] <= $expiryDaysAllowed
									)
								)
							)
						)
					)
				) {
					if(!array_key_exists($item['rv_reservation_ix'],$agentList)) {
						$agentList[$item['rv_reservation_ix']] = $item;
					} else {
						$agentList[$item['rv_reservation_ix']]['occupancy_count'] += $item['occupancy_count'];
					}
				}
			}
			$agentUsedList = array();
			foreach($rawAgentUsedList as $item) {
				if($item['rv_item_date_arrive'] <= $thisDate && $item['rv_item_date_depart'] > $thisDate) {
					if(!array_key_exists($item['rv_reservation_ix'],$agentUsedList)) {
						$agentUsedList[$item['rv_reservation_ix']] = $item;
					} else {
						$agentUsedList[$item['rv_reservation_ix']]['occupancy_count'] += $item['occupancy_count'];
					}
				}
			}
			$unexpired = array();
			foreach($agentList as $item) {
				if(!array_key_exists($item['rv_agent_id'], $allocationAgent)) {
					$allocationAgent[$item['rv_agent_id']] = array(
						'pr_agent_id' => $item['rv_agent_id'],
						'pr_name_last' => $item['pr_name_last'],
						'allocation' => array(),
						'total' => array(),
						'total_used' => array(),
						'allocation_used' => array(),
						'total_balance' => array()
					);
				}

				if(!array_key_exists($thisDate, $allocationAgent[$item['rv_agent_id']]['total'])) {
					$allocationAgent[$item['rv_agent_id']]['total'][$thisDate] = 0;
				}
				$allocationAgent[$item['rv_agent_id']]['total'][$thisDate] += $item['occupancy_count'];

				if(!$groupByAgent) {
					if(!array_key_exists($item['rv_reservation_ix'], $allocationAgent[$item['rv_agent_id']]['allocation'])) {
						$allocationAgent[$item['rv_agent_id']]['allocation'][$item['rv_reservation_ix']] = array(
							'rv_reservation_ix' => $item['rv_reservation_ix'],
							'rv_res_name' => $item['rv_res_name'],
							'bl_block_abbrev' => $item['bl_block_abbrev'],
							'occupancy' => array()
						);
					}
					$allocationAgent[$item['rv_agent_id']]['allocation'][$item['rv_reservation_ix']]['occupancy'][$thisDate] = $item['occupancy_count'];
				}
				$unexpired[] = $item['rv_reservation_ix'];
				if(!array_key_exists("total_used", $allocationAgent[$item['rv_agent_id']])) {
					$allocationAgent[$item['rv_agent_id']]['total_used'] = array();
				}
				if(!array_key_exists("allocation_used", $allocationAgent[$item['rv_agent_id']])) {
					$allocationAgent[$item['rv_agent_id']]['allocation_used'] = array();
				}
				if(!array_key_exists($thisDate, $allocationAgent[$item['rv_agent_id']]['total_used'])) {
					$allocationAgent[$item['rv_agent_id']]['total_used'][$thisDate] = 0;
				}
				if ($materialisation) {
					if(!array_key_exists("materialisation", $allocationAgent[$item['rv_agent_id']])) {
						$allocationAgent[$item['rv_agent_id']]['materialisation'] = array();
						$allocationAgent[$item['rv_agent_id']]['materialisation'][$thisDate] = 0;
						$allocationAgent[$item['rv_agent_id']]['allocation_materialisation'] = array();
					}
				}
			}
			$unexpired = array_unique($unexpired);

			foreach($agentUsedList as $item) {
				if(!array_key_exists($item['rv_agent_id'], $allocationAgent)) {
					$allocationAgent[$item['rv_agent_id']] = array(
						'pr_agent_id' => $item['rv_agent_id'],
						'pr_name_last' => $item['pr_name_last'],
						'allocation' => array(),
						'total' => array(),
						'total_used' => array(),
						'allocation_used' => array(),
						'total_balance' => array()
					);
				}

				if(!array_key_exists($thisDate, $allocationAgent[$item['rv_agent_id']]['total'])) {
					$allocationAgent[$item['rv_agent_id']]['total'][$thisDate] = 0;
				}
				if(!in_array($item['rv_reservation_ix'],$unexpired)) {
					$allocationAgent[$item['rv_agent_id']]['total'][$thisDate] -= $item['occupancy_count'];
				}
				if(!array_key_exists("total_used", $allocationAgent[$item['rv_agent_id']])) {
					$allocationAgent[$item['rv_agent_id']]['total_used'] = array();
				}
				if(!array_key_exists("allocation_used", $allocationAgent[$item['rv_agent_id']])) {
					$allocationAgent[$item['rv_agent_id']]['allocation_used'] = array();
				}
				if ($materialisation) {
					if(!array_key_exists("materialisation", $allocationAgent[$item['rv_agent_id']])) {
						$allocationAgent[$item['rv_agent_id']]['materialisation'] = array();
						$allocationAgent[$item['rv_agent_id']]['allocation_materialisation'] = array();
					}
				}
				if(!array_key_exists($thisDate, $allocationAgent[$item['rv_agent_id']]['total_used'])) {
					$allocationAgent[$item['rv_agent_id']]['total_used'][$thisDate] = 0;
				}
				$allocationAgent[$item['rv_agent_id']]['total_used'][$thisDate] -= $item['occupancy_count'];
				if(isset($allocationAgent[$item['rv_agent_id']]['materialisation']) && !array_key_exists($thisDate, $allocationAgent[$item['rv_agent_id']]['materialisation'])) {
					if ($allocationAgent[$item['rv_agent_id']]['total'][$thisDate] > 0) {
						$allocationAgent[$item['rv_agent_id']]['materialisation'][$thisDate] = $allocationAgent[$item['rv_agent_id']]['total_used'][$thisDate] / $allocationAgent[$item['rv_agent_id']]['total'][$thisDate] * 100;
					} else {
						$allocationAgent[$item['rv_agent_id']]['materialisation'][$thisDate] = 0;
					}
				}

				if(!$groupByAgent) {
					if(!array_key_exists($item['rv_reservation_ix'], $allocationAgent[$item['rv_agent_id']]['allocation_used'])) {
						$allocationAgent[$item['rv_agent_id']]['allocation_used'][$item['rv_reservation_ix']] = array(
							'rv_reservation_ix' => $item['rv_reservation_ix'],
							'rv_res_name' => $item['rv_res_name'],
							'bl_block_abbrev' => $item['bl_block_abbrev'],
							'occupancy' => array()
						);
					}
					if(!in_array($item['rv_reservation_ix'],$unexpired)) {
						if(!array_key_exists($item['rv_reservation_ix'], $allocationAgent[$item['rv_agent_id']]['allocation'])) {
							$allocationAgent[$item['rv_agent_id']]['allocation'][$item['rv_reservation_ix']] = array(
								'rv_reservation_ix' => $item['rv_reservation_ix'],
								'rv_res_name' => $item['rv_res_name'],
								'bl_block_abbrev' => $item['bl_block_abbrev'],
								'occupancy' => array()
							);
						}
						$allocationAgent[$item['rv_agent_id']]['allocation'][$item['rv_reservation_ix']]['occupancy'][$thisDate] = -$item['occupancy_count'];
					}
					$allocationAgent[$item['rv_agent_id']]['allocation_used'][$item['rv_reservation_ix']]['occupancy'][$thisDate] = -$item['occupancy_count'];
				}
			}
		}
		foreach($allocationAgent as $key => $item) {
			foreach($item['total'] as $totalDate => $totalValue) {
				$allocationAgent[$key]['total_balance'][$totalDate] = $totalValue - (isset($item['total_used'][$totalDate]) ? $item['total_used'][$totalDate] : 0);
				if (!isset($allocationAgent[$key]['allocation_used'][$totalDate])) {
					$allocationAgent[$key]['allocation_used'][$totalDate] = 0;
				}
				if (!isset($allocationAgent[$key]['total_used'][$totalDate])) {
					$allocationAgent[$key]['total_used'][$totalDate] = 0;
				}
				if ($materialisation) {
					if(!array_key_exists("materialisation", $allocationAgent[$key])) {
						$allocationAgent[$key]['materialisation'] = array();
					}
					if(!array_key_exists($totalDate, $allocationAgent[$key]['materialisation'])) {
						$allocationAgent[$key]['materialisation'][$totalDate] = 0;
					}
				}
			}
			if(!$groupByAgent) {
				foreach($item['allocation'] as $allocId => $allocItem) {
					$allocationAgent[$key]['allocation_balance'][$allocId] = array(
						'rv_reservation_ix' => $allocItem['rv_reservation_ix'],
						'rv_res_name' => $allocItem['rv_res_name'],
						'bl_block_abbrev' => $allocItem['bl_block_abbrev'],
						'occupancy' => array()
					);
					if ($materialisation) {
						$allocationAgent[$key]['allocation_materialisation'][$allocId] = array(
							'rv_reservation_ix' => $allocItem['rv_reservation_ix'],
							'rv_res_name' => $allocItem['rv_res_name'],
							'bl_block_abbrev' => $allocItem['bl_block_abbrev'],
							'occupancy' => array()
						);
					}
					foreach($allocItem['occupancy'] as $date => $amount) {
						$allocationAgent[$key]['allocation_balance'][$allocId]['occupancy'][$date] = 
							$amount - (isset($item['allocation_used'][$allocId]['occupancy'][$date]) ? $item['allocation_used'][$allocId]['occupancy'][$date] : 0);
						if ($materialisation) {
							if ($amount > 0) {
								$allocationAgent[$key]['allocation_materialisation'][$allocId]['occupancy'][$date] = 
									(isset($item['allocation_used'][$allocId]['occupancy'][$date]) ? $item['allocation_used'][$allocId]['occupancy'][$date] : 0) / $amount * 100;
							} else {
								$allocationAgent[$key]['allocation_materialisation'][$allocId]['occupancy'][$date] = 0;
							}
						}
					}
				}
			}
		}
		return $allocationAgent;
	}

	function ToReservationAllocation($rv_reservation_item_id=false, $excludeBlockAllocations=false) {
		$this->Generate();
		global $lDB;

		$itemJoin = "LEFT";
		if($rv_reservation_item_id === false || $rv_reservation_item_id == "") {
			$itemSQL = "";
		} else {
			$itemSQL = "
				AND (
					res_item.rv_reservation_item_ix IS NULL
					OR res_item.rv_reservation_item_ix = '$rv_reservation_item_id'
				)";
		}
		$excludeBlockAllocationsSQL = "";
		if ($excludeBlockAllocations) {
			$excludeBlockAllocationsSQL = " AND (rv_reservation.bl_block_period_id = '' OR rv_reservation.bl_block_period_id IS NULL) ";
		}
		if ($rv_reservation_item_id !== false && $excludeBlockAllocations === false) {
			$itemJoin = "INNER";
		}

		$allocationSQL = $this->GetAllocationSQL($this->EndDate);
		$rawAllocationList = $lDB->get("
			SELECT
				rv_reservation.rv_reservation_ix,
				rv_reservation.rv_res_name,
				rv_reservation_item.rv_item_accomm_count AS allocation_count,
				CASE rv_reservation_item.rv_alloc_expiry_date
					WHEN '0000-00-00' THEN rv_reservation.rv_alloc_expiry_date
					WHEN NULL THEN rv_reservation.rv_alloc_expiry_date
					ELSE rv_reservation_item.rv_alloc_expiry_date
				END AS rv_alloc_expiry_date,
				rv_reservation.rv_alloc_expiry_days,
				rv_reservation_item.rv_item_date_arrive,
				rv_reservation_item.rv_item_date_depart,
				rv_reservation.rv_alloc_expiry_days,
				bl_block.bl_block_ix,
				bl_block.bl_block_name
			FROM
				rv_reservation_item
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
				$itemJoin JOIN rv_reservation_item AS res_item ON res_item.rv_reservation_item_ix = rv_reservation_item.rv_link_res_item_id
				LEFT JOIN rv_reservation AS res ON res.rv_reservation_ix = res_item.rv_reservation_id
				LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id
				LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id
			WHERE
				rv_reservation_item.ac_accomm_type_id = '" . $this->AccommTypeId . "'
				$this->AllocationFilterSQL
				AND (
					(rv_reservation_item.rv_item_date_arrive >= '".$this->StartDate."' AND rv_reservation_item.rv_item_date_arrive <= '".$this->EndDate."')
					OR (rv_reservation_item.rv_item_date_depart >= '".$this->StartDate."' AND rv_reservation_item.rv_item_date_depart <= '".$this->EndDate."')
					OR (rv_reservation_item.rv_item_date_arrive < '".$this->StartDate."' AND rv_reservation_item.rv_item_date_depart > '".$this->EndDate."')
				)
				AND (
					res.rv_reservation_ix IS NULL
					OR res.rf_reservation_status_id = '30'
					OR (
						res.rf_reservation_status_id = '25'
						AND res.rv_create_expiry_date >= '" . date("Y-m-d H:i:s") . "' 
					) OR (
						res.rf_reservation_status_id = '20'
						AND res.rv_provision_expiry_date >= '" . $this->Today . "'
					)
				)
				AND $allocationSQL
				" . $this->AgentFilterSQL . "
				$itemSQL
				$excludeBlockAllocationsSQL
			ORDER BY
				rv_reservation.rv_date_recorded
		",2);
		if (empty($rawAllocationList)) {
			return array();
		}
		
		$rawItemList = array();
		if($rv_reservation_item_id !== false && $rv_reservation_item_id != "") {
			$rawItemList = $lDB->get("
				SELECT
					rv_reservation.rv_reservation_ix,
					rv_reservation.rv_res_name,
					alloc_item.rv_item_accomm_count as allocation_count,
					CASE alloc_item.rv_alloc_expiry_date
						WHEN '0000-00-00' THEN rv_reservation.rv_alloc_expiry_date
						WHEN NULL THEN rv_reservation.rv_alloc_expiry_date
						ELSE rv_reservation_item.rv_alloc_expiry_date
					END AS rv_alloc_expiry_date,
					rv_reservation.rv_alloc_expiry_days,
					alloc_item.rv_item_date_arrive,
					alloc_item.rv_item_date_depart
				FROM
					rv_reservation_item
					INNER JOIN rv_reservation_item AS alloc_item ON rv_reservation_item.rv_reservation_item_ix = alloc_item.rv_link_res_item_id
					INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = alloc_item.rv_reservation_id
				WHERE
					rv_reservation_item.rv_reservation_item_ix = '$rv_reservation_item_id'
					AND (
						(alloc_item.rv_item_date_arrive >= '".$this->StartDate."' AND alloc_item.rv_item_date_arrive <= '".$this->EndDate."')
						OR (alloc_item.rv_item_date_depart >= '".$this->StartDate."' AND alloc_item.rv_item_date_depart <= '".$this->EndDate."')
						OR (alloc_item.rv_item_date_arrive < '".$this->StartDate."' AND alloc_item.rv_item_date_depart > '".$this->EndDate."')
					)
			",2);
		}
		$reservationAllocation = array();
		foreach($this->Date as $thisDate) {
			$allocationList = array();
			$expiryDaysAllowed = dateSubtract($thisDate, $this->Today);
			foreach($rawAllocationList as $item) {
				if(
					(
						$item['rv_item_date_arrive'] <= $thisDate 
						&& $item['rv_item_date_depart'] > $thisDate
					) && (
						$this->ExpiredAllocation
						|| (
							!$this->ExpiredAllocation
							&& (
								(
									$item['rv_alloc_expiry_date'] != "0000-00-00"
									&& $item['rv_alloc_expiry_date'] >= $this->Today
								) || (
									$item['rv_alloc_expiry_date'] == "0000-00-00"
									&& $item['rv_alloc_expiry_days'] <= $expiryDaysAllowed
								)
							)
						)
					)
				) {
					if(!array_key_exists($item['rv_reservation_ix'],$allocationList)) {
						$allocationList[$item['rv_reservation_ix']] = $item;
					} else {
						$allocationList[$item['rv_reservation_ix']]['allocation_count'] += $item['allocation_count'];
					}
				}
			}
			$itemList = array();
			if($rv_reservation_item_id !== false && $rv_reservation_item_id != "") {
				foreach($rawItemList as $item) {
					if($item['rv_item_date_arrive'] <= $thisDate && $item['rv_item_date_depart'] > $thisDate) {
						if(!array_key_exists($item['rv_reservation_ix'],$itemList)) {
							$itemList[$item['rv_reservation_ix']] = $item;
						} else {
							$itemList[$item['rv_reservation_ix']]['allocation_count'] += $item['allocation_count'];
						}
					}
				}
			}
			foreach($allocationList as $item) {
				$expired = false;
				$selected = false;
				if($item['rv_alloc_expiry_date'] != "0000-00-00") {
					if($item['rv_alloc_expiry_date'] < date("Y-m-d")) {
						$expired = true;
					}
				} else {
					if($item['rv_alloc_expiry_days'] > dateSubtract($thisDate, date("Y-m-d"))) {
						$expired = true;
					}
				}
				if($rv_reservation_item_id !== false || $rv_reservation_item_id != "") {
					foreach($itemList as $resItem) {
						if($item['rv_reservation_ix'] == $resItem['rv_reservation_ix']) {
							$selected = true;
							if ($resItem['allocation_count'] >= 0) {
								$item['allocation_count'] -= $resItem['allocation_count'];
							} else {
								$item['allocation_count'] += $resItem['allocation_count'];
							}
						}
					}
				}
				$reservationAllocation[$thisDate][$item['rv_reservation_ix']] = array(
					'rv_reservation_ix' => $item['rv_reservation_ix'],
					'rv_res_name' => $item['rv_res_name'],
					'allocation_count' => $item['allocation_count'],
					'expired' => $expired,
					'selected' => $selected,
					'bl_block_ix' => $item['bl_block_ix'],
					'bl_block_name' => $item['bl_block_name'],
					'rv_alloc_expiry_date' => $item['rv_alloc_expiry_date']
				);
			}
		}
		return $reservationAllocation;
	}

	function toOccupancyAllocation() {
		global $lDB;
		$alloc = $this->ToReservationAllocation();

		$allocRes = array();
		$allocExpiryDate = array();
		foreach($alloc as $date=>$item) {
			foreach($item as $res=>$detail) {
				if(!$detail['expired']) {
					if(!array_key_exists($res,$allocRes)) {
						$allocRes[$res] = array();
					}
					if(!array_key_exists($date,$allocRes[$res])) {
						$allocRes[$res][$date] = 0;
					}
					$allocRes[$res][$date] += $detail['allocation_count'];
					if(!array_key_exists($res,$allocExpiryDate)) {
						$allocExpiryDate[$res] = array();
					}
					if(!array_key_exists($date,$allocExpiryDate[$res])) {
						$allocExpiry[$res][$date] = $detail['rv_alloc_expiry_date'];
					}
				}
			}
		}
		ksort($allocRes);
		foreach($allocRes as $res=>$item) {
			ksort($allocRes[$res]);
		}
		foreach($allocRes as $res=>$item) {
			$resInfo = $lDB->get("
				SELECT
					rv_reservation.rv_reservation_ix,
					rv_reservation.rv_res_name,
					bl_block.bl_block_ix,
					bl_block.bl_block_abbrev,
					bl_block.bl_block_name,
					rv_reservation.rv_alloc_expiry_date,
					rv_reservation.rv_alloc_expiry_days,
					pr_persona.pr_name_last,
					rv_reservation.rv_agent_id
				FROM
					rv_reservation
					INNER JOIN pr_persona ON rv_reservation.rv_agent_id = pr_persona.pr_persona_ix
					LEFT JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id
					LEFT JOIN bl_block ON bl_block.bl_block_ix = bl_block_period.bl_block_id
				WHERE
					rv_reservation.rv_reservation_ix = '$res'
			",1);
			$newItems = array();
			$new = true;
			foreach($item as $date=>$count) {
				if($new) {
					if (isset($allocExpiry[$res][$date])) {
						if ($allocExpiry[$res][$date] != '0000-00-00' && !empty($allocExpiry[$res][$date])) {
							$resInfo['rv_alloc_expiry_date'] = $allocExpiry[$res][$date];
						}
					}
					$current = array_merge($resInfo,array(
						"start"=>$date,
						"end"=>$date,
						"count"=>$count
					));
					$new = false;
				}
				if($current['count'] == $count) {
					$current['end'] = $date;
				} else {
					if($current['count'] > 0) {
						array_push($newItems,$current);
					}
					$new = true;
				}
			}
			array_push($newItems,$current);
			$allocRes[$res] = $newItems;
		}		
		return $allocRes;
	}

	function IsFull($iIncludeProvisional=true, $iIncludeAllocation=true) {
		$allocation = $this->ToAvailability($iIncludeProvisional, $iIncludeAllocation);
		$full = array();

		foreach($allocation as $key => $item) {
			$full[$key] = true;
			if($item > 0) {
				$full[$key] = false;
			}
		}
		return $full;
	}

	function IsProvisional() {
		$occupancy = $this->CombineOccupancy("20");
		$provisional = array();

		foreach($occupancy as $key => $item) {
			$provisional[$key] = false;
			if($item > 0) {
				$provisional[$key] = true;
			}
		}
		return $provisional;
	}

	function ToOccupancy($tStatusFilter="30:25") {
		$this->Generate();
		return $this->CombineOccupancy($tStatusFilter);
	}

	function ToAccommMin() {
		$this->Generate();
		$min = false;

		foreach($this->Accomm as $key => $item) {
			if($min === false) $min = $item;
			if($item < $min) $min = $item;
		}
		return $min;
	}

	function ToAccommMax() {
		$this->Generate();
		$max = 0;

		foreach($this->Accomm as $key => $item) {
			if($item > $max) $max = $item;
		}
		return $max;
	}

}
