<?php

require_once(__DIR__ . '/class.financial.interface.php');
require_once(__DIR__ . '/class.sun.systems.transaction.summary.export.php');
require_once(__DIR__ . '/class.sun.systems.transactions.export.php');

/**
 * Implementation of the financial interface to the Sun Systems accounting system.
 */
class SunSystemsInterface extends FinancialInterface
{
    /**
     * The configuration options supported by the Sun Systems Interface.
     *
     * @var array
     */
    protected $supportedOptions = [];

    /**
     * Create an instance of the Sun Systems Interface for the given invoicing unit.
     *
     * @param MySQLDB $lDB The connection to the database.
     * @param string $invoicingUnit The id of the invoicing unit.
     */
    public function __construct($lDB, $invoicingUnit)
    {
        parent::__construct($lDB, $invoicingUnit);
    }

    /**
     * Generates an array of summarised transactions in the format required to be imported into Sun Systems.
     *
     * @param string $batch The id of the batch to export.
     * @return array An array of the invoices contained within the given batch.
     */
    public function exportTransactionSummary($batch)
    {
        $transactionSummaryExport = new SunSystemsTransactionSummaryExport(
            $this->lDB,
            $this->activeOptions,
            $batch,
            $this->invoicingUnit['currency_symbol']
        );
        return $transactionSummaryExport->export();
    }

    /**
     * Generates an array of transactions in the format required to be imported into Sun Systems.
     *
     * @param string $batch The id of the batch to export.
     * @return array An array of the invoices contained within the given batch.
     */
    public function exportTransactions($batch)
    {
        $transactionExport = new SunSystemsTransactionExport(
            $this->lDB,
            $this->activeOptions,
            $batch,
            $this->invoicingUnit['currency_symbol']
        );
        return $transactionExport->export();
    }
}