<?php

class tpParseObject
{
   var $AttribList;
   var $ParamList;
   var $ValueList;

   var $CustomTag;
   var $CustomContent;
   var $CustomEnd;

   var $Tag;
   var $Contents;
   var $End;

   function __construct()
   {
      $this->ParamList = array();
      $this->AttribList = array();
      $this->ValueList = array();

      $this->CustomTag = false;
      $this->Tag = "";

      $this->CustomContent = false;
      $this->Content = "";

      $this->CustomEnd = false;
      $this->End = "";
   }

   function setParam($param,$value)
   {
      array_push($this->ParamList,(strtolower($param)));
      array_push($this->ValueList,trim($value));
   }

   function setAttrib($value)
   {
      array_push($this->AttribList,$value);
   }

   function setTag($value)
   {
      $this->CustomTag = true;
      $this->Tag = $value;
   }

   function setContent($value)
   {
      $this->CustomContent = true;
      $this->Content = $value;
   }

   function setEnd($value)
   {
      $this->CustomEnd = true;
      $this->End = $value;
   }

   function result($tag,$content,$end)
   {
      if ($this->CustomTag != "")
      {
         $tag = $this->Tag;
      }
      if ($this->CustomContent != "")
      {
         $content = $this->Content;
      }
      if ($this->CustomEnd != "")
      {
         $end = $this->End;
      }
      $temp = explode(" ",$tag);
      $tagName = $temp[0];

      // Add parameters (name=value)
      $imax = sizeof($this->ParamList);
      for($i=0;$i<$imax;$i++)
      {
         $param = $this->ParamList[$i];
         $value = $this->ValueList[$i];
         if (strpos($tag," ".$param) !== false) {
            $tag = str_replace(">","",$tag);
            $tagData = explode(" ",$tag);

            $jmax = sizeof($tagData);
            for($j=0;$j<$jmax;$j++)
            {
               if (substr($tagData[$j],0,strlen($param)) == $param)
               {
                  $tagData[$j] = "";
                  if(isset($tagData[$j+1]) && strlen($tagData[$j+1]) > 0 && $tagData[$j+1][0] == "=") {
                     $tagData[$j+1] = "";
                  }
               }
            }
            $tag = join(" ",$tagData).">";
         }

         $tag = str_replace($tagName,$tagName." ".$param."=\"".$value."\"",$tag);
      }

      $imax = sizeof($this->AttribList);
      for($i=0;$i<$imax;$i++)
      {
         $attrib = $this->AttribList[$i];
         $tag = str_replace($tagName,$tagName." ".$attrib,$tag);
      }

      return $tag.$content.$end;
   }
}

class tpParseTable extends tpParseObject
{
   var $Data;

   function __construct()
   {
      $this->ParamList = array();
      $this->AttribList = array();
      $this->ValueList = array();

      $this->CustomTag = false;
      $this->Tag = "";

      $this->CustomContent = false;
      $this->Content = "";

      $this->CustomEnd = false;
      $this->End = "";

      $this->Data = array();
   }

   function setTag($value)
   {
      $this->CustomTag = true;
      $this->Tag = $value;
   }

   function setContent($value)
   {
      $this->CustomContent = true;
      $this->Content = $value;
   }

   function setEnd($value)
   {
      $this->CustomEnd = true;
      $this->End = $value;
   }

   function result($tag,$content,$end)
   {
      if ($this->CustomTag != "")
      {
         $tag = $this->Tag;
      }
      if ($this->CustomContent != "")
      {
         $content = $this->Content;
      }
      if ($this->CustomEnd != "")
      {
         $end = $this->End;
      }
      $temp = explode(" ",$tag);
      $tagName = $temp[0];

      // Add parameters (name=value)
      $imax = sizeof($this->ParamList);
      for($i=0;$i<$imax;$i++)
      {
         $param = $this->ParamList[$i];
         $value = $this->ValueList[$i];
         if (preg_match("/ ".$param."/",$tag))
         {
            $tag = str_replace(">","",$tag);
            $tagData = explode(" ",$tag);

            $jmax = sizeof($tagData);
            for($j=0;$j<$jmax;$j++)
            {
               if (substr($tagData[$j],0,strlen($param)) == $param)
               {
                  $tagData[$j] = "";
                  if ($tagData[$j+1][0] == "=")
                  {
                     $tagData[$j+1] = "";
                  }
               }
            }
            $tag = join(" ",$tagData).">";
         }

         $tag = str_replace($tagName,$tagName." ".$param."=\"".$value."\"",$tag);
      }

      $imax = sizeof($this->AttribList);
      for($i=0;$i<$imax;$i++)
      {
         $attrib = $this->AttribList[$i];
         $tag = str_replace($tagName,$tagName." ".$attrib,$tag);
      }

      if (sizeof($this->Data) > 0)
      {
         $key = "<tr";
         $raw = explode($key,$content);
         $imax = sizeof($raw);
         $rowpos = strlen($raw[0]) + strlen($key);
         $rowFound = false;
         $rowOpen = 0;
         $rowClose = 0;

         for ($i=1;$i<$imax;$i++)
         {
            if (strpos($raw[$i]," static") !== false)
            {
               $rowpos += strlen($raw[$i]) + strlen($key);
               continue;
            }

            $startTag = tpFindEdges($rowpos,$content);
            $closePoint = tpFindClosePos($startTag['tagName'],$startTag['cPos'],$content);
            $stopTag = tpFindEdges($closePoint+1,$content);
            $open = $startTag['oPos'];
            $close = $stopTag['cPos'] - $startTag['oPos'];

            $rowpos += strlen($raw[$i]) + strlen($key);
            if (!$rowFound)
            {
               $rowFound = true;
               $rowOpen = $open;
               $rowClose = $close;
            }
            else
            {
               $raw[$i] = "";
            }
         }
         $content = join($key,$raw);
         $rowText = substr($content,$rowOpen,$rowClose);
		 
		 $rowData = "";
         $rowCode = '"row_';
         $rowCodeRegEX = '/'.$rowCode.'/';
         $imax = sizeof($this->Data);
         for ($i=0;$i<$imax;$i++)
         {
            $thisRowText = $rowText;
            while (preg_match($rowCodeRegEX,$thisRowText))
            {
               $tmp = preg_split($rowCodeRegEX,$thisRowText);
               $posStart = strlen($tmp[0]) + strlen($rowCode);
               $tmp = substr($thisRowText,$posStart,strlen($thisRowText));
               $posEnd = strpos($tmp,'"');
               $keyCode = substr($thisRowText,$posStart,$posEnd);
               $thisRowText = substr($thisRowText,0,$posStart-(strlen($rowCode))+1).$this->Data[$i][$keyCode].substr($thisRowText,$posStart+$posEnd,strlen($thisRowText));
            }
            $rowData .= tpParse($this->Data[$i],$thisRowText);
         }
         #echo $rowData;
         $content = substr($content,0,$rowOpen).$rowData.substr($content,$rowClose+$rowOpen);
         #die();
      }

      return $tag.$content.$end;
   }
}
