<?php

require_once(__DIR__ . '/class.financial.interface.php');
require_once(__DIR__ . '/class.financial.options.php');
require_once(__DIR__ . '/class.twinfields.invoice.export.php');

/**
 * Implementation of the financial interface to the Xero accounting system.
 */
class TwinfieldsInterface extends FinancialInterface
{
    /**
     * The configuration options supported by the Sage Evolution interface.
     *
     * @var array
     */
    protected $supportedOptions = [
        [
            'id' => FinancialOptions::OPTION_MEMO_FORMAT_INVOICE,
            'default' => '20'
        ],
        [
            'id' => FinancialOptions::OPTION_TWINFIELDS_CODE,
            'default' => 'VRK'
        ],
        [
            'id' => FinancialOptions::OPTION_HEADER_LANGUAGE,
            'default' => FinancialOptions::HEADER_LANGUAGE_ENGLISH
        ]
    ];

    /**
     * Create an instance of the Twinfields Interface for the given invoicing unit.
     *
     * @param MySQLDB $lDB The connection to the database.
     * @param string $invoicingUnit The id of the invoicing unit.
     */
    public function __construct($lDB, $invoicingUnit)
    {
        parent::__construct($lDB, $invoicingUnit);
    }

    /**
     * Generates an array of invoices in the format required to be imported into Twinfields.
     *
     * @param string $batch The id of the batch to export.
     * @return array An array of the invoices contained within the given batch.
     */
    public function exportInvoices($batch)
    {
        $invoiceExport = new TwinfieldsInvoiceExport($this->lDB, $this->activeOptions, $batch);
        return $invoiceExport->export();
    }
}