<?php

require_once(__DIR__ . '/class.financial.interface.php');
require_once(__DIR__ . '/class.financial.options.php');
require_once(__DIR__ . '/class.xero.invoice.export.php');

/**
 * Implementation of the financial interface to the Xero accounting system.
 */
class XeroInterface extends FinancialInterface
{
    /**
     * The configuration options supported by the Xero interface.
     *
     * @var array
     */
    protected $supportedOptions = [
        [
            'id' => FinancialOptions::OPTION_ACCOUNT_CODE_FORMAT,
            'default' => FinancialOptions::ACCOUNT_CODE_FORMAT_LEDGER_CODE_COST_CNTR
        ],
        [
            'id' => FinancialOptions::OPTION_REFERENCE_FORMAT,
            'default' => FinancialOptions::REFERENCE_FORMAT_RES_NUM
        ],
        [
            'id' => FinancialOptions::OPTION_INV_AMT_TYPE,
            'default' => FinancialOptions::INV_AMT_TYPE_SOURCE_CURR_INCL_TAX
        ],
        [
            'id' => FinancialOptions::OPTION_MEMO_FORMAT,
            'default' => FinancialOptions::MEMO_FORMAT_RES_NUM . ',' . FinancialOptions::MEMO_FORMAT_RES_NAME
        ],
        [
            'id' => FinancialOptions::OPTION_TRACKING_LABELS,
            'default' => 'Lodge,'
        ],
        [
            'id' => FinancialOptions::OPTION_TRACKING_VALUES,
            'default' => FinancialOptions::TRACKING_VALUES_COST_CNTR1 . ',' .
                FinancialOptions::TRACKING_VALUES_EMPTY
        ],
        [
            'id' => FinancialOptions::OPTION_DEBTOR_SELECT,
            'default' => FinancialOptions::DEBTOR_SELECT_RR
        ]
    ];

    /**
     * Create an instance of the Xero Interface for the given invoicing unit.
     *
     * @param MySQLDB $lDB The connection to the database.
     * @param string $invoicingUnit The id of the invoicing unit.
     */
    public function __construct($lDB, $invoicingUnit)
    {
        parent::__construct($lDB, $invoicingUnit);
    }

    /**
     * Generates an array of invoices in the format required to be imported into Xero.
     *
     * @param string $batch The id of the batch to export.
     * @return array An array of the invoices contained within the given batch.
     */
    public function exportInvoices($batch)
    {
        $invoiceExport = new XeroInvoiceExport($this->lDB, $this->activeOptions, $batch);
        return $invoiceExport->export();
    }
}