<?php
/*
 * $Id: class.xls.php,v 1.11 2012-09-14 10:17:56 light Exp $
 *
 * $Log: class.xls.php,v $
 * Revision 1.11  2012-09-14 10:17:56  light
 * Bug #8061 - HTML formatting codes are broken in XLS export
 *
 * Revision 1.10  2012-08-01 16:46:13  light
 * Bug #8016 - Encode HTML characters in ALL excel output
 *
 * Revision 1.9  2011-05-17 14:08:21  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.8  2011-01-10 15:25:38  light
 * Bug #7452 - CRM report export not opening in Excel
 *
 * Revision 1.7  2010-11-18 21:30:43  light
 * Bug #7290 - [PARENT] Ops Chart
 *
 * Revision 1.6  2009-08-03 11:44:00  light
 * Bug #6847 - [INT] Guest history report outstanding issues
 *
 * Revision 1.5  2009-07-27 14:16:33  light
 * Bug #6883 - Accommodation Chart Bugs
 *
 * Revision 1.4  2009-04-14 07:56:42  light
 * Bug #6723 - Project 10: ver 5.0 - Operations Chart
 *
 * Revision 1.2  2008-08-18 08:02:55  light
 * Bug #6501 - Project 6: bundled in version 4.0.2
 *
 * Revision 1.1  2008-08-01 10:22:32  light
 * Bug #6452 - Project 3: bundled in version 4.0.
 *
 * Bug #6144 - Export Accommodation Chart to excel.
 */

class XLS
{
	var $page;							//current page number
	var $author;						//author
	var $lauthor;						//last author
	var $dateCreated;					//Excel sheet creation date
	var $company;						//company name
	var $version;						//Version
	var $windowHeight;					//Window Height
	var $windowWidth;					//Window Width
    var $windowTopX;					//Window TopX
    var $windowTopY;					//WindowTopY
    var $protectStructure;				//Protect Structure
    var $protectWindows;				//Protect Windows

	var $horizontalResolution;			//Horizontal Resolution
    var $verticalResolution;			//Vertical Resolution

	var $styles = array();
	
	var $worksheets = array();
	var $table = array();
	var $row = array();
	var $cell = array();
	var $columns = array();

	function __construct($defaultStyle=array())
	{
		$this->dateCreated			=	date("Y-M-d");
		$this->windowHeight			=	6795;
		$this->windowWidth			=	8460;
		$this->windowTopX			=	120;
		$this->windowTopY			=	15;
		$this->windowHeight			=	6795;
		$this->windowHeight			=	6795;
		$this->protectStructure		=	false;
		$this->protectWindows		=	false;
		$this->horizontalResolution	=	600;
		$this->verticalResolution	=	600;

		$this->version				=	11.8036;
		$this->styles[0]			=	$defaultStyle;	
		
		$this->worksheet			=	array("Name" => "", "Protected" => 0, "RightToLeft" => 0);
	}

	function setAuther($author) {
		//Author of document
		$this->author = $author;
	}

	function setLastAuther($author) {
		//Last Author of document
		$this->lauthor = $author;
	}

	function setCompany($comp) {
		//set company name
		$this->company = $comp;
	}

	function setWindowHeight($h) {
		//set window height
		$this->windowHeight = $h;
	}


	function setWindowWidth($w) {
		//set window width
		$this->windowWidth = $w;
	}

	function setWindowTopX($x) {
		//set window top x axis
		$this->windowTopX = $x;
	}

	function setWindowTopY($y) {
		//set window top y axis
		$this->windowTopY = $y;
	}

	
	/* Format of $style array:
		$styles = array(
						'alignment'	=> array(
											Horizontal=>"Automatic", //Automatic, Left, Center, Right, Fill,Justify, CenterAcrossSelection, Distributed, and JustifyDistributed
											Indent => 0,			//Specifies the number of indents.
											ReadingOrder => "Context",			//Specifies the default right-to-left text entry mode for a cell.Other options are RightToLeft, LeftToRight, and Context
											ShrinkToFit =>0,				//True means that the text size should be shrunk so that all of the text fits within the cell.options are 0-false, 1-true;
											Vertical => "Automatic",		//Specifies the top-to-bottom alignment of text within a cell.Options are Automatic, Top, Bottom, Center, Justify, Distributed, and JustifyDistributed
											WrapText => 0					//Specifies whether the text in this cell should wrap at the cell boundary. False means that text either spills or gets truncated at the cell boundary, 0 or 1;
											),
						'border'		=> array([0]=>array(
												Position => "Left",			//Left, Top, Right, Bottom, DiagonalLeft, and DiagonalRight;
												Color => "#rrggbb",	//6-hexadecimal digit number in "#rrggbb" OR name;
												LineStyle => "None",		//Continuous,Dash,Dot,DashDot,DashDotDot,SlantDashDot,Double;
												Weight => 0			//0Hairline, 1Thin, 2Medium, 3Thick;
												), [1]=>array(//same way)),
						'font'			=> array(
												Bold => 0,				//1-yes, 0-no; 
												Color => "",			//6-hexadecimal digit number in "#rrggbb" OR name;
												FontName => "Arial",	//fontName {default Arial})
												Italic => 0,			//1, 0 {default 0}); 
												Outline => 0,			//(1, 0 {default 0});
												Shadow => 0,			//(1, 0 {default 0}), 
												Size => 10,				//({default 10}), 
												StrikeThrough => 0,		//(1, 0 {default 0}),
												Underline => "None"		//Single, Double, SingleAccounting,DoubleAccounting {default none}),
												VerticalAlign => "None",	//Subscript,Superscript {default None}), 
												CharSet => 0,			 
												Family => "Automatic"		// Decorative, Modern, Roman, Script, and Swiss {default Automatic})
												),
						'interior'		=> array(
												Color => "",			//6-hexadecimal digit number in "#rrggbb" OR name; 
												Pattern => "",			//None, Solid, Gray75, Gray50, Gray25, Gray125, Gray0625, HorzStripe, VertStripe, ReverseDiagStripe, DiagStripe, DiagCross, ThickDiagCross, ThinHorzStripe, ThinVertStripe, ThinReverseDiagStripe, ThinDiagStripe, ThinHorzCross, and ThinDiagCross;
												PatternColor => ""		//Specifies secondary fill color of the cell when Pattern does not equal Solid.;
												),
						'numberFormat'	=> array(
												Format => "General"		//General Number, General Date, Long Date, Medium Date, Short Date, Long Time, Medium Time, Short Time, Currency, Euro Currency, Fixed, Standard, Percent, Scientific, Yes/No, True/False, or On/Off;
												),
						'protection'	=> array(
												Protected =>1,			//(1, 0 {default 1});
												HideFormula => 0		//(1, 0 {default 0})
												)
						);
	*/

	function addStyle($styles=array(), $name='', $parent='') {
		$newStyle = true;
		
		foreach($this->styles as $key=>$styleArr) {
			$returnVal= $this->isArrayEquals($styleArr, $styles);
			if($returnVal) {
				$newStyle = false;
				return "s".$key;
			}
		}
		if($newStyle == true) {
				array_push($this->styles,$styles);
				$id = count($this->styles)-1;
				return "s".$id;
		}
	}

	/*
		Function : Column
		Param:
		$w = Specifies the width of a column in points. (Type = double)
		$autoFit = If true, column should be autosized for numeric and date values only. We do not autofit
					textual values. (Type = Boolean, Default =1)
		$styled = Specifies a reference to a previously defined ID attribute in a Style tag.
		$span = Specifies the number of adjacent columns with the same formatting as this column.
				(Unsigned long) 
		$hidden = True specifies that this column is hidden. (Type = Boolean)
		$index = Specifies the position of this column within the table. (Type = Unsigned long)
		$caption = Specifies the caption that should appear when the Component's custom row and column
					headers are showing. (Type = String)
	*/

	function Column($w="",$sheet=1, $autoFit="1", $styled="", $span="", $hidden="", $index="", $caption="") {
		$column = "<Column";
		if($autoFit == 0) {
			$column .= " ss:AutoFitWidth='0'";
		}
		if($w !="") {
			$column .= " ss:Width='".$w."'";
		}
		if($styled !="") {
			$column .= " ss:StyleID='".$styled."'";
		}
		if($span !="") {
			$column .= " ss:Span='".$span."'";
		}
		if($hidden !="") {
			$column .= " ss:Hidden='".$hidden."'";
		}
		if($index !="") {
			$column .= " ss:Index='".$index."'";
		}
		if($caption !="") {
			$column .= " ss:Caption='".$caption."'";
		}
		 $column .= "/>";

		 if(isset($this->columns[$sheet]) && is_array($this->columns[$sheet])) {
			array_push($this->columns[$sheet], $column);
		 } else {
			 $this->columns[$sheet] = array();
			 array_push($this->columns[$sheet], $column);
		}
		
	}



	/***********************************************************************************************
	function :	Cell
	param	 :	$data		-	Array of data neeed to add in cell.
				$formula	-	Specifies the formula stored in this cell. All formulas are persisted in R1C1
								notation.
				$arrRange	-	Specifies the range of cells onto which we apply an array formula. When an 
								array formula is specified, only the top-left cell contains an ArrayRange and 
								Formula attribute. Other cells in the range do not contain ArrayRange or 
								Formula. 
				$styleId	-	Specifies a reference to a previously defined ID attribute in a Style tag.
				$pFormula	-	Specifies the absolute formula stored in this cell when a copy/paste occurs 
								within the component. All formulas are persisted in R1C1 notation.
				$href		-	Specifies the URL to which to link this cell.
				$index		-	Specifies the column index of this cell within the containing row. If this 
								tag is not specified, the first instance of a Cell element within a row has 
								an assumed Index="1". Each additional Cell element has an assumed Index that 
								is one higher.
				$hTip		-	Caption that should appear when the component's custom row and column headers 
								are showing
				$mrgAcross	-	Specifies the number of adjacent cells across (right unless in right-to-left 
								mode) from the current cell to merge. 
				$mrgDown	-	Specifies the number of adjacent cells below the current cell to merge.
				
	************************************************************************************************/

	function Cell($data=array(),$styleId="",$index="", $href="",$hTip='',$formula="", $mrgAcross=0, $mrgDown=0, $pFormula="", $arrRange="") {
		$cell = "<Cell";
		if($pFormula != "") {
			$cell.= " ss:PasteFormula='".$pFormula."'";
		}
		if($arrRange != "") {
			$cell.= " ss:ArrayRange='".$arrRange."'";
		}
		if($formula != "") {
			$cell.= " ss:Formula='".$formula."'";
		}
		if($href != "") {
			$cell.= " ss:HRef='".$href."'";
		}
		if($index != "") {
			$cell.= " ss:Index='".$index."'";
		}
		if($styleId != "") {
			$cell.= " ss:StyleID='".$styleId."'";
		}
		if($mrgAcross != 0) {
			$cell.= " ss:MergeAcross='".$mrgAcross."'";
		}
		if($mrgDown != 0) {
			$cell.= " ss:MergeDown='".$mrgDown."'";
		}
		if($hTip != "") {
			$cell.= " ss:HRefScreenTip='".$hTip."'";
		}
		
		$cell.= ">";
		$rich = '';
		if(is_array($data)) {
			if($data['type'] == "String") {
				$data['data'] = str_replace("&nbsp;"," ",$data['data']);
				//$rich = ' xmlns="http://www.w3.org/TR/REC-html40"';
				$cell.= "<ss:Data ss:Type='".$data['type']."' xmlns='http://www.w3.org/TR/REC-html40'>" .trim($this->encode($data['data']))."</ss:Data>";
			} else {
				$cell.= "<Data ss:Type='".$data['type']."' ".$rich.">".trim($this->encode($data['data']))."</Data>";
			}

			if(isset($data['comment']) && is_array($data['comment'])) {
				$cell.= "<Comment ss:Author='".$this->encode($data['comment']['data'])."'  ss:ShowAlways=".$this->encode($data['comment']['data']).">";
				$cell.= "<Data ss:Type='".$data['comment']['type']."' ".$rich.">".trim($this->encode($data['comment']['data']))."</Data>";
				$cell.= "</Comment>";
			}
		}

		$cell.="</Cell>";

		return $cell;

	}
	
	/***********************************************************************************************
	function :	Row
	param	 :	$cells	-	Array of cells need to add in row.
				$h		-	Specifies the height of a row in points. (greater than or equal 0.)
				$autoFit-	Row should auto resized or not (1 or 0)
				$styleId-	Specifies a reference to a previously defined ID attribute in a Style tag.
				$span	-	Specifies the number of adjacent rows with the same formatting as this row.
				$hidden	-	True specifies that this row is hidden.
				$index	-	Specifies the position of this row within the table. If this tag is not specified, the first instance has an assumed Index="1".
				$caption-	Caption that should appear when the component's custom row and column headers are showing
				
	************************************************************************************************/

	function Row($cells=array(), $h='', $autoFit=1, $styleId="",$span=1,$hidden=false,$index="",$caption="" ) {
		$row = "<Row";
		if($h != "") {
			$row.= " ss:Height='".$h."'";
		}
		
		$row.= " ss:AutoFitHeight='".$autoFit."'";
		
		if($caption != "") {
			$row.= " ss:Caption='".$caption."'";
		}
		if($span != 1) {
			$row.= " ss:Span='".$span."'";
		}
		if($styleId != "") {
			$row.= " ss:StyleID='".$styleId."'";
		}
		if($index != "") {
			$row.= " ss:Index='".$index."'";
		}
		if($hidden != false) {
			$row.= " ss:Hidden='".$hidden."'";
		}
		
		$row.= ">\n";

		if(is_array($cells)) {
			foreach($cells as $cell) {
				$row.=$cell."\n";
			}
		}

		$row.= "</Row>";

		return $row;
	}

	/***********************************************************************************************
	function :	Table
	param	 :	$rows		-	Array of rows need to add in table
				$columnW	-	Default column width
				$rowH
				$styleId	-	Specifies a reference to a previously defined ID attribute in a Style tag.
				$colCount
				$rowCount
				$leftCell
				$topCell
				$fullCol
				$fullRows
	************************************************************************************************/

	function Table($rows=array(), $sheet=1, $columnArr=array(), $columnW=48, $rowH=12.75, $styleId="", $colCount="", $rowCount="", $leftCell=1, $topCell=1, $fullCol="", $fullRows="") {
		$table = "<Table";
		if($columnW != 48) {
			$table.= " ss:DefaultColumnWidth='".$columnW."'";
		}
		if($rowH != 12.75) {
			$table.= " ss:DefaultRowHeight='".$rowH."'";
		}
		if($colCount != "") {
			$table.= " ss:ExpandedColumnCount='".$colCount."'";
		}
		if($rowCount != "") {
			$table.= " ss:ExpandedRowCount='".$rowCount."'";
		}
		if($styleId != "") {
			$table.= " ss:StyleID='".$styleId."'";
		}
		if($leftCell != 1) {
			$table.= " ss:LeftCell='".$leftCell."'";
		}
		if($topCell != 1) {
			$table.= " ss:TopCell='".$topCell."'";
		}
		if($fullCol != "") {
			$table.= " ss:FullColumns='".$fullCol."'";
		}
		if($fullRows != "") {
			$table.= " ss:FullRows='".$fullRows."'";
		}
		
		$table.= ">\n";
		if(is_array($columnArr) && !empty($columnArr)) {
			foreach($columnArr as $col) {
				$table.= $col."\n";
			}
		} else if(isset($this->columns[$sheet]) && is_array($this->columns[$sheet])) {
			foreach($this->columns[$sheet] as $col) {
				$table.= $col."\n";
			}
		}

		if(is_array($rows)) {
			foreach($rows as $row) {
				$table.=$row."\n";
			}
		}

		$table.= "</Table>";

		return $table;
		
	}
	

	function Worksheet($tables = array(),$sheetNo=1, $name="") {
		if($name == "") {
			$name = "Sheet".$sheetNo;
		}

		$name = t_encodeHTMLField(preg_replace("/[\\[\\]\\/\\\\\\*\\?\\:]/","",$name));
		
		$sheet = "<Worksheet ss:Name=\"".$name."\">\n";
		if(is_array($tables)) {
			foreach($tables as $table) {
				$sheet.= $table."\n";
			}
		}
				
		$sheet.= "<WorksheetOptions xmlns='urn:schemas-microsoft-com:office:excel'>\n\t
					<Print>\n\t\t
						<ValidPrinterInfo />\n\t\t\t
						<HorizontalResolution>".$this->encode($this->horizontalResolution)."</HorizontalResolution>\n\t\t\t
						<VerticalResolution>".$this->encode($this->verticalResolution)."</VerticalResolution>\n\t\t\t
					</Print>\n\t\t
					<Selected />\n\t\t
					
					<ProtectObjects>False</ProtectObjects>\n\t\t
					<ProtectScenarios>False</ProtectScenarios>\n\t\t
				</WorksheetOptions>\n\t
			</Worksheet>";

		array_push($this->worksheets, $sheet);

	}

	function genrateWorkbook($workbookName, $workBookType="xls", $mailYn = 0) {
		$workbook = '<?xml version="1.0" encoding="utf-8"?>
				<?mso-application progid="Excel.Sheet"?>
				<Workbook
					xmlns="urn:schemas-microsoft-com:office:spreadsheet"
					xmlns:o="urn:schemas-microsoft-com:office:office"
					xmlns:x="urn:schemas-microsoft-com:office:excel"
					xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
					xmlns:html="http://www.w3.org/TR/REC-html40">
					<DocumentProperties xmlns="urn:schemas-microsoft-com:office:office">
						<Author>'.$this->encode($this->author).'</Author>
						<LastAuthor>'.$this->encode($this->lauthor).'</LastAuthor>
						<Created>'.$this->encode($this->dateCreated).'</Created>
						<Company>'.$this->encode($this->company).'</Company>
						<Version>'.$this->encode($this->version).'</Version>
					</DocumentProperties>
					<ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel">
						<WindowHeight>3795</WindowHeight>
						<WindowWidth>4460</WindowWidth>
						<WindowTopX>120</WindowTopX>
						<WindowTopY>150</WindowTopY>
						<ProtectStructure>False</ProtectStructure>
					</ExcelWorkbook>\n
		';
					
		if(isset($this->styles) && is_array($this->styles)) {
			$workbook.= "<Styles>\n";
			foreach($this->styles as $id=>$styles) {
				$align = "";
				$borders = array();
				$font = "";
				$interior = "";
				$numberFormat = "";
				$protection = "";
				$str = '';
				if($id == 0) {
					$sbstr = " ss:ID='Default'"; 
				}
				else {
					$sbstr = " ss:ID='s".$id."'";
				}

				$styles['alignment'] = isset($styles['alignment']) ? $styles['alignment'] : array();
				$styles['alignment']['WrapText'] = isset($styles['alignment']['WrapText']) ? $styles['alignment']['WrapText'] : 1;

				if(isset($styles['alignment'])) {
					foreach($styles['alignment'] as $key => $val) {
						$align.= " ss:".$key."='".trim($val)."'";
					}
				}
				
				if(isset($styles['border']) && is_array($styles['border']) && !empty($styles['border'])) {
					foreach($styles['border'] as $bord) {
						$border = "<Border";
						foreach($bord as $key => $val) {
							$border.= " ss:".$key."='".trim($val)."'";
						}
						$border.= "/> ";
						array_push($borders, $border);
					}
				}

				if(isset($styles['font']) && is_array($styles['font'])) {
					foreach($styles['font'] as $key => $val) {
						$font.= " ss:".$key."='".trim($val)."'";
					}
				}

				if(isset($styles['interior']) && is_array($styles['interior'])) {
					foreach($styles['interior'] as $key => $val) {
						$interior.= " ss:".$key."='".trim($val)."'";
					}
				}

				if(isset($styles['numberFormat']) && is_array($styles['numberFormat'])) {
					foreach($styles['numberFormat'] as $key => $val) {
						$numberFormat.= " ss:".$key."=".trim($val);
					}
				}

				if(isset($styles['protection']) && is_array($styles['protection'])) {
					foreach($styles['protection'] as $key => $val) {
						$protection.= " ss:".$key."=".trim($val);
					}
				}
				
				$str = "<Style".$sbstr.">";
				if($align!="") {
					$str .= "<Alignment".$align."/>";
				}
				if(!empty($borders)) {
					$str .= "<Borders>";
					foreach($borders as $border) {
						$str .= $border;
					}
					$str .= "</Borders>";
				}
				if($font!="") {
					$str .= "<Font".$font."/>";
				}
				if($interior!="") {
					$str .= "<Interior".$interior."/>";
				}
				if($numberFormat!="") {
					$str .= "<NumberFormat".$numberFormat."/>";
				}
				if($protection!="") {
					$str .= "<Protection".$protection."/>";
				}
				$str .= "</Style>";

				$workbook.= $str."\n";
			}
			$workbook.= "</Styles>";
		}
		
		//Add worksheet created above.
		if(isset($this->worksheets) && is_array($this->worksheets)) {
			foreach($this->worksheets as $worksheet) {
				$workbook.= $worksheet;
			}
		}
		
		$workbook.= "</Workbook>";
		
		if ( headers_sent() ) {
			echo('Some data has already been output to browser, can\'t send XLS file');
		}

		if($workBookType == "xls") {
			// Intercept the Excel XLS processing, and create XLSX file instead
			// Save temporary file, read into PHPExcel, then delete temporary file
			$remove = array("<b>", "</b>", "<u>", "</u>", "<i>", "</i>");
			$workbook = str_ireplace($remove, "", $workbook);
			require_once(__DIR__ . '/PHPExcel/PHPExcel/IOFactory.php');
			$file = tempnam(sys_get_temp_dir(), 'excel_');
			$handle = fopen($file, "w");
			fwrite($handle, $workbook);
			$objReader = PHPExcel_IOFactory::createReader('Excel2003XML');
			$objPHPExcel = $objReader->load($file);
			fclose($handle);
			unlink($file);

			// Styles are not retained through the conversion process from XLS to XLSX
			// Iterate through each cell, read and re-apply styles.
			foreach ($objPHPExcel->getWorksheetIterator() as $worksheet) {
				$worksheetTitle = $worksheet->getTitle();
				$highestColumn = $worksheet->getHighestColumn();
				$highestColumnIndex = PHPExcel_Cell::columnIndexFromString($highestColumn);
				$highestRow = $worksheet->getHighestRow();

				for($col = 0; $col < $highestColumnIndex; $col++) {
					for ($row = 1; $row <= $highestRow; $row++) {
						$cell = $worksheet->getCellByColumnAndRow($col, $row);

						$cell->getStyle()->applyFromArray(
							array(
								'font' => array(
									'name' => "Arial",
									'bold' => $cell->getStyle()->getFont()->getBold(),
									'italic' => $cell->getStyle()->getFont()->getItalic(),
									'underline' => $cell->getStyle()->getFont()->getUnderline(),
									'strike' => $cell->getStyle()->getFont()->getStrikethrough(),
									'size' => 10,
									'color' => array(
										'rgb' => $cell->getStyle()->getFont()->getColor()->getRGB()
									)
								),

								'fill' => array(
									'type' => $cell->getStyle()->getFill()->getStartColor()->getRGB() == "FFFFFF" ? PHPExcel_Style_Fill::FILL_NONE : PHPExcel_Style_Fill::FILL_SOLID,
									'color' => array(
										'rgb' => $cell->getStyle()->getFill()->getStartColor()->getRGB()
									)
								),
								'borders' => array(
									'left' => array(
										'style' => $cell->getStyle()->getBorders()->getLeft()->getBorderStyle() == "none" ? PHPExcel_Style_Border::BORDER_NONE : PHPExcel_Style_Border::BORDER_THIN,
										'color' => array(
											'rgb' => $cell->getStyle()->getBorders()->getLeft()->getColor()->getRGB()
										)
									),
									'top' => array(
										'style' => $cell->getStyle()->getBorders()->getTop()->getBorderStyle() == "none" ? PHPExcel_Style_Border::BORDER_NONE : PHPExcel_Style_Border::BORDER_THIN,
										'color' => array(
											'rgb' => $cell->getStyle()->getBorders()->getTop()->getColor()->getRGB()
										)
									),
									'right' => array(
										'style' => $cell->getStyle()->getBorders()->getRight()->getBorderStyle() == "none" ? PHPExcel_Style_Border::BORDER_NONE : PHPExcel_Style_Border::BORDER_THIN,
										'color' => array(
											'rgb' => $cell->getStyle()->getBorders()->getRight()->getColor()->getRGB()
										)
									),
									'bottom' => array(
										'style' => $cell->getStyle()->getBorders()->getBottom()->getBorderStyle() == "none" ? PHPExcel_Style_Border::BORDER_NONE : PHPExcel_Style_Border::BORDER_THIN,
										'color' => array(
											'rgb' => $cell->getStyle()->getBorders()->getBottom()->getColor()->getRGB()
										)
									)
								)
							)
						);
					}
				}
			}
			$objPHPExcel->setActiveSheetIndex(0);
			$objPHPExcel->getActiveSheet()->setSelectedCell('A1');

			// Create XLSX file
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

			if($mailYn == 1) {
				// Return file data for attaching to email
				ob_start();
				$objWriter->save('php://output');
				$excelOutput = ob_get_clean();
				return $excelOutput;
			} else {
				// Serve file for download, then die
				header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
				header('Content-Disposition: attachment;filename="' . $workbookName . '"');
				header('Cache-Control: max-age=0');
				ob_end_clean();
				echo $objWriter->save('php://output');
				die;
			}
		}

		if($mailYn == 1) {
			return $workbook;
		} else {
			if($workBookType == "xml") {
				$workbook = $workbook;
				header('Content-Type: text/xml; charset=utf-8');
			} else {
				$workbook = $workbook;
				header("Content-Type: application/vnd.ms-excel; charset=utf-8");
			}
			header("Cache-control: private");
			header('Content-Length: ' . strlen($workbook));
			header("Content-Disposition: attachment; filename=" . $workbookName);
			echo $workbook;
			flush();
			die();
		}
	}
	
	function rgb2html($r, $g=-1, $b=-1) {
		if(is_string($r) && $r[0] == "#") {
			return $r;
		}
		if (is_array($r) && sizeof($r) == 3)
			list($r, $g, $b) = $r;

		$r = intval($r); $g = intval($g);
		$b = intval($b);

		$r = dechex($r<0?0:($r>255?255:$r));
		$g = dechex($g<0?0:($g>255?255:$g));
		$b = dechex($b<0?0:($b>255?255:$b));

		$color = (strlen($r) < 2?'0':'').$r;
		$color .= (strlen($g) < 2?'0':'').$g;
		$color .= (strlen($b) < 2?'0':'').$b;
		return '#'.$color;
	}
	
	
	function isArrayEquals($arr1,$arr2) {
		$returnVal=true;
		if(is_array($arr1)) {
			foreach($arr1 as $k=>$val) {
				if(!array_key_exists($k,$arr2)) { 
					$returnVal=false;
					break;
				} else {
					if(is_array($val)) {
						if(!is_array($arr2[$k])) {
							$returnVal=false;
							break;
						}
						if($returnVal) {
							$returnVal=$this->isArrayEquals($arr1[$k],$arr2[$k]);
						}
					} else {
						if($arr1[$k]!==$arr2[$k]) { 
							$returnVal=false;
							break;
						}   
					}
				}
			}
		}
		
		if(is_array($arr2)) {
			foreach($arr2 as $k=>$val) {
				if(!array_key_exists($k,$arr1)) {
					$returnVal=false;
					break;
				} else {
					if(is_array($val)) {
						if(!is_array($arr1[$k])) {
							$returnVal=false;
							break;
						}
						if($returnVal) {
							$returnVal=$this->isArrayEquals($arr2[$k],$arr1[$k]);
						}
					} else{
						if($arr2[$k]!==$arr1[$k]) { 
							$returnVal=false;
							break;
						}   
					}
				}
			}
		}
		return   $returnVal ;
   }

	function encode($string){
		
		$string = str_replace("&nbsp;"," ",$string);
		$string = htmlspecialchars($string);
		$string = str_replace("\n", "&#10;", $string);

		$string = preg_replace("/&lt;b&gt;/i", "<B>", $string);
		$string = preg_replace("/&lt;\/b&gt;/i", "</B>", $string);

		$string = preg_replace("/&lt;br\/&gt;/i", "<BR />", $string);
		$string = str_replace("&amp;#10;", "&#10;", $string);

		return $string;
	}

}
