<?php

require_once(__DIR__ . "/class.zip_extract.php");
require_once(__DIR__ . "/functions.cache.php");

class Zip
{
	protected $files;

	function __construct($files=[])
	{
		$this->files = [];
		foreach($files as $filename=>$content) {
			$this->files[] = [
				PCLZIP_ATT_FILE_NAME=>$filename,
				PCLZIP_ATT_FILE_CONTENT=>$content
			];
		}
	}

	function export()
	{ 
		$tempFilename = tempnam(cacheRoot(),"tran_");
		$zip = new PclZip($tempFilename);
		$zip->create($this->files);
		$data = file_get_contents($tempFilename);
		unlink($tempFilename);
		return $data;
	}
}
