<?php

/*
 * $Id: confirm_yn.php,v 1.3 2013-08-23 11:52:20 light Exp $
 *
 * $Log: confirm_yn.php,v $
 * Revision 1.3  2013-08-23 11:52:20  light
 * Bug #8281 - Financial report cleanups
 *
 * Revision 1.2  2012-08-20 16:08:40  light
 * Bug #7951 - BROWSER: Google Chrome Compliance
 *
 * Revision 1.1  2011-12-22 12:46:29  light
 * Bug #7575 - Customisation of step 2 & 3 on public calendar
 *
 *
 */

/**
 * confim_yn.php - Confirmation popup (used by openConfirm())
 */

require_once(__DIR__ . '/class.mysqldb.php');
require_once(__DIR__ . '/inc.setup.php');
require_once(__DIR__ . '/functions.system.php');
require_once(__DIR__ . '/ac_logon.php');

session_write_close();

global $domain;

$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";
if ($userStatusId == "0") {
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/confirm_yn.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file(__DIR__ . "/../images/$principal_id/confirm_yn.htm")));
	}

	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/confirm_yn.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/confirm_yn.css\" type=\"text/css\" />";
	} else {
		$indexCSS = "";
	}
	$GLOBALS['temp']['customCSS'] = "
		<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />
		$indexCSS
	";
	
	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Do not include imageset CSS if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customCSS'] = "";
	}
}


?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html>
	<head>
		<title>Alert Message</title>
		<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
		<link rel="stylesheet" href="/resource/Resrequest/Application/public/css/sys.css" type="text/css" />
		<link rel="stylesheet" href="/resource/Resrequest/Application/public/css/enterprise.css" type="text/css" />
		<script type="text/javascript" src="/resource/Resrequest/Application/public/include/js/ui-kit/uikit.min.js"></script>
		<script type="text/javascript" src="/resource/Resrequest/Application/public/include/js/ui-kit/uikit-icons.min.js"></script>
		<?=$GLOBALS['temp']['customCSS']?>
		<script type="text/javascript" src="/resource/Resrequest/Application/public/include/js/system.js"></script>
	</head>

	<body onkeydown="keyDown(event);" onload="initialisePage();" onfocus="popupFocus();" onunload="popupUnload();" style="overflow:hidden;">
		<div id="overDiv" style="position: absolute; visibility: hidden; z-index: 1;"></div>
		<form style="margin: 0; padding: 0; height: 100vh; display: grid; grid-template-rows: auto 1fr auto;">
			<nav class="uk-navbar-container darkbar tb-smaller" uk-navbar>
				<div class="uk-navbar-left">
					<i class="material-icons uk-margin-small-right">warning</i>Confirm this action
				</div>
			</nav>
			<div class="tb-smaller-pop uk-background-default" style="overflow-y: auto;">
				<div>
					<div id="messageText" align="left"></div>
				</div>
			</div>
			<nav class="tb-smaller uk-navbar-container lgrey-bg" uk-navbar=uk-navbar>
				<div class="uk-navbar-center">
					<input onclick="setResponse('yes');" type="button" class="btn btn-primary uk-margin-small-right" value="Yes" />
					<input onclick="setResponse('no');" type="button" class="btn btn-lgrey" value="No" />

				</div>
			</nav>

		</form>
		
		<input type="hidden" id="message" name="message" />

		<?=$GLOBALS['temp']['customHTML']?>
		
		<script type="text/javascript">
			// <![CDATA[
			function initialisePage() {
				id("messageText").innerHTML = window.unescape(window.location.search.substr(9));
				var divHeight = document.getElementById('messageText').clientHeight;
				windowResize(300,200+divHeight);
			}

			function setResponse(response) {
				//opener.response = response;
				if ( response == "yes" ) {
					window.opener.confirmPopupAction();
				} else {
					window.opener.cancelPopupAction();
				}
				window.close();
			}

			function keyDown(e) {
				if ( e.keyCode == 13 || e.keyCode == 27 || e.keyCode == 78 ) {
					setResponse("no");
				}
				if ( e.keyCode == 89 ) {
					setResponse("yes");
				}				
				e.keyCode 		= 0;
				e.returnValue = false;
			}
			// ]]>
		</script>
	</body>
</html>

