<?php
/**
 * Base class file
 */
class File
{
  protected $fileName;
  protected $interpolated = false;
  protected $content = "";
  protected $extension = "";
  const TEMPLATE_FILES_DIRECTORY = __DIR__ . "/../../../../public/html/";
  const LEGACY_DIRECTORY = __DIR__ . "/../";
  const ALLOWED_EXTENSIONS = [
    'htm',
    'html',
    'js',
    'css'
  ];
  
  protected function __construct(
    $_fileName
  ) {
    $this->setFileName($_fileName);
    $this->setExtension($this->getFileName());
    $this->getContent();
  }

  public function setFileName($_fileName) {
    if (strpos($_fileName, "?")) {
      $_fileName = substr($_fileName, 0, strpos($_fileName, "?"));
    }
    $this->fileName = $_fileName;
  }

  public function getFileName($basename = false) {
    if ($basename) {
      return basename($this->fileName);
    } else {
      return $this->fileName;
    }
  }

  public function setExtension($_fileName) {
    $extension = "";
    if (!empty($_fileName)) {
      $extension = pathinfo($_fileName, PATHINFO_EXTENSION);
      if (strpos($extension, "?")) {
        $extension = substr($extension, 0, strpos($extension, "?"));
      }
      if (!in_array($extension, self::ALLOWED_EXTENSIONS)) {
        throw new Exception("ERROR: Extension '$extension' for '$_fileName' not allowed");
      }
    }
    $this->extension = $extension;
  }

  public function getExtension() {
    return $this->extension;
  }

  public function setInterpolated($_interpolated) {
    $this->interpolated = $_interpolated;
  }

  public function getInterpolated() {
    return $this->interpolated;
  }

  protected function getContent() {
    $fileName = $this->getFileName();
    if (!empty($fileName) && empty($this->content)) {
      if (file_exists($fileName)) {
        $this->content = @file_get_contents($fileName);
      } else {
        throw new Exception("ERROR: File '$fileName' not found");
      }
    }
    return $this->content;
  }

  protected function setContent($_content) {
    $this->content = $_content;
    return $this->content;
  }

  public function interpolate($data) {
    if (!empty($this->content)) {
      $this->content = $this->setContent(showpage($data, $this->content));
      $this->setInterpolated(true);
    }
    return $this->content;
  }
}
