<?php
require_once(__DIR__ . '/../functions.system.php');
require_once(__DIR__ . '/../inc.setup.php');
require_once(__DIR__ . '/class.file.php');

/**
 * Allows managing a script
 */
class Script extends File
{
  protected $urlBase;
  protected $position;
  protected $inline;
  protected $requiresInterpolation;

  const SCRIPT_POSITION_NONE = 0;
  const SCRIPT_POSITION_HEAD = 1;
  const SCRIPT_POSITION_TOP = 2;
  const SCRIPT_POSITION_BOTTOM = 3;
  // Sourced through script src tag
  const SCRIPT_INLINE_FALSE = false;
  // Injected inline inside document
  const SCRIPT_INLINE_TRUE = true;
  // Script requires interpolation
  const SCRIPT_REQUIRES_INTERPOLATION_FALSE = false;
  const SCRIPT_REQUIRES_INTERPOLATION_TRUE = true;
  const URL_BASE = "/resource/Resrequest/Application/public/";

  function __construct(
    $_fileName,
    $_inline,
    $_urlBase = "",
    $_position = 0,
    $_requiresInterpolation = false
  )
  {
    parent::__construct($_fileName);
    $this->setUrlBase($_urlBase);
    $this->setPosition($_position);
    $this->setInline($_inline);
    $this->setRequiresInterpolation($_requiresInterpolation);
  }

  public function setUrlBase($_urlBase) {
    $this->urlBase = $_urlBase;
  }

  public function getUrlBase() {
    return $this->urlBase;
  }

  public function setInline(bool $_inline) {
    $this->inline = $_inline;
  }

  public function getInline() {
    return $this->inline;
  }

  public function setRequiresInterpolation(bool $_requiresInterpolation) {
    $this->requiresInterpolation = $_requiresInterpolation;
  }

  public function getRequiresInterpolation() {
    return $this->requiresInterpolation;
  }

  public function setPosition($_position) {
    $this->position = $_position;
  }

  public function getPosition() {
    return $this->position;
  }

  public function getTag() {
    $tag = "";
    if ($this->getInline() === self::SCRIPT_INLINE_FALSE) {
      if (empty($this->urlBase)) {
        throw new Exception("ERROR: Url base is required to load script tag '$this->fileName'");
      }
      if ($this->getRequiresInterpolation() === self::SCRIPT_REQUIRES_INTERPOLATION_TRUE) {
        $src = $this->urlBase;
      } else {
        $src = $this->urlBase . $this->getFileName(true);
      }
      switch ($this->extension) {
        case 'js':
          $tag = "<script src=\"$src\"></script>";
          break;
        case 'css':
          $tag = "<link rel=\"stylesheet\" href=\"$src\" />";
          break;
        default:
          throw new Exception("ERROR: Undefined script type '$this->type' for '$this->fileName'");
          break;
      }
    } else {
      $fileName = $this->getFileName(true);
      switch ($this->extension) {
        case 'js':
          $tag = "\n// File: $fileName - START\n";
          $tag .= "//<![CDATA[\n";
          $tag .= $this->getContent();
          $tag .= "//]]>\n";
          $tag .= "\n// File: $fileName - END\n";
          $tag = "<script type=\"text/javascript\">\n$tag\n</script>";
          break;
        case 'css':
          $tag = "\n/* File: $fileName - START */\n";
          $tag .= $this->getContent();
          $tag .= "\n/* File: $fileName - END */\n";
          $tag = "<style>\n$tag\n</style>";
          break;
        default:
          throw new Exception("ERROR: Undefined script type '$this->extension' for '$this->fileName'");
          break;
      }
    }
    return $tag;
  }

  public static function setHeaders() {
    header('Content-Type: application/javascript');
  }
}
