<?php

require_once(__DIR__ . '/db.ac_accomm_room.php');
require_once(__DIR__ . '/db.ac_accomm_room_block.php');
require_once(__DIR__ . '/db.ac_accomm_type.php');

define("DB_AC_ACCOMM_BLOCK_TYPE_STATIC",1);
define("DB_AC_ACCOMM_BLOCK_TYPE_DYNAMIC",2);

function db_ac_accomm_block_exists($ac_accomm_block_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(ac_accomm_block_ix) FROM ac_accomm_block WHERE ac_accomm_block_ix = '$ac_accomm_block_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_ac_accomm_block_insert($ac_accomm_type_id,$ac_start_date,$ac_end_date,$ac_reason,$ac_type_ind) {
	global $lDB;
	global $dbcode;

	if(!db_ac_accomm_type_exists($ac_accomm_type_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO ac_accomm_block (
			ac_accomm_block_db,
			ac_accomm_type_id,
			ac_start_date,
			ac_end_date,
			ac_reason,
			ac_type_ind
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($ac_accomm_type_id)."',
			'".$lDB->escape($ac_start_date)."',
			'".$lDB->escape($ac_end_date)."',
			'".$lDB->escape($ac_reason)."',
			'".$lDB->escape($ac_type_ind)."'
		)
	");	

	$ac_accomm_block_id = $lDB->insert_id;

	return $ac_accomm_block_id;
}

function db_ac_accomm_block_delete($ac_accomm_block_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(*) FROM ac_accomm_room_block WHERE ac_accomm_block_id = '$ac_accomm_block_id'",4);

	if($count == 0) {
		$lDB->put("DELETE FROM ac_accomm_block WHERE ac_accomm_block.ac_accomm_block_ix = '$ac_accomm_block_id'");
	}
	return true;
}

function db_ac_accomm_block_set_start_date($ac_accomm_block_id, $ac_start_date) {
	global $lDB;

	if(!db_ac_accomm_block_exists($ac_accomm_block_id)) {
		return false;
	}

	$lDB->put("
		UPDATE
			ac_accomm_block
		SET
			ac_accomm_block.ac_start_date = '" . $lDB->escape($ac_start_date) . "'
		WHERE
			ac_accomm_block.ac_accomm_block_ix = '" . $lDB->escape($ac_accomm_block_id) . "'
	");

	return true;
}

function db_ac_accomm_block_set_end_date($ac_accomm_block_id, $ac_end_date) {
	global $lDB;

	if(!db_ac_accomm_block_exists($ac_accomm_block_id)) {
		return false;
	}

	$lDB->put("
		UPDATE
			ac_accomm_block
		SET
			ac_accomm_block.ac_end_date = '" . $lDB->escape($ac_end_date) . "'
		WHERE
			ac_accomm_block.ac_accomm_block_ix = '" . $lDB->escape($ac_accomm_block_id) . "'
	");

	return true;
}

function db_ac_accomm_block_clone($ac_accomm_block_id) {
	global $lDB;

	$ac_accomm_block = $lDB->get("
		SELECT
			ac_accomm_block.ac_accomm_type_id,
			ac_accomm_block.ac_start_date,
			ac_accomm_block.ac_end_date,
			ac_accomm_block.ac_reason,
			ac_accomm_block.ac_type_ind
		FROM
			ac_accomm_block
		WHERE
			ac_accomm_block.ac_accomm_block_ix = '" . $lDB->escape($ac_accomm_block_id) . "'
	",1);

	$clone_accomm_block_id = db_ac_accomm_block_insert(
		$ac_accomm_block['ac_accomm_type_id'],
		$ac_accomm_block['ac_start_date'],
		$ac_accomm_block['ac_end_date'],
		$ac_accomm_block['ac_reason'],
		$ac_accomm_block['ac_type_ind']
	);

	$ac_accomm_room_blocks = db_ac_accomm_room_block_get_room_by_block($ac_accomm_block_id);
	foreach($ac_accomm_room_blocks as $ac_accomm_room_id) {
		db_ac_accomm_room_block_insert($clone_accomm_block_id,$ac_accomm_room_id);
	}

	return $clone_accomm_block_id;
}

