<?php

function insert_accomm_uploaded_image($ac_accomm_image_filename, $ac_accomm_image_desc, $ac_accomm_type_id) {
	global $lDB;
	global $dbcode;

	$lDB->put("
		INSERT INTO ac_accomm_image (
			ac_accomm_image.ac_accomm_image_db,
			ac_accomm_image.ac_accomm_image_id,
			ac_accomm_image.ac_accomm_image_desc,
			ac_accomm_image.ac_accomm_image_filename,
			ac_accomm_image.ac_accomm_type_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($ac_accomm_image_desc)."',
			'".$lDB->escape($ac_accomm_image_filename)."',
			'".$lDB->escape($ac_accomm_type_id)."'
		)
	");

	$ac_accomm_image_id = $lDB->insert_id;

	return $ac_accomm_image_id;
}

function delete_accomm_image($ac_accomm_image_id) {
	global $lDB;

	$lDB->put("
		DELETE FROM 
			ac_accomm_image 
		WHERE 
			ac_accomm_image_ix = '$ac_accomm_image_id'
	");
}


function get_accomm_image_listing_names($ac_accomm_type_id) {
	global $lDB;
	global $principal_id;

	$imageList = $lDB->get("
		SELECT DISTINCT
			ac_accomm_image.ac_accomm_image_desc,
			ac_accomm_image.ac_accomm_image_filename,
			ac_accomm_image.ac_accomm_image_ix
		FROM
			ac_accomm_image
		WHERE
			ac_accomm_image.ac_accomm_type_id = '".$ac_accomm_type_id."'
		ORDER BY
			ac_accomm_image.ac_accomm_image_desc ASC
	",2);

	return $imageList;
}


function get_accomm_image_listing_data($pr_business_id, $ac_accomm_type_id) {
	global $lDB;
	global $principal_id;
	global $domain;

	$imageList = $lDB->get("
		SELECT DISTINCT
			ac_accomm_image.ac_accomm_image_desc,
			ac_accomm_image.ac_accomm_image_filename,
			ac_accomm_image.ac_accomm_image_ix
		FROM
			ac_accomm_image
		WHERE
			ac_accomm_image.ac_accomm_type_id = '".$ac_accomm_type_id."'
		ORDER BY
			ac_accomm_image.ac_accomm_image_desc ASC
	",2);

	$imageData = array();

	foreach ($imageList as $image) {
		// Forcing http to avoid SSL errors on getimagesize function
		$imageFile = "http://".$GLOBALS['images_dir'].'/'.$principal_id.'/business_structure/'.$pr_business_id.'/'.$ac_accomm_type_id.'/'.$image['ac_accomm_image_filename'];
		$realFile = __DIR__.'/../../../../../../../images/'.$principal_id.'/business_structure/'.$pr_business_id.'/'.$ac_accomm_type_id.'/'.$image['ac_accomm_image_filename'];
		$imageName = substr( $imageFile, (strrpos($imageFile, "/")+ 1) );
		$imageExtension = strtoupper( substr( $imageFile, (strrpos($imageFile, ".")+ 1) ) );
		 
        if (file_exists($imageFile)) {
            $imageSize = getimagesize($imageFile);
            $imageWidth = $imageHeight = $imageSize = 0;
            list($imageWidth, $imageHeight) = getimagesize($imageFile);
            $imageSize = ceil(filesize($realFile)/1000).'KB';
        } else {
            $imageSize = 0;
            $imageWidth = $imageHeight = $imageSize = 0;
            list($imageWidth, $imageHeight) = array(0, 0);
            $imageSize = '0KB';
        }
		
		$imageData[] = [
			"imageID" => $image['ac_accomm_image_ix'],
			"imageFile" => $imageFile,
			"imageDescription" => $image['ac_accomm_image_desc'],
			"imageName" => $imageName,
			"imageExtension" => $imageExtension,
			"imageSize" => $imageSize,
			"imageHeight" => $imageHeight,
			"imageWidth" => $imageWidth
		];
	}
	return $imageData;	
}

function get_accomm_image_listing_html($pr_business_id, $ac_accomm_type_id) {
	$imageData = get_accomm_image_listing_data($pr_business_id, $ac_accomm_type_id);
	$imageHtml = '<table width="100%" cellspacing="0" align="center" class="colLt">';

	foreach ($imageData as $image) {
		$imageHtml .= '<tr>
			<td width="10" valign="middle">
				<input type="checkbox" class="imageCheckbox" value="'.$image['imageID'].'" imageFile="'.$image['imageFile'].'">
			</td>
			<td valign="middle">
				<img src="'.$image['imageFile'].'" style="width:100px;">
			</td>
			<td valign="middle">
				<div>'.$image['imageDescription'].'</div>
				<div title="'.$image['imageFile'].'">'.$image['imageName'].'</div>
				<div>'.$image['imageExtension'].' - '.$image['imageSize'].' - '.$image['imageWidth'].' x '.$image['imageHeight'].'
			</td>
		</tr>
		<tr>
			<td height="5" colspan="3"><img src="/resource/Resrequest/Application/public/img/1x1.gif"></td>
		</tr>';
	}
	$imageHtml .= '</table>';

	return $imageHtml;
}
