<?php

require_once(__DIR__ . '/db.ac_accomm_block.php');
require_once(__DIR__ . '/db.ac_accomm_room_attr.php');
require_once(__DIR__ . '/db.ac_accomm_type.php');

function db_ac_accomm_room_exists($ac_accomm_room_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(ac_accomm_room_ix) FROM ac_accomm_room WHERE ac_accomm_room_ix = '$ac_accomm_room_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_ac_accomm_room_insert($ac_accomm_type_id,$ac_desc,$ac_accomm_room_create_date=false) {
	global $lDB;
	global $dbcode;

	if(!db_ac_accomm_type_exists($ac_accomm_type_id)) {
		return false;
	}

	if($ac_accomm_room_create_date === false) {
		$ac_accomm_room_create_date = date("Y-m-d");
	}

	$lDB->put("
		INSERT INTO ac_accomm_room (
			ac_accomm_room_db,
			ac_accomm_type_id,
			ac_desc,
			ac_accomm_room_create_date
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($ac_accomm_type_id)."',
			'".$lDB->escape($ac_desc)."',
			'".$lDB->escape($ac_accomm_room_create_date)."'
		)
	");

	$ac_accomm_room_id = $lDB->insert_id;

	$rf_date_res_limit = $lDB->get("SELECT rf_date_res_limit FROM rf_default",4);
	$stock = new Stock($ac_accomm_type_id,date("Y-m-d"), $rf_date_res_limit);
	$stock->ClearCache(array('accomm'));

	return $ac_accomm_room_id;
}

function db_ac_accomm_room_set_desc($ac_accomm_room_id,$ac_desc) {
	global $lDB;

	if(!db_ac_accomm_room_exists($ac_accomm_room_id)) {
		return false;
	}

	$lDB->put("UPDATE ac_accomm_room SET ac_desc = '$ac_desc' WHERE ac_accomm_room_ix = '$ac_accomm_room_id'");

	return true;
}

function db_ac_accomm_room_set_inactive($ac_accomm_room_id) {
	global $lDB;

	if(!db_ac_accomm_room_exists($ac_accomm_room_id)) {
		return false;
	}

	$today = date("Y-m-d");

	$lDB->put("
		UPDATE ac_accomm_room SET
			ac_accomm_room_inactive_yn = 1,
			ac_accomm_room_inactive_date = '".$lDB->escape($today)."'
		WHERE
			ac_accomm_room.ac_accomm_room_ix = '$ac_accomm_room_id'
	");

	return true;
}

function db_ac_accomm_room_delete($ac_accomm_room_id) {
	global $lDB;

	if(!db_ac_accomm_room_exists($ac_accomm_room_id)) {
		return false;
	}

	list($ac_accomm_type_id,$ac_accomm_room_create_date) = $lDB->get("
		SELECT
			ac_accomm_type_id,
			ac_accomm_room_create_date
		FROM
			ac_accomm_room WHERE ac_accomm_room_ix = '$ac_accomm_room_id'
	",1);

	$resRooms = $lDB->get("SELECT COUNT(*) FROM rv_res_item_group WHERE rv_res_item_group.ac_accomm_room_id = '$ac_accomm_room_id'",4);
	$resItems = $lDB->get("SELECT COUNT(*) FROM rv_reservation_item WHERE ac_accomm_type_id = '$ac_accomm_type_id'",4);

	$today = date("Y-m-d");

	if( // room is linked to one or more reservation room groups
		$resRooms > 0 
	) { // inactivate
		db_ac_accomm_room_set_inactive($ac_accomm_room_id);
	} else { // delete
		db_ac_accomm_room_attr_delete_by_room($ac_accomm_room_id);
		db_ac_accomm_room_block_delete_by_room($ac_accomm_room_id);
		$lDB->put("DELETE FROM ac_accomm_room WHERE ac_accomm_room.ac_accomm_room_ix = '$ac_accomm_room_id'");
	}

	$rf_date_res_limit = $lDB->get("SELECT rf_date_res_limit FROM rf_default",4);
	$stock = new Stock($ac_accomm_type_id,date("Y-m-d"), $rf_date_res_limit);
	$stock->ClearCache(array('accomm','block'));
	return true;
}
