<?php

require_once(__DIR__ . '/class.stock.php');
require_once(__DIR__ . '/db.ac_accomm_block.php');
require_once(__DIR__ . '/db.ac_accomm_room.php');

function db_ac_accomm_room_block_exists($ac_accomm_room_block_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(ac_accomm_room_block_ix) FROM ac_accomm_room_block WHERE ac_accomm_room_block_ix = '$ac_accomm_room_block_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_ac_accomm_room_block_insert($ac_accomm_block_id,$ac_accomm_room_id) {
	global $lDB;
	global $dbcode;

	if(!db_ac_accomm_block_exists($ac_accomm_block_id)) {
		return false;
	}

	if(!db_ac_accomm_room_exists($ac_accomm_room_id)) {
		return false;
	}

	$ac_accomm_type_id_block = $lDB->get("SELECT ac_accomm_type_id FROM ac_accomm_block WHERE ac_accomm_block_ix = '$ac_accomm_block_id'",4);
	$ac_accomm_type_id_room = $lDB->get("SELECT ac_accomm_type_id FROM ac_accomm_room WHERE ac_accomm_room_ix = '$ac_accomm_room_id'",4);

	if($ac_accomm_type_id_block != $ac_accomm_type_id_room) {
		return false;
	}
	
	$lDB->put("
		INSERT INTO ac_accomm_room_block (
			ac_accomm_room_block_db,
			ac_accomm_block_id,
			ac_accomm_room_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($ac_accomm_block_id)."',
			'".$lDB->escape($ac_accomm_room_id)."'
		)
	");	

	$ac_accomm_room_block_id = $lDB->insert_id;

	db_ac_accomm_room_block_clear_cache($ac_accomm_block_id);

	return $ac_accomm_room_block_id;
}

function db_ac_accomm_room_block_delete($ac_accomm_room_block_id) {
	global $lDB;

	if(!db_ac_accomm_room_block_exists($ac_accomm_room_block_id)) {
		return false;
	}

	$ac_accomm_block_id = $lDB->get("SELECT ac_accomm_block_id FROM ac_accomm_room_block WHERE ac_accomm_room_block_ix = '$ac_accomm_room_block_id'",4);

	$lDB->put("DELETE FROM ac_accomm_room_block WHERE ac_accomm_room_block.ac_accomm_room_block_ix = '$ac_accomm_room_block_id'");

	db_ac_accomm_room_block_clear_cache($ac_accomm_block_id);

	db_ac_accomm_block_delete($ac_accomm_block_id);

	return true;
}

function db_ac_accomm_room_block_get_room_by_block($ac_accomm_block_id) {
	global $lDB;

	return $lDB->get("
		SELECT
			ac_accomm_room_block.ac_accomm_room_id
		FROM
			ac_accomm_room_block
		WHERE
			ac_accomm_room_block.ac_accomm_block_id = '" . $lDB->escape($ac_accomm_block_id) . "'
	",3);
}

function db_ac_accomm_room_block_delete_by_block($ac_accomm_block_id) {
	global $lDB;

	if(!db_ac_accomm_block_exists($ac_accomm_block_id)) {
		return false;
	}
	
	$list = $lDB->get("
		SELECT
			ac_accomm_room_block.ac_accomm_room_block_ix
		FROM
			ac_accomm_room_block
		WHERE
			ac_accomm_room_block.ac_accomm_block_id = '$ac_accomm_block_id'
	",3);


	foreach($list as $ac_accomm_room_block_id) {
		db_ac_accomm_room_block_delete($ac_accomm_room_block_id);
	}
}

function db_ac_accomm_room_block_delete_by_room($ac_accomm_room_id) {
	global $lDB;

	if(!db_ac_accomm_room_exists($ac_accomm_room_id)) {
		return false;
	}

	$list = $lDB->get("
		SELECT
			ac_accomm_room_block.ac_accomm_room_block_ix
		FROM
			ac_accomm_room_block
		WHERE
			ac_accomm_room_block.ac_accomm_room_id = '$ac_accomm_room_id'
	",3);

	foreach($list as $ac_accomm_room_block_id) {
		db_ac_accomm_room_block_delete($ac_accomm_room_block_id);
	}
}

function db_ac_accomm_room_block_clear_cache($ac_accomm_block_id) {
	global $lDB;

	list($ac_accomm_type_id,$ac_start_date,$ac_end_date) = $lDB->get("
		SELECT
			ac_accomm_type_id,
			ac_start_date,
			ac_end_date
		FROM
			ac_accomm_block
		WHERE
			ac_accomm_block.ac_accomm_block_ix = '$ac_accomm_block_id'
	",1);

	$ac_end_date = date("Y-m-d", strtotime("-1 day", strtotime($ac_end_date)));

	$stock = new Stock($ac_accomm_type_id,$ac_start_date,$ac_end_date);
	$stock->ClearCache(array('block'));
}
