<?php

require_once(__DIR__ . '/class.stock.php');
require_once(__DIR__ . '/db.rt_rate.php');

require_once(__DIR__ . '/functions.property.php');

function db_ac_accomm_type_exists($ac_accomm_type_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(ac_accomm_type_ix) FROM ac_accomm_type WHERE ac_accomm_type_ix = '".$lDB->escape($ac_accomm_type_id)."'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_ac_accomm_type_delete($ac_accomm_type_id) {
	global $lDB;

	if(!db_ac_accomm_type_exists($ac_accomm_type_id)) {
		return false;
	}

	if (!accommCanDelete($ac_accomm_type_id)) {
		$lDB->put("
			UPDATE ac_accomm_type SET
				ac_accomm_type_inactive_yn = '1',
				ac_accomm_type_inactive_date = '".date("Y-m-d")."'
			WHERE
				ac_accomm_type_ix = '$ac_accomm_type_id'
		");
		$result = false;
	} else {
		db_rt_rate_delete_by_accomm_type($ac_accomm_type_id);
		$lDB->put("DELETE FROM ac_accomm_type WHERE ac_accomm_type_ix = '$ac_accomm_type_id'");
		$result = true;
	}	

	$rf_date_res_limit = $lDB->get("SELECT rf_date_res_limit FROM rf_default",4);
	$stock = new Stock($ac_accomm_type_id,date("Y-m-d"), $rf_date_res_limit);
	$stock->ClearCache();

	return $result;
}
