<?php

require_once(__DIR__ . "/db.ac_pos_stock.php");

function db_ac_pos_exists($ac_pos_id) {
	global $lDB;

	$apiCheck = $lDB->get("SELECT COUNT(ac_pos_ix) FROM ac_pos WHERE ac_pos_ix = '$ac_pos_id'",4);
	if($apiCheck > 0) { return true; } else { return false; }
}

function db_ac_pos_has_default($ac_pos_id) {
	global $lDB;

	$apiCheck = $lDB->get("
		SELECT
			COUNT(ac_pos_ix) 
		FROM
			ac_pos
			INNER JOIN ac_pos_stock ON ac_pos_stock.ac_pos_stock_ix = ac_pos.ac_pos_stock_id
		WHERE
			ac_pos_ix = '$ac_pos_id'
	",4);
	if($apiCheck > 0) { return true; } else { return false; }
}

function db_ac_pos_cash_period_desc($ac_cash_period_ind) {
	switch($ac_cash_period_ind) {
	case 1:
		return "Daily";
	case 2:
		return "Weekly";
	case 3:
		return "Monthly";
	default:
		return "";
	}
}

function db_ac_pos_cash_folio_desc($ac_cash_folio_ind) {
	switch($ac_cash_folio_ind) {
	case 1:
		return "Consolidate by currency";
	case 2:
		return "Split by transaction";
	case 0:
	default:
		return "";
	}
}

function db_ac_pos_set_pos_stock($ac_pos_id, $ac_pos_stock_id) {
	global $lDB;

	if(!db_ac_pos_exists($ac_pos_id)) {
		return false;
	}
	   
	if(!db_ac_pos_stock_exists($ac_pos_stock_id)) {
		$ac_pos_stock_id = "";
	}

	$lDB->put("
		UPDATE ac_pos SET
			ac_pos.ac_pos_stock_id = '" . $lDB->escape($ac_pos_stock_id) . "'
		WHERE
			ac_pos.ac_pos_ix = '" . $lDB->escape($ac_pos_id) . "'
	");

	return true;
}

function db_ac_pos_update_cc($ac_pos_ix,$fn_cost_centres = array()) {
	global $lDB;

	if(!db_ac_pos_exists($ac_pos_ix)) {
		return false;
	}
	$setFields = array();
	foreach ($fn_cost_centres as $fieldName => $ccId) {
		$ccIdValue = $lDB->escape($ccId) == 'None' ? "" : $lDB->escape($ccId);
		$setFields[] = $fieldName . " = '" . $ccIdValue . "'";
	}
	$setFieldsSql = join(', ', $setFields);

	$lDB->put("
		UPDATE 
			ac_pos
		SET 
			$setFieldsSql
		WHERE 
			ac_pos_ix = '" . $lDB->escape($ac_pos_ix) . "'
	");

	return true;

}

function db_ac_pos_update_default_cc($ac_pos_ix,$fn_cost_centre_1_ix_default) {
	global $lDB;

	if(!db_ac_pos_exists($ac_pos_ix)) {
		return false;
	}

	$lDB->put("
		UPDATE 
			ac_pos
		SET 
			fn_cost_centre_1_id = '$fn_cost_centre_1_ix_default'
		WHERE 
			ac_pos_ix = '$ac_pos_ix';
	");

return true;

}