<?php

require_once(__DIR__ . "/db.ac_pos.php");
require_once(__DIR__ . "/db.ac_pos_stock.php");

function db_ac_pos_map_exists($ac_pos_map_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(ac_pos_map_ix) FROM ac_pos_map WHERE ac_pos_map_ix = '" . $lDB->escape($ac_pos_map_id) . "'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_ac_pos_map_exists_by_pos($ac_pos_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(ac_pos_map_ix) FROM ac_pos_map WHERE ac_pos_id = '" . $lDB->escape($ac_pos_id) . "'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_ac_pos_map_insert($ac_pos_id,$ac_pos_stock_id) {
	global $lDB;
	global $dbcode;

	if(!db_ac_pos_exists($ac_pos_id)) {
		return false;
	}

	if(!db_ac_pos_stock_exists($ac_pos_stock_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO ac_pos_map (
			ac_pos_map_db,
			ac_pos_map_id,
			ac_pos_id,
			ac_pos_stock_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'',
			'".$lDB->escape($ac_pos_id)."',
			'".$lDB->escape($ac_pos_stock_id)."'
		)
	");

	$ac_pos_map_ix = $lDB->insert_id;

	return $ac_pos_map_ix;	
}

function db_ac_pos_map_delete($ac_pos_map_id) {
	global $lDB;

	if(!db_ac_pos_map_exists($ac_pos_map_id)) {
		return false;
	}

	$lDB->put("DELETE FROM ac_pos_map WHERE ac_pos_map_ix = '$ac_pos_map_id'");

	return true;
}

function db_ac_pos_map_delete_by_stock($ac_pos_id, $ac_pos_stock_id) {
	global $lDB;

	return db_ac_pos_map_delete($lDB->get("
		SELECT
			ac_pos_map.ac_pos_map_ix
		FROM
			ac_pos_map
		WHERE
			ac_pos_map.ac_pos_id = '" . $lDB->escape($ac_pos_id) . "'
			AND ac_pos_map.ac_pos_stock_id = '" . $lDB->escape($ac_pos_stock_id) . "'
	",4));
}

function db_ac_pos_map_delete_by_pos($ac_pos_id) {
	global $lDB;

	$list = $lDB->get("SELECT ac_pos_map_ix FROM ac_pos_map WHERE ac_pos_id = '$ac_pos_id'",3);
	foreach($list as $ac_pos_map_id) {
		db_ac_pos_map_delete($ac_pos_map_id);
	}
}

function db_ac_pos_map_bulk_update($ac_pos_id, $new_stock_item_ids) {
	global $lDB;

	$duplicates = $lDB->get("
		SELECT
			ac_pos_stock.ac_pos_stock_code
		FROM
			ac_pos_stock
		WHERE
			ac_pos_stock.ac_pos_stock_ix IN ('" . join("','",array_map(function($id) use ($lDB) {
				return $lDB->escape($id);
			},$new_stock_item_ids)) . "')
		GROUP BY
			ac_pos_stock.ac_pos_stock_code
		HAVING
			COUNT(ac_pos_stock.ac_pos_stock_ix) > 1
	",3);
	if(sizeof($duplicates) > 0) {
		return false;
	}

	$old_stock_item_ids = $lDB->get("
		SELECT
			ac_pos_map.ac_pos_stock_id
		FROM
			ac_pos_map
		WHERE
			ac_pos_map.ac_pos_id = '" . $lDB->escape($ac_pos_id) . "'
	",3);

	$insert_ids = array_diff($new_stock_item_ids, $old_stock_item_ids);
	foreach($insert_ids as $ac_pos_stock_id) {
		db_ac_pos_map_insert($ac_pos_id, $ac_pos_stock_id);
	}

	$delete_ids = array_diff($old_stock_item_ids, $new_stock_item_ids);
	foreach($delete_ids as $ac_pos_stock_id) {
		db_ac_pos_map_delete_by_stock($ac_pos_id, $ac_pos_stock_id);
	}

	return true;
}
