<?php

require_once(__DIR__ . "/db.ac_extra.php");
require_once(__DIR__ . "/db.pr_business.php");

function db_ac_pos_stock_exists($ac_pos_stock_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(ac_pos_stock_ix) FROM ac_pos_stock WHERE ac_pos_stock_ix = '" . $lDB->escape($ac_pos_stock_id) . "'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_ac_pos_stock_insert($pr_business_id, $ac_pos_stock_code, $ac_extra_id) {
	global $lDB;
	global $dbcode;

	if(!db_pr_business_exists($pr_business_id) || !db_ac_extra_is_pos($ac_extra_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO ac_pos_stock (
			ac_pos_stock_db,
			ac_pos_stock_code,
			pr_business_id,
			ac_extra_id
		) VALUES (
			'" . $lDB->escape($dbcode) . "',
			'" . $lDB->escape($ac_pos_stock_code) . "',
			'" . $lDB->escape($pr_business_id) . "',
			'" . $lDB->escape($ac_extra_id) . "'
		)
	");

	$ac_pos_stock_id = $lDB->insert_id;

	return $ac_pos_stock_id;
}

function db_ac_pos_stock_update($ac_pos_stock_id, $ac_pos_stock_code, $ac_extra_id) {
	global $lDB;

	if(!db_ac_pos_stock_exists($ac_pos_stock_id) || !db_ac_extra_is_pos($ac_extra_id)) {
		return false;
	}

	$lDB->put("
		UPDATE ac_pos_stock SET
			ac_pos_stock_code = '" . $lDB->escape($ac_pos_stock_code) . "',
			ac_extra_id = '" . $lDB->escape($ac_extra_id) . "'
		WHERE
			ac_pos_stock.ac_pos_stock_ix = '" . $lDB->escape($ac_pos_stock_id) . "'
	");
}

function db_ac_pos_stock_delete($ac_pos_stock_id) {
	global $lDB;

	if(!db_ac_pos_stock_exists($ac_pos_stock_id)) {
		return false;
	}

	$lDB->put("DELETE FROM ac_pos_stock WHERE ac_pos_stock_ix = '" . $lDB->escape($ac_pos_stock_id) . "'");
	return true;
}

function db_ac_pos_stock_bulk_update($pr_business_id, $items) {
	global $lDB;

	$oldIds = $lDB->get("
		SELECT
			ac_pos_stock.ac_pos_stock_ix
		FROM
			ac_pos_stock
		WHERE
			ac_pos_stock.pr_business_id = '" . $lDB->escape($pr_business_id) . "'
	",3);

	// Filter both existing and new items down to those that may be edited
	$oldIds = array_filter($oldIds, function($ac_pos_stock_id) {
		global $lDB;

		$ac_pos_stock_db = $lDB->get("
			SELECT ac_pos_stock_db FROM ac_pos_stock WHERE ac_pos_stock_ix = '" . $lDB->escape($ac_pos_stock_id) . "'
		",4);
		return canEditDB($ac_pos_stock_db);
	});

	$items = array_filter($items, function($item) {
		global $lDB;

		if(!db_ac_pos_stock_exists($item['ac_pos_stock_ix'])) {
			return true;
		} else {
			$ac_pos_stock_db = $lDB->get("
				SELECT ac_pos_stock_db FROM ac_pos_stock WHERE ac_pos_stock_ix = '" . $lDB->escape($item['ac_pos_stock_ix']) . "'
			",4);
			return canEditDB($ac_pos_stock_db);
		}
	});

	$newIds = [];
	foreach($items as $item) {
		if(!db_ac_pos_stock_exists($item['ac_pos_stock_ix'])) {
			$newIds[] = db_ac_pos_stock_insert($pr_business_id, $item['ac_pos_stock_code'], $item['ac_extra_id']);
		} else {

			$newIds[] = $item['ac_pos_stock_ix'];
			db_ac_pos_stock_update($item['ac_pos_stock_ix'], $item['ac_pos_stock_code'], $item['ac_extra_id']);
		}
	}

	// Filter out any deletions which have links
	$deletedIds = array_filter(array_diff($oldIds, $newIds), function($ac_pos_stock_id) {
		global $lDB;

		$linked_default = $lDB->get("SELECT COUNT(*) FROM ac_pos WHERE ac_pos.ac_pos_stock_id = '" . $lDB->escape($ac_pos_stock_id) . "'",4) > 0;
		$linked_map = $lDB->get("SELECT COUNT(*) FROM ac_pos_map WHERE ac_pos_map.ac_pos_stock_id = '" . $lDB->escape($ac_pos_stock_id) . "'",4) > 0;
		return !$linked_default && !$linked_map;
	});
	foreach($deletedIds as $ac_pos_stock_id) {
		db_ac_pos_stock_delete($ac_pos_stock_id);
	}
	return true;
}
