<?php

define("DB_AD_BATCH_INSERT",1);
define("DB_AD_BATCH_UPDATE",2);
define("DB_AD_BATCH_DELETE",3);
define("DB_AD_BATCH_CLOSE",4);
define("DB_AD_BATCH_OPEN",5);
define("DB_AD_BATCH_EXPORT",6);

function db_ad_batch_exists($ad_batch_id) {
	global $lDB;

	$batchCheck = $lDB->get("SELECT COUNT(ad_batch_ix) FROM ad_batch WHERE ad_batch_ix = '$ad_batch_id'",4);
	if($batchCheck > 0) { return true; } else { return false; }

}

function db_ad_batch_action_desc($ad_batch_action_ind) {
	switch($ad_batch_action_ind) {
	case DB_AD_BATCH_INSERT:
		return "Create";
	case DB_AD_BATCH_UPDATE:
		return "Edit";
	case DB_AD_BATCH_DELETE:
		return "Delete";
	case DB_AD_BATCH_CLOSE:
		return "Close";
	case DB_AD_BATCH_OPEN:
		return "Open";
	case DB_AD_BATCH_EXPORT:
		return "Export";
	}
}


function db_ad_batch_insert($fn_batch_id, $ad_batch_action_ind, $ad_batch_result=false, $pr_user_id=false) {
	global $lDB;
	global $dbcode;

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}
	$createDate = date("Y-m-d H:i:s");
	$ad_create_date_tz = date("e");

	$extra = array();
	if($ad_batch_result !== false) {
		$extra['ad_batch_result'] = $lDB->escape($ad_batch_result);
	}
	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}
	

	$lDB->put("
		INSERT INTO ad_batch (
			ad_batch_db,
			ad_batch_id,
			fn_batch_id,
			ad_batch_action_ind,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id
			$extraFields
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'',
			'".$lDB->escape($fn_batch_id)."',
			'".$lDB->escape($ad_batch_action_ind)."',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($pr_user_id)."'
			$extraValues
		)
	");	

	$batchId = $lDB->insert_id;

	return $batchId;	
	
}
