<?php

require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.ad_persona_detail.php");
require_once(__DIR__ . "/db.rv_reservation.php");

function db_ad_persona_exists($ad_persona_ix) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(ad_persona_id) FROM ad_persona WHERE ad_persona_ix = '".$lDB->escape($ad_persona_ix)."'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_ad_persona_insert($pr_persona_id,$ad_persona_form,array $items = array(),$rv_reservation_id=false) {

	global $lDB;
	global $dbcode;

	if(!db_pr_persona_exists($pr_persona_id)) {
		return false;
	}

	if($rv_reservation_id !== false && !db_rv_reservation_exists($rv_reservation_id)) {
		return false;
	}

	$rf_database_id = $lDB->get("select rf_database_id from rf_database where rf_db_code = '".$dbcode."'",4);
	$ad_persona_time = date("Y-m-d H:i:s");
	$pr_user_id = $GLOBALS['userid'];

	$ad_persona_time_tz = date("e");

	$lDB->put("
		INSERT INTO ad_persona (
			ad_persona_db,
			ad_persona_time,
			ad_persona_time_tz,
			ad_persona_form,
			pr_user_id,
			rf_database_id,
			pr_persona_id,
			rv_reservation_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($ad_persona_time)."',
			'".$lDB->escape($ad_persona_time_tz)."',
			'".$lDB->escape($ad_persona_form)."',
			'".$lDB->escape($pr_user_id)."',
			'".$lDB->escape($rf_database_id)."',
			'".$lDB->escape($pr_persona_id)."',
			'".$lDB->escape($rv_reservation_id)."'
		)
	");

	$ad_persona_id = $lDB->insert_id;

	foreach($items as $item) {
		db_ad_persona_detail_insert(
			$item['ad_res_detail_value_from'],
			$item['ad_res_detail_value_to'],
			$item['ad_res_detail_value_from_display'],
			$item['ad_res_detail_value_to_display'],
			$item['ad_res_detail_id_from'],
			$item['ad_res_detail_id_to'],
			$item['ad_res_detail_field_id'],
			$item['ad_res_detail_action_ind'],
			$ad_persona_id,
			$item['ad_module_field_id']
		);
	}

	return $ad_persona_id;
}
