<?php

// Actions
define("DB_AD_PERSONA_DETAIL_ACTION_ADD",1);
define("DB_AD_PERSONA_DETAIL_ACTION_EDIT",2);
define("DB_AD_PERSONA_DETAIL_ACTION_DELETE",3);

require_once(__DIR__ . '/db.ad_persona.php');
require_once(__DIR__ . '/db.tc_table.php');
require_once(__DIR__ . '/db.ad_module_field.php');
require_once(__DIR__ . '/functions.audit.php');

function db_ad_persona_detail_exists($ad_res_detail_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(ad_res_detail_id) FROM ad_res_detail WHERE ad_res_detail_ix = '".$lDB->escape($ad_res_detail_id)."'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_ad_persona_detail_insert(
	$ad_persona_detail_value_from,
	$ad_persona_detail_value_to,
	$ad_persona_detail_value_from_display,
	$ad_persona_detail_value_to_display,
	$ad_persona_detail_id_from,
	$ad_persona_detail_id_to,
	$ad_persona_detail_field_id,
	$ad_persona_detail_action_ind, 
	$ad_persona_id, 
	$ad_module_field_id) {

	global $lDB;

	if(!db_ad_persona_exists($ad_persona_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO ad_persona_detail (
			ad_persona_detail_db,
			ad_persona_detail_value_from,
			ad_persona_detail_value_to,
			ad_persona_detail_value_from_display,
			ad_persona_detail_value_to_display,
			ad_persona_detail_id_from,
			ad_persona_detail_id_to,
			ad_persona_detail_field_id,
			ad_persona_detail_action_ind,
			ad_persona_id,
			ad_module_field_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($ad_persona_detail_value_from)."',
			'".$lDB->escape($ad_persona_detail_value_to)."',
			'".$lDB->escape($ad_persona_detail_value_from_display)."',
			'".$lDB->escape($ad_persona_detail_value_to_display)."',
			'".$lDB->escape($ad_persona_detail_id_from)."',
			'".$lDB->escape($ad_persona_detail_id_to)."',
			'".$lDB->escape($ad_persona_detail_field_id)."',
			'".$lDB->escape($ad_persona_detail_action_ind)."',
			'".$lDB->escape($ad_persona_id)."',
			'".$lDB->escape($ad_module_field_id)."'
		);
	");

	$ad_persona_detail_id = $lDB->insert_id;

	return $ad_persona_id;
}

function db_ad_persona_detail_action_desc($ad_res_detail_action_ind) {
	switch($ad_res_detail_action_ind) {
		case DB_AD_PERSONA_DETAIL_ACTION_ADD:
			return "Add";
			break;
		case DB_AD_PERSONA_DETAIL_ACTION_EDIT:
			return "Edit";
			break;
		case DB_AD_PERSONA_DETAIL_ACTION_DELETE:
			return "Delete";
			break;
		default:
			return "";
	}
}
