<?php

require_once(__DIR__ . '/db.tc_table.php');
require_once(__DIR__ . '/db.ad_module_field.php');

// Actions
define("DB_AD_RES_DETAIL_ACTION_ADD",1);
define("DB_AD_RES_DETAIL_ACTION_EDIT",2);
define("DB_AD_RES_DETAIL_ACTION_DELETE",3);
// Data types
define("DB_AD_RES_DETAIL_TYPE_BOOLEAN",1);
define("DB_AD_RES_DETAIL_TYPE_CURRENCY",2);
define("DB_AD_RES_DETAIL_TYPE_DATETIME",3);
define("DB_AD_RES_DETAIL_TYPE_DATE",4);
define("DB_AD_RES_DETAIL_TYPE_FLOAT",5);
define("DB_AD_RES_DETAIL_TYPE_INTEGER",6);
define("DB_AD_RES_DETAIL_TYPE_STRING",7);
define("DB_AD_RES_DETAIL_TYPE_TEXT",8);
define("DB_AD_RES_DETAIL_TYPE_TIME",9);

function db_ad_res_detail_exists($ad_res_detail_ix) {
	global $lDB;

	$tranCheck = $lDB->get("SELECT COUNT(ad_res_detail_id) FROM ad_res_detail WHERE ad_res_detail_ix = '$ad_res_detail_ix'",4);
	if($tranCheck > 0) { return true; } else { return false; }
}

function db_ad_res_detail_insert(
	$ad_res_detail_value_from, 
	$ad_res_detail_value_to, 
	$ad_res_detail_value_from_display, 
	$ad_res_detail_value_to_display, 
	$ad_res_detail_id_from, 
	$ad_res_detail_id_to, 
	$ad_res_detail_action_ind, 
	$ad_reservation_id, 
	$ad_module_field_id) {

	global $lDB;

	$lDB->put("
		INSERT INTO ad_res_detail (
			ad_res_detail_db,
			ad_res_detail_value_from,
			ad_res_detail_value_to,
			ad_res_detail_value_from_display,
			ad_res_detail_value_to_display,
			ad_res_detail_id_from,
			ad_res_detail_id_to,
			ad_res_detail_action_ind,
			ad_reservation_id,
			ad_module_field_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($ad_res_detail_value_from)."',
			'".$lDB->escape($ad_res_detail_value_to)."',
			'".$lDB->escape($ad_res_detail_value_from_display)."',
			'".$lDB->escape($ad_res_detail_value_to_display)."',
			'".$lDB->escape($ad_res_detail_id_from)."',
			'".$lDB->escape($ad_res_detail_id_to)."',
			'".$lDB->escape($ad_res_detail_action_ind)."',
			'".$lDB->escape($ad_reservation_id)."',
			'".$lDB->escape($ad_module_field_id)."'
		)
	");
	$ad_res_detail_id = $lDB->insert_id;

	return $ad_res_detail_id;
}

function db_ad_res_detail_action_desc($ad_res_detail_action_ind) {
	switch($ad_res_detail_action_ind) {
		case DB_AD_RES_DETAIL_ACTION_ADD:
			return "Add";
			break;
		case DB_AD_RES_DETAIL_ACTION_EDIT:
			return "Edit";
			break;
		case DB_AD_RES_DETAIL_ACTION_DELETE:
			return "Delete";
			break;
		default:
			return "";
	}
}

function db_ad_res_detail_format($value,$ad_module_field_display_type_ind) {
	$max = 30;
	switch($ad_module_field_display_type_ind) {
		case DB_AD_RES_DETAIL_TYPE_BOOLEAN:
			return ($value == true) ? "True" : "False";
			break;
		case DB_AD_RES_DETAIL_TYPE_CURRENCY:
			return (empty($value)) ? "" : number_format((double)$value, 2);
			break;
		case DB_AD_RES_DETAIL_TYPE_DATE:
			return (empty($value) || $value == "0000-00-00" || $value == "0000-00-00 00:00:00") ? "" : date("Y-m-d", strtotime($value));;
			break;
		case DB_AD_RES_DETAIL_TYPE_DATETIME:
			return (empty($value) || $value == "0000-00-00" || $value == "0000-00-00 00:00:00") ? "" : date("Y-m-d H:i:s", strtotime($value));;
			break;
		case DB_AD_RES_DETAIL_TYPE_FLOAT:
			return (empty($value)) ? "" : number_format((double)$value, 2);
			break;
		case DB_AD_RES_DETAIL_TYPE_INTEGER:
			return (empty($value)) ? "" : number_format((double)$value, 0);
			break;
		case DB_AD_RES_DETAIL_TYPE_STRING:
			if (strlen($value) > $max) {
				$value = str_replace(array("'", '"'), array("&#39;", '&#39;&#39;'), $value);
				$value = substr($value, 0, $max - 3) . "...<img class='eye' onmouseout='nd()' onmouseover='overlib(\"" . t_encodeOverlib($value) . "\",LEFT,WIDTH,400)' src='/resource/Resrequest/Application/public/img/button_note.gif' />";
			}
			return $value;
			break;
		case DB_AD_RES_DETAIL_TYPE_TEXT:
			if (strlen($value) > $max) {
				$value = str_replace(array("'", '"'), array("&#39;", '&#39;&#39;'), $value);
				$value = substr($value, 0, $max - 3) . "...<img class='eye' onmouseout='nd()' onmouseover='overlib(\"" . t_encodeOverlib($value) . "\",LEFT,WIDTH,400)' src='/resource/Resrequest/Application/public/img/button_note.gif' />";
			}
			return $value;
			break;
		case DB_AD_RES_DETAIL_TYPE_TIME:
			return date("H:i:s", strtotime($value));;
			break;
		default:
			return $value;
	}
}
