<?php

function db_bl_block_exists($bl_block_ix) {
	global $lDB;

	$blockCount = $lDB->get("SELECT COUNT(bl_block_id) FROM bl_block WHERE bl_block_ix = '$bl_block_ix'",4);
	if($blockCount > 0) { return true; } else { return false; }
}

function db_bl_block_insert(
	$bl_block_name,
	$bl_block_abbrev,
	$rv_consultant_id,
	$rv_agent_id,
	$rv_agent_contact_persona_id,
	$rv_agent_ref,
	$rt_rate_type_id,
	$bl_block_commission_perc,
	$bl_block_note,
	$bl_block_note_internal,
	$pr_user_id=false) {


	global $lDB;

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}	
	$ad_create_date = $ad_modify_date = date('Y-m-d H:i:s');
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO bl_block (
			bl_block_db,
			bl_block_name,
			bl_block_abbrev,
			rv_consultant_id,
			rv_agent_id,
			rv_agent_contact_persona_id,
			rv_agent_ref,
			rt_rate_type_id,
			bl_block_commission_perc,
			bl_block_note,
			bl_block_note_internal,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($bl_block_name)."',
			'".$lDB->escape($bl_block_abbrev)."',
			'".$lDB->escape($rv_consultant_id)."',
			'".$lDB->escape($rv_agent_id)."',
			'".$lDB->escape($rv_agent_contact_persona_id)."',
			'".$lDB->escape($rv_agent_ref)."',
			'".$lDB->escape($rt_rate_type_id)."',
			'".$lDB->escape($bl_block_commission_perc)."',
			'".$lDB->escape($bl_block_note)."',
			'".$lDB->escape($bl_block_note_internal)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($pr_user_id)."',
			'".$lDB->escape($ad_modify_date)."',
			'".$lDB->escape($ad_modify_date_tz)."',
			'".$lDB->escape($pr_user_id)."'
		)
	");
	$bl_block_id = $lDB->insert_id;

	return $bl_block_id;
}

function db_bl_block_update(
	$bl_block_ix,
	$bl_block_name,
	$bl_block_abbrev,
	$rv_consultant_id,
	$rv_agent_id,
	$rv_agent_contact_persona_id,
	$rv_agent_ref,
	$rt_rate_type_id,
	$bl_block_commission_perc,
	$bl_block_note,
	$bl_block_note_internal,
	$pr_user_id=false) {
	
	if (!db_bl_block_exists($bl_block_ix)) {
		return false;
	}

	global $lDB;

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}	
	$ad_modify_date = date('Y-m-d H:i:s');
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE bl_block 
		SET
			bl_block_name = '".$lDB->escape($bl_block_name)."',
			bl_block_abbrev = '".$lDB->escape($bl_block_abbrev)."',
			rv_consultant_id = '".$lDB->escape($rv_consultant_id)."',
			rv_agent_id = '".$lDB->escape($rv_agent_id)."',
			rv_agent_contact_persona_id = '".$lDB->escape($rv_agent_contact_persona_id)."',
			rv_agent_ref = '".$lDB->escape($rv_agent_ref)."',
			rt_rate_type_id = '".$lDB->escape($rt_rate_type_id)."',
			bl_block_commission_perc = '".$lDB->escape($bl_block_commission_perc)."',
			bl_block_note = '".$lDB->escape($bl_block_note)."',
			bl_block_note_internal = '".$lDB->escape($bl_block_note_internal)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			bl_block_ix = '$bl_block_ix'");
}

function db_bl_block_delete($bl_block_ix) {
	global $lDB;
	$message = array();

	if (!db_bl_block_exists($bl_block_ix)) {
		$message[] = "This block template cannot be deleted as it cannot be found";
	}
	$numberAllocations = $lDB->get("
		SELECT 
			COUNT(*) 
		FROM 
			rv_reservation
			INNER JOIN bl_block_period ON bl_block_period.bl_block_period_ix = rv_reservation.bl_block_period_id
			INNER JOIN rv_reservation allocation ON allocation.bl_block_period_id = bl_block_period.bl_block_period_ix 
		WHERE 
			bl_block_period.bl_block_id = '". $bl_block_ix . "'
			AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15' AND allocation.rf_reservation_status_id != '97'
	",4);
	if ($numberAllocations != 0) {
		$message[] = "This block template is linked to one or more allocations. You must cancel/delete all such links before this block template can be deleted";
	}

	$numberReservations = $lDB->get("
		SELECT 
			COUNT(*) 
		FROM 
			rv_reservation
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
			INNER JOIN rv_reservation_item alloc_item ON alloc_item.rv_link_res_item_id = rv_reservation_item.rv_reservation_item_ix
			INNER JOIN rv_reservation allocation ON allocation.rv_reservation_ix = alloc_item.rv_reservation_id 
			INNER JOIN bl_block_period ON bl_block_period.bl_block_period_ix = allocation.bl_block_period_id
		WHERE 
			bl_block_period.bl_block_id = '". $bl_block_ix . "'
			AND allocation.rv_reservation_type_ind = '5' AND allocation.rf_reservation_status_id = '15' AND allocation.rf_reservation_status_id != '97'
			AND rv_reservation.rf_reservation_status_id NOT IN('90','95')
	",4);
	if ($numberReservations != 0) {
		$message[] = "This block template is linked to one or more reservations. You must cancel/delete such links before this block template can be deleted";
	}

	$numberPeriods = $lDB->get("
		SELECT 
			COUNT(*) 
		FROM 
			bl_block_period
		WHERE 
			bl_block_period.bl_block_id = '". $bl_block_ix . "'
	",4);
	if ($numberPeriods != 0) {
		$message[] = "This block template is linked to one or more periods. You must delete all such links before this block template can be deleted";
	}

	if (count($message) == 0) {
		$lDB->put("
			DELETE 
				bl_block
		   	FROM
				bl_block
			WHERE
				bl_block_ix = '$bl_block_ix'
		");
	}
	return $message;
}
