<?php

function db_bl_block_itinerary_exists($bl_block_itinerary_ix) {
	global $lDB;

	$blockItineraryCount = $lDB->get("SELECT COUNT(bl_block_itinerary_id) FROM bl_block_itinerary WHERE bl_block_itinerary_ix = '$bl_block_itinerary_ix'",4);
	if($blockItineraryCount > 0) { return true; } else { return false; }
}

function db_bl_block_itinerary_insert(
	$bl_block_period_id,
	$ac_accomm_type_id,
	$rt_rate_type_id,
	$bl_itinerary_day_start,
	$bl_itinerary_day_end,
	$bl_block_itinerary_rooms,
	$bl_block_itinerary_pax,
	$pr_user_id=false) {

	global $lDB;

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}	
	$ad_create_date = $ad_modify_date = date('Y-m-d H:i:s');
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO bl_block_itinerary (
			bl_block_itinerary_db, 
			bl_block_period_id,
			ac_accomm_type_id,
			rt_rate_type_id,
			bl_itinerary_day_start,
			bl_itinerary_day_end,
			bl_block_itinerary_rooms,
			bl_block_itinerary_pax,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($bl_block_period_id)."',
			'".$lDB->escape($ac_accomm_type_id)."',
			'".$lDB->escape($rt_rate_type_id)."',
			'".$lDB->escape($bl_itinerary_day_start)."',
			'".$lDB->escape($bl_itinerary_day_end)."',
			'".$lDB->escape($bl_block_itinerary_rooms)."',
			'".$lDB->escape($bl_block_itinerary_pax)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($pr_user_id)."',
			'".$lDB->escape($ad_modify_date)."',
			'".$lDB->escape($ad_modify_date_tz)."',
			'".$lDB->escape($pr_user_id)."'
		)
	");
	$bl_block_itinerary_id = $lDB->insert_id;

	return $bl_block_itinerary_id;
}

function db_bl_block_itinerary_update(
	$bl_block_itinerary_ix,
	$ac_accomm_type_id,
	$rt_rate_type_id,
	$bl_itinerary_day_start,
	$bl_itinerary_day_end,
	$bl_block_itinerary_rooms,
	$bl_block_itinerary_pax,
	$pr_user_id=false) {

	if (!db_bl_block_itinerary_exists($bl_block_itinerary_ix)) {
		return false;
	}

	global $lDB;

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}	
	$ad_modify_date = date('Y-m-d H:i:s');
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE bl_block_itinerary 
		SET
			ac_accomm_type_id = '".$lDB->escape($ac_accomm_type_id)."',
			rt_rate_type_id = '".$lDB->escape($rt_rate_type_id)."',
			bl_itinerary_day_start = '".$lDB->escape($bl_itinerary_day_start)."',
			bl_itinerary_day_end = '".$lDB->escape($bl_itinerary_day_end)."',
			bl_block_itinerary_rooms = '".$lDB->escape($bl_block_itinerary_rooms)."',
			bl_block_itinerary_pax = '".$lDB->escape($bl_block_itinerary_pax)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			bl_block_itinerary_ix = '$bl_block_itinerary_ix'
	");
	$bl_block_itinerary_id = $lDB->insert_id;

	return $bl_block_itinerary_id;
}

function db_bl_block_itinerary_delete($bl_block_itinerary_ix) {
	if (!db_bl_block_itinerary_exists($bl_block_itinerary_ix)) {
		$canDelete = false;
		$message[] = "This block itinerary cannot be deleted as it cannot be found";
	}
	global $lDB;
	$message = array();
	$canDelete = true;
	$deleteItineraries = is_array($bl_block_itinerary_ix) ? implode("','", $bl_block_itinerary_ix) : $bl_block_itinerary_ix;

	$numberReservationItineraries = $lDB->get("
		SELECT 
			COUNT(*) 
		FROM 
			rv_reservation_item 
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
		WHERE 
			bl_block_itinerary_id IN ('". $deleteItineraries . "')
			rv_reservation.rf_reservation_status_id != '95'
			AND rv_reservation.rf_reservation_status_id != '97'
	",4);

	if ($numberReservationItineraries != 0) {
		$canDelete = false;
		$message[] = "This block itinerary is linked to one or more reservation and/or allocation itineraries. You must delete all such links before this block itinerary can be deleted";
	}

	if ($canDelete) {
		$lDB->put("
			DELETE FROM
				bl_block_itinerary
			WHERE
				bl_block_itinerary_ix = '$bl_block_itinerary_ix'
		");
		$message = true;
	}
	return $message;
}
