<?php

// Lead time
define("DB_BL_PER_RECURRENCE_IND_WEEKLY_WEEKDAY",1);
define("DB_BL_PER_RECURRENCE_IND_MONTHLY_DAY",2);
define("DB_BL_PER_RECURRENCE_IND_ORDINAL_MONTH",3);
define("DB_BL_PER_RECURRENCE_IND_INTERVAL_MONTH_OFFSET",4);
define("DB_BL_PER_RECURRENCE_IND_INTERVAL_MONTH_ORDINAL_WEEK",5);
define("DB_BL_PER_RECURRENCE_IND_INTERVAL_DAYS",6);

// Expiry
define("DB_BL_PER_EXPIRY_LEAD_TIME_DAYS",1);
define("DB_BL_PER_EXPIRY_LEAD_TIME_DATE",2);

// Weekdays
define("DB_BL_MONDAY",1);
define("DB_BL_TUESDAY",2);
define("DB_BL_WEDNESDAY",3);
define("DB_BL_THURSDAY",4);
define("DB_BL_FRIDAY",5);
define("DB_BL_SATURDAY",6);
define("DB_BL_SUNDAY",7);

// Interval month offset direction
define("DB_BL_INTERVAL_MONTH_OFFSET_AFTER_START",1);
define("DB_BL_INTERVAL_MONTH_OFFSET_BEFORE_END",2);

function db_bl_block_period_exists($bl_block_period_ix) {
	global $lDB;

	$blockPeriodCount = $lDB->get("SELECT COUNT(bl_block_period_id) FROM bl_block_period WHERE bl_block_period_ix = '$bl_block_period_ix'",4);
	if($blockPeriodCount > 0) { return true; } else { return false; }
}

function db_bl_block_period_insert(
	$bl_block_id,
	$bl_per_date_start_series_fst,
	$bl_per_date_start_series_lst,
	$bl_per_recurrence_per_ind,
	$bl_per_recurrence_per_1,
	$bl_per_recurrence_per_2,
	$bl_per_recurrence_per_3,
	$bl_per_recurrence_per_4,
	$bl_per_recurrence_per_5,
	$bl_per_expiry_ind,
	$bl_per_expiry_lead_time_days,
	$bl_per_expiry_lead_time_date,
	$pr_user_id=false) {

	global $lDB;

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}	
	$ad_create_date = $ad_modify_date = date('Y-m-d H:i:s');
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO bl_block_period (
			bl_block_period_db,
			bl_block_id,
			bl_per_date_start_series_fst,
			bl_per_date_start_series_lst,
			bl_per_recurrence_per_ind,
			bl_per_recurrence_per_1,
			bl_per_recurrence_per_2,
			bl_per_recurrence_per_3,
			bl_per_recurrence_per_4,
			bl_per_recurrence_per_5,
			bl_per_expiry_ind,
			bl_per_expiry_lead_time_days,
			bl_per_expiry_lead_time_date,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($bl_block_id)."',
			'".$lDB->escape($bl_per_date_start_series_fst)."',
			'".$lDB->escape($bl_per_date_start_series_lst)."',
			'".$lDB->escape($bl_per_recurrence_per_ind)."',
			'".$lDB->escape($bl_per_recurrence_per_1)."',
			'".$lDB->escape($bl_per_recurrence_per_2)."',
			'".$lDB->escape($bl_per_recurrence_per_3)."',
			'".$lDB->escape($bl_per_recurrence_per_4)."',
			'".$lDB->escape($bl_per_recurrence_per_5)."',
			'".$lDB->escape($bl_per_expiry_ind)."',
			'".$lDB->escape($bl_per_expiry_lead_time_days)."',
			'".$lDB->escape($bl_per_expiry_lead_time_date)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($pr_user_id)."',
			'".$lDB->escape($ad_modify_date)."',
			'".$lDB->escape($ad_modify_date_tz)."',
			'".$lDB->escape($pr_user_id)."'
		)
	");
	$bl_block_period_id = $lDB->insert_id;

	return $bl_block_period_id;
}

function db_bl_block_period_update(
	$bl_block_period_ix,
	$bl_per_date_start_series_fst,
	$bl_per_date_start_series_lst,
	$bl_per_recurrence_per_ind,
	$bl_per_recurrence_per_1,
	$bl_per_recurrence_per_2,
	$bl_per_recurrence_per_3,
	$bl_per_recurrence_per_4,
	$bl_per_recurrence_per_5,
	$bl_per_expiry_ind,
	$bl_per_expiry_lead_time_days,
	$bl_per_expiry_lead_time_date,
	$pr_user_id=false) {
	if (!db_bl_block_period_exists($bl_block_period_ix)) {
		return false;
	}

	global $lDB;

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}	
	$ad_modify_date = date('Y-m-d H:i:s');
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE 
			bl_block_period
		SET
			bl_per_date_start_series_fst = '".$lDB->escape($bl_per_date_start_series_fst)."',
			bl_per_date_start_series_lst = '".$lDB->escape($bl_per_date_start_series_lst)."',
			bl_per_recurrence_per_ind = '".$lDB->escape($bl_per_recurrence_per_ind)."',
			bl_per_recurrence_per_1 = '".$lDB->escape($bl_per_recurrence_per_1)."',
			bl_per_recurrence_per_2 = '".$lDB->escape($bl_per_recurrence_per_2)."',
			bl_per_recurrence_per_3 = '".$lDB->escape($bl_per_recurrence_per_3)."',
			bl_per_recurrence_per_4 = '".$lDB->escape($bl_per_recurrence_per_4)."',
			bl_per_recurrence_per_5 = '".$lDB->escape($bl_per_recurrence_per_5)."',
			bl_per_expiry_ind = '".$lDB->escape($bl_per_expiry_ind)."',
			bl_per_expiry_lead_time_days = '".$lDB->escape($bl_per_expiry_lead_time_days)."',
			bl_per_expiry_lead_time_date = '".$lDB->escape($bl_per_expiry_lead_time_date)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			bl_block_period_ix = '".$lDB->escape($bl_block_period_ix)."'
	");
	return true;
}

function db_bl_block_period_delete($bl_block_period_ix) {
	global $lDB;
	$message = array();
	$canDelete = true;
	$deletePeriods = is_array($bl_block_period_ix) ? implode("','", $bl_block_period_ix) : $bl_block_period_ix;

	$numberReservationItems = $lDB->get("
		SELECT 
			COUNT(*) 
		FROM 
			rv_reservation_item 
			INNER JOIN bl_block_itinerary ON bl_block_itinerary.bl_block_itinerary_ix = rv_reservation_item.bl_block_itinerary_id
		WHERE 
			bl_block_itinerary.bl_block_period_id IN ('". $deletePeriods . "')
	",4);
	if ($numberReservationItems != 0) {
		$canDelete = false;
		$message[] = "This block period is linked to one or more reservation and/or allocation itineraries. You must delete all such links before this block period can be deleted";
	}

	$numberItineraries = $lDB->get("
		SELECT 
			COUNT(*) 
		FROM 
			bl_block_itinerary
		WHERE 
			bl_block_itinerary.bl_block_period_id IN ('". $deletePeriods . "')
	",4);
	if ($numberItineraries != 0) {
		$canDelete = false;
		$message[] = "This block period is linked to one or more block itineraries. You must delete all such links before this block period can be deleted";
		$message[] = "
		SELECT 
			COUNT(*) 
		FROM 
			bl_block_itinerary
		WHERE 
			bl_block_itinerary.bl_block_period_id IN ('". $deletePeriods . "')
			";
	}

	if ($canDelete) {
		if (!is_array($bl_block_period_ix)) {
			if (db_bl_block_period_exists($bl_block_period_ix)) {
				$lDB->put("
					DELETE FROM
						bl_block_period
					WHERE
						bl_block_period_ix = '$bl_block_period_ix'
				");
			} else {
				$message[] = "This block period cannot be deleted as it cannot be found";
			}
		} else {
			$blockPeriodCounter = 0;
			foreach ($bl_block_period_ix as $block_period) {
				if (db_bl_block_period_exists($block_period)) {
					$lDB->put("
						DELETE FROM
							bl_block_period
						WHERE
							bl_block_period_ix = '$block_period'
					");
				} else {
					$blockPeriodCounter += 1;
				}
			}
			if ($blockPeriodCounter > 0) {
				$message[] = $blockPeriodCounter . " block periods couldn't be deleted as they couldn't be found";
			}
		}
	}
	return $message;
}

/**
 * getExpiryDescription() - Get the description to display for a block based on its expiry setup
 * @param int $bl_per_expiry_ind
 * @param int $bl_per_expiry_lead_time_days
 * @param string $bl_per_expiry_lead_time_date
 * @return string
 **/
function getExpiryDescription(
	$bl_per_expiry_ind,
	$bl_per_expiry_lead_time_days,
	$bl_per_expiry_lead_time_date) {
	$expiryDescription = "";
	switch ($bl_per_expiry_ind) {
		case DB_BL_PER_EXPIRY_LEAD_TIME_DAYS:
			$expiryDescription = "Lead time " . $bl_per_expiry_lead_time_days . " day(s)";
			break;
		case DB_BL_PER_EXPIRY_LEAD_TIME_DATE:
			$expiryDescription = "On " . chng_date($bl_per_expiry_lead_time_date,"-");
			break;
		default:
			$expiryDescription = $bl_per_expiry_ind;
			break;
	}
	return $expiryDescription;
}

/**
 * getRecurrencePeriodDescription() - Gets the description of a recurrence for a block period based on its setup
 * @param int $bl_per_recurrence_per_ind
 * @param int $bl_per_recurrence_per_1
 * @param int $bl_per_recurrence_per_2
 * @param int $bl_per_recurrence_per_3
 * @param int $bl_per_recurrence_per_4
 * @param int $bl_per_recurrence_per_5
 * @return string
 **/
function getRecurrencePeriodDescription(
	$bl_per_recurrence_per_ind,
	$bl_per_recurrence_per_1,
	$bl_per_recurrence_per_2,
	$bl_per_recurrence_per_3,
	$bl_per_recurrence_per_4,
	$bl_per_recurrence_per_5) {
	$recurrencePeriodDescription = "";
	switch ($bl_per_recurrence_per_ind) {
		case DB_BL_PER_RECURRENCE_IND_WEEKLY_WEEKDAY:
			$recurrencePeriodDescription = "Weekly on " . getWeekdayShortName($bl_per_recurrence_per_1);
			break;
		case DB_BL_PER_RECURRENCE_IND_MONTHLY_DAY:
			$recurrencePeriodDescription = "Monthly on the " . getOrdinal($bl_per_recurrence_per_1) . " day of the month";
			break;
		case DB_BL_PER_RECURRENCE_IND_ORDINAL_MONTH:
			$recurrencePeriodDescription = "Every " . getOrdinal($bl_per_recurrence_per_2) . " " . getWeekdayShortName($bl_per_recurrence_per_1) . " of the month";
			break;
		case DB_BL_PER_RECURRENCE_IND_INTERVAL_MONTH_OFFSET:
			$recurrencePeriodDescription = "Every " . $bl_per_recurrence_per_4 . " months, " . $bl_per_recurrence_per_1 . " days " . getRecurrencePeriodOffsetDirectionDescription($bl_per_recurrence_per_5) . " of the month";
			break;
		case DB_BL_PER_RECURRENCE_IND_INTERVAL_MONTH_ORDINAL_WEEK:
			$recurrencePeriodDescription = "Every " . $bl_per_recurrence_per_4 . " months on the  " . getOrdinal($bl_per_recurrence_per_3) . " " . getWeekdayShortName($bl_per_recurrence_per_1) . " of the month";
			break;
		case DB_BL_PER_RECURRENCE_IND_INTERVAL_DAYS:
			$recurrencePeriodDescription = "Every " . $bl_per_recurrence_per_4 . " days";
			break;
		default:
			$recurrencePeriodDescription = $bl_per_recurrence_per_ind;
			break;
	}
	return $recurrencePeriodDescription;
}

/**
 * getRecurrencePeriodOffsetDirectionDescription() - Gets the offset description for a recurrence for a block period
 * @param int $bl_per_recurrence_per_5
 * @return string
 **/
function getRecurrencePeriodOffsetDirectionDescription($bl_per_recurrence_per_5) {
	$recurrencePeriodOffsetDirectionDescription = "";
	switch ($bl_per_recurrence_per_5) {
		case DB_BL_PER_EXPIRY_LEAD_TIME_DAYS:
			$recurrencePeriodOffsetDirectionDescription = "after the start";
			break;
		case DB_BL_PER_EXPIRY_LEAD_TIME_DATE:
			$recurrencePeriodOffsetDirectionDescription = "before the end";
			break;
		default:
			$recurrencePeriodOffsetDirectionDescription = $bl_per_recurrence_per_5;
			break;
	}
	return $recurrencePeriodOffsetDirectionDescription;
}
