<?php

require_once(__DIR__ . "/db.ad_batch.php");
require_once(__DIR__ . "/functions.csv.php");
require_once(__DIR__ . "/functions.transaction.php");

function db_fn_batch_exists($fn_batch_id) {
	global $lDB;

	$batchCheck = $lDB->get("SELECT COUNT(fn_batch_ix) FROM fn_batch WHERE fn_batch_ix = '$fn_batch_id'",4);
	if($batchCheck > 0) { return true; } else { return false; }

}

function db_fn_batch_insert($pr_business_id, $fn_batch_name, $fn_year_id, $fn_batch_note, $pr_user_id=false) {
	global $lDB;
	global $dbcode;
	// Check if this business is allowed to create a batch
	// STILL TO BE IMPLEMENTED
	// return false on exception
	
	$fn_batch_prefix = $lDB->get("SELECT pr_bus_inv_prefix FROM pr_business WHERE pr_business_id = '$pr_business_id'",4);
	

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$createDate = date("Y-m-d H:i:s");
	$ad_create_date_tz = $ad_modify_date_tz = date("e");
	$lDB->put("
		INSERT INTO fn_batch (
			fn_batch_db,
			fn_batch_id,
			fn_batch_prefix,
			fn_batch_name,
			fn_year_id,
			fn_batch_note,
			pr_business_id,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'',
			'".$lDB->escape($fn_batch_prefix)."',
			'".$lDB->escape($fn_batch_name)."',
			'".$lDB->escape($fn_year_id)."',
			'".$lDB->escape($fn_batch_note)."',
			'".$lDB->escape($pr_business_id)."',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($pr_user_id)."',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($ad_modify_date_tz)."',
			'".$lDB->escape($pr_user_id)."'
		)
	");
	$insertId = $lDB->insert_id;
	$batchId = $fn_batch_prefix.$insertId;
	// Populate fn_folio_ix
	db_ad_batch_insert($batchId, DB_AD_BATCH_INSERT);
	
	return $batchId;	
}

function db_fn_batch_update($fn_batch_id, $fn_batch_name,$fn_year_id,$fn_batch_note) {
	global $lDB;

	$master = $lDB->isMaster;
	$lDB->isMaster = "1";	
	
	$lDB->put("
		UPDATE fn_batch SET
			fn_batch_name = '".$lDB->escape($fn_batch_name)."',
			fn_year_id = '".$lDB->escape($fn_year_id)."',
			fn_batch_note = '".$lDB->escape($fn_batch_note)."'
		WHERE
			fn_batch.fn_batch_ix = '$fn_batch_id'
	");
	db_ad_batch_insert($fn_batch_id, DB_AD_BATCH_UPDATE);

	$lDB->isMaster = $master;	
}

function db_fn_batch_delete_by_id($fn_batch_id, $pr_user_id=false) {
	global $lDB;

	$tranCount = $lDB->get("SELECT COUNT(*) FROM fn_tran WHERE fn_batch_id = '$fn_batch_id'",4);
	if($tranCount > 0) {
		return false;
	}

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}

	$master = $lDB->isMaster;
	$lDB->isMaster = "1";	

	$deleteDate = date("Y-m-d H:i:s");
	$ad_delete_date_tz = date("e");
	$lDB->put("
		UPDATE fn_batch SET
			ad_delete_date = '".$lDB->escape($deleteDate)."',
			ad_delete_date_tz = '".$lDB->escape($ad_delete_date_tz)."',
			ad_delete_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			fn_batch.fn_batch_ix = '$fn_batch_id'
	");
	db_ad_batch_insert($fn_batch_id, DB_AD_BATCH_DELETE);	

	$lDB->isMaster = $master;	
}

function db_fn_batch_close($fn_batch_id) {
	global $lDB;

	$master = $lDB->isMaster;
	$lDB->isMaster = "1";
	
	$closeDate = date("Y-m-d H:i:s");
	$GLOBALS['lDB']->put("
		UPDATE fn_batch SET
			fn_batch_closed_yn = '1'
		WHERE
			fn_batch.fn_batch_ix = '$fn_batch_id'
	");
	db_ad_batch_insert($fn_batch_id, DB_AD_BATCH_CLOSE);

	$lDB->isMaster = $master;
}

function db_fn_batch_open($fn_batch_id) {
	global $lDB;

	$master = $lDB->isMaster;
	$lDB->isMaster = "1";

	$GLOBALS['lDB']->put("
		UPDATE fn_batch SET
			fn_batch_closed_yn = '0'
		WHERE
			fn_batch.fn_batch_ix = '$fn_batch_id'
	");
	db_ad_batch_insert($fn_batch_id, DB_AD_BATCH_OPEN);

	$lDB->isMaster = $master;
}
