<?php
require_once(__DIR__ . "/db.pr_business.php");

function db_fn_cost_centre_exists($fn_cost_centre_ix) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(*) FROM fn_cost_centre WHERE fn_cost_centre_ix = '$fn_cost_centre_ix'",4);

	if($check > 0) {
		return true;
	} else {
		return false;
	}
}

function db_fn_cost_centre_insert($fn_cost_centre_code, $fn_cost_centre_desc, $fn_cost_centre_ind, $pr_business_id) {
	global $dbcode;
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		$lDB->put("
			INSERT INTO fn_cost_centre (
				fn_cost_centre_db,
				fn_cost_centre_code,
				fn_cost_centre_desc,
				fn_cost_centre_ind,
				pr_business_id
			) VALUES (
				'".$lDB->escape($dbcode)."',
				'".$lDB->escape($fn_cost_centre_code)."',
				'".$lDB->escape($fn_cost_centre_desc)."',
				'".$lDB->escape($fn_cost_centre_ind)."',
				'".$lDB->escape($pr_business_id)."'
			)
		");
		$costCentreId = $GLOBALS['lDB']->insert_id;
		return $costCentreId;
	} else {
		return false;
	}
}

function db_fn_cost_centre_update($fn_cost_centre_ix, $fn_cost_centre_code, $fn_cost_centre_desc, $fn_cost_centre_ind, $pr_business_id) {
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";
		$lDB->put("
			UPDATE 
				fn_cost_centre
			SET 
				fn_cost_centre_code = '".$lDB->escape($fn_cost_centre_code)."',
				fn_cost_centre_desc = '".$lDB->escape($fn_cost_centre_desc)."',
				fn_cost_centre_ind = '".$lDB->escape($fn_cost_centre_ind)."'
			WHERE
				fn_cost_centre.fn_cost_centre_ix = '$fn_cost_centre_ix' 
				AND fn_cost_centre.pr_business_id = '$pr_business_id'
		");
		$lDB->isMaster = $master;
		return true;
	} else {
		return false;
	}
}

function db_fn_cost_centre_delete($action, $fn_cost_centre_ix) {
	global $lDB;

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_cost_centre WHERE fn_cost_centre_ix = '$fn_cost_centre_ix'",4);
	if(db_pr_business_ledger_allow($pr_business_id)) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";
	
		if($action == "delete") {
			$lDB->put("DELETE FROM fn_cost_centre WHERE fn_cost_centre_ix = '$fn_cost_centre_ix'");
		}

		if($action == "inactive") {
			$lDB->put("
				UPDATE fn_cost_centre SET 
					fn_cost_centre_inactive_yn = '1' 
				WHERE
					fn_cost_centre.fn_cost_centre_ix = '$fn_cost_centre_ix'
			");		
		}
		$lDB->isMaster = $master;
		return true;
	} else {
		return false;
	}
}

function db_fn_cost_centre_check_duplicate($fn_cost_centre_code, $fn_cost_centre_desc, $pr_business_id, $fn_cost_centre_ix = "" ) {
	if($fn_cost_centre_ix != "") {
		$editSQL = "AND fn_cost_centre.fn_cost_centre_ix != '$fn_cost_centre_ix'";
	} else {
		$editSQL = "";
	}

	$exists = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			fn_cost_centre
		WHERE
			fn_cost_centre.pr_business_id = '$pr_business_id'
			AND (
				fn_cost_centre.fn_cost_centre_code = '$fn_cost_centre_code' 
				OR fn_cost_centre.fn_cost_centre_desc = '$fn_cost_centre_desc'
			)
			$editSQL
	",4);

	return $exists;

}
