<?php

require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.rf_database.php");

define("DB_FN_DB_BUS_DEBTOR_SUSPENSE",1);
define("DB_FN_DB_BUS_DEBTOR_CASH",2);


function db_fn_db_business_exists($fn_db_business_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(fn_db_business_id) FROM fn_db_business WHERE fn_db_business_ix = '$fn_db_business_id'",4);
	if($check > 0) { return true; } else { return false; }
}

function db_fn_db_business_exists_by_all($pr_business_id,$rf_database_id) {
	global $lDB;

	$check = $lDB->get("
		SELECT COUNT(*) FROM fn_db_business WHERE pr_business_id = '$pr_business_id' AND rf_database_id = '$rf_database_id'
	",4);
	if($check > 0) { return true; } else { return false; }
}

function db_fn_db_business_get_by_all($pr_business_id,$rf_database_id) {
	return $GLOBALS['lDB']->get("
		SELECT fn_db_business_ix FROM fn_db_business WHERE pr_business_id = '$pr_business_id' AND rf_database_id = '$rf_database_id'
	",4);
}


function db_fn_db_business_insert($pr_business_id,$rf_database_id,$fn_db_bus_debtor_ind=DB_FN_DB_BUS_DEBTOR_SUSPENSE) {
	global $lDB;
	global $dbcode;

	if(!db_pr_business_exists($pr_business_id)) {
		return false;
	}

	if(!db_rf_database_exists($rf_database_id)) {
		return false;
	}

	if(db_fn_db_business_exists_by_all($pr_business_id,$rf_database_id)) {
		return false;
	}

	$lDB->put("
		INSERT INTO fn_db_business (
			fn_db_business_db,
			pr_business_id,
			rf_database_id,
			fn_db_bus_debtor_ind
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pr_business_id)."',
			'".$lDB->escape($rf_database_id)."',
			'".$lDB->escape($fn_db_bus_debtor_ind)."'
		)
	");

	$fn_db_business_id = $lDB->insert_id;

	return $fn_db_business_id;	
	
}

function db_fn_db_business_update($fn_db_business_id,$fn_db_bus_debtor_ind) {
	global $lDB;

	if(!db_fn_db_business_exists($fn_db_business_id)) {
		return false;
	}

	$lDB->put("
		UPDATE fn_db_business SET
			fn_db_bus_debtor_ind = '".$lDB->escape($fn_db_bus_debtor_ind)."'
		WHERE
			fn_db_business_ix = '$fn_db_business_id'
	");

	return true;
}

function db_fn_db_business_set($pr_business_id,$rf_database_id,$fn_db_bus_debtor_ind) {
	if(!db_fn_db_business_exists_by_all($pr_business_id,$rf_database_id)) {
		db_fn_db_business_insert($pr_business_id,$rf_database_id,$fn_db_bus_debtor_ind);
	} else {
		$fn_db_business_id = db_fn_db_business_get_by_all($pr_business_id,$rf_database_id);
		db_fn_db_business_update($fn_db_business_id,$fn_db_bus_debtor_ind);
	}
}

