<?php
require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.pr_persona.php");

function db_fn_debtor_exists($fn_debtor_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(*) FROM fn_debtor WHERE fn_debtor_ix = '$fn_debtor_id'",4);
	if($check > 0) { return true; } else { return false; }

}

function db_fn_debtor_exists_by_code($pr_business_id,$fn_debtor_code) {
	global $lDB;

    $fn_debtor_code = $lDB->escape($fn_debtor_code);
    $pr_business_id = $lDB->escape($pr_business_id);


	$check = $lDB->get("SELECT COUNT(*) FROM fn_debtor WHERE fn_debtor_code = '{$fn_debtor_code}' AND pr_business_id = '{$pr_business_id}'",4);
	if($check > 0) { return true; } else { return false; }

}

function db_fn_debtor_insert($fn_debtor_code, $fn_debtor_desc, $rf_currency_id,$pr_business_id, $pr_persona_id=false, $fn_debtor_export_yn=false) {
	global $dbcode;
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {

		if($fn_debtor_export_yn != "1") {
			$fn_debtor_export_yn = "0";
		}

		if($pr_persona_id === false || !db_pr_persona_exists($pr_persona_id)) {
			$pr_persona_id = "";
		}

		$lDB->put("
			INSERT INTO fn_debtor (
				fn_debtor_db,
				fn_debtor_code,
				fn_debtor_desc,
				rf_currency_id,
				pr_business_id,
				pr_persona_id,
				fn_debtor_export_yn
			) VALUES (
				'".$lDB->escape($dbcode)."',
				'".$lDB->escape($fn_debtor_code)."',
				'".$lDB->escape($fn_debtor_desc)."',
				'".$lDB->escape($rf_currency_id)."',
				'".$lDB->escape($pr_business_id)."',
				'".$lDB->escape($pr_persona_id)."',
				'".$lDB->escape($fn_debtor_export_yn)."'
			)
		");

		$debtorId = $GLOBALS['lDB']->insert_id;
		return $debtorId;
	} else {
		return false;
	}
}

function db_fn_debtor_update($fn_debtor_ix, $fn_debtor_code, $fn_debtor_desc, $rf_currency_id, $pr_business_id, $pr_persona_id=false, $fn_debtor_export_yn=false) {
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";		

		if($fn_debtor_export_yn != "1") {
			$fn_debtor_export_yn = "0";
		}

		$extra = array();

		if($pr_persona_id !== false) {
			if(db_pr_persona_exists($pr_persona_id)) {
				$extra['pr_persona_id'] = $pr_persona_id;
			} else {
				$extra['pr_persona_id'] = "";
			}
		}

		$extraSQL = "";
		foreach($extra as $field=>$value) {
			$extraSQL .= "
				$field = '$value',
			";
		}

		$lDB->put("
			UPDATE fn_debtor SET 
				fn_debtor_code = '".$lDB->escape($fn_debtor_code)."',
				fn_debtor_desc = '".$lDB->escape($fn_debtor_desc)."', 
				rf_currency_id = '".$lDB->escape($rf_currency_id)."',
				$extraSQL
				fn_debtor_export_yn = '$fn_debtor_export_yn'
			WHERE
				fn_debtor.fn_debtor_ix = '$fn_debtor_ix' 
			AND 
				fn_debtor.pr_business_id = '$pr_business_id'
		");
		$lDB->isMaster = $master;
		return true;
	} else {
		return false;
	} 
}

function db_fn_debtor_delete($action, $fn_debtor_ix) {
	global $lDB;

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_debtor WHERE fn_debtor_ix = '$fn_debtor_ix'",4);
	if(db_pr_business_ledger_allow($pr_business_id)) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";		

		if($action == "delete") {
			$lDB->put("DELETE FROM fn_debtor WHERE fn_debtor_ix = '$fn_debtor_ix'");
		}

		if($action == "inactive") {
			$lDB->put("
				UPDATE 
					fn_debtor
				SET 
					fn_debtor_inactive_yn = '1' 
				WHERE
					fn_debtor.fn_debtor_ix = '$fn_debtor_ix'
			");
		}
		$lDB->isMaster = $master;
		return true;
	} else {
		return false;
	}
}

function db_fn_debtor_check_duplicate($fn_debtor_code, $fn_debtor_desc, $pr_business_id, $fn_debtor_ix = "" ) {
	if($fn_debtor_ix != "") {
		$editSQL = "AND fn_debtor.fn_debtor_ix != '$fn_debtor_ix'";
	} else {
		$editSQL = "";
	}

	$exists = $GLOBALS['lDB']->get("
		SELECT
			COUNT(*)
		FROM
			fn_debtor
		WHERE
			fn_debtor.pr_business_id = '" . $pr_business_id . "'
			AND (
				fn_debtor.fn_debtor_code = '" . $fn_debtor_code . "'
				OR fn_debtor.fn_debtor_desc = '" . $GLOBALS['lDB']->escape($fn_debtor_desc) . "'
			)
			$editSQL
	",4);

	return $exists;
}

function db_fn_debtor_set_export($fn_debtor_id, $fn_debtor_export_yn=1) {
	global $lDB;
	
	if(!db_fn_debtor_exists($fn_debtor_id)) {
		return false;
	}

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_debtor WHERE fn_debtor_ix = '$fn_debtor_ix'",4);
	if(!db_pr_business_ledger_allow($pr_business_id)) {
		return false;
	}

	$master = $lDB->isMaster;
	$lDB->isMaster = "1";		

	$lDB->put("
		UPDATE fn_debtor SET
			fn_debtor_export_yn = '".$lDB->escape($fn_debtor_export_yn)."'
		WHERE
			fn_debtor.fn_debtor_ix = '$fn_debtor_id'
	");

	$lDB->isMaster = $master;
	
	return true;
}

function db_fn_debtor_set_persona($fn_debtor_id,$pr_persona_id,$force=false) {
	global $lDB;

	if(!db_fn_debtor_exists($fn_debtor_id)) {
		return false;
	}

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_debtor WHERE fn_debtor_ix = '$fn_debtor_id'",4);

	if(!db_pr_business_ledger_allow($pr_business_id)) {
		return false;
	}


	$hasPersona = $lDB->get("
		SELECT
			COUNT(*)
		FROM
			fn_debtor
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = fn_debtor.pr_persona_id
		WHERE
			fn_debtor.fn_debtor_ix = '$fn_debtor_id'
	",4);

	if($hasPersona == 0 || $force) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";			

		$lDB->put("
			UPDATE fn_debtor SET
				fn_debtor.pr_persona_id = '".$lDB->escape($pr_persona_id)."'
			WHERE
				fn_debtor.fn_debtor_ix = '$fn_debtor_id'
		");

		$lDB->isMaster = $master;
		
	} else {
		return false;
	}
}

function db_fn_debtor_set_currency($fn_debtor_id,$rf_currency_id) {
	global $lDB;

	if(!db_fn_debtor_exists($fn_debtor_id)) {
		return false;
	}

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_debtor WHERE fn_debtor_ix = '$fn_debtor_id'",4);
	if(!db_pr_business_ledger_allow($pr_business_id)) {
		return false;
	}

	$lDB->put("
		UPDATE fn_debtor SET
			rf_currency_id = '".$lDB->escape($rf_currency_id)."'
		WHERE
			fn_debtor.fn_debtor_ix = '$fn_debtor_id'
	");
}
