<?php

/**
 * db.fn_folio.php - Database functions for table fn_folio
 */

require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.rf_bank.php");
require_once(__DIR__ . "/db.rv_payment.php");
require_once(__DIR__ . "/db.rv_payment_item.php");
require_once(__DIR__ . "/db.tc_res_update.php");

require_once(__DIR__ . "/functions.reservation.php");

function db_fn_folio_exists($fn_folio_id) {
	global $lDB;
	
	$folioCheck = $lDB->get("SELECT COUNT(fn_folio_ix) FROM fn_folio WHERE fn_folio_ix = '$fn_folio_id'",4);
	if($folioCheck > 0) { return true; } else { return false; }
}

function db_fn_folio_exists_by_reservation($fn_folio_id,$rv_reservation_id) {
	global $lDB;
	
	$folioCheck = $lDB->get("
		SELECT COUNT(fn_folio_ix) FROM fn_folio WHERE fn_folio_ix = '$fn_folio_id' AND rv_reservation_id = '$rv_reservation_id'
	",4);
	if($folioCheck > 0) { return true; } else { return false; }
}


function db_fn_folio_exists_by_folio($rv_reservation_id, $pr_business_id, $rf_currency_id, $rv_res_item_group_id="", $fn_folio_to_id) {
	global $lDB;
	
	// Type: 1 = res item, 2 = extra item
	$resLevel = $lDB->get("SELECT rv_folio_level_ind FROM rv_reservation WHERE rv_reservation_ix = '$rv_reservation_id'",4);
	if($rv_res_item_group_id == "" || $resLevel == 1) {
		$groupCheck = "AND rv_res_item_group_id IS NULL";
	} elseif($rv_res_item_group_id != 2 && $resLevel == 3) {
		$groupCheck = "AND rv_res_item_group_id = '$rv_res_item_group_id'";
	} else {
		$groupCheck = "";
	}
	
	$sqlFrom = "
		FROM
			fn_folio
		WHERE
			fn_invoice_id IS NULL
			AND rv_reservation_id = '$rv_reservation_id'
			AND pr_business_id = '$pr_business_id'
			AND rf_currency_id = '$rf_currency_id'
			AND fn_folio_db IN ('".join("','",getDBCodes())."')
			AND fn_folio_to_id = '$fn_folio_to_id'
			$groupCheck
	";
	$folioCheck = $lDB->get("SELECT count(fn_folio_ix) $sqlFrom",4);
	if($folioCheck == "0") {
		return false;
	} else {
		return $lDB->get("SELECT fn_folio_ix $sqlFrom",4);
	}
}


function db_fn_folio_get_max_folio_num($rv_reservation_id) {
	global $lDB;

	$max = $lDB->get("SELECT MAX(fn_folio_folio_num) FROM fn_folio WHERE rv_reservation_id = '$rv_reservation_id'",4);
	if(trim($max == "") || $max == "0") {
		$max = "0";
	}
	return $max;
}

function db_get_folio_date($rv_reservation_id,$pr_business_id,$fn_folio_id=false) {
	global $lDB;

	$today = date("Y-m-d");
	$folioList = $lDB->get("SELECT fn_folio_ix FROM fn_folio WHERE rv_reservation_id = '$rv_reservation_id' AND pr_business_id = '$pr_business_id'",3);

	$fromSQL = " FROM rv_reservation_item WHERE fn_folio_id IN ('".join("','",$folioList)."')";
	$rf_invoice_date = $lDB->get("SELECT rf_invoice_date FROM rf_default",4);
	if($rf_invoice_date == "1") {
		$selectSQL = "SELECT MAX(rv_item_date_depart)";
	} else {
		$selectSQL = "SELECT MIN(rv_item_date_arrive)";
	}
	$defaultDate = $lDB->get("$selectSQL $fromSQL",4);

	$businessAccomm = $lDB->get("SELECT COUNT(*) $fromSQL",4);
	if($businessAccomm > 0 && $fn_folio_id !== false) {
		$folioAccomm = $lDB->get("SELECT COUNT(*) FROM rv_reservation_item WHERE fn_folio_id = '$fn_folio_id'",4);
		if($folioAccomm > 0) {
			return $defaultDate;
		} else {
			$accommRange = $lDB->get("
				SELECT
					MIN(rv_reservation_item.rv_item_date_arrive) AS rv_item_date_arrive,
					MAX(rv_reservation_item.rv_item_date_depart) AS rv_item_date_depart
				$fromSQL
			",1);
			if($today >= $accommRange['rv_item_date_arrive'] && $today <= $accommRange['rv_item_date_depart']) {
				return $today;
			} else {
				return $defaultDate;
			}
		}
	} else {
		// Extras-only folios
		$extrasCount = $lDB->get("SELECT COUNT(*) FROM rv_extra WHERE fn_folio_id IN ('".join("','",$folioList)."') AND rv_extra_void_ind = 0",4);
		if($extrasCount > 0 && $fn_folio_id !== false) {
			if($rf_invoice_date == "1") {
				$selectSQL = "SELECT MAX(rv_extra_date_serv)";
			} else {
				$selectSQL = "SELECT MIN(rv_extra_date_serv)";
			}
			$defaultDate = $lDB->get("$selectSQL FROM rv_extra WHERE fn_folio_id IN ('".join("','",$folioList)."') AND rv_extra_void_ind = 0",4);
			return $defaultDate;
		} else {
			return $today;
		}
	}
}	



function db_fn_folio_insert($rv_reservation_id, $pr_business_id, $rf_currency_id, $rv_res_item_group_id="",$fn_folio_to_id=false, $createNew=false) {
	global $lDB;
	
	$folioNum = db_fn_folio_get_max_folio_num($rv_reservation_id) + 1;
	
	if(!$createNew) {
		$checkFolio = db_fn_folio_exists_by_folio($rv_reservation_id, $pr_business_id, $rf_currency_id, $rv_res_item_group_id, $fn_folio_to_id);
		// if there is already a matching folio, just return it's identifier
		if(! ($checkFolio === false) ) {
			return $checkFolio;
		}
	}
	if($rv_res_item_group_id == "") {
		$groupId = "NULL";
	} else {
		$groupId = "'$rv_res_item_group_id'";
	}
	$fn_folio_date = db_get_folio_date($rv_reservation_id,$pr_business_id);

	$today = date("Y-m-d H:i:s");
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO fn_folio (
			fn_folio_db,
			fn_folio_folio_num,
			pr_business_id,
			rv_reservation_id,
			rf_currency_id,
			rv_res_item_group_id,
			fn_folio_to_id,
			fn_folio_date,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($folioNum)."',
			'".$lDB->escape($pr_business_id)."',
			'".$lDB->escape($rv_reservation_id)."',
			'".$lDB->escape($rf_currency_id)."',
			$groupId,
			'".$lDB->escape($fn_folio_to_id)."',
			'".$lDB->escape($fn_folio_date)."',
			'".$lDB->escape($today)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($GLOBALS['userid'])."',
			'".$lDB->escape($today)."',
			'".$lDB->escape($ad_modify_date_tz)."',
			'".$lDB->escape($GLOBALS['userid'])."'
		)
	");
	$folioId = $lDB->insert_id;

	return $folioId;
}


function db_fn_folio_insert_reservation_item($rv_reservation_item_id) {
	global $lDB;
	
	$resId = $lDB->get("SELECT rv_reservation_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",4);
	$currencyId = $lDB->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);

	$businessId = db_pr_business_get_billing($lDB->get("SELECT pr_business_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$rv_reservation_item_id'",4));
	$fn_folio_to_id = $lDB->get("
		SELECT
			pr_persona.pr_persona_ix
		FROM
			rv_reservation
			INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_invoice_persona_id
		WHERE
			rv_reservation.rv_reservation_ix = '$resId'
	",4);
	if($fn_folio_to_id == "0" || trim($fn_folio_to_id) == "") {
		$fn_folio_to_id = false;
	}
	  
	return db_fn_folio_insert($resId, $businessId, $currencyId,"", $fn_folio_to_id);
}

function db_fn_folio_insert_extra($rv_extra_id, $rv_res_item_group_id=false, $fn_folio_to_id=false, $createNew=false, $regen=false) {
	global $lDB;
	
	if(trim($fn_folio_to_id) == "") {
		$fn_folio_to_id = false;
	}
	$fromSQL = " FROM rv_extra WHERE rv_extra_ix = '$rv_extra_id'";
	$resId = $lDB->get("SELECT rv_reservation_id".$fromSQL,4);
	$currencyId = $lDB->get("SELECT rv_extra_inv_curr_id".$fromSQL,4);
	$businessId = $lDB->get("SELECT pr_business_inv_id".$fromSQL,4);
	if($rv_res_item_group_id === true) {
		$folioLevel = $lDB->get("SELECT rv_folio_level_ind FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
		if($folioLevel == "3") {
			$rv_res_item_group_id = $lDB->get("SELECT rv_res_item_group_id".$fromSQL,4);
			if($regen) {
				if($fn_folio_to_id === false) {
					$guestCount = $lDB->get("SELECT COUNT(rv_res_item_guest_id) FROM rv_res_item_guest WHERE rv_res_item_group_id = '$rv_res_item_group_id'",4);
					if($guestCount > 0) {
						$fn_folio_to_id = $lDB->get("SELECT pr_guest_id FROM  rv_res_item_guest WHERE rv_res_item_group_id = '$rv_res_item_group_id'",4);
					} else {
						$fn_folio_to_id = $lDB->get("SELECT rv_invoice_persona_id FROM  rv_reservation WHERE rv_reservation_ix = '$resId'",4);
					}
				}
			}
			if($fn_folio_to_id == "0" || trim($fn_folio_to_id) == "") {
				$fn_folio_to_id = false;
			}
		} else {
			$rv_res_item_group_id = false;
		}
	}
	$extraCurrency = $lDB->get("SELECT rf_currency_id ".$fromSQL,4);
	if($extraCurrency == "0" || trim($extraCurrency) == "") {
		return "0";
	}
	return db_fn_folio_insert($resId, $businessId, $currencyId,  $rv_res_item_group_id, $fn_folio_to_id, $createNew);
}

function db_fn_folio_delete_by_id($fn_folio_id) {
	global $lDB;

	$resItemCount = $lDB->get("SELECT COUNT(rv_reservation_item_ix) FROM rv_reservation_item WHERE fn_folio_id = '$fn_folio_id'",4);
	$extraCount = $lDB->get("SELECT COUNT(*) FROM rv_extra WHERE fn_folio_id = '$fn_folio_id' AND rv_extra.rv_extra_void_ind = '0'",4);
	$checkInvoice = $lDB->get("
		SELECT
			COUNT(fn_folio_ix)
		FROM
			fn_folio
		WHERE
			fn_folio_ix = '$fn_folio_id'
			AND fn_invoice_id IS NOT NULL
			AND fn_invoice_id <> '0'
			AND trim(fn_invoice_id) <> ''
	",4);
	$checkPayment = $lDB->get("SELECT COUNT(rv_payment_item_ix) FROM rv_payment_item WHERE fn_folio_id = '$fn_folio_id'",4);
	$checkPaymentAmount = $lDB->get("SELECT SUM(rv_payment_item_amt) FROM rv_payment_item WHERE fn_folio_id = '$fn_folio_id'",4);
	if($resItemCount == "0" && $extraCount == "0" && $checkInvoice == "0" && ($checkPayment == "0" || $checkPaymentAmount == 0)) {
		$lDB->put("DELETE FROM fn_folio WHERE fn_folio.fn_folio_ix = '$fn_folio_id'");
		return true;
	} else {
		return false;
	}
}

function db_fn_folio_update_totals($fn_folio_id) {
	global $lDB;

	$oldFlagChngs = $GLOBALS['flagChngs'];
	$GLOBALS['flagChngs'] = "0";

	$rv_reservation_id = $lDB->get("SELECT rv_reservation_id FROM fn_folio WHERE fn_folio_ix='$fn_folio_id'",4);

	
	$resItemTotal = $lDB->get("
		SELECT
			SUM( rv_item_amt_payable) as total,
			SUM(rv_item_amt_comm) as totalComm,
			SUM(rv_item_amt_tax) as totalTax
		FROM
			rv_reservation_item
		WHERE
			fn_folio_id = '$fn_folio_id'
	",1);
	$total = $resItemTotal['total'];
	$totalComm = $resItemTotal['totalComm'];
	$totalTax = $resItemTotal['totalTax'];

	$extraTotal = $lDB->get("
		SELECT
			SUM(rv_extra_amt_payable) as total,
			SUM(rv_extra_amt_comm) as totalComm,
			rv_extra.rv_extra_ix AS extra_id,
			(
				SELECT SUM(rv_extra_tax_amt)
				FROM rv_extra_tax
				WHERE rv_extra_tax.rv_extra_id = extra_id
			) as totalTax
		FROM
			rv_extra
		WHERE
			rv_extra.fn_folio_id = '$fn_folio_id'
			AND rv_extra.rv_extra_void_ind = '0'
	",1);
	$total += $extraTotal['total'];
	$totalComm += $extraTotal['totalComm'];
	$totalTax += $extraTotal['totalTax'];

	$totalPaid = $lDB->get("
		SELECT
			SUM(rv_payment_item.rv_payment_item_amt)
		FROM
			rv_payment_item
		WHERE
			rv_payment_item.fn_folio_id = '$fn_folio_id'
	",4);

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_folio WHERE fn_folio_ix = '$fn_folio_id'",4);

	$wasMaster = false;
	if ($GLOBALS['lDB']->isMaster == "0"){
		$GLOBALS['lDB']->isMaster = "1";
		$wasMaster = true;
	}
	$today = date("Y-m-d H:i:s");
	$ad_modify_date_tz = date("e");
	
	// Check for TBA items so that flag can be set
	$accommAll = $lDB->get("
		SELECT
			COUNT(rv_res_item_comp.rv_res_item_comp_id) as accommCount,
			COUNT(rv_reservation_item.rv_reservation_item_ix) as itemCount
		FROM
			rv_reservation_item
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			LEFT JOIN rv_res_item_comp ON rv_res_item_comp.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
			LEFT JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
		WHERE
			rv_reservation_item.fn_folio_id = '$fn_folio_id'
			AND (
				rv_res_item_comp.rv_item_comp_separate_yn = 0
				OR rt_component.rt_component_id IS NULL
			)
		GROUP BY
			rv_reservation_ix,
			rv_res_item_comp.rt_tax_id
	",2);	
	
	$hasTBA = 0;
	foreach($accommAll as $accommKey=>$accommItem) {
		if($accommItem['accommCount'] == 0 && $accommItem['itemCount'] > 0) {
			$hasTBA = 1;
		}
	}	

	$lDB->put("
		UPDATE fn_folio SET
			fn_folio_amount  = '".$lDB->escape(db_round($total,2))."',
			fn_folio_amt_comm = '".$lDB->escape(db_round($totalComm,2))."',
			fn_folio_amt_tax = '".$lDB->escape(db_round($totalTax,6))."',
			fn_folio_amt_paid = '".$lDB->escape(db_round($totalPaid,2))."',
			fn_folio_date = '".$lDB->escape(db_get_folio_date($rv_reservation_id,$pr_business_id,$fn_folio_id))."',
			ad_modify_date = '".$lDB->escape($today)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($GLOBALS['userid'])."',
			fn_folio_amt_tba_yn = '".$lDB->escape($hasTBA)."'
		WHERE
			fn_folio_ix = '$fn_folio_id'
	");
	if($wasMaster) {
		$lDB->isMaster = "0";
	}
	
	db_tc_res_update_insert($rv_reservation_id);
	$GLOBALS['flagChngs'] = $oldFlagChngs;	
}

function fn_folio_pay($fn_folio_id,$gl_exch_rate=false) {
	global $lDB;
	// Check if the outstanding amount is to be cleared
	$folioInfo = $lDB->get("
		SELECT
			fn_folio.fn_folio_amount,
			fn_folio.fn_folio_amt_paid,
			fn_folio.rf_currency_id,
			pr_business.pr_business_id,
			fn_folio.rv_reservation_id
		FROM
			fn_folio
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
		WHERE
			fn_folio.fn_folio_ix = '$fn_folio_id'
	",1);
	$folioOutstanding = $folioInfo['fn_folio_amount'] - $folioInfo['fn_folio_amt_paid'];

	
	if($folioOutstanding != 0) {
		$rf_mthd_pmnt_id = $lDB->get("SELECT rf_mthd_pmnt_ix FROM rf_mthd_pmnt WHERE rf_mthd_pmnt_sys_code = '3'",4);
		$systemUserId = $lDB->get("SELECT pr_persona_ix FROM pr_persona WHERE pr_sys_code = '9'",4);
		$rf_bank_id = db_rf_bank_debt($folioInfo['rf_currency_id'], $folioInfo['pr_business_id']);
		$rv_payment_id = db_rv_payment_insert($systemUserId,date("Y-m-d"),$rf_bank_id,$rf_mthd_pmnt_id,"Write off");
		$rv_payment_item_id = db_rv_payment_item_insert($rv_payment_id,$fn_folio_id,$folioOutstanding,1,$gl_exch_rate);		
		ammendReservation($folioInfo['rv_reservation_id'],"Write off");
	}
}
