<?php

require_once(__DIR__ . "/db.fn_invoice_item.php");
require_once(__DIR__ . "/db.fn_invoice_item_tax.php");
require_once(__DIR__ . "/db.fn_invoice_payment.php");
require_once(__DIR__ . "/db.fn_invoice_special.php");
require_once(__DIR__ . "/db.fn_tran.php");
require_once(__DIR__ . "/db.rf_exchange_rate.php");
require_once(__DIR__ . "/db.rv_res_item_comp.php");
require_once(__DIR__ . "/db.rv_extra.php");

require_once(__DIR__ . '/class.lock.php');

require_once(__DIR__ . "/functions.reservation.php");

define("DB_FN_INVOICE_NORMAL",1);
define("DB_FN_INVOICE_REVERSE",2);

define("DB_FN_INVOICE_STATUS_LINKED",2);
define("DB_FN_INVOICE_STATUS_UNLINKED",8);

define("DB_FN_INVOICE_TYPE_INVOICE",1);
define("DB_FN_INVOICE_TYPE_CREDIT",2);

define("DB_FN_INVOICE_REVERSE_NONE",0);
define("DB_FN_INVOICE_REVERSE_PARENT",2);
define("DB_FN_INVOICE_REVERSE_CHILD",4);

function db_fn_invoice_exists($fn_invoice_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(fn_invoice_ix) FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_fn_invoice_exists_by_reservation($rv_reservation_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(fn_invoice_ix) FROM fn_invoice WHERE rv_reservation_id = '$rv_reservation_id' AND fn_inv_reverse_ind = 0 AND fn_inv_void_yn = 0",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_fn_invoice_exists_by_folio($fn_folio_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(fn_invoice_ix) FROM fn_invoice WHERE fn_folio_id = '$fn_folio_id' AND fn_inv_reverse_ind = 0 AND fn_inv_void_yn = 0",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_fn_invoice_status_desc($fn_inv_status_ind) {
	switch($fn_inv_status_ind) {
	case DB_FN_INVOICE_STATUS_LINKED:
		return "Linked";
	case DB_FN_INVOICE_STATUS_UNLINKED:
		return "Unlinked";
	default:
		return "Unknown";
	}
}

function db_fn_invoice_type_desc($fn_inv_type_ind) {
	switch($fn_inv_type_ind) {
	case DB_FN_INVOICE_TYPE_INVOICE:
		return "Invoice";
	case DB_FN_INVOICE_TYPE_CREDIT:
		return "Credit Note";
	default:
		return "Unknown";
	}
}

function db_fn_invoice_reverse_desc($fn_inv_reverse_ind) {
	switch($fn_inv_reverse_ind) {
	case DB_FN_INVOICE_REVERSE_NONE:
		return "None";
	case DB_FN_INVOICE_REVERSE_PARENT:
		return "Reversed";
	case DB_FN_INVOICE_REVERSE_CHILD:
		return "Reversal";
	}
}

function db_fn_invoice_detail_new($fn_folio_id) {
	global $lDB;

	$folio = $lDB->get("
		SELECT
			fn_folio.fn_folio_ix AS fn_folio_id,
			pr_business.pr_bus_inv_prefix AS fn_invoice_prefix,
			pr_business.pr_bus_inv_number,
			pr_business.pr_business_id,
			pr_business.pr_bus_memo_info AS fn_inv_bus_memo_conditions,
			fn_folio.rv_reservation_id,
			rv_reservation.rv_agent_ref AS fn_inv_agent_ref,
			billing_entity.pr_persona_link_id as billing_persona_link_id,
			billing_entity.pr_name_last as fn_inv_from,
			billing_entity.pr_corr_addr_line1 as fn_inv_be_addr_line1,
			billing_entity.pr_corr_addr_line2 as fn_inv_be_addr_line2,
			billing_entity.pr_corr_addr_line3 as fn_inv_be_addr_line3,
			billing_entity.pr_corr_city as fn_inv_be_city,
			billing_entity_country.rf_country_name as fn_inv_be_country,
			billing_entity.pr_corr_post_code as fn_inv_be_post_code,
			billing_entity.pr_email as fn_inv_be_email,
			billing_entity.pr_web_addr as fn_inv_be_web_addr,
			pr_business.pr_bus_statutory_1 as fn_inv_be_statutory_1,
			pr_business.pr_bus_statutory_2 as fn_inv_be_statutory_2,
			pr_business.pr_bus_statutory_3 as fn_inv_be_statutory_3,
			pr_business.pr_bus_statutory_label_1 as fn_inv_be_statutory_label_1,
			pr_business.pr_bus_statutory_label_2 as fn_inv_be_statutory_label_2,
			pr_business.pr_bus_statutory_label_3 as fn_inv_be_statutory_label_3,
			pr_business.pr_bus_home_curr_id as billing_currency_id,
			invoice_to.pr_name_first as fn_inv_to_first,
			invoice_to.pr_name_last as fn_inv_to_last,
			invoice_to.pr_statutory_1 as fn_inv_to_statutory_1,
			invoice_to.pr_statutory_2 as fn_inv_to_statutory_2,
			invoice_to.pr_statutory_3 as fn_inv_to_statutory_3,
			invoice_to.pr_corr_addr_line1 as fn_inv_to_addr_line1,
			invoice_to.pr_corr_addr_line2 as fn_inv_to_addr_line2,
			invoice_to.pr_corr_addr_line3 as fn_inv_to_addr_line3,
			invoice_to.pr_corr_city as fn_inv_to_city,
			invoice_to_country.rf_country_name as fn_inv_to_country,
			invoice_to.pr_corr_post_code as fn_inv_to_post_code,
			fn_folio.fn_invoice_id,
			fn_folio.rf_currency_id as folio_currency_id,
			folio_currency.rf_currency_symbol as fn_inv_curr,
			billing_currency.rf_currency_symbol as fn_inv_curr_home,
			fn_folio.fn_folio_amt_paid AS fn_inv_amt_paid,
			fn_folio.fn_folio_to_id,
			fn_folio.fn_folio_amount AS fn_inv_amt_payable
		FROM
			fn_folio
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			INNER JOIN rf_currency AS folio_currency ON folio_currency.rf_currency_ix = fn_folio.rf_currency_id
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
			INNER JOIN pr_persona AS billing_entity ON billing_entity.pr_persona_ix = pr_business.pr_business_id
			INNER JOIN rf_currency AS billing_currency ON billing_currency.rf_currency_ix = pr_business.pr_bus_home_curr_id 
			LEFT JOIN rf_country AS billing_entity_country ON billing_entity_country.rf_country_ix = billing_entity.pr_corr_country_id
			LEFT JOIN pr_persona AS invoice_to ON invoice_to.pr_persona_ix = fn_folio.fn_folio_to_id
			LEFT JOIN rf_country AS invoice_to_country ON invoice_to_country.rf_country_ix = invoice_to.pr_corr_country_id
		WHERE
			fn_folio_ix = '$fn_folio_id'
	",1);

	$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);
	$folio['fn_inv_be_statutory_label_1'] = $folio['fn_inv_be_statutory_label_1'] != "" ? $folio['fn_inv_be_statutory_label_1'] : $default_statutory_labels['rf_statutory_label_1'];
	$folio['fn_inv_be_statutory_label_2'] = $folio['fn_inv_be_statutory_label_2'] != "" ? $folio['fn_inv_be_statutory_label_2'] : $default_statutory_labels['rf_statutory_label_2'];
	$folio['fn_inv_be_statutory_label_3'] = $folio['fn_inv_be_statutory_label_3'] != "" ? $folio['fn_inv_be_statutory_label_3'] : $default_statutory_labels['rf_statutory_label_3'];

	/* Disallow if invoice already exists */
	if($folio['fn_invoice_id'] != "" && $folio['fn_invoice_id'] != "0") {
		return false;
	}

	$telephonePersonaId = $folio['pr_business_id'];
	if($GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_persona WHERE pr_persona_ix = '$folio[billing_persona_link_id]'",4) > 0) {
		$folio = array_merge($folio,$GLOBALS['lDB']->get("
			SELECT
				pr_persona.pr_corr_addr_line1 as fn_inv_be_addr_line1,
				pr_persona.pr_corr_addr_line2 as fn_inv_be_addr_line2,
				pr_persona.pr_corr_addr_line3 as fn_inv_be_addr_line3,
				pr_persona.pr_corr_city as fn_inv_be_city,
				rf_country.rf_country_name as fn_inv_be_country,
				pr_persona.pr_corr_post_code as fn_inv_be_post_code
			FROM
				pr_persona
				LEFT JOIN rf_country ON rf_country.rf_country_ix = pr_persona.pr_corr_country_id
			WHERE
			pr_persona.pr_persona_ix = '$folio[billing_persona_link_id]'
		",1));
		$telephonePersonaId = $folio['billing_persona_link_id'];
	}
	$folio['fn_inv_be_phone'] = $GLOBALS['lDB']->get("
		SELECT
			pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_persona_id = '$telephonePersonaId'
			AND rf_phone_type_id <> 'RS1'
		ORDER BY
			pr_default_yn DESC
	",4);
	$folio['fn_inv_be_fax'] = $GLOBALS['lDB']->get("
		SELECT
			pr_phone_number
		FROM
			pr_phone
		WHERE
			pr_persona_id = '$telephonePersonaId'
			AND rf_phone_type_id = 'RS1'
		ORDER BY
			pr_default_yn DESC
	",4);
	if(cacheExists("invoiceInsertBookingNote")) {
		$folio['fn_inv_booking_info'] = cacheGet("invoiceInsertBookingNote");
	} else {
		$folio['fn_inv_booking_info'] = $GLOBALS['lDB']->get("SELECT rf_booking_info FROM rf_custom",4);
		cacheSet("invoiceInsertBookingNote",$folio['fn_inv_booking_info']);
	}

	if($folio['fn_folio_to_id'] == "0" || trim($folio['fn_folio_to_id']) == "") {
		$folio['fn_inv_to_first'] = "";
		$folio['fn_inv_to_last'] = "Cash";
		$folio['fn_inv_to_statutory_1'] = "";
		$folio['fn_inv_to_statutory_2'] = "";
		$folio['fn_inv_to_statutory_3'] = "";
		$folio['fn_inv_to_addr_line1'] = "";
		$folio['fn_inv_to_addr_line2'] = "";
		$folio['fn_inv_to_addr_line3'] = "";
		$folio['fn_inv_to_city'] = "";
		$folio['fn_inv_to_country'] = "";
		$folio['fn_inv_to_post_code'] = "";
	}	

	// Check if there is a valid current invoice number
	if(empty($folio['pr_bus_inv_number'])) {
		$folio['pr_bus_inv_number'] = '';
	}

	$folio['fn_inv_to'] = trim($folio['fn_inv_to_first'] . " " . $folio['fn_inv_to_last']);

	foreach($folio as $fId=>$fVal) {
		$folio[$fId] = addslashes($fVal);
	}

	return $folio;	
}

function db_fn_invoice_detail_credit($fn_invoice_id) {
	global $lDB;

	$invoice = $lDB->get("
		SELECT
			fn_invoice.fn_inv_be_addr_line1,
			fn_invoice.fn_inv_be_addr_line2,
			fn_invoice.fn_inv_be_addr_line3,
			fn_invoice.fn_inv_be_city,
			fn_invoice.fn_inv_be_country,
			fn_invoice.fn_inv_be_post_code,
			fn_invoice.fn_inv_be_statutory_1,
			fn_invoice.fn_inv_be_statutory_2,
			fn_invoice.fn_inv_be_statutory_3,
			fn_invoice.fn_inv_be_statutory_label_1,
			fn_invoice.fn_inv_be_statutory_label_2,
			fn_invoice.fn_inv_be_statutory_label_3,
			fn_invoice.fn_inv_be_email,				
			fn_invoice.fn_inv_be_phone,
			fn_invoice.fn_inv_be_fax,
			fn_invoice.fn_inv_be_web_addr,
			fn_invoice.fn_inv_date,
			fn_invoice.fn_inv_from,
			fn_invoice.fn_inv_to,
			fn_invoice.fn_inv_to_statutory_1,
			fn_invoice.fn_inv_to_statutory_2,
			fn_invoice.fn_inv_to_statutory_3,
			fn_invoice.fn_inv_to_addr_line1,
			fn_invoice.fn_inv_to_addr_line2,
			fn_invoice.fn_inv_to_addr_line3,
			fn_invoice.fn_inv_to_city,
			fn_invoice.fn_inv_to_country,
			fn_invoice.fn_inv_to_post_code,
			fn_invoice.fn_invoice_prefix,
			fn_invoice.fn_folio_id,
			fn_invoice.pr_business_id,
			fn_invoice.rv_reservation_id,
			fn_invoice.fn_inv_agent_ref,
			fn_invoice.fn_inv_curr,
			fn_invoice.fn_inv_curr_home,
			fn_invoice.fn_inv_status_ind,
			fn_invoice.fn_inv_bus_memo_conditions,
			fn_invoice.fn_inv_booking_info,
			fn_invoice.fn_inv_exch_rate,
			fn_invoice.fn_inv_exch_rate_balance,
			fn_invoice.fn_inv_amt_payable,
			pr_business.pr_bus_inv_number
		FROM
			fn_invoice
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_invoice.pr_business_id
		WHERE
			fn_invoice_ix = '$fn_invoice_id'
	",1);

	$invoice['fn_inv_amt_paid'] = "0";

	if(empty($invoice['pr_bus_inv_number'])) {
		$invoice['pr_bus_inv_number'] = '';
	}

	foreach($invoice as $key=>$item) {
		$invoice[$key] = addslashes($item);
	}
	
	return $invoice;
}

function db_fn_invoice_insert($fn_invoice_type, $fn_link_id, $fn_inv_date, $fn_inv_exch_rate=false) {
	global $lDB;

	$extra = array();

	if($fn_invoice_type == DB_FN_INVOICE_NORMAL) {
		$invoice = db_fn_invoice_detail_new($fn_link_id);

		if($fn_inv_exch_rate !== false) {
			$extra['fn_inv_exch_rate'] = $fn_inv_exch_rate;
			$extra['fn_inv_exch_rate_balance'] = $fn_inv_exch_rate;
			db_rf_exchange_rate_set($invoice['folio_currency_id'],$invoice['billing_currency_id'],$fn_inv_exch_rate);
		}

		$fn_inv_status_ind = DB_FN_INVOICE_STATUS_LINKED;
		$fn_inv_reverse_ind = DB_FN_INVOICE_REVERSE_NONE;
	} else {
		$invoice = db_fn_invoice_detail_credit($fn_link_id);

		$extra['fn_inv_exch_rate'] = $invoice['fn_inv_exch_rate'];
		$extra['fn_inv_exch_rate_balance'] = $invoice['fn_inv_exch_rate'];

		$fn_inv_status_ind = DB_FN_INVOICE_STATUS_UNLINKED;
		$fn_inv_reverse_ind = DB_FN_INVOICE_REVERSE_CHILD;
	}

	if($invoice === false) {
		return false;
	}

	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}


	$fn_inv_type_ind = DB_FN_INVOICE_TYPE_INVOICE;
	if($invoice['fn_inv_amt_payable'] < 0) {
		$fn_inv_type_ind = DB_FN_INVOICE_TYPE_CREDIT;
	}

	// Allows use of certain special characters, like quotes, in invoicing unit names
	$invoice['fn_inv_from'] = str_replace("\\", "", $invoice['fn_inv_from']);

	$lDB->put("
		INSERT INTO fn_invoice (
			fn_invoice_db,
			fn_invoice_prefix,
			fn_invoice_id,
			fn_inv_status_ind,
			fn_inv_type_ind,
			fn_inv_reverse_ind,
			fn_inv_date,
			fn_inv_be_addr_line1,
			fn_inv_be_addr_line2,
			fn_inv_be_addr_line3,
			fn_inv_be_city,
			fn_inv_be_country,
			fn_inv_be_post_code,
			fn_inv_be_statutory_1,
			fn_inv_be_statutory_2,
			fn_inv_be_statutory_3,
			fn_inv_be_statutory_label_1,
			fn_inv_be_statutory_label_2,
			fn_inv_be_statutory_label_3,
			fn_inv_be_email,				
			fn_inv_be_phone,
			fn_inv_be_fax,
			fn_inv_be_web_addr,
			fn_inv_from,
			fn_inv_to,
			fn_inv_to_statutory_1,
			fn_inv_to_statutory_2,
			fn_inv_to_statutory_3,
			fn_inv_to_addr_line1,
			fn_inv_to_addr_line2,
			fn_inv_to_addr_line3,
			fn_inv_to_city,
			fn_inv_to_country,
			fn_inv_to_post_code,
			fn_folio_id,
			pr_business_id,
			rv_reservation_id,
			fn_inv_agent_ref,
			fn_inv_curr,
			fn_inv_curr_home,
			fn_inv_amt_paid,
			fn_inv_bus_memo_conditions,
			fn_inv_booking_info
			$extraFields
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'".$lDB->escape($invoice['fn_invoice_prefix'])."',
			'".$lDB->escape($invoice['pr_bus_inv_number'])."',
			$fn_inv_status_ind,
			$fn_inv_type_ind,
			$fn_inv_reverse_ind,
			'".$lDB->escape($fn_inv_date)."',
			'".$lDB->escape($invoice['fn_inv_be_addr_line1'])."',
			'".$lDB->escape($invoice['fn_inv_be_addr_line2'])."',
			'".$lDB->escape($invoice['fn_inv_be_addr_line3'])."',
			'".$lDB->escape($invoice['fn_inv_be_city'])."',
			'".$lDB->escape($invoice['fn_inv_be_country'])."',
			'".$lDB->escape($invoice['fn_inv_be_post_code'])."',
			'".$lDB->escape($invoice['fn_inv_be_statutory_1'])."',
			'".$lDB->escape($invoice['fn_inv_be_statutory_2'])."',
			'".$lDB->escape($invoice['fn_inv_be_statutory_3'])."',
			'".$lDB->escape($invoice['fn_inv_be_statutory_label_1'])."',
			'".$lDB->escape($invoice['fn_inv_be_statutory_label_2'])."',
			'".$lDB->escape($invoice['fn_inv_be_statutory_label_3'])."',
			'".$lDB->escape($invoice['fn_inv_be_email'])."',
			'".$lDB->escape($invoice['fn_inv_be_phone'])."',
			'".$lDB->escape($invoice['fn_inv_be_fax'])."',
			'".$lDB->escape($invoice['fn_inv_be_web_addr'])."',
			'".$lDB->escape($invoice['fn_inv_from'])."',
			'".$lDB->escape($invoice['fn_inv_to'])."',
			'".$lDB->escape($invoice['fn_inv_to_statutory_1'])."',
			'".$lDB->escape($invoice['fn_inv_to_statutory_2'])."',
			'".$lDB->escape($invoice['fn_inv_to_statutory_3'])."',
			'".$lDB->escape($invoice['fn_inv_to_addr_line1'])."',
			'".$lDB->escape($invoice['fn_inv_to_addr_line2'])."',
			'".$lDB->escape($invoice['fn_inv_to_addr_line3'])."',
			'".$lDB->escape($invoice['fn_inv_to_city'])."',
			'".$lDB->escape($invoice['fn_inv_to_country'])."',
			'".$lDB->escape($invoice['fn_inv_to_post_code'])."',
			'".$lDB->escape($invoice['fn_folio_id'])."',
			'".$lDB->escape($invoice['pr_business_id'])."',
			'".$lDB->escape($invoice['rv_reservation_id'])."',
			'".$lDB->escape($invoice['fn_inv_agent_ref'])."',
			'".$lDB->escape($invoice['fn_inv_curr'])."',
			'".$lDB->escape($invoice['fn_inv_curr_home'])."',
			'".$lDB->escape($invoice['fn_inv_amt_paid'])."',
			'".$lDB->escape($invoice['fn_inv_bus_memo_conditions'])."',
			'".$lDB->escape($invoice['fn_inv_booking_info'])."'
			$extraValues
		)
	");

	$itemId = $GLOBALS['lDB']->insert_id;

	if($fn_invoice_type == DB_FN_INVOICE_NORMAL) {
		$lDB->put("
			UPDATE
				fn_folio
			SET
				fn_invoice_id = '".$lDB->escape($itemId)."',
				fn_folio_status_ind = 2
			WHERE
				fn_folio_ix = '$invoice[fn_folio_id]'
		");
	}

	if($invoice['pr_bus_inv_number'] != '') {
		$GLOBALS['lDB']->put("
			UPDATE pr_business SET pr_bus_inv_number = NULL WHERE pr_business_id = '$invoice[pr_business_id]'
		");
	}

	return $itemId;

}

function db_fn_invoice_get_items($fn_folio_id) {
	global $lDB;

	$defaultDate = ($lDB->get("SELECT rf_invoice_date FROM rf_default",4)==1?"MAX(rv_item_date_depart)":"MIN(rv_item_date_arrive)");

	$amt_date = $lDB->get("
		SELECT
			$defaultDate
		FROM
			rv_reservation_item
		WHERE
			rv_reservation_item.fn_folio_id = '$fn_folio_id'
	",4);

	$sqlSelect = "
		SUM(rv_res_item_comp.rv_item_comp_amt_comm) AS amt_comm,
		SUM(rv_res_item_comp.rv_item_comp_amt_payable) AS amt_payable,
		SUM(rv_res_item_comp.rv_item_comp_amt_tax) AS amt_tax,
		rv_res_item_comp.rv_item_comp_tax_perc AS amt_tax_perc,
		/*rf_tax_rate.rf_tax_rate_desc AS amt_tax_desc,*/
		rv_res_item_comp.rt_tax_ind,
		rv_res_item_comp.rt_tax_id,
		'1' as amt_type,
		'$amt_date' as amt_date
	";
	$sqlFrom = "
		rv_res_item_comp
		INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
	";
	$sqlWhere = "
		AND rv_reservation_item.fn_folio_id = '$fn_folio_id'
	";
	$sqlGroup = "
		rv_res_item_comp.rt_tax_ind,
		rv_res_item_comp.rt_tax_id
	";

	$consolidatedLabel = addslashes($lDB->get("SELECT rf_doc_invoice_comp_group_label FROM rf_default",4));

	$list = $lDB->get("
		SELECT
			'$consolidatedLabel' as amt_desc,
			$sqlSelect
		FROM
			$sqlFrom
		WHERE
			rv_res_item_comp.rv_item_comp_separate_yn = 0
			$sqlWhere
		GROUP BY
			$sqlGroup
	",2);
	foreach($list as $key=>$item) {
		switch($item['rt_tax_ind']) {
		case DB_FN_INVOICE_ITEM_TAX_RATE:
			$list[$key]['amt_tax_desc'] = $lDB->get("SELECT rf_tax_rate_desc FROM rf_tax_rate WHERE rf_tax_rate_ix = '$item[rt_tax_id]'",4);
			break;
		case DB_FN_INVOICE_ITEM_TAX_GROUP:
			$list[$key]['amt_tax_desc'] = $lDB->get("SELECT rt_tax_group_desc FROM rt_tax_group WHERE rt_tax_group_ix = '$item[rt_tax_id]'",4);
			break;
		}
		$list[$key]['idList'] = $lDB->get("
			SELECT
				DISTINCT rv_res_item_comp.rv_res_item_comp_ix as id
			FROM
				$sqlFrom
			WHERE
				rv_res_item_comp.rv_item_comp_separate_yn = 0
				AND rv_res_item_comp.rt_tax_ind = '$item[rt_tax_ind]'
				AND rv_res_item_comp.rt_tax_id = '$item[rt_tax_id]'
				$sqlWhere
		",3);
		$list[$key]['tax_detail'] = $lDB->get("
			SELECT
				SUM(rv_res_item_comp_tax.rv_res_item_comp_tax_amt) AS rv_res_item_comp_tax_amt,
				rv_res_item_comp_tax.rv_res_item_comp_tax_perc,
				rv_res_item_comp_tax.rf_tax_rate_id
			FROM
				rv_res_item_comp_tax
			WHERE
				rv_res_item_comp_tax.rv_res_item_comp_id IN ('".join("','",$list[$key]['idList'])."')
			GROUP BY
				rv_res_item_comp_tax.rv_res_item_comp_tax_perc,
				rv_res_item_comp_tax.rf_tax_rate_id
		",2);				
	}

	$listSep = $lDB->get("
		SELECT
			rt_component.rt_component_desc as amt_desc,
			$sqlSelect
		FROM
			$sqlFrom
		WHERE
			rv_res_item_comp.rv_item_comp_separate_yn = 1
			$sqlWhere
		GROUP BY
			rt_component.rt_component_desc,
			$sqlGroup
	",2);
	foreach($listSep as $key=>$item) {
		switch($item['rt_tax_ind']) {
		case DB_FN_INVOICE_ITEM_TAX_RATE:
			$listSep[$key]['amt_tax_desc'] = $lDB->get("SELECT rf_tax_rate_desc FROM rf_tax_rate WHERE rf_tax_rate_ix = '$item[rt_tax_id]'",4);
			break;
		case DB_FN_INVOICE_ITEM_TAX_GROUP:
			$listSep[$key]['amt_tax_desc'] = $lDB->get("SELECT rt_tax_group_desc FROM rt_tax_group WHERE rt_tax_group_ix = '$item[rt_tax_id]'",4);
			break;
		}
		$listSep[$key]['idList'] = $lDB->get("
			SELECT
				DISTINCT rv_res_item_comp.rv_res_item_comp_ix as id
			FROM
				$sqlFrom
			WHERE
				rv_res_item_comp.rv_item_comp_separate_yn = 1
				AND rt_component.rt_component_desc = '$item[amt_desc]'
				AND rv_res_item_comp.rt_tax_ind = '$item[rt_tax_ind]'
				AND rv_res_item_comp.rt_tax_id = '$item[rt_tax_id]'
				$sqlWhere
		",3);
		$listSep[$key]['tax_detail'] = $lDB->get("
			SELECT
				SUM(rv_res_item_comp_tax.rv_res_item_comp_tax_amt) AS rv_res_item_comp_tax_amt,
				rv_res_item_comp_tax.rv_res_item_comp_tax_perc,
				rv_res_item_comp_tax.rf_tax_rate_id
			FROM
				rv_res_item_comp_tax
			WHERE
				rv_res_item_comp_tax.rv_res_item_comp_id IN ('".join("','",$listSep[$key]['idList'])."')
			GROUP BY
				rv_res_item_comp_tax.rv_res_item_comp_tax_perc,
				rv_res_item_comp_tax.rf_tax_rate_id
		",2);				
	}
	$list = array_merge($list,$listSep);

	$listExtra = $lDB->get("
		SELECT
			ac_extra.ac_ext_desc as amt_desc,
			rv_extra.rv_extra_amt_comm as amt_comm,
			rv_extra.rv_extra_amt_payable as amt_payable,
			rv_extra.rv_extra_ix AS extra_id,
			rv_extra.rv_extra_amt_tax as amt_tax,
			rv_extra.rv_extra_tax_perc as amt_tax_perc,
			rv_extra.rf_tax_id,
			rv_extra.rv_extra_tax_ind,
			IF(	rv_extra.rv_extra_tax_ind = '10',
				rf_tax_rate.rf_tax_rate_desc,
				rt_tax_group.rt_tax_group_desc) AS amt_tax_desc,
			'2' as amt_type,
			rv_extra.rv_extra_ix as amt_id,
			rv_extra.rv_extra_date_serv AS amt_date,
			rv_extra.rf_tax_id AS rf_tax_rate_id
		FROM
			rv_extra
			INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
			LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_extra.rf_tax_id
			LEFT JOIN rt_tax_group ON rt_tax_group.rt_tax_group_ix = rv_extra.rf_tax_id
		WHERE
			rv_extra.fn_folio_id = '$fn_folio_id'
			AND rv_extra.rv_extra_void_ind = 0
	",2);

	foreach($listExtra as $key=>$item) {
		$listExtra[$key]['tax_detail'] = $lDB->get("
			SELECT
				rv_extra_tax.rv_extra_tax_amt AS amt_tax,
				rv_extra_tax.rv_extra_tax_perc AS amt_tax_perc,
				rv_extra_tax.rf_tax_rate_id,
				rf_tax_rate.rf_tax_rate_desc
			FROM
				rv_extra_tax
				LEFT JOIN rf_tax_rate ON rf_tax_rate.rf_tax_rate_ix = rv_extra_tax.rf_tax_rate_id
			WHERE
				rv_extra_tax.rv_extra_id = '".$item['extra_id']."'
		",2);
	}

	$list = array_merge($list,$listExtra);

	return $list;
}

function db_fn_invoice_is_void($fn_invoice_id) {
	global $lDB;

	$fn_inv_status_ind = $lDB->get("SELECT fn_inv_status_ind FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'",4);
	if($fn_inv_status_ind == DB_FN_INVOICE_STATUS_UNLINKED) {
		return true;
	} else {
		return false;
	}
}

function db_fn_invoice_void($fn_invoice_id,$fn_inv_reverse_link_id=false,$fn_inv_date=false,$acquire_lock=true) {
	global $lDB;

	$folioId = $lDB->get("SELECT fn_folio_id FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'",4);

	if($acquire_lock) {
		$lock = new Lock("folio_".$folioId);
		if(!$lock->Acquire()) {
			return false;
		}
	}

	// Stop if the invoice is already void
	if(db_fn_invoice_is_void($fn_invoice_id)) {
		if($acquire_lock) {
			$lock->Release();
		}
		return false;
	}

	$fn_inv_date = db_fn_invoice_get_date($fn_invoice_id, $fn_inv_date);

	$voidDate = date("Y-m-d");
	$voidDateTime = date("Y-m-d H:i:s");
	$voidUser = $GLOBALS['userid'];

	// Delete GL Transaction table entries
	$reservationId = $lDB->get("SELECT rv_reservation_id FROM fn_folio WHERE fn_folio_ix = '$folioId'",4);

	$invoiceItemList = $lDB->get("SELECT fn_invoice_item_ix FROM fn_invoice_item WHERE fn_invoice_id = '$fn_invoice_id'",3);

	$resItemList = $GLOBALS['lDB']->get("SELECT rv_reservation_item_ix FROM rv_reservation_item WHERE fn_invoice_id = '$fn_invoice_id'",3);
	foreach($resItemList as $resItemId) {
		$GLOBALS['lDB']->put("UPDATE rv_reservation_item SET fn_invoice_id = NULL WHERE rv_reservation_item_ix = '$resItemId'");
	}

	$resCompList = $GLOBALS['lDB']->get("
		SELECT
			rv_res_item_comp_ix
		FROM
			rv_res_item_comp
		WHERE
			fn_invoice_item_id IN ('".join("','",$invoiceItemList)."')
	",3);
	foreach($resCompList as $resCompId) {
		$GLOBALS['lDB']->put("UPDATE rv_res_item_comp SET fn_invoice_item_id = NULL WHERE rv_res_item_comp_ix = '$resCompId'");
	}
	
	$resExtraList = $GLOBALS['lDB']->get("
		SELECT
			rv_extra_ix
		FROM
			rv_extra
		WHERE
			fn_invoice_item_id  IN ('".join("','",$invoiceItemList)."')
	",3);
	foreach($resExtraList as $resExtraId) {
		$GLOBALS['lDB']->put("UPDATE rv_extra SET fn_invoice_item_id = NULL WHERE rv_extra_ix = '$resExtraId'");
	}

	db_fn_tran_delete_by_invoice_id($fn_invoice_id,$fn_inv_reverse_link_id,$fn_inv_date);
	db_fn_invoice_void_clear_debt($folioId);

	// Set flags
	$GLOBALS['lDB']->put("
		UPDATE fn_folio SET
			fn_invoice_id = NULL,
			fn_folio_status_ind = 0
		WHERE
			fn_folio_ix = '$folioId'				
	");

	$extra = "";

	$fn_inv_void_yn = "1";

	if($fn_inv_reverse_link_id !== false) {
		$fn_inv_void_yn = "0";
		$fn_inv_reverse_ind = DB_FN_INVOICE_REVERSE_PARENT;
		$extra = "
			fn_inv_reverse_ind = '".DB_FN_INVOICE_REVERSE_PARENT."',
			fn_inv_reverse_link_id = '$fn_inv_reverse_link_id',
		";
	}
	$GLOBALS['lDB']->put("
		UPDATE fn_invoice SET
			fn_inv_status_ind = ".DB_FN_INVOICE_STATUS_UNLINKED.",
			fn_inv_void_yn = '".$lDB->escape($fn_inv_void_yn)."',
			$extra
			fn_inv_void_date = '".$lDB->escape($voidDate)."',
			fn_inv_void_user_id = '".$lDB->escape($voidUser)."'
		WHERE
			fn_invoice_ix = '$fn_invoice_id'
	");

	if($fn_inv_reverse_link_id === false) {
		$label = db_fn_invoice_type_desc($lDB->get("SELECT fn_inv_type_ind FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'",4));
		ammendReservation($reservationId,"Void $label ($fn_invoice_id)");
	}

	if($acquire_lock) {
		$lock->Release();
	}
}

function db_fn_invoice_reverse($fn_invoice_id, $fn_inv_date=false) {
	global $lDB;

	$fn_folio_id = $lDB->get("SELECT fn_folio_id FROM fn_invoice WHERE fn_invoice_ix = '".$fn_invoice_id."'",4);
	$lock = new Lock("folio_".$fn_folio_id);
	if(!$lock->Acquire()) {
		return false;
	}

	// Stop if the invoice is already void
	if(db_fn_invoice_is_void($fn_invoice_id)) {
		$lock->Release();
		return false;
	}

	$fn_inv_date = db_fn_invoice_get_date($fn_invoice_id, $fn_inv_date);

	$fn_invoice_id_reverse = db_fn_invoice_insert(DB_FN_INVOICE_REVERSE, $fn_invoice_id, $fn_inv_date);

	$items = $lDB->get("SELECT * FROM fn_invoice_item WHERE fn_invoice_id = '$fn_invoice_id'",2);
	foreach($items as $item) {
		$fn_inv_item_amount = $item['fn_inv_item_amount'] * -1;
		$fn_inv_item_amt_comm = $item['fn_inv_item_amt_comm'] * -1;
		$fn_inv_item_amt_tax = $item['fn_inv_item_amt_tax'] * -1;

		$fn_invoice_item_id_reverse = db_fn_invoice_item_insert($fn_invoice_id_reverse, $item['fn_inv_item_type'], $item['fn_inv_item_date'], $item['fn_inv_item_desc'], $fn_inv_item_amount, $fn_inv_item_amt_comm, $fn_inv_item_amt_tax, $item['fn_inv_item_tax_perc'], $item['fn_inv_item_tax_desc']);

		$taxItems = $lDB->get("SELECT * FROM fn_invoice_item_tax WHERE fn_invoice_item_id = '$item[fn_invoice_item_ix]'",2);
		foreach($taxItems as $taxItem) {
			$fn_invoice_item_tax_amt = $taxItem['fn_invoice_item_tax_amt'] * -1;
			db_fn_invoice_item_tax_insert($fn_invoice_item_id_reverse,$taxItem['rf_tax_rate_id'],$fn_invoice_item_tax_amt, $taxItem['fn_invoice_item_tax_perc']);
		}
	}
		
	$lDB->put("
		UPDATE fn_invoice SET
			fn_inv_reverse_ind = ".DB_FN_INVOICE_REVERSE_CHILD.",
			fn_inv_reverse_link_id = '".$lDB->escape($fn_invoice_id)."'
		WHERE
			fn_invoice.fn_invoice_ix = '$fn_invoice_id_reverse'
	");

	$doFiscalisation = checkFiscalisationByInvoice($fn_invoice_id);
	if ($doFiscalisation) {
		// Components and Extras are going to be unlinked during voiding, so let's get a list of them first for the credit fiscalisation
		require_once(__DIR__ . '/class.fiscalator.php');
		$fiscalise = new Fiscalator();
		$compExtraList = $fiscalise->getInvoiceComponentsExtras($fn_invoice_id);
	}

	db_fn_invoice_void($fn_invoice_id,$fn_invoice_id_reverse,$fn_inv_date,false);

	$label = db_fn_invoice_type_desc($lDB->get("SELECT fn_inv_type_ind FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'",4));
	$label_reverse = db_fn_invoice_type_desc($lDB->get("SELECT fn_inv_type_ind FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id_reverse'",4));
	$rv_reservation_id = $lDB->get("SELECT rv_reservation_id FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id_reverse'",4);
	ammendReservation($rv_reservation_id,"Reversal $label_reverse ($fn_invoice_id_reverse) of $label ($fn_invoice_id)");

	$lock->Release();

	// Fiscalisation, if applicable
	if ($doFiscalisation) {
		$fiscalise->uploadCreditInvoice($fn_invoice_id, $fn_invoice_id_reverse, $compExtraList);
	}
}

function db_fn_invoice_void_clear_debt($fn_folio_id) {
	global $lDB;

	$rf_mthd_pmnt_id = $lDB->get("SELECT rf_mthd_pmnt_ix FROM rf_mthd_pmnt WHERE rf_mthd_pmnt_sys_code = '2'",4);
	$payments = $lDB->get("
		SELECT
			rv_payment_item.rv_payment_item_ix
		FROM
			rv_payment_item
			INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
			LEFT JOIN rv_payment_item as contra_item ON contra_item.rv_payment_item_ix = rv_payment_item.rv_payment_contra_id
		WHERE
			rv_payment_item.fn_folio_id = '$fn_folio_id'
			AND rv_payment.rf_mthd_pmnt_id = '$rf_mthd_pmnt_id'
			AND contra_item.rv_payment_item_ix IS NULL
	",3);
	$rf_mthd_pmnt_id = $lDB->get("SELECT rf_mthd_pmnt_ix FROM rf_mthd_pmnt WHERE rf_mthd_pmnt_sys_code = '3'",4);
	foreach($payments as $rv_payment_item_id) {
		db_rv_payment_void_payment(array($rv_payment_item_id),"Voided invoice",$rf_mthd_pmnt_id);
	}
}


function db_fn_invoice_create($fn_folio_id, $fn_inv_date, $fn_inv_exch_rate=false) {
	global $lDB;
	$zeroFolio = false;

	$lock = new Lock("folio_".$fn_folio_id);
	if(!$lock->Acquire()) {
		return false;
	}

	if(!db_fn_invoice_allow_date($fn_folio_id, $fn_inv_date)) {
		$lock->Release();
		return false;
	}

	if(!db_fn_invoice_allow_date($fn_folio_id, $fn_inv_date)) {
		return false;
	}

	if($fn_inv_exch_rate == "") { $fn_inv_exch_rate = false; }
	$invoiceId = db_fn_invoice_insert(DB_FN_INVOICE_NORMAL, $fn_folio_id, $fn_inv_date, $fn_inv_exch_rate);
	if($invoiceId !== false) {
		$itemList =  db_fn_invoice_get_items($fn_folio_id);
		foreach($itemList as $item) {
			//$invItemId = db_fn_invoice_item_insert($invoiceId, $item['amt_type'], $item['amt_desc'], $item['fn_ledger_id'],
			$invItemId = db_fn_invoice_item_insert($invoiceId, $item['amt_type'], $item['amt_date'], $item['amt_desc'], 
				$item['amt_payable'], $item['amt_comm'], $item['amt_tax'], $item['amt_tax_perc'],$item['amt_tax_desc']);
			if($item['amt_type'] == 1) {
				foreach($item['tax_detail'] as $tax) {
					db_fn_invoice_item_tax_insert($invItemId,$tax['rf_tax_rate_id'],$tax['rv_res_item_comp_tax_amt'], $tax['rv_res_item_comp_tax_perc']);
				}
				foreach($item['idList'] as $idItem) {
					db_rv_res_item_comp_set_invoice($idItem, $invItemId, $invoiceId);
				}
			} else {
				if (isset($item['tax_detail'])) {
					foreach($item['tax_detail'] as $tax) {
						db_fn_invoice_item_tax_insert($invItemId,$tax['rf_tax_rate_id'],$tax['amt_tax'],$tax['amt_tax_perc']);
					}
				} else {
					db_fn_invoice_item_tax_insert($invItemId,$item['rf_tax_rate_id'],$item['amt_tax'],$item['amt_tax_perc']);
				}
				db_rv_extra_set_invoice($item['amt_id'], $invItemId);
			}
		}
		db_fn_invoice_payment_create($invoiceId);
		
		// Record Special in fn_invoice_special (if applied)		
		db_fn_invoice_special_create($fn_folio_id, $invoiceId);

		// Figure out the balance exchange
		$fn_folio_amount = $lDB->get("SELECT fn_folio_amount FROM fn_folio WHERE fn_folio_ix = '$fn_folio_id'",4);
		if($fn_folio_amount != 0) {
			$exchangeList = $lDB->get("
				SELECT
					fn_tran.fn_tran_exch_rate,
					SUM(fn_tran.fn_tran_amt_incl) AS fn_tran_amt,
					SUM(rv_payment_item.rv_payment_item_amt) AS rv_payment_item_amt
				FROM
					fn_tran
					INNER JOIN rv_payment_item ON rv_payment_item.rv_payment_item_ix = fn_tran.fn_tran_link_id
				WHERE
					fn_tran.fn_tran_link_ind IN ('".DB_FN_TRAN_LINK_PAYMENT."','".DB_FN_TRAN_LINK_DEPOSIT."')
					AND fn_tran.fn_folio_id = '$fn_folio_id'
				GROUP BY
					fn_tran.fn_tran_exch_rate
			",2);
			$outstandingInv = $fn_folio_amount;
			$tranTotal = 0;
			$tranTotalInv = 0;
			foreach($exchangeList as $key=>$exchangeItem) {
				$outstandingInv -= $exchangeItem['rv_payment_item_amt'];
				$tranTotal += $exchangeItem['fn_tran_amt'];
				$tranTotalInv += $exchangeItem['rv_payment_item_amt'];
			}
			if($fn_inv_exch_rate === false || $fn_inv_exch_rate == 0) {
				$fn_inv_exch_rate = 1;
			}
			$outstanding = $outstandingInv * $fn_inv_exch_rate;
			$tranTotal += $outstanding;
			$avg = round($fn_folio_amount / $tranTotal,6);
			$lDB->put("UPDATE fn_invoice SET fn_inv_exch_rate = '".$lDB->escape($fn_inv_exch_rate)."' WHERE fn_invoice_ix = '$invoiceId'");
		} else { $zeroFolio = true; }

		$checkTran = $lDB->get("
			SELECT 
				pr_business.fn_system_id
			FROM
				fn_folio
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
			WHERE
				fn_folio.fn_folio_ix = '$fn_folio_id'
		",4);
		$useTran = false;
		if(trim($checkTran) != "" && $checkTran != "0" && $checkTran != "RS1") {
			db_fn_tran_invoice($invoiceId);
		}
	}
	$reservationId = $lDB->get("SELECT rv_reservation_id FROM fn_folio WHERE fn_folio_ix = '$fn_folio_id'",4);
	ammendReservation($reservationId,"Generate Invoice ($invoiceId)");

	$lock->Release();

	// Fiscalisation, if applicable
	if (checkFiscalisationByInvoiceUnit($invoiceId)) {

		require_once(__DIR__ . '/class.fiscalator.php');
		$fiscalise = new Fiscalator();
		!$zeroFolio ? $fiscalise->uploadInvoice($invoiceId) : $fiscalise->updateInvoiceStatus($invoiceId, 9);
	}

	return $invoiceId;
}

function db_fn_invoice_allow_future_date($fn_folio_id,$fn_invoice_id=false) {
	global $lDB;

	if($fn_invoice_id === false) {
		$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_folio WHERE fn_folio.fn_folio_ix = '$fn_folio_id'",4);
	} else {
		$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_invoice WHERE fn_invoice.fn_invoice_ix = '$fn_invoice_id'",4);
	}
	$pr_bus_inv_future_ind = $lDB->get("SELECT pr_bus_inv_future_ind FROM pr_business WHERE pr_business_id = '$pr_business_id'",4);
	if($pr_bus_inv_future_ind == 0) {
		$allow_future = ($lDB->get("SELECT rf_invoice_future_yn FROM rf_default",4) == "1"?true:false);
	} else {
		$allow_future = ($pr_bus_inv_future_ind == "1"?true:false);
	}
	return $allow_future;
}

function db_fn_invoice_allow_date($fn_folio_id, $fn_inv_date) {
	$allow_future = db_fn_invoice_allow_future_date($fn_folio_id);

	$today = date("Y-m-d");
	if($allow_future || $fn_inv_date <= $today) {
		return true;
	} else {
		return false;
	}
}

function db_fn_invoice_max_date($fn_folio_id,$fn_invoice_id=false) {
	global $lDB;

	if($fn_invoice_id === false) {
		$month = date("m");
		$year = date("Y");
	} else {
		$fn_inv_date = $lDB->get("SELECT fn_inv_date FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'",4);
		list($year,$month) = explode("-",$fn_inv_date);
	}
	if($fn_invoice_id !== false || db_fn_invoice_allow_future_date($fn_folio_id,$fn_invoice_id)) {
		return date("Y-m-d",mktime(0,0,0,date("m")+1,0,date("Y")));
	} else {
		return date("Y-m-d");
	}
}

function db_fn_invoice_get_date($fn_invoice_id, $fn_inv_date) {
	global $lDB;

	if($fn_inv_date === false) {
		// Use folio date, not todays date (as is the case with invoicing)
		$fn_folio_id = $lDB->get("SELECT fn_folio_id FROM fn_invoice WHERE fn_invoice_ix = '".$fn_invoice_id."'",4);
		$fn_inv_date = $lDB->get("SELECT fn_folio_date FROM fn_folio WHERE fn_folio_ix = '".$fn_folio_id."'",4);
	}

	return $fn_inv_date;
}

function checkFiscalisationByInvoice($invoiceId) {
	global $lDB;

	if (!$invoiceId) {
		return false;
	}

	return $lDB->get("select count(*) from fs_invoice where fn_invoice_id = '" . $invoiceId . "';", 4);
}

function checkFiscalisationByInvoiceUnit($invoiceId) {
	global $lDB;

	if (!$invoiceId) {
		return false;
	}
	
	$fiscalatorKey = $lDB->get("
		SELECT
			pr_business.fiscalator_key
		FROM
			fn_invoice
			LEFT JOIN pr_business ON pr_business.pr_business_id = fn_invoice.pr_business_id 
		WHERE
			fn_invoice_ix = '" . $invoiceId . "'
	", 4);
	return !empty($fiscalatorKey) ? true : false;
}

function checkFiscalisationByBusinessId($pr_business_id) {
	global $lDB;

	if (!$pr_business_id) {
		return false;
	}

	$fiscalatorKey = $lDB->get("select fiscalator_key from pr_business where pr_business_id = '" . $pr_business_id . "'", 4);
	return !empty(trim($fiscalatorKey)) ? true : false;

}

function updateIncompleteFiscalInvoices() {
	global $lDB;
	$result = false;

	$invoiceList = $lDB->get("
		SELECT 
			fn_invoice_ix 
		FROM 
			fn_invoice 
		WHERE 
			fn_inv_fiscal_status_ind = 1
			AND
			fn_inv_status_ind != 8
	"
	, 3);

	if ($invoiceList) {
		require_once(__DIR__ . '/class.fiscalator.php');
		$updateFiscalStatuses = new Fiscalator();
		$retryList = join(',', $invoiceList);
		$result = $updateFiscalStatuses->queryInvoice($retryList);
	}
	return $result;
}