<?php

require_once(__DIR__ . "/db.fn_invoice_item.php");
require_once(__DIR__ . "/db.pr_bus_tax.php");

define("DB_FN_INVOICE_ITEM_TAX_RATE",10);
define("DB_FN_INVOICE_ITEM_TAX_GROUP",20);

function db_fn_invoice_item_tax_exists($fn_invoice_item_tax_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(fn_invoice_item_tax_ix) FROM fn_invoice_item_tax WHERE fn_invoice_item_tax_ix = '$fn_invoice_item_tax_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_fn_invoice_item_tax_insert($fn_invoice_item_id,$rf_tax_rate_id,$fn_invoice_item_tax_amt, $fn_invoice_item_tax_perc) {
	global $lDB;
	global $dbcode;
	
	if(!db_fn_invoice_item_exists($fn_invoice_item_id)) {
		return false;
	}

	$pr_business_id = $lDB->get("
		SELECT
			fn_invoice.pr_business_id
		FROM
			fn_invoice_item
			INNER JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_invoice_item.fn_invoice_id
		WHERE
			fn_invoice_item.fn_invoice_item_ix = '$fn_invoice_item_id'
	",4);

	$fn_invoice_item_tax_seq = "0";
	$fn_invoice_item_tax_inactive_yn = "0";

	if(db_pr_bus_tax_exists_by_business($pr_business_id)) {
		if(!db_pr_bus_tax_exists_by_all($pr_business_id,$rf_tax_rate_id)) {
			$fn_invoice_item_tax_inactive_yn = "1";
		} else {
			$fn_invoice_item_tax_seq = db_pr_bus_tax_by_all($pr_business_id,$rf_tax_rate_id);
		}
	}

	$fn_invoice_item_tax_desc = $lDB->get("SELECT rf_tax_rate_desc FROM rf_tax_rate WHERE rf_tax_rate_ix = '$rf_tax_rate_id'",4);

	$lDB->put("
		INSERT INTO fn_invoice_item_tax (
			fn_invoice_item_tax_db,
			fn_invoice_item_tax_amt,
			fn_invoice_item_tax_perc,
			fn_invoice_item_tax_desc,
			fn_invoice_item_tax_seq,
			fn_invoice_item_tax_inactive_yn,
			rf_tax_rate_id,
			fn_invoice_item_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($fn_invoice_item_tax_amt)."',
			'".$lDB->escape($fn_invoice_item_tax_perc)."',
			'".$lDB->escape($fn_invoice_item_tax_desc)."',
			'".$lDB->escape($fn_invoice_item_tax_seq)."',
			'".$lDB->escape($fn_invoice_item_tax_inactive_yn)."',
			'".$lDB->escape($rf_tax_rate_id)."',
			'".$lDB->escape($fn_invoice_item_id)."'
		)
	");
	
	$fn_invoice_item_tax_ix = $lDB->insert_id;
	
	return $fn_invoice_item_tax_ix;	
}

