<?php

function db_fn_invoice_payment_insert($fn_invoice_id, $fn_inv_payment_amt, $fn_inv_payment_bank, $fn_inv_payment_curr, $fn_inv_payment_date, $fn_inv_payment_method, $fn_inv_payment_payer, $fn_inv_payment_ref, $rv_payment_contra_id, $rv_payment_item_id) {
	global $lDB;

	$lDB->put("
		INSERT INTO fn_invoice_payment (
			fn_invoice_payment_db,
			fn_invoice_payment_id,
			fn_invoice_id,
			rv_payment_item_id,
			fn_inv_payment_amt,
			fn_inv_payment_bank,
			fn_inv_payment_curr,
			fn_inv_payment_date,
			fn_inv_payment_method,
			fn_inv_payment_payer,
			fn_inv_payment_ref,
			rv_payment_contra_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($fn_invoice_id)."',
			'".$lDB->escape($rv_payment_item_id)."',
			'".$lDB->escape($fn_inv_payment_amt)."',
			'".$lDB->escape($fn_inv_payment_bank)."',
			'".$lDB->escape($fn_inv_payment_curr)."',
			'".$lDB->escape($fn_inv_payment_date)."',
			'".$lDB->escape($fn_inv_payment_method)."',
			'".$lDB->escape($fn_inv_payment_payer)."',
			'".$lDB->escape($fn_inv_payment_ref)."',
			'".$lDB->escape($rv_payment_contra_id)."'
		)
	");

	$paymentId = $GLOBALS['lDB']->insert_id;

	return $paymentId;
}

function db_fn_invoice_payment_create($fn_invoice_id) {
	global $lDB;

	$folioId = $lDB->get("SELECT fn_folio_id FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'",4);

	$paymentList = $lDB->get("
		SELECT
			rv_payment_item.rv_payment_item_amt,
			rf_bank.rf_bank_acc_name,
			rf_currency.rf_currency_symbol,
			rv_payment.rv_pmnt_date,
			rf_mthd_pmnt.rf_mthd_pmnt_desc,
			pr_persona.pr_persona_ix,
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			rv_payment.rv_pmnt_ref,
			rv_payment_item.rv_payment_contra_id,
			rv_payment_item.rv_payment_item_ix
		FROM
			rv_payment_item
			INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
			LEFT JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rv_payment_item.rf_currency_id
			INNER JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = rv_payment.rf_mthd_pmnt_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_payment.pr_persona_id
		WHERE
			rv_payment_item.fn_folio_id = '$folioId'
	",2);

	foreach($paymentList as $paymentItem) {
		if(empty($paymentItem['pr_persona_ix'])) {
			$pr_name = "Cash";
		} else {
			$pr_name = trim($paymentItem['pr_name_first'] . " " . $paymentItem['pr_name_last']);
		}
		db_fn_invoice_payment_insert($fn_invoice_id, $paymentItem['rv_payment_item_amt'], $paymentItem['rf_bank_acc_name'], $paymentItem['rf_currency_symbol'], $paymentItem['rv_pmnt_date'], $paymentItem['rf_mthd_pmnt_desc'], $pr_name, $paymentItem['rv_pmnt_ref'], $paymentItem['rv_payment_contra_id'], $paymentItem['rv_payment_item_ix']);
	}
}
