<?php
require_once(__DIR__ . "/db.pr_business.php");

function db_fn_ledger_exists($fn_ledger_id) {
	global $lDB;

	$ledgerCheck = $lDB->get("SELECT COUNT(fn_ledger_ix) FROM fn_ledger WHERE fn_ledger_ix = '$fn_ledger_id'",4);
	if($ledgerCheck > 0) { return true; } else { return false; }

}

function db_fn_ledger_insert($fn_ledger_code, $fn_ledger_desc, $pr_business_id) {
	global $dbcode;
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		$lDB->put("
			INSERT INTO fn_ledger (
				fn_ledger_db,
				fn_ledger_code,
				fn_ledger_desc,
				pr_business_id
			) VALUES (
				'".$lDB->escape($dbcode)."',
				'".$lDB->escape($fn_ledger_code)."',
				'".$lDB->escape($fn_ledger_desc)."',
				'".$lDB->escape($pr_business_id)."'
			)
		");
		$ledgerId = $GLOBALS['lDB']->insert_id;

		return $ledgerId;
	} else {
		return false;
	}
}

function db_fn_ledger_update($fn_ledger_ix,$fn_ledger_code,$fn_ledger_desc,$pr_business_id) {
	global $lDB;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";
		$GLOBALS['lDB']->put("
			UPDATE fn_ledger SET 
				fn_ledger_code = '".$lDB->escape($fn_ledger_code)."',
				fn_ledger_desc = '".$lDB->escape($fn_ledger_desc)."' 
			WHERE
				fn_ledger.fn_ledger_ix = '$fn_ledger_ix' 
				AND fn_ledger.pr_business_id = '$pr_business_id'
		");
		$lDB->isMaster = $master;
		return true;
	} else {
		return false;
	}
}

function db_fn_ledger_delete($action, $fn_ledger_ix) {
	global $lDB;
	$result = false;

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_ledger WHERE fn_ledger_ix = '$fn_ledger_ix'",4);
	if(db_pr_business_ledger_allow($pr_business_id)) {	
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";
		if($action == "delete") {
			$lDB->put("DELETE FROM fn_ledger WHERE fn_ledger_ix = '$fn_ledger_ix'");
		}

		if($action == "inactive") {
			$lDB->put("
				UPDATE fn_ledger SET 
					fn_ledger_inactive_yn = '1' 
				WHERE
					fn_ledger.fn_ledger_ix = '$fn_ledger_ix'
			");
		}
		$lDB->isMaster = $master;
		return true;
	} else {
		return false;
	}
}

function db_fn_ledger_check_duplicate($fn_ledger_code, $fn_ledger_desc, $pr_business_id, $fn_ledger_ix = "" ) {
	if($fn_ledger_ix != "") {
		$editSQL = "AND fn_ledger.fn_ledger_ix != '$fn_ledger_ix'";
	} else {
		$editSQL = "";
	}

	$exists = $GLOBALS['lDB']->get("
		SELECT
			COUNT(fn_ledger.fn_ledger_ix)
		FROM
			fn_ledger
		WHERE
			fn_ledger.pr_business_id = '$pr_business_id'
			AND (
				fn_ledger.fn_ledger_code = '$fn_ledger_code'
				OR fn_ledger.fn_ledger_desc = '$fn_ledger_desc'
			)
			$editSQL
	",4);

	return $exists;

}
