<?php

require_once(__DIR__ . "/db.fn_db_business.php");
require_once(__DIR__ . "/db.fn_debtor.php");
require_once(__DIR__ . "/db.fn_invoice.php");
require_once(__DIR__ . "/db.fn_ledger.php");
require_once(__DIR__ . "/db.fn_option_data.php");
require_once(__DIR__ . "/db.fn_tran_item.php");
require_once(__DIR__ . "/db.fn_tran_stat.php");
require_once(__DIR__ . "/db.fn_year.php");
require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.pr_persona.php");
require_once(__DIR__ . "/db.pr_persona_inv.php");
require_once(__DIR__ . "/db.rv_payment.php");
require_once(__DIR__ . "/db.rv_payment_item.php");
require_once(__DIR__ . "/db.rf_bank.php");
require_once(__DIR__ . "/db.rt_component.php");
require_once(__DIR__ . "/db.rf_tax_inv.php");

define("DB_FN_TRAN_LINK_PAYMENT",10);
define("DB_FN_TRAN_LINK_DEPOSIT",20);
define("DB_FN_TRAN_LINK_REVERSAL",30);
define("DB_FN_TRAN_LINK_INVOICE",40);
define("DB_FN_TRAN_LINK_PO_RECEIPT",51);
define("DB_FN_TRAN_LINK_RETURN",52);
define("DB_FN_TRAN_LINK_COS",53); 
define("DB_FN_TRAN_LINK_ISSUE",54);
define("DB_FN_TRAN_LINK_TRANSFER",55);

function db_fn_tran_exists($fn_tran_id) {
	global $lDB;

	$tranCheck = $lDB->get("SELECT COUNT(fn_tran_ix) FROM fn_tran WHERE fn_tran_ix = '$fn_tran_id'",4);
	if($tranCheck > 0) { return true; } else { return false; }

}

function db_fn_tran_exists_by_link($fn_tran_link_ind,$fn_tran_link_id) {
	global $lDB;

	$tranCheck = $lDB->get("SELECT COUNT(fn_tran_ix) FROM fn_tran WHERE fn_tran_link_ind = '$fn_tran_link_ind' AND fn_tran_link_id = '$fn_tran_link_id'",4);
	if($tranCheck > 0) { return true; } else { return false; }

}

function db_fn_tran_link_desc($fn_tran_link_ind) {
	switch($fn_tran_link_ind) {
	case DB_FN_TRAN_LINK_INVOICE:
		return "Invoice";
	case DB_FN_TRAN_LINK_PAYMENT:
		return "Payment";
	case DB_FN_TRAN_LINK_DEPOSIT:
		return "Deposit";
	case DB_FN_TRAN_LINK_REVERSAL:
		return "Deposit reversal";
	case DB_FN_TRAN_LINK_PO_RECEIPT:
		return "Goods received";
	case DB_FN_TRAN_LINK_RETURN:
		return "Supplier return";
	case DB_FN_TRAN_LINK_COS:
		return "Cost of sales";
	case DB_FN_TRAN_LINK_ISSUE:
		return "Stock issue";
	case DB_FN_TRAN_LINK_TRANSFER:
		return "Transfer";
	default:
		return "Unknown";
	}
}

function db_fn_tran_insert($fn_tran_link_ind,$fn_tran_link_id,$fn_tran_exch_rate=false,$fn_tran_inv_yn=false,$fn_tran_contra_id=false,$fn_inv_date=false,$pr_user_id=false) {
	global $lDB;

	$createDate = date("Y-m-d H:i:s");
	$createDateTz = date("e");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}	

	if($fn_tran_link_ind == DB_FN_TRAN_LINK_INVOICE) {
		$linkInfo = $lDB->get("
			SELECT
				fn_invoice.rv_reservation_id,
				fn_invoice.fn_folio_id,
				fn_folio.pr_business_id,
				fn_invoice.fn_inv_date as fn_tran_date_ledger,
				pr_business.fn_ledger_id_debtors,
				fn_folio.rf_currency_id as invoice_currency_id,
				rf_currency.rf_currency_symbol,
				fn_folio.fn_folio_ix,
				fn_inv_exch_rate as fn_tran_exch_rate,
				fn_folio.fn_folio_to_id,
				fn_invoice.fn_inv_amt_payable
			FROM
				fn_invoice
				INNER JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
				INNER JOIN rf_currency ON rf_currency_ix = fn_folio.rf_currency_id
			WHERE
				fn_invoice.fn_invoice_ix = '$fn_tran_link_id'
		",1);		
		if($linkInfo['fn_inv_amt_payable'] < 0) {
			$fn_tran_detail = "CN";
		} else {
			$fn_tran_detail = "IN";
		}
		$fn_tran_detail .= ";$fn_tran_link_id";
		$fn_tran_detail_suffix = "";
	} else {
		$linkInfo = $lDB->get("
			SELECT
				rv_payment_item.rv_reservation_id,
				rv_payment_item.fn_folio_id,
				fn_folio.pr_business_id,
				rv_payment.rv_pmnt_date as fn_tran_date_ledger,
				pr_business.fn_ledger_id_debtors,
				rv_payment.rf_currency_id as payment_currency_id,
				payment_currency.rf_currency_symbol,
				fn_folio.fn_folio_ix,
				rv_payment_item.rv_pay_item_exch_rate,
				pr_business.pr_bus_home_curr_id,
				fn_folio.rf_currency_id as invoice_currency_id,
				folio_currency.rf_currency_symbol as invoice_currency_symbol,
				rf_bank.rf_bank_abbrev,
				rv_payment.rv_payment_ix,
				fn_folio.fn_folio_to_id,
				rv_payment_item.rv_pay_item_amt_rec,
				rv_payment.rv_pmnt_ref
			FROM
				rv_payment_item
				INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
				INNER JOIN rf_bank ON rf_bank.rf_bank_ix = rv_payment.rf_bank_id 
				INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
				INNER JOIN rf_currency AS payment_currency ON payment_currency.rf_currency_ix = rv_payment.rf_currency_id
				INNER JOIN rf_currency AS folio_currency ON folio_currency.rf_currency_ix = fn_folio.rf_currency_id
			WHERE
				rv_payment_item.rv_payment_item_ix = '$fn_tran_link_id'
		",1);
/*		$invCheck = $lDB->get("SELECT COUNT(*) FROM fn_invoice WHERE fn_folio_id = '$linkInfo[fn_folio_ix]' AND fn_invoice.fn_inv_status_ind <> 8",4);
		if($invCheck > 0) {
			$invExch = $lDB->get("SELECT fn_inv_exch_rate FROM fn_invoice WHERE fn_folio_id = '$linkInfo[fn_folio_ix]' AND fn_invoice.fn_inv_status_ind <> 8",4);
			$linkInfo['fn_tran_exch_rate'] = $linkInfo['rv_pay_item_exch_rate'] * $invExch;
		} else {*/
			if($linkInfo['payment_currency_id'] == $linkInfo['pr_bus_home_curr_id'] && $fn_tran_exch_rate === false) {
				$linkInfo['fn_tran_exch_rate'] = $linkInfo['rv_pay_item_exch_rate'];
			} elseif($fn_tran_exch_rate !== false) {
				$linkInfo['fn_tran_exch_rate'] = $fn_tran_exch_rate;
			} else {
				// No exchange rate found, this should never happen
				return false;
			}
//		}
		$rv_pmnt_ref_memo = "";
		switch($fn_tran_link_ind) {
		case DB_FN_TRAN_LINK_PAYMENT:
			if($linkInfo['rv_pay_item_amt_rec'] < 0) {
				$fn_tran_detail = "RF";
			} else {
				$fn_tran_detail = "PM";
			}
			$rv_pmnt_ref_memo = ";".$linkInfo['rv_pmnt_ref'];
			break;
		case DB_FN_TRAN_LINK_DEPOSIT:
			$fn_tran_detail = "DP";
			break;
		case DB_FN_TRAN_LINK_REVERSAL:
			$fn_tran_detail = "DR";
			$linkInfo['fn_tran_date_ledger'] = $lDB->get("
				SELECT
					fn_invoice.fn_inv_date
				FROM
					rv_payment_item
					INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
					INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
					INNER JOIN fn_invoice ON fn_invoice.fn_invoice_ix = fn_folio.fn_invoice_id 
						AND fn_invoice.fn_inv_status_ind = '".DB_FN_INVOICE_STATUS_LINKED."'
				WHERE
					rv_payment_item.rv_payment_item_ix = '$fn_tran_link_id'
			",4);
			break;
		}
		$fn_tran_detail .= ";$linkInfo[rv_payment_ix]".$rv_pmnt_ref_memo;
		$fn_tran_detail_suffix = ";$linkInfo[rf_bank_abbrev]";
	}

	$rv_reservation_id = $linkInfo['rv_reservation_id'];
	$fn_folio_id = $linkInfo['fn_folio_id'];
	$pr_business_id = $linkInfo['pr_business_id'];
	if($fn_inv_date === false) {
		$fn_tran_date_ledger = $linkInfo['fn_tran_date_ledger'];
	} else {
		$fn_tran_date_ledger = $fn_inv_date;
	}
	$fn_ledger_ctl_id = $linkInfo['fn_ledger_id_debtors'];
	$rf_currency_id = $linkInfo['invoice_currency_id'];
	$fn_tran_exch_rate = $linkInfo['fn_tran_exch_rate'];
	$pr_persona_id = $linkInfo['fn_folio_to_id'];
	if(!db_pr_persona_exists($pr_persona_id)) {
		$pr_persona_id = false;
	}

	$folioInfo = $lDB->get("
		SELECT
			pr_persona.pr_name_last,
			pr_persona.pr_name_first,
			rv_reservation.rv_reservation_ix,
			rv_reservation.rv_res_name
		FROM
			fn_folio
			INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
			LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = fn_folio.fn_folio_to_id
		WHERE
			fn_folio_ix = '$linkInfo[fn_folio_ix]'
	",1);
	$fn_name = trim($folioInfo['pr_name_first'] . " " . $folioInfo['pr_name_last']);
	if($fn_name == "") {
		$fn_name = "Cash";
	}
	$fn_tran_detail .= ";$folioInfo[rv_reservation_ix] ".addslashes($folioInfo['rv_res_name']).";".addslashes($fn_name).";".addslashes($linkInfo['rf_currency_symbol']).";$fn_tran_exch_rate".addslashes($fn_tran_detail_suffix);

	if($fn_tran_inv_yn) {
		$fn_tran_inv_yn = "1";
	} else {
		$fn_tran_inv_yn = "0";
	}

	$extra = array();
	if($fn_tran_contra_id !== false) {
		$extra['fn_tran_contra_id'] = $lDB->escape($fn_tran_contra_id);;
	}
	if($pr_persona_id !== false) {
		$extra['pr_persona_id'] = $lDB->escape($pr_persona_id);;
	}
	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}
	

	$lDB->put("
		INSERT INTO fn_tran (
			fn_tran_db,
			fn_tran_id,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			fn_tran_link_ind,
			fn_tran_link_id,
			fn_folio_id,
			rv_reservation_id,
			pr_business_id,
			fn_tran_date_ledger,
			fn_ledger_ctl_id,
			rf_currency_id,
			fn_tran_exch_rate,
			fn_tran_detail,
			fn_tran_inv_yn
			$extraFields
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($createDateTz)."',
			'".$lDB->escape($pr_user_id)."',
			'".$lDB->escape($fn_tran_link_ind)."',
			'".$lDB->escape($fn_tran_link_id)."',
			'".$lDB->escape($fn_folio_id)."',
			'".$lDB->escape($rv_reservation_id)."',
			'".$lDB->escape($pr_business_id)."',
			'".$lDB->escape($fn_tran_date_ledger)."',
			'".$lDB->escape($fn_ledger_ctl_id)."',
			'".$lDB->escape($rf_currency_id)."',
			'".$lDB->escape(db_round($fn_tran_exch_rate,6))."',
			'".$lDB->escape($fn_tran_detail)."',
			'".$lDB->escape($fn_tran_inv_yn)."'
			$extraValues
		)
	");

	$tranId = $lDB->insert_id;

	return $tranId;	
}

function db_fn_tran_update_total($fn_tran_id) {
	global $lDB;

	$master = $lDB->isMaster;
	$lDB->isMaster = "1";

	$amountTypes = join("','",array(DB_FN_TRAN_ITEM_TYPE_ACCOMM,DB_FN_TRAN_ITEM_TYPE_EXTRA,DB_FN_TRAN_ITEM_TYPE_DEPOSIT,DB_FN_TRAN_ITEM_TYPE_BANK));
	$amountExcl = $lDB->get("SELECT SUM(fn_tran_item_amt) FROM fn_tran_item WHERE fn_tran_id = '$fn_tran_id' AND fn_tran_item_type_ind IN ('$amountTypes')",4);
	$amountExclInv = $lDB->get("SELECT SUM(fn_tran_item_amt_source) FROM fn_tran_item WHERE fn_tran_id = '$fn_tran_id' AND fn_tran_item_type_ind IN ('$amountTypes')",4);
	$amountTax = $lDB->get("SELECT SUM(fn_tran_item_amt) FROM fn_tran_item WHERE fn_tran_id = '$fn_tran_id' AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_TAX."'",4);
	$amountTaxInv = $lDB->get("SELECT SUM(fn_tran_item_amt_source) FROM fn_tran_item WHERE fn_tran_id = '$fn_tran_id' AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_TAX."'",4);
	$amountIncl = $amountExcl + $amountTax;
	$amountInclInv = $amountExclInv + $amountTaxInv;


	$amountExcl = $amountExcl * -1;
	$amountExclInv = $amountExclInv * -1;
	$amountTax = $amountTax * -1;
	$amountTaxInv = $amountTaxInv * -1;
	$amountIncl = $amountIncl * -1;
	$amountInclInv = $amountInclInv * -1;

	$lDB->put("
		UPDATE fn_tran SET
			fn_tran_amt_excl = '".$lDB->escape(db_round(abs($amountExcl),6))."',
			fn_tran_amt_incl = '".$lDB->escape(db_round(abs($amountIncl),6))."',
			fn_tran_amt_source = '".$lDB->escape(db_round(abs($amountInclInv),6))."'
		WHERE
			fn_tran_ix = '$fn_tran_id'
	");

	// Delete any old debtor items...
	$debtorItemId = $lDB->get("SELECT fn_tran_item_ix FROM fn_tran_item WHERE fn_tran_id = '$fn_tran_id' AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEBTOR."'",4);
	if(db_fn_tran_item_exists($debtorItemId)) {
		db_fn_tran_item_delete_by_id($debtorItemId);
	}

	// ... and add one with the new totals
	$tranInfo = $lDB->get("
		SELECT
			fn_tran.pr_business_id,
			fn_tran.fn_tran_exch_rate,
			fn_tran.rf_currency_id,
			fn_folio.fn_folio_to_id,
			fn_db_business.fn_db_bus_debtor_ind,
			pr_business.fn_debtor_id_suspense,
			pr_business.fn_debtor_id_suspense_foreign,
			pr_business.pr_bus_home_curr_id
		FROM
			fn_tran
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = fn_tran.fn_folio_id
			INNER JOIN rf_database ON rf_database.rf_db_code = fn_tran.fn_tran_db
			LEFT JOIN fn_db_business ON fn_db_business.rf_database_id = rf_database.rf_database_id AND fn_db_business.pr_business_id = fn_tran.pr_business_id
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id			
		WHERE
			fn_tran_ix = '$fn_tran_id'
	",1);
	if(db_pr_persona_exists($tranInfo['fn_folio_to_id'])) {
		// First get from rf_currency_inv if possible
		$fn_ledger_id = $lDB->get("
			SELECT 
				fn_ledger_id_debtors 
			FROM 
				rf_currency_inv 
			WHERE 
				pr_business_id = '$tranInfo[pr_business_id]' 
				AND rf_currency_id = '$tranInfo[rf_currency_id]'
		",4);	

		if (!db_fn_ledger_exists($fn_ledger_id)){
			$fn_ledger_id = $lDB->get("SELECT fn_ledger_id_debtors FROM pr_business WHERE pr_business_id = '$tranInfo[pr_business_id]'",4);	
		}

		$fn_debtor_id = "";
		if(db_pr_persona_inv_exists($tranInfo['fn_folio_to_id'],$tranInfo['pr_business_id'])) {
			$fn_debtor_id = $lDB->get("
				SELECT fn_debtor_id FROM pr_persona_inv WHERE pr_persona_id = '$tranInfo[fn_folio_to_id]' AND pr_business_id = '$tranInfo[pr_business_id]'
			",4);
		}
		if(!db_fn_debtor_exists($fn_debtor_id)) {
				if($tranInfo['fn_db_bus_debtor_ind'] != DB_FN_DB_BUS_DEBTOR_CASH) {
					if($tranInfo['pr_bus_home_curr_id'] != $tranInfo['rf_currency_id'] && !empty($tranInfo['fn_debtor_id_suspense_foreign'])) {
						$fn_debtor_id = $tranInfo['fn_debtor_id_suspense_foreign'];
					} else {
						$fn_debtor_id = $tranInfo['fn_debtor_id_suspense'];
					}
				} else {
					$fn_ledger_id = $lDB->get("SELECT fn_ledger_id_cash FROM pr_business WHERE pr_business_id = '$tranInfo[pr_business_id]'",4);
					$fn_debtor_id = $lDB->get("SELECT fn_debtor_id_cash FROM pr_business WHERE pr_business_id = '$tranInfo[pr_business_id]'",4);
				}
		}
	} else {
		$fn_ledger_id = $lDB->get("SELECT fn_ledger_id_cash FROM pr_business WHERE pr_business_id = '$tranInfo[pr_business_id]'",4);
		$fn_debtor_id = $lDB->get("SELECT fn_debtor_id_cash FROM pr_business WHERE pr_business_id = '$tranInfo[pr_business_id]'",4);
	}

	$fn_debtor_code = $lDB->get("SELECT fn_debtor_code FROM fn_debtor WHERE fn_debtor_ix = '$fn_debtor_id'",4);
	db_fn_tran_item_insert($fn_tran_id,DB_FN_TRAN_ITEM_TYPE_DEBTOR,$fn_ledger_id,$fn_debtor_id,"",$amountIncl,$amountIncl,$amountInclInv,$amountInclInv,$fn_debtor_code);
	$lDB->isMaster = $master;
}

function db_fn_tran_delete_by_id($fn_tran_id) {
	global $lDB;

	$itemList = $lDB->get("SELECT fn_tran_item_ix FROM fn_tran_item WHERE fn_tran_id = '$fn_tran_id'",3);
	foreach($itemList as $item) {
		db_fn_tran_item_delete_by_id($item);
	}
	$lDB->put("DELETE FROM fn_tran WHERE fn_tran_ix = '$fn_tran_id'");
}

function db_fn_tran_delete_by_invoice_id($fn_invoice_id,$fn_invoice_id_reverse=false,$fn_inv_date=false) {
	global $lDB;

	$fn_folio_id = $lDB->get("SELECT fn_folio_id FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'",4);
	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix
		FROM
			fn_tran
			LEFT JOIN fn_batch ON fn_batch.fn_batch_ix = fn_tran.fn_batch_id
		WHERE
			fn_tran.fn_folio_id = '$fn_folio_id'
			AND fn_tran_inv_yn = '1'
	",2);
	foreach($list as $item) {
		db_fn_tran_void($item['fn_tran_ix'],$fn_invoice_id_reverse,$fn_inv_date);
		$lDB->put("UPDATE fn_tran SET fn_tran_inv_yn = '0' WHERE fn_tran.fn_tran_ix = '$item[fn_tran_ix]'");
	}
}

function db_fn_tran_void($fn_tran_id,$fn_tran_link_id=false,$fn_inv_date=false) {
	global $lDB;

	$tran = $lDB->get("
		SELECT
			fn_tran.fn_tran_link_ind,
			fn_tran.fn_tran_link_id,
			fn_tran.fn_tran_exch_rate,
			fn_tran.fn_tran_inv_yn
		FROM 
			fn_tran
		WHERE
			fn_tran.fn_tran_ix = '$fn_tran_id'
	",1);

	$fn_tran_inv_yn = false;
/*	if($tran['fn_tran_inv_yn'] == "1") {
		$fn_tran_inv_yn = true;
}*/

	if($fn_tran_link_id !== false && $tran['fn_tran_link_ind'] == DB_FN_TRAN_LINK_INVOICE) {
		$tran['fn_tran_link_id'] = $fn_tran_link_id;
//		$fn_tran_inv_yn = false;
	}

	$tranItemNoteExists = $lDB->get("SELECT fn_tran_item_note FROM fn_tran_item LIMIT 1", 4);
    if ($lDB->error) {
        // fn_tran_item_note field does not exist in the database yet (7.17 backport check)
        $tranItemNoteExists = false;
        $fn_tran_item_note_field = '';		
    } else {
        $tranItemNoteExists = true;
        $fn_tran_item_note_field = 'fn_tran_item.fn_tran_item_note,';
    }

	$fn_tran_contra_id = db_fn_tran_insert($tran['fn_tran_link_ind'],$tran['fn_tran_link_id'],$tran['fn_tran_exch_rate'],$fn_tran_inv_yn,$fn_tran_id,$fn_inv_date);
	$list = $lDB->get("
		SELECT
			fn_tran_item.fn_tran_item_type_ind,
			fn_tran_item.fn_ledger_id,
			fn_tran_item.fn_debtor_id,
			fn_tran_item.fn_tran_item_amt,
			fn_tran_item.fn_tran_item_amt_incl,
			fn_tran_item.fn_tran_item_amt_source,
			fn_tran_item.fn_tran_item_amt_source_incl,
			fn_tran_item.fn_tran_cost_ctr1_id,
			fn_tran_item.fn_tran_cost_ctr2_id,
			$fn_tran_item_note_field
			fn_tran_item.rf_tax_inv_id
		FROM
			fn_tran_item
		WHERE
			fn_tran_item.fn_tran_id = '$fn_tran_id'
	",2);
	foreach($list as $item) {
		$item['fn_tran_item_amt'] *= -1;
		$item['fn_tran_item_amt_source'] *= -1;
		$item['fn_tran_item_amt_incl'] *= -1;
		$item['fn_tran_item_amt_source_incl'] *= -1;
		$fn_tran_item_note = '';

        if ($tranItemNoteExists) {
            $fn_tran_item_note = $item['fn_tran_item_note'];
        }
		db_fn_tran_item_insert($fn_tran_contra_id,$item['fn_tran_item_type_ind'],$item['fn_ledger_id'],$item['fn_debtor_id'],$item['rf_tax_inv_id'],$item['fn_tran_item_amt'],$item['fn_tran_item_amt_incl'],$item['fn_tran_item_amt_source'],$item['fn_tran_item_amt_source_incl'],$fn_tran_item_note,$item['fn_tran_cost_ctr1_id'],$item['fn_tran_cost_ctr2_id']);
	}
	db_fn_tran_update_total($fn_tran_contra_id);

	$master = $lDB->isMaster;
	$lDB->isMaster = "1";
	$lDB->put("UPDATE fn_tran SET fn_tran_contra_id = '".$lDB->escape($fn_tran_contra_id)."' WHERE fn_tran_ix = '$fn_tran_id'");
	$lDB->isMaster = $master;
}

function db_fn_tran_reverse($fn_invoice_id,$fn_invoice_id_reverse) {
	global $lDB;

	$list = $lDB->get("
		SELECT
			fn_tran.fn_tran_ix
		FROM
			fn_tran
		WHERE
			fn_tran_link_id = '$fn_invoice_id'
			AND fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
	",2);
	foreach($list as $item) {
		db_fn_tran_void($item['fn_tran_ix'],$fn_invoice_id_reverse);
	}	
}

function db_fn_tran_set_batch($fn_tran_id,$fn_batch_id) {
	global $lDB;

	$master = $lDB->isMaster;
	$lDB->isMaster = "1";
	$lDB->put("
		UPDATE fn_tran SET
			fn_batch_id = '".$lDB->escape($fn_batch_id)."'
		WHERE
			fn_tran_ix = '$fn_tran_id'
	");
	$lDB->isMaster = $master;
}

function db_fn_tran_invoice($fn_invoice_id,$fn_tran_id=false) {
	global $lDB;

	if($fn_tran_id !== false) {
		if(!db_fn_tran_exists($fn_tran_id)) {
			return false;
		}

		$fn_invoice_id = $lDB->get("
			SELECT fn_tran_link_id FROM fn_tran
			WHERE
				fn_tran_ix = '$fn_tran_id'
				AND fn_tran_link_ind = '".DB_FN_TRAN_LINK_INVOICE."'
		",4);
		if(!db_fn_invoice_exists($fn_invoice_id)) {
			return false;
		}
	}

	$invoiceInfo = $lDB->get("
		SELECT
			pr_business.pr_business_id,
			pr_business.pr_bus_post_inv_yn,
			pr_business.pr_bus_post_pmt_yn,
			pr_business.pr_bus_post_dep_yn,
			pr_business.pr_bus_post_clear_dtrs_yn,
			pr_business.pr_bus_ignore_past_pmt_yn,
			pr_business.pr_bus_post_tax_cost_ctr_yn,
			rt_component_inv.rt_component_inv_meal_code,
			fn_system.fn_system_name
		FROM
			fn_invoice
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
			LEFT JOIN rt_component_inv ON
				rt_component_inv.pr_business_id = pr_business.pr_business_id
				AND rt_component_inv.rt_component_id = pr_business.fn_meal_component_default_id
			INNER JOIN fn_system ON fn_system.fn_system_ix = pr_business.fn_system_id
		WHERE
			fn_invoice.fn_invoice_ix = '$fn_invoice_id'
	",1);	
	$statsEnabled = false;
	if($invoiceInfo['fn_system_name'] == "netsuite") {
		// Hard coded initially, if other interfaces need stats this should 
		// be turned into a field on fn_system or an entry in fn_option
		$statsEnabled = true;
	}
	$fn_folio_id = $lDB->get("SELECT fn_folio_id FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'",4);
	$fn_inv_exch_rate = $lDB->get("SELECT fn_inv_exch_rate FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id' AND fn_invoice.fn_inv_status_ind <> 8",4);
		

	if($invoiceInfo['pr_bus_post_inv_yn'] == "1") {
		if($fn_tran_id === false) {
			$fn_tran_id = db_fn_tran_insert(DB_FN_TRAN_LINK_INVOICE,$fn_invoice_id,false,true);
			$new = true;
		} else {
			// remove transaction items
			$tranItems = $lDB->get("SELECT fn_tran_item.fn_tran_item_ix FROM fn_tran_item WHERE fn_tran_item.fn_tran_id = '$fn_tran_id'",3);
			foreach($tranItems as $fn_tran_item_id) {
				$lDB->put("DELETE FROM fn_tran_item WHERE fn_tran_item.fn_tran_item_ix = '$fn_tran_item_id'");
			}

			// remove stats
			$statItems = $lDB->get("SELECT fn_tran_stat.fn_tran_stat_ix FROM fn_tran_stat WHERE fn_tran_stat.fn_tran_id = '$fn_tran_id'",3);
			foreach($statItems as $fn_tran_stat_id) {
				$lDB->put("DELETE FROM fn_tran_stat WHERE fn_tran_stat.fn_tran_stat_ix = '$fn_tran_stat_id'");
			}
			$new = false;
		}

		$taxPrecision = db_fn_option_data_by_name($invoiceInfo['pr_business_id'], "tax_precision");
		if($taxPrecision === false || !is_numeric($taxPrecision)) {
			$taxPrecision = 6;
		}

		$accommList = $lDB->get("
			SELECT
				rv_res_item_comp.rv_res_item_comp_ix,
				rv_res_item_comp.rv_item_comp_amt_payable,
				rv_res_item_comp.rv_item_comp_amt_tax,
				pr_business.fn_cost_centre_1_id as fn_cost_centre_1_id,
				ac_accomm_type.fn_cost_centre_id as fn_cost_centre_2_id_accomm,
				rt_component_inv.fn_cost_centre_2_id AS fn_cost_centre_2_id_component,
				rt_component_inv.fn_ledger_id,
				rt_component.rt_component_desc,
				rv_reservation_item.rv_reservation_item_ix,
				rv_reservation_item.rv_item_nights,
				rv_reservation_item.rv_item_accomm_count,
				(rv_reservation_item.rv_item_adult_count+rv_reservation_item.rv_item_child_count) AS rv_item_pax_count,
				rf_tax_inv.rf_tax_inv_ix,
				rf_tax_inv.fn_ledger_id as tax_ledger_id
			FROM
				rv_res_item_comp
				INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
				INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
				INNER JOIN pr_business ON pr_business.pr_business_id = rv_reservation_item.pr_business_id
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
				LEFT JOIN rt_component_inv ON rt_component_inv.rt_component_id = rv_res_item_comp.rt_component_id AND rt_component_inv.pr_business_id = fn_folio.pr_business_id
				LEFT JOIN rf_tax_inv ON 
					rf_tax_inv.rf_tax_id = rv_res_item_comp.rt_tax_id
					AND rf_tax_inv.rf_tax_ind = rv_res_item_comp.rt_tax_ind
					AND rf_tax_inv.pr_business_id = fn_folio.pr_business_id
			WHERE
				rv_reservation_item.fn_folio_id = '$fn_folio_id'
		",6);

		$extraList = $lDB->get("
			SELECT DISTINCT
				rv_extra.rv_extra_amt_payable,
				rv_extra.rv_extra_tax_ind,
				rv_extra.rv_extra_ix AS extra_id,
				(
					SELECT SUM(rv_extra_tax_amt)
					FROM rv_extra_tax
					WHERE rv_extra_tax.rv_extra_id = extra_id
				) as rv_extra_amt_tax,
				rv_extra.pr_business_id AS property_business_id,
				fn_folio.pr_business_id AS folio_business_id,
				pr_business.fn_cost_centre_1_id as property_cost_centre_1_id,
				pr_billing.fn_cost_centre_1_default_id,
				ac_extra_inv.fn_cost_centre_1_id AS extra_cost_centre_1_id,
				ac_extra_cat_inv.fn_cost_centre_1_id AS extra_cat_cost_centre_1_id,
				ac_extra_inv.fn_cost_centre_2_id as extra_cost_centre_2_id,
				ac_extra_cat_inv.fn_cost_centre_2_id AS extra_cat_cost_centre_2_id,
				rf_tax_inv.rf_tax_inv_ix,
				rf_tax_inv.fn_ledger_id as tax_ledger_id,
				ac_extra_inv.fn_ledger_id,
				ac_extra_cat_inv.fn_ledger_id AS extra_cat_ledger_id,
				ac_extra.ac_ext_desc,
				rv_extra.rv_reservation_id
			FROM
				rv_extra
				LEFT JOIN rv_extra_tax ON rv_extra_tax.rv_extra_id = rv_extra.rv_extra_ix
				INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
				INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
				LEFT JOIN ac_extra_inv ON ac_extra_inv.ac_extra_id = rv_extra.ac_extra_id AND ac_extra_inv.pr_business_id = fn_folio.pr_business_id
				LEFT JOIN ac_extra_cat_inv ON ac_extra_cat_inv.ac_extra_category_id = ac_extra.ac_extra_category_id AND ac_extra_cat_inv.pr_business_id = fn_folio.pr_business_id
				LEFT JOIN rf_tax_inv ON 
					rf_tax_inv.rf_tax_id = rv_extra.rf_tax_id
					AND rf_tax_inv.rf_tax_ind = rv_extra.rv_extra_tax_ind
					AND rf_tax_inv.pr_business_id = fn_folio.pr_business_id
				LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id
				LEFT JOIN pr_business AS pr_billing ON pr_billing.pr_business_id = fn_folio.pr_business_id
			WHERE
				rv_extra.fn_folio_id = '$fn_folio_id'
		",6);

		$accommTotal = array();
		$accommStats = [];
		$taxTotal = array();
		$extraTotal = array();	
		foreach($accommList as $item) {
			$meal_plans = $lDB->get("
				SELECT
					rt_component_inv.rt_component_inv_ix
				FROM
					rv_res_item_comp
					INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
					LEFT JOIN rt_component_inv ON
						rt_component_inv.pr_business_id = '" . $lDB->escape($invoiceInfo['pr_business_id']) . "'
						AND rt_component_inv.rt_component_id = rt_component.rt_component_ix
				WHERE
					rv_res_item_comp.rv_reservation_item_id = '" . $lDB->escape($item['rv_reservation_item_ix']) . "'
					AND rt_component.rt_component_type_ind = '" . DB_RT_COMPONENT_TYPE_MEAL_PLAN . "'
			",3);
			if(sizeof($meal_plans) == 0) { // Use the default if no meal plan exists
				$meal_plan_id = $invoiceInfo['rt_component_inv_meal_code'];
			} elseif(sizeof($meal_plans) == 1) { // Use the meal plan if only one is found
				$meal_plan_id = $meal_plans[0];
			} else { // otherwise use an empty meal plan
				$meal_plan_id = "";
			}
			if(empty($meal_plan_id)) {
				$meal_plan_id = "";
			}
			$item['fn_cost_centre_2_id'] = $item['fn_cost_centre_2_id_accomm'];
			if(!empty($item['fn_cost_centre_2_id_component'])) {
				$item['fn_cost_centre_2_id'] = $item['fn_cost_centre_2_id_component'];
			}

			// Total
			$cc1 = trim($item['fn_cost_centre_1_id']);
			if($cc1 == "") { $cc1 = "AAAAA"; }
			$cc2 = trim($item['fn_cost_centre_2_id']);
			if($cc2 == "") { $cc2 = "BBBBB"; }
			$mp = trim($meal_plan_id);
			if($mp == "") { $mp = "CCCCC"; }
			$gl = trim($item['fn_ledger_id']);
			if($gl == "") { $gl = "DDDDD"; }
			$tax = trim($item['rf_tax_inv_ix']);
			if($tax == "") { $tax = "EEEEE"; }
			$totalKey = $cc1.$cc2.$mp.$gl.$tax;

			if($statsEnabled && !array_key_exists($item['rv_reservation_item_ix'], $accommStats)) {
				$accommStats[$item['rv_reservation_item_ix']] = [
					'fn_cost_centre_id'=>$item['fn_cost_centre_1_id'],
					'rt_component_inv_id'=>$meal_plan_id,
					'fn_tran_stat_nights'=>$item['rv_item_nights'],
					'fn_tran_stat_pax'=>$item['rv_item_pax_count'],
					'fn_tran_stat_bed_nights'=>$item['rv_item_nights'] * $item['rv_item_accomm_count'] * $item['rv_item_pax_count'],
					'fn_tran_stat_room_nights'=>$item['rv_item_nights'] * $item['rv_item_accomm_count']
				];
			}
			
			if(!array_key_exists($totalKey,$accommTotal)) {
				$accommTotal[$totalKey] = array(
					'fn_tran_item_amt'=>($item['rv_item_comp_amt_payable'] - $item['rv_item_comp_amt_tax']) * $fn_inv_exch_rate * -1,
					'fn_tran_item_amt_incl'=>$item['rv_item_comp_amt_payable'] * $fn_inv_exch_rate * -1,
					'fn_tran_item_amt_source'=>($item['rv_item_comp_amt_payable'] - $item['rv_item_comp_amt_tax']) * -1,
					'fn_tran_item_amt_source_incl'=>$item['rv_item_comp_amt_payable'] * -1,
					'fn_ledger_id'=>$item['fn_ledger_id'],
					'fn_tran_cost_ctr1_id'=>$item['fn_cost_centre_1_id'],
					'fn_tran_cost_ctr2_id'=>$item['fn_cost_centre_2_id'],
					'rt_component_inv_id'=>$meal_plan_id,
					'rf_tax_inv_id'=>$item['rf_tax_inv_ix'],
					'rt_component_desc' => $item['rt_component_desc']
				);
			} else {
				$accommTotal[$totalKey]['fn_tran_item_amt'] += ($item['rv_item_comp_amt_payable'] - $item['rv_item_comp_amt_tax']) * $fn_inv_exch_rate * -1;
				$accommTotal[$totalKey]['fn_tran_item_amt_incl'] += $item['rv_item_comp_amt_payable'] * $fn_inv_exch_rate * -1;
				$accommTotal[$totalKey]['fn_tran_item_amt_source'] += ($item['rv_item_comp_amt_payable'] - $item['rv_item_comp_amt_tax']) * -1;
				$accommTotal[$totalKey]['fn_tran_item_amt_source_incl'] += $item['rv_item_comp_amt_payable'] * -1;
			}

			// Tax
			$accommTaxList = $lDB->get("
				SELECT
					rv_res_item_comp_tax.rv_res_item_comp_tax_amt,
					rf_tax_inv.rf_tax_inv_ix,
					rf_tax_inv.fn_ledger_id
				FROM
					rv_res_item_comp_tax
					INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_tax.rv_res_item_comp_id
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
					INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
					LEFT JOIN rf_tax_inv ON 
						rf_tax_inv.rf_tax_id = rv_res_item_comp_tax.rf_tax_rate_id
						AND rf_tax_inv.rf_tax_ind = 10
						AND rf_tax_inv.pr_business_id = fn_folio.pr_business_id
				WHERE
					rv_res_item_comp_tax.rv_res_item_comp_id = '$item[rv_res_item_comp_ix]'
			",2);

			$accommTotal[$totalKey]['accommTaxList'] = $accommTaxList;

			foreach($accommTaxList as $taxItem) {
				if($invoiceInfo['pr_bus_post_tax_cost_ctr_yn'] == "1") {
					$taxKey = $cc1.$cc2.$mp.$taxItem['fn_ledger_id'];
					$taxCC1 = $item['fn_cost_centre_1_id'];
					$taxCC2 = $item['fn_cost_centre_2_id'];
				} else {
					$taxKey = $mp.$taxItem['fn_ledger_id'];
					$taxCC1 = "";
					$taxCC2 = "";
				}
				$taxItem['rv_res_item_comp_tax_amt'] = round($taxItem['rv_res_item_comp_tax_amt'],$taxPrecision);
				if(!array_key_exists($taxKey,$taxTotal)) {
					$taxTotal[$taxKey] = array(
						'fn_tran_item_amt'=>$taxItem['rv_res_item_comp_tax_amt'] * $fn_inv_exch_rate * -1,
						'fn_tran_item_amt_source'=>$taxItem['rv_res_item_comp_tax_amt'] * -1,
						'fn_ledger_id'=>$taxItem['fn_ledger_id'],
						'fn_tran_cost_ctr1_id'=>$taxCC1,
						'fn_tran_cost_ctr2_id'=>$taxCC2,
						'rt_component_inv_id'=>$meal_plan_id,
						'rf_tax_inv_id'=>$taxItem['rf_tax_inv_ix']
					);
				} else {
					$taxTotal[$taxKey]['fn_tran_item_amt'] += $taxItem['rv_res_item_comp_tax_amt'] * $fn_inv_exch_rate * -1;
					$taxTotal[$taxKey]['fn_tran_item_amt_source'] += $taxItem['rv_res_item_comp_tax_amt'] * -1;
				}
			}
		}

		foreach($extraList as $item) {
			$rv_reservation_item_id = "";
			if(db_pr_business_exists($item['property_business_id'])) { // property specific
				// Look for an itinerary using this property
				$rv_reservation_item_id = $lDB->get("
					SELECT
						rv_reservation_item.rv_reservation_item_ix
					FROM
						rv_reservation_item
					WHERE
						rv_reservation_item.rv_reservation_id = '" . $lDB->escape($item['rv_reservation_id']) . "'
						AND rv_reservation_item.pr_business_id = '" . $lDB->escape($item['property_business_id']) . "'
					ORDER BY
						rv_reservation_item.rv_item_date_arrive
					LIMIT 1
				",4);
			} else { // non-property-specific
				$rv_reservation_item_id = $lDB->get("
					SELECT
						rv_reservation_item.rv_reservation_item_ix
					FROM
						rv_reservation_item
						INNER JOIN fn_folio ON rv_reservation_item.fn_folio_id = fn_folio.fn_folio_ix
					WHERE
						rv_reservation_item.rv_reservation_id = '" . $lDB->escape($item['rv_reservation_id']) . "'
						AND fn_folio.pr_business_id = '" . $lDB->escape($item['folio_business_id']) . "'
					ORDER BY
						rv_reservation_item.rv_item_date_arrive
					LIMIT 1
				",4);
			}
			if(!empty($rv_reservation_item_id)) {
				$meal_plans = $lDB->get("
					SELECT
						rt_component_inv.rt_component_inv_ix
					FROM
						rv_res_item_comp
						INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
						LEFT JOIN rt_component_inv ON
							rt_component_inv.pr_business_id = '" . $lDB->escape($invoiceInfo['pr_business_id']) . "'
							AND rt_component_inv.rt_component_id = rt_component.rt_component_ix
					WHERE
						rv_res_item_comp.rv_reservation_item_id = '" . $rv_reservation_item_id . "'
						AND rt_component.rt_component_type_ind = '" . DB_RT_COMPONENT_TYPE_MEAL_PLAN . "'
				",3);
				if(sizeof($meal_plans) == 0) { // Use the default if no meal plan exists
					$meal_plan_id = $invoiceInfo['rt_component_inv_meal_code'];
				} elseif(sizeof($meal_plans) == 1) { // Use the meal plan if only one is found
					$meal_plan_id = $meal_plans[0];
				} else { // otherwise use an empty meal plan
					$meal_plan_id = "";
				}
				if(empty($meal_plan_id)) {
					$meal_plan_id = "";
				}
			} else {
				$meal_plan_id = $invoiceInfo['rt_component_inv_meal_code'];
			}

			// Extra
			if($item['extra_cost_centre_1_id'] != "0" && trim($item['extra_cost_centre_1_id']) != "") {
				$cc1 = $item['extra_cost_centre_1_id'];
			} else {
				if($item['extra_cat_cost_centre_1_id'] != "0" && trim($item['extra_cat_cost_centre_1_id']) != "") {
					$cc1 = $item['extra_cat_cost_centre_1_id'];
				} else {
					if($item['property_cost_centre_1_id'] != "0" && trim($item['property_cost_centre_1_id']) != "") {
						$cc1 = $item['property_cost_centre_1_id'];
					} else {
						$cc1 = $item['fn_cost_centre_1_default_id'];
					}
				}
			}
			$item['fn_cost_centre_1_id'] = $cc1;
			if(trim($item['extra_cost_centre_2_id']) == "") {
				$item['fn_cost_centre_2_id'] = $item['extra_cat_cost_centre_2_id'];
			} else {
				$item['fn_cost_centre_2_id'] = $item['extra_cost_centre_2_id'];
			}
			$cc1 = trim($cc1);
			if($cc1 == "") { $cc1 = "AAAAA"; }
			$cc2 = trim($item['fn_cost_centre_2_id']);
			if($cc2 == "") { $cc2 = "BBBBB"; }
			$mp = trim($meal_plan_id);
			if($mp == "") { $mp = "CCCCC"; }

			if(trim($item['fn_ledger_id']) == "") {
				$item['fn_ledger_id'] = $item['extra_cat_ledger_id'];
			}
			$gl = trim($item['fn_ledger_id']);
			if($gl == "") { $gl = "DDDDD"; }

			$tax = trim($item['rf_tax_inv_ix']);
			if($tax == "") { $tax = "EEEEE"; }

			$totalKey = $cc1.$cc2.$mp.$gl.$tax;

			if(!array_key_exists($totalKey,$extraTotal)) {
				$extraTotal[$totalKey] = array(
					'fn_tran_item_amt'=>($item['rv_extra_amt_payable'] - $item['rv_extra_amt_tax']) * $fn_inv_exch_rate * -1,
					'fn_tran_item_amt_incl'=>$item['rv_extra_amt_payable'] * $fn_inv_exch_rate * -1,
					'fn_tran_item_amt_source'=>($item['rv_extra_amt_payable'] - $item['rv_extra_amt_tax']) * -1,
					'fn_tran_item_amt_source_incl'=>$item['rv_extra_amt_payable'] * -1,
					'fn_ledger_id'=>$item['fn_ledger_id'],
					'fn_tran_cost_ctr1_id'=>$item['fn_cost_centre_1_id'],
					'fn_tran_cost_ctr2_id'=>$item['fn_cost_centre_2_id'],
					'rt_component_inv_id'=>$meal_plan_id,
					'rf_tax_inv_id'=>$item['rf_tax_inv_ix'],
					'ac_ext_desc' => $item['ac_ext_desc']
				);
			} else {
				$extraTotal[$totalKey]['fn_tran_item_amt'] += ($item['rv_extra_amt_payable'] - $item['rv_extra_amt_tax']) * $fn_inv_exch_rate * -1;
				$extraTotal[$totalKey]['fn_tran_item_amt_incl'] += $item['rv_extra_amt_payable'] * $fn_inv_exch_rate * -1;
				$extraTotal[$totalKey]['fn_tran_item_amt_source'] += ($item['rv_extra_amt_payable'] - $item['rv_extra_amt_tax']) * -1;
				$extraTotal[$totalKey]['fn_tran_item_amt_source_incl'] += ($item['rv_extra_amt_payable']) * -1;
			}

			// Tax
			$taxRates = $lDB->get("
				SELECT DISTINCT
					rv_extra_tax.rv_extra_tax_ix,
					rv_extra_tax.rf_tax_rate_id,
					rv_extra_tax.rv_extra_tax_perc,
					rv_extra_tax.rv_extra_tax_amt,
					rf_tax_rate.rf_tax_rate_desc,
					rf_tax_inv.fn_ledger_id AS tax_ledger_id
				FROM
					rv_extra
					INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
					LEFT JOIN rv_extra_tax on rv_extra_tax.rv_extra_id = rv_extra.rv_extra_ix
					LEFT JOIN rf_tax_rate on rf_tax_rate.rf_tax_rate_ix = rv_extra_tax.rf_tax_rate_id
					LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_id = rv_extra_tax.rf_tax_rate_id
						AND rf_tax_inv.pr_business_id = fn_folio.pr_business_id
				WHERE
					rv_extra.rv_extra_ix = '".$item['extra_id']."'
			",2);

			foreach ($taxRates as $taxRate) {
				if($invoiceInfo['pr_bus_post_tax_cost_ctr_yn'] == "1") {
					$taxKey = $cc1.$cc2.$mp.$taxRate['tax_ledger_id'];
					$taxCC1 = $item['fn_cost_centre_1_id'];
					$taxCC2 = $item['fn_cost_centre_2_id'];
				} else {
					$taxKey = $mp.$taxRate['tax_ledger_id'];
					$taxCC1 = "";
					$taxCC2 = "";
				}
				$tax_amt = $taxRate['rv_extra_tax_amt'];

				if(!array_key_exists($taxKey,$taxTotal)) {
					$taxTotal[$taxKey] = array(
						'fn_tran_item_amt'=>$tax_amt * $fn_inv_exch_rate * -1,
						'fn_tran_item_amt_source'=>$tax_amt * -1,
						'fn_ledger_id'=>$taxRate['tax_ledger_id'],
						'fn_tran_cost_ctr1_id'=>$taxCC1,
						'fn_tran_cost_ctr2_id'=>$taxCC2,
						'rt_component_inv_id'=>$meal_plan_id,
						'rf_tax_inv_id'=>$item['rf_tax_inv_ix']				
					);
				} else {
					$taxTotal[$taxKey]['fn_tran_item_amt'] += $tax_amt * $fn_inv_exch_rate * -1;
					$taxTotal[$taxKey]['fn_tran_item_amt_source'] += $tax_amt * -1;
				}
			}
		}

		// Insert tax items
		foreach($taxTotal as $item) {
			if($item['fn_tran_item_amt'] != 0) {
				db_fn_tran_item_insert($fn_tran_id,DB_FN_TRAN_ITEM_TYPE_TAX,$item['fn_ledger_id'],"",$item['rf_tax_inv_id'],$item['fn_tran_item_amt'],$item['fn_tran_item_amt'],$item['fn_tran_item_amt_source'],$item['fn_tran_item_amt_source'],'',$item['fn_tran_cost_ctr1_id'],$item['fn_tran_cost_ctr2_id'],$item['rt_component_inv_id']);
			}
		}

		// Insert accomm items
		foreach($accommTotal as $item) {
			if($item['fn_tran_item_amt'] != 0) {
				db_fn_tran_item_insert($fn_tran_id,DB_FN_TRAN_ITEM_TYPE_ACCOMM,$item['fn_ledger_id'],"",$item['rf_tax_inv_id'],$item['fn_tran_item_amt'],$item['fn_tran_item_amt_incl'],$item['fn_tran_item_amt_source'],$item['fn_tran_item_amt_source_incl'],$item['rt_component_desc'],$item['fn_tran_cost_ctr1_id'],$item['fn_tran_cost_ctr2_id'],$item['rt_component_inv_id']);
			}
		}

		// Insert extra items
		foreach($extraTotal as $item) {
			if($item['fn_tran_item_amt'] != 0) {
				db_fn_tran_item_insert($fn_tran_id,DB_FN_TRAN_ITEM_TYPE_EXTRA,$item['fn_ledger_id'],"",$item['rf_tax_inv_id'],$item['fn_tran_item_amt'],$item['fn_tran_item_amt_incl'],$item['fn_tran_item_amt_source'],$item['fn_tran_item_amt_source_incl'],$item['ac_ext_desc'],$item['fn_tran_cost_ctr1_id'],$item['fn_tran_cost_ctr2_id'],$item['rt_component_inv_id']);
			}
		}

		db_fn_tran_update_total($fn_tran_id);

		if($statsEnabled) {
			$stats = [];
			foreach($accommStats as $rv_reservation_item_id=>$accommStat) {
				$key = $accommStat['fn_cost_centre_id'] . "_" . $accommStat['rt_component_inv_id'];
				if(!array_key_exists($key, $stats)) {
					$stats[$key] = [
						'fn_cost_centre_id'=>$accommStat['fn_cost_centre_id'],
						'rt_component_inv_id'=>$accommStat['rt_component_inv_id'],
						'fn_tran_stat_nights'=>0,
						'fn_tran_stat_pax'=>0,
						'fn_tran_stat_bed_nights'=>0,
						'fn_tran_stat_room_nights'=>0
					];
				}
				$stats[$key]['fn_tran_stat_nights'] += $accommStat['fn_tran_stat_nights'];
				$stats[$key]['fn_tran_stat_pax'] += $accommStat['fn_tran_stat_pax'];
				$stats[$key]['fn_tran_stat_bed_nights'] += $accommStat['fn_tran_stat_bed_nights'];
				$stats[$key]['fn_tran_stat_room_nights'] += $accommStat['fn_tran_stat_room_nights'];
			}

			foreach($stats as $stat) {
				db_fn_tran_stat_insert($fn_tran_id, $stat['fn_cost_centre_id'], $stat['rt_component_inv_id'], $stat['fn_tran_stat_nights'], $stat['fn_tran_stat_pax'], $stat['fn_tran_stat_bed_nights'], $stat['fn_tran_stat_room_nights']);
			}
		}
	}

	// When recreating transaction items for an invoice, don't handle deposts or payments
	if(!$new) {
		return;
	}

	if($invoiceInfo['pr_bus_post_dep_yn'] == "1") {
		// Deposit reversals
		$depositList = $lDB->get("
			SELECT
				fn_tran.fn_tran_ix
			FROM
				fn_tran
			WHERE
				fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_DEPOSIT."'
				AND fn_tran.fn_folio_id = '$fn_folio_id'
		",3);
		foreach($depositList as $depositId) {
			$depositInfo = $lDB->get("
				SELECT
					fn_tran_item.fn_ledger_id,
					fn_tran_item.fn_tran_item_amt,
					fn_tran_item.fn_tran_item_amt_source,
					fn_tran.fn_tran_link_id,
					fn_tran.fn_tran_exch_rate
				FROM
					fn_tran_item
					INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
				WHERE
					fn_tran_item.fn_tran_id = '$depositId'
					AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEPOSIT."'
			",1);
			$fn_tran_id = db_fn_tran_insert(DB_FN_TRAN_LINK_REVERSAL,$depositInfo['fn_tran_link_id'],$depositInfo['fn_tran_exch_rate'],true);

			$fn_tran_item_amt_source = $depositInfo['fn_tran_item_amt_source'] * -1;
			$fn_tran_item_amt = $depositInfo['fn_tran_item_amt'] * -1;
			db_fn_tran_item_insert($fn_tran_id,DB_FN_TRAN_ITEM_TYPE_DEPOSIT,$depositInfo['fn_ledger_id'],"","",$fn_tran_item_amt,$fn_tran_item_amt,$fn_tran_item_amt_source,$fn_tran_item_amt_source);
			db_fn_tran_update_total($fn_tran_id);	
		}
	}

	if($invoiceInfo['pr_bus_post_clear_dtrs_yn'] == "1") {
		// Check if the outstanding amount is to be cleared
		$folioInfo = $lDB->get("
			SELECT
				fn_folio.fn_folio_amount,
				fn_folio.fn_folio_amt_paid,
				fn_folio.rf_currency_id,
				pr_business.pr_business_id,
				pr_business.pr_bus_post_clear_dtrs_yn
			FROM
				fn_folio
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
			WHERE
				fn_folio.fn_folio_ix = '$fn_folio_id'
		",1);
		$folioOutstanding = $folioInfo['fn_folio_amount'] - $folioInfo['fn_folio_amt_paid'];

		$rf_mthd_pmnt_id = $lDB->get("SELECT rf_mthd_pmnt_ix FROM rf_mthd_pmnt WHERE rf_mthd_pmnt_sys_code = '2'",4);
		
		if($folioInfo['pr_bus_post_clear_dtrs_yn'] == "1" && $folioOutstanding != 0) {
			$systemUserId = $lDB->get("SELECT pr_persona_ix FROM pr_persona WHERE pr_sys_code = '9'",4);
			$rf_bank_id = db_rf_bank_debt($folioInfo['rf_currency_id'], $folioInfo['pr_business_id']);
			$rv_payment_id = db_rv_payment_insert($systemUserId,date("Y-m-d"),$rf_bank_id,$rf_mthd_pmnt_id,"Invoice: $fn_invoice_id");
			$rv_payment_item_id = db_rv_payment_item_insert($rv_payment_id,$fn_folio_id,$folioOutstanding,1);		
		}
	}

	if($invoiceInfo['pr_bus_post_pmt_yn'] == "1") {
		$ignorePastSQL = "";
		$today = date("Y-m-d");
		if($invoiceInfo['pr_bus_ignore_past_pmt_yn'] == "1") {
			list($firstYearClosed,$firstYearEnd) = $lDB->get("
				SELECT
					fn_year.fn_year_status_ind,
					fn_year.fn_year_end_date
				FROM
					fn_year
				WHERE
					fn_year.pr_business_id = '$invoiceInfo[pr_business_id]'
				ORDER BY
					fn_year.fn_year_end_date
			",1);
			if($firstYearClosed == DB_FN_YEAR_STATUS_CLOSED) {
				$ignorePastSQL = "
					AND rv_payment.rv_pmnt_date > '$firstYearEnd'
				";
			}
		}
		// Find payment items without transactions
		$payments = $lDB->get("
			SELECT DISTINCT
				rv_payment_item.rv_payment_item_ix,
				rv_payment_item.rv_pay_item_exch_rate
			FROM
				rv_payment_item
				LEFT JOIN fn_tran ON 
					fn_tran.fn_tran_link_id = rv_payment_item.rv_payment_item_ix 
					AND (
						fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_PAYMENT."'
						OR fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_DEPOSIT."'
					)
				LEFT JOIN fn_tran AS fn_tran_contra ON fn_tran.fn_tran_contra_id = fn_tran_contra.fn_tran_ix
				INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
				INNER JOIN rf_mthd_pmnt ON rf_mthd_pmnt.rf_mthd_pmnt_ix = rv_payment.rf_mthd_pmnt_id
			WHERE
				rv_payment_item.fn_folio_id = '$fn_folio_id'
				AND (
					fn_tran.fn_tran_ix IS NULL
					OR (
						fn_tran.fn_tran_ix IS NOT NULL
						AND fn_tran_contra.fn_tran_ix IS NOT NULL
					)
				)
				AND rf_mthd_pmnt.rf_mthd_pmnt_sys_code NOT IN (2)
				$ignorePastSQL
		",2);
		foreach($payments as $payment) {
			db_fn_tran_payment($payment['rv_payment_item_ix'],$payment['rv_pay_item_exch_rate']*$fn_inv_exch_rate,true);
		}
	}
}

function db_fn_tran_active($fn_system_id) {
	if(trim($fn_system_id) != "" && $fn_system_id != "0" && $fn_system_id != "RS1") {
		return true;
	}
	return false;
}

function db_fn_tran_payment_active($fn_system_id,$pr_bus_post_pmt_yn) {
	if(db_fn_tran_active($fn_system_id) && $pr_bus_post_pmt_yn == "1") {	
		return true;
	}
	return false;
}

function db_fn_tran_payment_lookup($rv_payment_item_id) {
	global $lDB;

	return $lDB->get("
		SELECT
			rv_payment_item.rv_pay_item_amt_rec,
			rv_payment_item.rv_payment_item_amt,
			rv_payment.rv_payment_ix,
			rv_payment.rv_pmnt_date,
			rv_payment.rv_pmnt_note,
			rv_payment.rv_pmnt_ref,
			fn_folio.fn_folio_ix,
			fn_folio.fn_folio_date,
			fn_invoice.fn_invoice_ix,
			fn_invoice.fn_inv_exch_rate,
			rf_bank_inv.fn_ledger_id_account,
			rf_bank_inv.fn_ledger_id_deposit,
			pr_business.fn_system_id,
			pr_business.pr_bus_post_pmt_yn,
			pr_business.pr_bus_post_dep_yn
		FROM
			rv_payment_item
			INNER JOIN rv_payment ON rv_payment.rv_payment_ix = rv_payment_item.rv_payment_id
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_payment_item.fn_folio_id
			INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
			LEFT JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix AND fn_invoice.fn_inv_status_ind <> 8
			LEFT JOIN rf_bank_inv ON rf_bank_inv.rf_bank_id = rv_payment.rf_bank_id AND rf_bank_inv.pr_business_id = fn_folio.pr_business_id
		WHERE
			rv_payment_item.rv_payment_item_ix = '$rv_payment_item_id'
	",1);
}

function db_fn_tran_payment($rv_payment_item_id,$fn_tran_exch_rate=false,$fn_tran_inv_yn=false) {
	$paymentInfo = db_fn_tran_payment_lookup($rv_payment_item_id);

	if(db_fn_tran_payment_active($paymentInfo['fn_system_id'],$paymentInfo['pr_bus_post_pmt_yn'])) {
		$fn_tran_link_ind = DB_FN_TRAN_LINK_PAYMENT;
		$fn_tran_item_type_ind = DB_FN_TRAN_ITEM_TYPE_BANK;
		$fn_ledger_id = $paymentInfo['fn_ledger_id_account'];

		$fn_tran_item_amt_source = $paymentInfo['rv_payment_item_amt'];
		if($fn_tran_exch_rate == "none") {
			$fn_tran_item_amt = $paymentInfo['rv_pay_item_amt_rec'];
			$fn_tran_exch_rate = 0;
		} else {
			if(trim($paymentInfo['fn_invoice_ix']) != "" && $paymentInfo['fn_invoice_ix'] != "0") {
				//$fn_tran_exch_rate = $fn_tran_exch_rate * $paymentInfo['fn_inv_exch_rate'];
			}
			$fn_tran_item_amt = $fn_tran_item_amt_source * $fn_tran_exch_rate;
		}

		$fn_tran_id = db_fn_tran_insert($fn_tran_link_ind,$rv_payment_item_id,$fn_tran_exch_rate,$fn_tran_inv_yn);
		$fn_tran_item_note = $paymentInfo['rv_pmnt_note'] . ';' . $paymentInfo['rv_pmnt_ref'];
		db_fn_tran_item_insert($fn_tran_id,$fn_tran_item_type_ind,$fn_ledger_id,"","",$fn_tran_item_amt,$fn_tran_item_amt,$fn_tran_item_amt_source,$fn_tran_item_amt_source, $fn_tran_item_note);
		db_fn_tran_update_total($fn_tran_id);	

		if($paymentInfo['pr_bus_post_dep_yn'] == "1" && $paymentInfo['rv_pmnt_date'] < $paymentInfo['fn_folio_date'] && (trim($paymentInfo['fn_invoice_ix']) == "" || $paymentInfo['fn_invoice_ix'] == "0")) {
			$fn_tran_link_ind = DB_FN_TRAN_LINK_DEPOSIT;
			$fn_tran_item_type_ind = DB_FN_TRAN_ITEM_TYPE_DEPOSIT;
			$fn_ledger_id = $paymentInfo['fn_ledger_id_deposit'];

			$fn_tran_id = db_fn_tran_insert($fn_tran_link_ind,$rv_payment_item_id,$fn_tran_exch_rate,$fn_tran_inv_yn);
	
			$fn_tran_item_amt_source *= -1;
			$fn_tran_item_amt *= -1;

			db_fn_tran_item_insert($fn_tran_id,$fn_tran_item_type_ind,$fn_ledger_id,"","",$fn_tran_item_amt,$fn_tran_item_amt,$fn_tran_item_amt_source,$fn_tran_item_amt_source, $fn_tran_item_note);
			db_fn_tran_update_total($fn_tran_id);				
		}
	}
}
