<?php
require_once(__DIR__ . "/db.fn_tran.php");
require_once(__DIR__ . "/db.fn_ledger.php");

define("DB_FN_TRAN_ITEM_TYPE_DEBTOR",10);
define("DB_FN_TRAN_ITEM_TYPE_TAX",20);
define("DB_FN_TRAN_ITEM_TYPE_ACCOMM",30);
define("DB_FN_TRAN_ITEM_TYPE_EXTRA",40);
define("DB_FN_TRAN_ITEM_TYPE_DEPOSIT",50);
define("DB_FN_TRAN_ITEM_TYPE_BANK",60);
define("DB_FN_TRAN_ITEM_TYPE_SUPP",70);
define("DB_FN_TRAN_ITEM_TYPE_INVENT",71);
define("DB_FN_TRAN_ITEM_TYPE_INP_VAT",72);
define("DB_FN_TRAN_ITEM_TYPE_EXPENSE",73);


function db_fn_tran_item_exists($fn_tran_item_id) {
	global $lDB;

	$tranItemCheck = $lDB->get("SELECT COUNT(fn_tran_item_ix) FROM fn_tran_item WHERE fn_tran_item_ix = '$fn_tran_item_id'",4);
	if($tranItemCheck > 0) { return true; } else { return false; }

}

function db_fn_tran_item_type_desc($fn_tran_item_type_ind) {
	switch($fn_tran_item_type_ind) {
	case DB_FN_TRAN_ITEM_TYPE_DEBTOR:
		return "Debtor";
	case DB_FN_TRAN_ITEM_TYPE_TAX:
		return "Tax";
	case DB_FN_TRAN_ITEM_TYPE_ACCOMM:
		return "Accommodation";
	case DB_FN_TRAN_ITEM_TYPE_EXTRA:
		return "Extra";
	case DB_FN_TRAN_ITEM_TYPE_DEPOSIT:
		return "Deposit";
	case DB_FN_TRAN_ITEM_TYPE_BANK:
		return "Bank";
	case DB_FN_TRAN_ITEM_TYPE_SUPP:
		return "Supplier";
	case DB_FN_TRAN_ITEM_TYPE_INVENT:
		return "Inventory";
	case DB_FN_TRAN_ITEM_TYPE_INP_VAT:
		return "Input VAT";
	case DB_FN_TRAN_ITEM_TYPE_EXPENSE:
		return "Expense";
	}
}


function db_fn_tran_item_insert($fn_tran_id,$fn_tran_item_type_ind,$fn_ledger_id,$fn_debtor_id,$rf_tax_inv_id,$fn_tran_item_amt,$fn_tran_item_amt_incl,$fn_tran_item_amt_source,$fn_tran_item_amt_source_incl,$fn_tran_item_note='',$fn_tran_cost_ctr1_id=false,$fn_tran_cost_ctr2_id=false,$rt_component_inv_id=false,$pr_user_id=false) {
	global $lDB;
	global $dbcode;

	$rf_currency_id = $lDB->get("SELECT rf_currency_id FROM fn_tran WHERE fn_tran_ix = '$fn_tran_id'",4);

	if(!db_fn_ledger_exists($fn_ledger_id)) {
		$suspense = $lDB->get("
			SELECT
				pr_business.fn_ledger_id_suspense,
				pr_business.fn_ledger_id_suspense_foreign,
				pr_business.pr_bus_home_curr_id
			FROM
				fn_tran
				INNER JOIN pr_business ON pr_business.pr_business_id = fn_tran.pr_business_id
			WHERE
				fn_tran.fn_tran_ix = '$fn_tran_id'
		",1);
		if($suspense['pr_bus_home_curr_id'] != $rf_currency_id && !empty($suspense['fn_ledger_id_suspense_foreign'])) {
			$fn_ledger_id = $suspense['fn_ledger_id_suspense_foreign'];
		} else {
			$fn_ledger_id = $suspense['fn_ledger_id_suspense'];
		}
	}

	$createDate = date("Y-m-d H:i:s");
	$createDateTz = date("e");

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}
	
	$extra = array();
	if($fn_tran_cost_ctr1_id !== false && !empty($fn_tran_cost_ctr1_id)) {
		$extra['fn_tran_cost_ctr1_id'] = $lDB->escape($fn_tran_cost_ctr1_id);
	}
	if($fn_tran_cost_ctr2_id !== false && !empty($fn_tran_cost_ctr2_id)) {
		$extra['fn_tran_cost_ctr2_id'] = $lDB->escape($fn_tran_cost_ctr2_id);
	}
	if($rt_component_inv_id !== false && !empty($rt_component_inv_id)) {
		$extra['rt_component_inv_id'] = $lDB->escape($rt_component_inv_id);
	}
	$extraFields = "";
	$extraValues = "";
	if(sizeof($extra) > 0) {
		$extraFields = "," .join(",",array_keys($extra));
		$extraValues = ",'" . join("','",array_values($extra)) . "'";
	}

	$fn_tran_item_note_field = 'fn_tran_item_note,';
	$fn_tran_item_note_value = "'" . $lDB->escape($fn_tran_item_note) . "',";

	$tranItemExists = $lDB->get("SELECT fn_tran_item_note FROM fn_tran_item LIMIT 1", 4);
	if ($lDB->error) {
		// fn_tran_item_note field does not exist in the database yet (7.17 backport check)
		$fn_tran_item_note_field = '';		
		$fn_tran_item_note_value = '';
	}

	$lDB->put("
		INSERT INTO fn_tran_item (
			fn_tran_item_db,
			fn_tran_item_id,
			fn_tran_id,
			fn_tran_item_type_ind,
			$fn_tran_item_note_field
			fn_ledger_id,
			fn_debtor_id,
			rf_tax_inv_id,
			fn_tran_item_amt,
			fn_tran_item_amt_incl,
			fn_tran_item_amt_source,
			fn_tran_item_amt_source_incl,
			rf_currency_id,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id
			$extraFields
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'',
			'".$lDB->escape($fn_tran_id)."',
			'".$lDB->escape($fn_tran_item_type_ind)."',
			$fn_tran_item_note_value
			'".$lDB->escape($fn_ledger_id)."',
			'".$lDB->escape($fn_debtor_id)."',
			'".$lDB->escape($rf_tax_inv_id)."',
			'".$lDB->escape(db_round($fn_tran_item_amt,6))."',
			'".$lDB->escape(db_round($fn_tran_item_amt_incl,6))."',
			'".$lDB->escape(db_round($fn_tran_item_amt_source,6))."',
			'".$lDB->escape(db_round($fn_tran_item_amt_source_incl,6))."',
			'".$lDB->escape($rf_currency_id)."',
			'".$lDB->escape($createDate)."',
			'".$lDB->escape($createDateTz)."',
			'".$lDB->escape($pr_user_id)."'
			$extraValues
		)
	");

	$tranItemId = $lDB->insert_id;

	return $tranItemId;	
}

function db_fn_tran_item_delete_by_id($fn_tran_item_id,$pr_user_id=false) {
	global $lDB;

	$lDB->put("DELETE FROM fn_tran_item WHERE fn_tran_item_ix = '$fn_tran_item_id'");
}

function db_fn_tran_item_set_debtor($fn_tran_item_id,$fn_debtor_id,$pr_user_id=false) {
	global $lDB;

	if(!db_fn_tran_item_exists($fn_tran_item_id)) {
		return false;
	}

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}
	$ad_modify_date = date("Y-m-d H:i:s");
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE fn_tran_item SET
			fn_debtor_id = '".$lDB->escape($fn_debtor_id)."',
			ad_modify_date = '".$ad_modify_date."',
			ad_modify_date_tz = '".$ad_modify_date_tz."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			fn_tran_item_ix = '$fn_tran_item_id'
	");

	return true;
}

function db_fn_tran_item_set_ledger($fn_tran_item_id,$fn_ledger_id,$pr_user_id=false) {
	global $lDB;

	if(!db_fn_tran_item_exists($fn_tran_item_id)) {
		return false;
	}

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}
	$ad_modify_date = date("Y-m-d H:i:s");
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE fn_tran_item SET
			fn_ledger_id = '".$lDB->escape($fn_ledger_id)."',
			ad_modify_date = '".$ad_modify_date."',
			ad_modify_date_tz = '".$ad_modify_date_tz."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			fn_tran_item_ix = '$fn_tran_item_id'
	");

	return true;
}

function db_fn_tran_item_set_supplier($fn_tran_item_id,$fn_supplier_code,$pr_user_id=false) {
	global $lDB;

	if(!db_fn_tran_item_exists($fn_tran_item_id)) {
		return false;
	}

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}
	$ad_modify_date = date("Y-m-d H:i:s");
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE fn_tran_item SET
			fn_supplier_code = '".$lDB->escape($fn_supplier_code)."',
			ad_modify_date = '".$ad_modify_date."',
			ad_modify_date_tz = '".$ad_modify_date_tz."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			fn_tran_item_ix = '$fn_tran_item_id'
	");

	return true;
}

function db_fn_tran_item_set_cost_centre($fn_tran_item_id,$fn_tran_cost_ctr1_id="",$fn_tran_cost_ctr2_id="",$pr_user_id=false) {
	global $lDB;

	if(!db_fn_tran_item_exists($fn_tran_item_id)) {
		return false;
	}

	// Default to the currently logged in user
	if($pr_user_id === false) {
		$pr_user_id = $GLOBALS['userid'];
	}
	$ad_modify_date = date("Y-m-d H:i:s");
	$ad_modify_date_tz = date("e");
	$cost_centre_1_sql = "";
	$cost_centre_2_sql = "";
	if(isset($fn_tran_cost_ctr1_id) && $fn_tran_cost_ctr1_id != "") {
		$cost_centre_1_sql = "fn_tran_cost_ctr1_id = '".$lDB->escape($fn_tran_cost_ctr1_id)."', ";
	}
	if(isset($fn_tran_cost_ctr2_id) && $fn_tran_cost_ctr2_id != "") {
		$cost_centre_2_sql = "fn_tran_cost_ctr2_id = '".$lDB->escape($fn_tran_cost_ctr2_id)."', ";
	}

	$lDB->put("
		UPDATE fn_tran_item SET
		$cost_centre_1_sql
		$cost_centre_2_sql
			ad_modify_date = '".$ad_modify_date."',
			ad_modify_date_tz = '".$ad_modify_date_tz."',
			ad_modify_user_id = '".$lDB->escape($pr_user_id)."'
		WHERE
			fn_tran_item_ix = '$fn_tran_item_id'
	");

	return true;
}
