<?php

define("DB_FN_YEAR_STATUS_OPEN",2);
define("DB_FN_YEAR_STATUS_CLOSED",20);

function db_fn_year_exists($fn_year_id) {
	global $lDB;

	$check = $lDB->get("SELECT COUNT(*) FROM fn_year WHERE fn_year_ix = '$fn_year_id'",4);
	if($check > 0) { return true; } else { return false; }

}

function db_fn_year_insert($pr_business_id,$fn_year_desc,$fn_year_end_date,$pr_user_id=false) {
	global $lDB;
	global $dbcode;

	if(db_pr_business_ledger_allow($pr_business_id)) {
		// Default to the currently logged in user
		if($pr_user_id === false) {
			$pr_user_id = $GLOBALS['userid'];
		}
		$createDate = date("Y-m-d H:i:s");
		$createDateTz = date("e");

		$lDB->put("
			INSERT INTO fn_year (
				fn_year_db,
				fn_year_id,
				pr_business_id,
				fn_year_desc,
				fn_year_end_date,
				ad_create_date,
				ad_create_date_tz,
				ad_create_user_id
			) VALUES (
				'".$lDB->escape($dbcode)."',
				'',
				'".$lDB->escape($pr_business_id)."',
				'".$lDB->escape($fn_year_desc)."',
				'".$lDB->escape($fn_year_end_date)."',
				'".$lDB->escape($createDate)."',
				'".$lDB->escape($createDateTz)."',
				'".$lDB->escape($pr_user_id)."'
			)
		");
		$yearId = $lDB->insert_id;	
		return $yearId;
	} else {
		return false;
	}
}

function db_fn_year_update($fn_year_id,$fn_year_desc,$fn_year_end_date) {
	global $lDB;

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_year WHERE fn_year_ix = '$fn_year_id'",4);
	if(db_pr_business_ledger_allow($pr_business_id)) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";		
		$lDB->put("
			UPDATE fn_year SET
				fn_year_desc = '".$lDB->escape($fn_year_desc)."',
				fn_year_end_date = '".$lDB->escape($fn_year_end_date)."'
			WHERE
				fn_year_ix = '$fn_year_id'
		");
		$lDB->isMaster = $master;
		return true;
	} else {
		return false;
	}
}

function db_fn_year_set_status($fn_year_id,$fn_year_status_ind) {
	global $lDB;

	if(!db_fn_year_exists($fn_year_id)) {
		return false;
	}

	$lDB->put("UPDATE fn_year SET fn_year_status_ind = '".$lDB->escape($fn_year_status_ind)."' WHERE fn_year_ix = '$fn_year_id'");

	return true;
}

function db_fn_year_delete_by_id($fn_year_id) {
	global $lDB;

	$pr_business_id = $lDB->get("SELECT pr_business_id FROM fn_year WHERE fn_year_ix = '$fn_year_id'",4);
	if(db_pr_business_ledger_allow($pr_business_id)) {
		$master = $lDB->isMaster;
		$lDB->isMaster = "1";		
		$yearCount = $lDB->get("SELECT COUNT(*) FROM fn_batch WHERE fn_year_id = '$fn_year_id'",4);

		if($yearCount > 0) {
			return false;
		}

		$lDB->put("DELETE FROM fn_year WHERE fn_year_ix = '$fn_year_id'");
		$lDB->isMaster = $master;

		return true;
	} else {
		return false;
	}
}

