<?php

function db_notifications_get_count() {
    $notifications = $GLOBALS['lDB']->get("
        SELECT
            COUNT(pr_notification_target.pr_notification_target_ix)
        FROM
            pr_notification_target
            LEFT JOIN pr_notification_receipt ON pr_notification_receipt.pr_notification_id = pr_notification_target.pr_notification_id AND pr_notification_receipt.pr_user_id = '" . $GLOBALS['userid'] . "'
        WHERE
            pr_notification_target.pr_user_id = '" . $GLOBALS['userid'] . "'
            AND (
                pr_notification_receipt.pr_notification_receipt_ix IS NULL
                OR pr_notification_receipt.pr_notification_receipt_read_timestamp IS NULL
            )
    ",4);

    $sessionId = $GLOBALS['lDB']->get("
        SELECT
            GROUP_CONCAT(pr_notification_target.pr_notification_target_ix)
        FROM
            pr_notification_target
        WHERE
            pr_notification_target.pr_user_id = '" . $GLOBALS['userid'] . "'
    ",4);

    $notificationPrefs = $GLOBALS['lDB']->get("
        SELECT
            pr_notification_prefs.pr_notification_prefs_show_popup
        FROM
            pr_notification_prefs
        WHERE
            pr_notification_prefs.pr_user_id = '" . $GLOBALS['userid'] . "'
    ",1);

    $showPopup = empty($notificationPrefs) || $notificationPrefs['pr_notification_prefs_show_popup'] == 1 ? true : false;

    return array(
        "count" => $notifications,
        "sessionId" => md5($sessionId),
        "showPopup" => $showPopup
    );
}

function db_notifications_receipt_record($pr_notification_id, $type) {
    global $lDB;

    if (empty($pr_notification_id)) {
        return;
    }

    $receipt = $lDB->get("
        SELECT
            pr_notification_receipt_ix,
            pr_notification_receipt_delivered_timestamp,
            pr_notification_receipt_read_timestamp,
            pr_notification_receipt_acknowledged_timestamp
        FROM
            pr_notification_receipt
        WHERE
            pr_user_id = '" . $GLOBALS['userid'] . "'
            AND pr_notification_id = '" . $pr_notification_id . "'
    ",1);

    if (empty($receipt)) {
        $lDB->put("
            INSERT INTO pr_notification_receipt (
                pr_notification_receipt_ix,
                pr_user_id,
                pr_notification_id,
                pr_notification_receipt_delivered_timestamp
            )
                SELECT GET_UUID(),
                '" . $lDB->escape($GLOBALS['userid']) . "',
                '" . $lDB->escape($pr_notification_id) . "',
                NOW()
        ");
        return;
    } else {
        $pr_notification_receipt_ix = $receipt['pr_notification_receipt_ix'];
    }

    if ($type == "1" && $receipt['pr_notification_receipt_read_timestamp'] == "") {
        $lDB->put("
            UPDATE
                pr_notification_receipt
            SET
                pr_notification_receipt_read_timestamp = NOW()
            WHERE
                pr_notification_receipt_ix = '" . $pr_notification_receipt_ix . "'
        ");
        return;
    }

    if ($type == "2" && $receipt['pr_notification_receipt_acknowledged_timestamp'] == "") {
        $lDB->put("
            UPDATE
                pr_notification_receipt
            SET
                pr_notification_receipt_acknowledged_timestamp = NOW()
            WHERE
                pr_notification_receipt_ix = '" . $pr_notification_receipt_ix . "'
        ");
    }
}

function db_notifications_archive_record($pr_notification_id, $action) {
    global $lDB;
    define("ACTION_ARCHIVE", "1");
    define("ACTION_UNARCHIVE", "0");

    // action: 1 = archive, 0 = unarchive
    if (empty($pr_notification_id) || !isset($action)) {
        return;
    }

    $pr_notification_archive_ix = $lDB->get("
        SELECT
            pr_notification_archive_ix
        FROM
            pr_notification_archive
        WHERE
            pr_user_id = '" . $GLOBALS['userid'] . "'
            AND pr_notification_id = '" . $pr_notification_id . "'
    ",4);

    switch($action) {
    case ACTION_ARCHIVE:   // archive
        if (empty($pr_notification_archive_ix)) {
            $lDB->put("
                INSERT INTO pr_notification_archive (
                    pr_notification_archive_ix,
                    pr_user_id,
                    pr_notification_id,
                    pr_notification_archive_timestamp
                )
                    SELECT GET_UUID(),
                    '" . $lDB->escape($GLOBALS['userid']) . "',
                    '" . $lDB->escape($pr_notification_id) . "',
                    NOW()
            ");
        }
        return("1");
        break;
    case ACTION_UNARCHIVE:   // unarchive
        if (!empty($pr_notification_archive_ix)) {
            $lDB->put("
                DELETE FROM
                    pr_notification_archive
                WHERE
                    pr_notification_archive_ix = '" . $pr_notification_archive_ix . "'
            ");
        }
        return("0");
        break;
    }
}

function db_notifications_get_notifications($pr_notification_id="", $search="") {

    if (empty($pr_notification_id)) {
        // Get listing
        $additionalWhere = "";
        if (!empty($search)) {
            $searchWhere = explode(" ", $search);
            $keywordPairs = array();
            foreach ($searchWhere as $keyword) {
                $keywordPairs[] = "pr_notification.pr_notification_subject LIKE '%" . $keyword . "%'
                        OR pr_notification.pr_notification_message LIKE '%" . $keyword . "%'";
            }
            $additionalWhere .= "AND (" . join($keywordPairs, " OR ") . ") ";
        }

        $notifications = $GLOBALS['lDB']->get("
            SELECT
                pr_notification.pr_notification_ix AS 'notificationID',
                pr_notification.pr_notification_subject AS 'subject',
                pr_notification.pr_notification_added AS 'time',
                pr_notification_receipt.pr_notification_receipt_ix AS 'receiptID',
                pr_notification_receipt.pr_notification_receipt_delivered_timestamp AS 'delivered',
                pr_notification_receipt.pr_notification_receipt_read_timestamp AS 'read',
                pr_notification_receipt.pr_notification_receipt_acknowledged_timestamp AS 'acknowledged',
                pr_notification_target.pr_user_id AS 'user',
                TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) AS 'username',
                IF(pr_notification_archive.pr_notification_archive_ix IS NULL, 0, 1) AS 'archived'
            FROM
                pr_notification_target
                LEFT JOIN pr_notification ON pr_notification.pr_notification_ix = pr_notification_target.pr_notification_id
                LEFT JOIN pr_notification_receipt ON
                    pr_notification_receipt.pr_notification_id = pr_notification_target.pr_notification_id
                    AND pr_notification_receipt.pr_user_id = '" . $GLOBALS['userid'] . "'
                LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_notification_target.pr_user_id
                LEFT JOIN pr_notification_archive ON
                    pr_notification_archive.pr_notification_id = pr_notification_target.pr_notification_id
                    AND pr_notification_archive.pr_user_id = '" . $GLOBALS['userid'] . "'
            WHERE
                pr_notification_target.pr_user_id = '" . $GLOBALS['userid'] . "'
                " . $additionalWhere . "
            ORDER BY
                pr_notification.pr_notification_added DESC
        ",2);
        $type = 0;
    } else {
        // Open individual message
        $notifications = $GLOBALS['lDB']->get("
            SELECT
                pr_notification.pr_notification_ix AS 'notificationID',
                pr_notification.pr_notification_message AS 'notificationMessage',
                pr_notification_receipt.pr_notification_receipt_acknowledged_timestamp AS 'acknowledged'
            FROM
                pr_notification
                LEFT JOIN pr_notification_receipt ON
                    pr_notification_receipt.pr_notification_id = pr_notification.pr_notification_ix
                    AND pr_notification_receipt.pr_user_id = '" . $GLOBALS['userid'] . "'
            WHERE
                pr_notification.pr_notification_ix = '" . $pr_notification_id . "'
        ",2);
        $type = 1;
    }

    foreach ($notifications AS $notification) {
        db_notifications_receipt_record($notification['notificationID'], $type);
    }
    return $notifications;
}

function db_notifications_popups_toggle() {
    global $lDB;

    $popupStatus = $lDB->get("
        SELECT
            pr_notification_prefs_ix,
            pr_notification_prefs_show_popup
        FROM
            pr_notification_prefs
        WHERE
            pr_user_id = '" . $GLOBALS['userid'] . "'
    ",1);

    if (empty($popupStatus)) {
        $lDB->put("
            INSERT INTO pr_notification_prefs (
                pr_notification_prefs_ix,
                pr_notification_prefs_show_popup,
                pr_user_id
            )
                SELECT GET_UUID(),
                0,
                '" . $lDB->escape($GLOBALS['userid']) . "'
        ");
        return "0";
    }

    $showPopup = $popupStatus['pr_notification_prefs_show_popup'] == 1 ? 0 : 1;

    $lDB->put("
        UPDATE
            pr_notification_prefs
        SET
            pr_notification_prefs_show_popup = " . $showPopup . "
        WHERE
            pr_notification_prefs_ix = '" . $popupStatus['pr_notification_prefs_ix'] . "'
    ");
    return $showPopup;
}