<?php
require_once(__DIR__ . "/db.pf_option.php");

function db_pf_field_exists($pf_field_id) {
	global $lDB;

	$fieldCheck = $lDB->get("SELECT COUNT(pf_field_ix) FROM pf_field WHERE pf_field_ix = '$pf_field_id'",4);
	if($fieldCheck > 0) { return true; } else { return false; }
}

function db_pf_field_exists_by_name($pf_option_id,$pf_field_name) {
	global $lDB;

	$fieldCheck = $lDB->get("SELECT COUNT(pf_field_ix) FROM pf_field WHERE pf_option_id = '$pf_option_id' AND pf_field_name = '$pf_field_name'",4);
	if($fieldCheck > 0) { return true; } else { return false; }
}

function db_pf_field_insert($pf_option_id,$pf_field_name,$pf_field_contents) {
	global $lDB;

	if(!db_pf_option_exists($pf_option_id)) {
		return false;
	}

	if(db_pf_field_exists_by_name($pf_option_id,$pf_field_name)) {
		return false;
	}
	$lDB->put("
		INSERT INTO pf_field (
			pf_field_db,
			pf_field_id,
			pf_field_contents,
			pf_field_name,
			pf_option_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($pf_field_contents)."',
			'".$lDB->escape($pf_field_name)."',
			'".$lDB->escape($pf_option_id)."'
		)
	");
	$fieldId = $lDB->insert_id;

	return $fieldId;	
}

function db_pf_field_update($pf_option_id,$pf_field_name,$pf_field_contents) {
	global $lDB;

	if(db_pf_field_exists_by_name($pf_option_id,$pf_field_name)) {
		$fieldId = $lDB->get("SELECT pf_field_ix FROM pf_field WHERE pf_option_id = '$pf_option_id' AND pf_field_name = '$pf_field_name'",4);
		$lDB->put("
			UPDATE pf_field SET
				pf_field_contents = '".$lDB->escape($pf_field_contents)."'
			WHERE
				pf_field_ix = '$fieldId'
		");
		return $fieldId;
	} else {
		return db_pf_field_insert($pf_option_id,$pf_field_name,$pf_field_contents);
	}	
}

function db_pf_field_delete($pf_field_id) {
	global $lDB;

	$lDB->put("DELETE FROM pf_field WHERE pf_field_ix = '$pf_field_id'");
}

function db_pf_field_by_name($pf_option_id,$pf_field_name) {
	global $lDB;

	return $lDB->get("SELECT pf_field_contents FROM pf_field WHERE pf_option_id = '$pf_option_id' AND pf_field_name = '$pf_field_name'",4);
}

function db_pf_field_by_option($pf_option_id) {
	global $lDB;
	return $lDB->get("SELECT pf_field_ix FROM pf_field WHERE pf_option_id = '$pf_option_id'",3);
}

function db_pf_field_load_by_name($pf_option_id,$pf_field_name,&$result) {
	$value = trim(db_pf_field_by_name($pf_option_id,$pf_field_name));
	if($value != "") {
		$result = $value;
	} else {
		$result = false;
	}
}
