<?php
require_once(__DIR__ . "/db.pf_object.php");

define("DB_PF_LEVEL_SYSTEM",1);
define("DB_PF_LEVEL_GLOBAL",3);
define("DB_PF_LEVEL_ENV",5);
define("DB_PF_LEVEL_USER",7);
define("DB_PF_LEVEL_TEMPLATE",9);


function db_pf_option_exists($pf_option_id) {
	global $lDB;

	$optionCheck = $lDB->get("SELECT COUNT(pf_option_ix) FROM pf_option WHERE pf_option_ix = '$pf_option_id'",4);
	if($optionCheck > 0) { return true; } else { return false; }
}

function db_pf_option_exists_by_level_default($pf_object_id,$pf_level_ind,$pf_level_link_id) {
	global $lDB;

	$optionCheck = $lDB->get("SELECT COUNT(pf_option_ix) FROM pf_option WHERE pf_object_id = '$pf_object_id' AND pf_level_ind = '$pf_level_ind' AND pf_level_link_id = '$pf_level_link_id' AND pf_option_default_yn = '1'",4);
	if($optionCheck > 0) { return true; } else { return false; }
}

function db_pf_option_find_level(&$pf_level_ind, &$pf_level_link_id) {
	if($pf_level_ind===false) { // Default to user profile
		$pf_level_ind = DB_PF_LEVEL_USER; // user level?
	}

	if($pf_level_link_id === false) {
		if($pf_level_ind == DB_PF_LEVEL_ENV) {
			$pf_level_link_id = $GLOBALS['dbcode'];
		} else if($pf_level_ind == DB_PF_LEVEL_USER) {
			$pf_level_link_id = $GLOBALS['userid'];
		} else {
			$pf_level_link_id = "";
		}
	}	
}

function db_pf_option_level_name($pf_level_ind) {
	switch($pf_level_ind) {
	case DB_PF_LEVEL_SYSTEM:
		return "System";
	case DB_PF_LEVEL_GLOBAL:
		return "Global";
	case DB_PF_LEVEL_ENV:
		return "Environment";
	case DB_PF_LEVEL_USER:
		return "User";
	case DB_PF_LEVEL_TEMPLATE:
		return "Template";
	}
}

function db_pf_option_insert($pf_object_id,$pf_option_name,$pf_option_note,$pf_level_ind=false,$pf_level_link_id=false,$pf_option_default_yn=false,$pf_option_favourite_yn=false,$pf_option_title="") {
	global $lDB;

	if(!db_pf_object_exists($pf_object_id)) {
		return false;
	}

	db_pf_option_find_level($pf_level_ind,$pf_level_link_id);

	if($pf_option_default_yn===false) {
		$pf_option_default_yn = "0";
	} else {
		$pf_option_default_yn = "1";
		db_pf_option_remove_default(db_pf_option_get_default($pf_object_id,$pf_level_ind,$pf_level_link_id));
	}

	if(empty($pf_option_favourite_yn)) {
		$pf_option_favourite_yn = "0";
	} else {
		$pf_option_favourite_yn = "1";
	}

	$lDB->put("
		INSERT INTO pf_option (
			pf_option_db,
			pf_option_id,
			pf_object_id,
			pf_option_name,
			pf_option_note,
			pf_option_default_yn,
			pf_option_favourite_yn,
			pf_option_title,
			pf_level_ind,
			pf_level_link_id
		) VALUES (
			'".$lDB->escape($GLOBALS['dbcode'])."',
			'',
			'".$lDB->escape($pf_object_id)."',
			'".$lDB->escape($pf_option_name)."',
			'".$lDB->escape($pf_option_note)."',
			'".$lDB->escape($pf_option_default_yn)."',
			'".$lDB->escape($pf_option_favourite_yn)."',
			'".$lDB->escape($pf_option_title)."',
			'".$lDB->escape($pf_level_ind)."',
			'".$lDB->escape($pf_level_link_id)."'
		)
	");

	$optionId = $lDB->insert_id;

	return $optionId;	
}

function db_pf_option_update($pf_option_id,$pf_option_name,$pf_option_note,$pf_level_ind=false,$pf_level_link_id=false,$pf_option_default_yn=false,$pf_option_favourite_yn=false,$pf_option_title="") {

	global $lDB;
	$pf_level = "";
	
	if($pf_option_default_yn===false) {
		$pf_option_default_yn = "0";
	}

	if($pf_option_default_yn == "1") {
		db_pf_option_remove_default(db_pf_option_get_default(db_pf_option_object($pf_option_id),$pf_level_ind,db_pf_option_level_link_id($pf_option_id)));
	}

	if($pf_option_favourite_yn===false) {
		$pf_option_favourite_yn = "0";
	}
	
	$lDB->put("
		UPDATE pf_option SET
			pf_option_name = '".$lDB->escape($pf_option_name)."',
			pf_option_note = '".$lDB->escape($pf_option_note)."',
			pf_option_default_yn = '".$lDB->escape($pf_option_default_yn)."',
			pf_option_favourite_yn = '".$lDB->escape($pf_option_favourite_yn)."',
			pf_option_title = '".$lDB->escape($pf_option_title)."'
			$pf_level
		WHERE
			pf_option_ix = '$pf_option_id'
	");
}

function db_pf_option_remove_default($pf_option_id) {
	$GLOBALS['lDB']->put("UPDATE pf_option SET pf_option_default_yn = '0' WHERE pf_option_ix='$pf_option_id'");
}

function db_pf_option_delete($pf_option_id) {
	global $lDB;
	$fieldList = db_pf_field_by_option($pf_option_id);
	foreach($fieldList as $item) {
		db_pf_field_delete($item);
	}

	$lDB->put("DELETE FROM pf_option WHERE pf_option_ix = '$pf_option_id'");
}

function db_pf_option_get_default($pf_object_id,$pf_level_ind,$pf_level_link_id) {
	return $GLOBALS['lDB']->get("SELECT pf_option_ix FROM pf_option WHERE pf_object_id='$pf_object_id' AND pf_level_ind='$pf_level_ind' AND pf_level_link_id='$pf_level_link_id' AND pf_option_default_yn = '1'",4);
}

function db_pf_option_default($pf_object_id, $pf_level_ind=false, $pf_level_link_id=false) {
	global $lDB;

	db_pf_option_find_level($pf_level_ind,$pf_level_link_id);

	if($pf_level_ind == DB_PF_LEVEL_USER && db_pf_option_exists_by_level_default($pf_object_id,DB_PF_LEVEL_USER,$pf_level_link_id)) {
		return db_pf_option_get_default($pf_object_id,DB_PF_LEVEL_USER,$pf_level_link_id);
	} else {
		$pf_level_ind = DB_PF_LEVEL_ENV;
		$pf_level_link_id = false;
		db_pf_option_find_level($pf_level_ind,$pf_level_link_id);
	}

	if($pf_level_ind == DB_PF_LEVEL_ENV && db_pf_option_exists_by_level_default($pf_object_id,DB_PF_LEVEL_ENV,$pf_level_link_id)) {
		return db_pf_option_get_default($pf_object_id,DB_PF_LEVEL_ENV,$pf_level_link_id);
	} else {
		$pf_level_ind = DB_PF_LEVEL_GLOBAL;
		$pf_level_link_id = false;
		db_pf_option_find_level($pf_level_ind,$pf_level_link_id);
	}

	if($pf_level_ind == DB_PF_LEVEL_GLOBAL && db_pf_option_exists_by_level_default($pf_object_id,DB_PF_LEVEL_GLOBAL,$pf_level_link_id)) {
		return db_pf_option_get_default($pf_object_id,DB_PF_LEVEL_GLOBAL,$pf_level_link_id);
	} else {
		$pf_level_ind = DB_PF_LEVEL_SYSTEM;
		$pf_level_link_id = false;
		db_pf_option_find_level($pf_level_ind,$pf_level_link_id);
	}

	if($pf_level_ind == DB_PF_LEVEL_SYSTEM && db_pf_option_exists_by_level_default($pf_object_id,DB_PF_LEVEL_SYSTEM,$pf_level_link_id)) {
		return db_pf_option_get_default($pf_object_id,DB_PF_LEVEL_SYSTEM,$pf_level_link_id);
	} else {
		return false;
	}
}

function db_pf_option_object($pf_option_id) {
	return $GLOBALS['lDB']->get("SELECT pf_object_id FROM pf_option WHERE pf_option_ix='$pf_option_id'",4);
}

function db_pf_option_level_link_id($pf_option_id) {
	return $GLOBALS['lDB']->get("SELECT pf_level_link_id FROM pf_option WHERE pf_option_ix='$pf_option_id'",4);
}

function db_pf_option_level($pf_option_id) {
	return $GLOBALS['lDB']->get("SELECT pf_level_ind FROM pf_option WHERE pf_option_ix = '$pf_option_id'",4);
}

function db_pf_option_allow_system() {
	$systemUserId = $GLOBALS['lDB']->get("SELECT pr_persona_ix FROM pr_persona WHERE pr_sys_code = '9'",4);
	if($systemUserId == $GLOBALS['userid']) {
		return true;
	}
	return false;
}

function db_pf_option_allow_save($pf_option_id,$job,$new=false) {
	if(!db_pf_option_exists($pf_option_id)) {
		return false;
	}
	$dbCode = $GLOBALS['lDB']->get("SELECT pf_option_db FROM pf_option WHERE pf_option_ix = '".$pf_option_id."'",4);
	if(!canEditDB($dbCode) && !$new) {
		return false;
	}
	$level = db_pf_option_level($pf_option_id);

	if($level == DB_PF_LEVEL_SYSTEM && !db_pf_option_allow_system()) {
		return false;
	}

	if($level == DB_PF_LEVEL_USER) {
		return true;
	}

	if($GLOBALS['jobLevelArray'][$job] >= 15) {
		return true;
	}
	return false;

}

function db_pf_option_check_duplicate($pf_object_id, $pf_option_name, $pf_option_id=false, $pf_level_ind=false,$pf_level_link_id=false) {
	global $lDB;
	if(db_pf_option_exists($pf_option_id)) {
		$lDB->get("SELECT pf_level_ind, pf_level_link_id FROM pf_option WHERE pf_option_ix = '$pf_option_id'",4);
	} else {
		db_pf_option_find_level($pf_level_ind,$pf_level_link_id);
	}

	$levelSQL = "";

	switch($pf_level_ind) {
	case DB_PF_LEVEL_SYSTEM:
	case DB_PF_LEVEL_GLOBAL:
		$levelSQL = "
			AND pf_option.pf_level_ind = '$pf_level_ind'
		";
		break;
	case DB_PF_LEVEL_ENV:
	case DB_PF_LEVEL_USER:
	case DB_PF_LEVEL_TEMPLATE:
		$levelSQL = "
			AND pf_option.pf_level_ind = '$pf_level_ind'
			AND pf_option.pf_level_link_id = '$pf_level_link_id'
		";
	}
	$check = $lDB->get("
		SELECT
			COUNT(pf_option_ix)
		FROM
			pf_option
		WHERE
			pf_option.pf_option_ix <> '$pf_option_id'
			AND pf_option.pf_object_id = '$pf_object_id'
			AND pf_option.pf_option_name = '$pf_option_name'
			$levelSQL
	",4);
	if($check > 0) {
		return true;
	}
	return false;
}

function db_pf_option_get_defaults($pf_object_id, $only_defaults=true) {
    $defaults = $only_defaults ? "AND pf_option.pf_option_default_yn = '1'" : "";
	return $GLOBALS['lDB']->get("
		SELECT
			pf_option.pf_option_ix
		FROM
			pf_option
		WHERE
			pf_object_id = '$pf_object_id'
			AND (
				pf_level_ind = '".DB_PF_LEVEL_SYSTEM."'
				OR pf_level_ind = '".DB_PF_LEVEL_GLOBAL."'
				OR (
					pf_level_ind = '".DB_PF_LEVEL_ENV."'
					AND pf_level_link_id IN ('".join("','",getDBCodes())."')
				) OR (
					pf_level_ind = '".DB_PF_LEVEL_USER."'
					AND pf_level_link_id = '$GLOBALS[userid]'
				)
			)
			" . $defaults . "
		ORDER BY
			pf_option.pf_level_ind DESC
	",3);
}

function db_pf_option_get_title($pf_option_id) {
	global $lDB;

	if(db_pf_option_exists($pf_option_id)) {
		return $lDB->get("SELECT pf_option_title FROM pf_option WHERE pf_option.pf_option_ix = '$pf_option_id'",4);
	} else {
		return "";
	}
}

function db_pf_option_get_name($pf_option_id) {
	global $lDB;

	if(db_pf_option_exists($pf_option_id)) {
		return $lDB->get("SELECT pf_option_name FROM pf_option WHERE pf_option.pf_option_ix = '$pf_option_id'",4);
	} else {
		return "";
	}
}

function db_pf_option_get_note($pf_option_id) {
	global $lDB;

	if(db_pf_option_exists($pf_option_id)) {
		return $lDB->get("SELECT pf_option_note FROM pf_option WHERE pf_option.pf_option_ix = '$pf_option_id'",4);
	} else {
		return "";
	}
}

function db_pf_option_check_default($pf_option_id) {
	global $lDB;

	if(db_pf_option_exists($pf_option_id)) {
		return $lDB->get("SELECT pf_option_default_yn FROM pf_option WHERE pf_option.pf_option_ix = '$pf_option_id'",4);
	} else {
		return "";
	}
}

function db_pf_option_get_by_user($pf_object_id=false,$pf_option_favourite_yn=false,$pr_user_id=false) {
	global $lDB;

	$objectSQL = "";
	if($pf_object_id !== false) {
		$objectSQL = "
			AND pf_option.pf_object_id = '$pf_object_id'
		";
	}

	if($pr_user_id === false) {
		$userSQL = "
			AND pf_option.pf_level_link_id = '$GLOBALS[userid]'
		";
	} elseif($pr_user_id == "all") {
		$userSQL = "";
	} else {
		$userSQL = "
			AND pf_option.pf_level_link_id = '$pr_user_id'
		";
	}

	$favouriteSQL = "";
	if($pf_option_favourite_yn) {
		$favouriteSQL = "
			AND pf_option.pf_option_favourite_yn = '1'
			AND TRIM(pf_option.pf_option_title) != ''
			";
		$sortSQL = "
			pf_option.pf_option_title
		";
		
	} else {
		$sortSQL = "
			pf_option.pf_level_ind,
			pf_option.pf_option_name
		";
	}

	return $lDB->get("
		SELECT
			pf_option.pf_option_db,
			pf_option.pf_option_ix,
			pf_option.pf_option_name,
			pf_option.pf_option_note,
			pf_option.pf_level_ind,
			pf_option.pf_level_link_id,
			pf_option.pf_option_default_yn,
			pf_option.pf_option_favourite_yn,
			pf_option.pf_option_title,
			pf_object.sc_job_id
		FROM
			pf_option
			INNER JOIN pf_object ON pf_object.pf_object_ix = pf_option.pf_object_id
		WHERE
			(
				pf_level_ind = '".DB_PF_LEVEL_SYSTEM."'
				OR pf_level_ind = '".DB_PF_LEVEL_GLOBAL."'
				OR pf_level_ind = '".DB_PF_LEVEL_TEMPLATE."'
				OR (
					pf_level_ind = '".DB_PF_LEVEL_ENV."'
					AND pf_level_link_id IN ('".join("','",getDBCodes())."')
				) OR (
					pf_level_ind = '".DB_PF_LEVEL_USER."'
					$userSQL
				)
			)
			$favouriteSQL
			$objectSQL
		ORDER BY
			$sortSQL
	",2);
	
}
