<?php

require_once(__DIR__ . "/db.pg_account.php");
require_once(__DIR__ . "/db.pr_business.php");

function db_pg_acc_business_exists($pg_acc_business_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(pg_acc_business_ix) FROM pg_acc_business WHERE pg_acc_business_ix = '$pg_acc_business_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_pg_acc_business_exists_by_all($pg_account_id,$pr_business_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(pg_acc_business_ix) FROM pg_acc_business WHERE pg_account_id = '$pg_account_id' AND pr_business_id = '$pr_business_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_pg_acc_business_insert($pg_account_id,$pr_business_id) {
	global $lDB;
	global $dbcode;
	global $userid;
	if(db_pg_acc_business_exists_by_all($pg_account_id,$pr_business_id)) {
		return false;
	}

	if(!db_pg_account_exists($pg_account_id)) {
		return false;
	}

	if(!db_pr_business_exists($pr_business_id) && $pr_business_id != "0") {
		return false;
	}

	$ad_create_date = date("Y-m-d H:i:s");
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO pg_acc_business (
			pg_acc_business_db,
			pg_account_id,
			pr_business_id,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pg_account_id)."',
			'".$lDB->escape($pr_business_id)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($userid)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_modify_date_tz)."',
			'".$lDB->escape($userid)."'			
		)
	",1);	

	$pg_acc_business_id = $lDB->insert_id;

	return $pg_acc_business_id;	
}

function db_pg_acc_business_delete($pg_acc_business_id) {
	global $lDB;

	if(!db_pg_acc_business_exists($pg_acc_business_id)) {
		return false;
	}

	$lDB->put("DELETE FROM pg_acc_business WHERE pg_acc_business_ix = '$pg_acc_business_id'");
	return true;
}

function db_pg_acc_business_delete_by_all($pg_account_id,$pr_business_id) {
	$list = $GLOBALS['lDB']->get("SELECT pg_acc_business_ix FROM pg_acc_business WHERE pg_account_id = '$pg_account_id' AND pr_business_id = '$pr_business_id'",3);
	foreach($list as $id) {
		db_pg_acc_business_delete($id);
	}
}

function db_pg_acc_business_set($pg_account_id,$pr_business_id,$enabled) {
	if($enabled && !db_pg_acc_business_exists_by_all($pg_account_id,$pr_business_id)) {
		db_pg_acc_business_insert($pg_account_id,$pr_business_id);
	}
	if(!$enabled && db_pg_acc_business_exists_by_all($pg_account_id,$pr_business_id)) {
		db_pg_acc_business_delete_by_all($pg_account_id,$pr_business_id);
	}
}

function db_pg_acc_business_delete_by_account($pg_account_id) {
	$list = $GLOBALS['lDB']->get("SELECT pg_acc_business_ix FROM pg_acc_business WHERE pg_account_id = '$pg_account_id'",3);
	foreach($list as $item) {
		db_pg_acc_business_delete($item);
	}
}

