<?php

require_once(__DIR__ . "/db.pg_account.php");
require_once(__DIR__ . "/db.rf_currency.php");
require_once(__DIR__ . "/db.rf_bank.php");

function db_pg_acc_currency_exists($pg_acc_currency_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(pg_acc_currency_ix) FROM pg_acc_currency WHERE pg_acc_currency_ix = '$pg_acc_currency_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_pg_acc_currency_exists_by_all($pg_account_id,$rf_currency_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(pg_acc_currency_ix) FROM pg_acc_currency WHERE pg_account_id = '$pg_account_id' AND rf_currency_id = '$rf_currency_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_pg_acc_currency_insert($pg_account_id,$rf_currency_id,$rf_bank_id,$pg_acc_currency_code,$pg_acc_currency_inactive_yn) {
	global $lDB;
	global $dbcode;
	global $userid;

	if(!db_pg_account_exists($pg_account_id)) {
		return false;
	}

	if(!db_rf_currency_exists($rf_currency_id)) {
		return false;
	}

	if(!db_rf_bank_exists($rf_bank_id)) {
		return false;
	}

	if(empty($pg_acc_currency_inactive_yn)) {
		$pg_acc_currency_inactive_yn = "0";
	} else {
		$pg_acc_currency_inactive_yn = "1";
	}

	$ad_create_date = date("Y-m-d H:i:s");
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO pg_acc_currency (
			pg_acc_currency_db,
			pg_account_id,
			rf_currency_id,
			rf_bank_id,
			pg_acc_currency_code,
			pg_acc_currency_inactive_yn,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pg_account_id)."',
			'".$lDB->escape($rf_currency_id)."',
			'".$lDB->escape($rf_bank_id)."',
			'".$lDB->escape($pg_acc_currency_code)."',
			'".$lDB->escape($pg_acc_currency_inactive_yn)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($userid)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_modify_date_tz)."',
			'".$lDB->escape($userid)."'			
		)
	");	

	$pg_acc_currency_id = $lDB->insert_id;

	return $pg_acc_currency_id;	
}

function db_pg_acc_currency_update($pg_acc_currency_id,$rf_bank_id,$pg_acc_currency_code,$pg_acc_currency_inactive_yn) {
	global $lDB;
	global $userid;

	if(!db_rf_bank_exists($rf_bank_id)) {
		return false;
	}

	if(empty($pg_acc_currency_inactive_yn)) {
		$pg_acc_currency_inactive_yn = "0";
	} else {
		$pg_acc_currency_inactive_yn = "1";
	}

	$ad_modify_date = date("Y-m-d H:i:s");
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE pg_acc_currency SET
			rf_bank_id = '".$lDB->escape($rf_bank_id)."',
			pg_acc_currency_code = '".$lDB->escape($pg_acc_currency_code)."',
			pg_acc_currency_inactive_yn = '".$lDB->escape($pg_acc_currency_inactive_yn)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($userid)."'
		WHERE
			pg_acc_currency_ix = '$pg_acc_currency_id'
	");
		
}

function db_pg_acc_currency_get_by_all($pg_account_id,$rf_currency_id) {
	return $GLOBALS['lDB']->get("SELECT pg_acc_currency_ix FROM pg_acc_currency WHERE pg_account_id = '$pg_account_id' AND rf_currency_id = '$rf_currency_id'",4);
}

function db_pg_acc_currency_set($pg_account_id,$rf_currency_id,$rf_bank_id,$pg_acc_currency_code,$pg_acc_currency_inactive_yn) {
	if(!db_pg_acc_currency_exists_by_all($pg_account_id,$rf_currency_id)) {
		db_pg_acc_currency_insert($pg_account_id,$rf_currency_id,$rf_bank_id,$pg_acc_currency_code,$pg_acc_currency_inactive_yn);
	} else {
		$pg_acc_currency_id = db_pg_acc_currency_get_by_all($pg_account_id,$rf_currency_id);
		db_pg_acc_currency_update($pg_acc_currency_id,$rf_bank_id,$pg_acc_currency_code,$pg_acc_currency_inactive_yn);
	}
}

function db_pg_acc_currency_delete($pg_acc_currency_id) {
	if(!db_pg_acc_currency_exists($pg_acc_currency_id)) {
		return false;
	}

	$GLOBALS['lDB']->put("DELETE FROM pg_acc_currency WHERE pg_acc_currency_ix = '$pg_acc_currency_id'");
}

function db_pg_acc_currency_delete_by_account($pg_account_id) {
	$list = $GLOBALS['lDB']->get("SELECT pg_acc_currency_ix FROM pg_acc_currency WHERE pg_account_id = '$pg_account_id'",3);
	foreach($list as $item) {
		db_pg_acc_currency_delete($item);
	}
}
