<?php

require_once(__DIR__ . "/db.pg_account.php");
require_once(__DIR__ . "/db.pg_type_obj.php");

function db_pg_acc_obj_data_exists($pg_acc_obj_data_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(pg_acc_obj_data_ix) FROM pg_acc_obj_data WHERE pg_acc_obj_data_ix = '$pg_acc_obj_data_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_pg_acc_obj_data_exists_by_all($pg_account_id,$pg_type_obj_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(pg_acc_obj_data_ix) FROM pg_acc_obj_data WHERE pg_account_id = '$pg_account_id' AND pg_type_obj_id = '$pg_type_obj_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_pg_acc_obj_data_insert($pg_account_id,$pg_type_obj_id,$pg_acc_obj_data,$pg_type_obj_data_id) {
	global $lDB;
	global $dbcode;
	global $userid;

	if(!db_pg_account_exists($pg_account_id)) {
		return false;
	}

	if(!db_pg_type_obj_exists($pg_type_obj_id)) {
		return false;
	}	

	$ad_create_date = date("Y-m-d H:i:s");
	$ad_create_date_tz = $ad_modify_date_tz = date("e");

	$lDB->put("
		INSERT INTO pg_acc_obj_data (
			pg_acc_obj_data_db,
			pg_account_id,
			pg_type_obj_id,
			pg_acc_obj_data,
			pg_type_obj_data_id,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pg_account_id)."',
			'".$lDB->escape($pg_type_obj_id)."',
			'".$lDB->escape($pg_acc_obj_data)."',
			'".$lDB->escape($pg_type_obj_data_id)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($userid)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_modify_date_tz)."',
			'".$lDB->escape($userid)."'			
		)
	");	

	$pg_acc_obj_data_id = $lDB->insert_id;

	return $pg_acc_obj_data_id;	
}

function db_pg_acc_obj_data_update($pg_acc_obj_data_id,$pg_acc_obj_data,$pg_type_obj_data_id) {
	global $lDB;
	global $userid;

	if(!db_pg_acc_obj_data_exists($pg_acc_obj_data_id)) {
		return false;
	}

	$ad_modify_date = date("Y-m-d H:i:s");
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE pg_acc_obj_data SET
			pg_acc_obj_data = '".$lDB->escape($pg_acc_obj_data)."',
			pg_type_obj_data_id = '".$lDB->escape($pg_type_obj_data_id)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($userid)."'
		WHERE
			pg_acc_obj_data_ix = '$pg_acc_obj_data_id'
	");
}

function db_pg_acc_obj_data_get_by_all($pg_account_id,$pg_type_obj_id) {
	return $GLOBALS['lDB']->get("SELECT pg_acc_obj_data_ix FROM pg_acc_obj_data WHERE pg_account_id = '$pg_account_id' AND pg_type_obj_id = '$pg_type_obj_id'",4);
}

function db_pg_acc_obj_data_get_by_name($pg_account_id,$pg_type_obj_name) {
	global $lDB;

	return $lDB->get("
		SELECT
			pg_acc_obj_data.pg_acc_obj_data
		FROM
			pg_acc_obj_data
			INNER JOIN pg_account ON pg_account.pg_account_ix = pg_acc_obj_data.pg_account_id
			INNER JOIN pg_type_obj ON pg_type_obj.pg_type_obj_ix = pg_acc_obj_data.pg_type_obj_id
		WHERE
			pg_account.pg_account_ix = '$pg_account_id'
			AND pg_type_obj.pg_type_obj_name = '$pg_type_obj_name'
	",4);
}

function db_pg_acc_obj_data_set($pg_account_id,$pg_type_obj_id,$pg_acc_obj_data,$pg_type_obj_data_id) {
	if(db_pg_type_obj_get_ind($pg_type_obj_id) == "6" && $pg_acc_obj_data == "********") {
		return false;
	}
	if(!db_pg_acc_obj_data_exists_by_all($pg_account_id,$pg_type_obj_id)) {
		db_pg_acc_obj_data_insert($pg_account_id,$pg_type_obj_id,$pg_acc_obj_data,$pg_type_obj_data_id);
	} else {
		$pg_acc_obj_data_id = db_pg_acc_obj_data_get_by_all($pg_account_id,$pg_type_obj_id);
		db_pg_acc_obj_data_update($pg_acc_obj_data_id,$pg_acc_obj_data,$pg_type_obj_data_id);
	}
}

function db_pg_acc_obj_data_delete($pg_acc_obj_data_id) {
	if(!db_pg_acc_obj_data_exists($pg_acc_obj_data_id)) {
		return false;
	}

	$GLOBALS['lDB']->put("DELETE FROM pg_acc_obj_data WHERE pg_acc_obj_data_ix = '$pg_acc_obj_data_id'");
}

function db_pg_acc_obj_data_delete_by_account($pg_account_id) {
	$list = $GLOBALS['lDB']->get("SELECT pg_acc_obj_data_ix FROM pg_acc_obj_data WHERE pg_account_id = '$pg_account_id'",3);
	foreach($list as $item) {
		db_pg_acc_obj_data_delete($item);
	}
}
