<?php

require_once(__DIR__ . "/db.pg_type.php");
require_once(__DIR__ . "/db.pr_business.php");
require_once(__DIR__ . "/db.rf_currency.php");
require_once(__DIR__ . "/db.rf_mthd_pmnt.php");
require_once(__DIR__ . "/db.rv_payment_gateway.php");

function db_pg_account_exists($pg_account_id) {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(pg_account_ix) FROM pg_account WHERE pg_account_ix = '$pg_account_id'",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_pg_account_exists_by_any() {
	global $lDB;

	$count = $lDB->get("SELECT COUNT(pg_account_ix) FROM pg_account",4);
	if($count > 0 ) {
		return true;
	} else {
		return false;
	}
}

function db_pg_account_insert($pg_type_id,$pg_acc_name,$pg_acc_external_yn,$pg_acc_internal_yn,$pg_acc_public_yn,$rf_mthd_pmnt_id,$pg_account_inactive_yn,$pg_account_sys_code) {
	global $lDB;
	global $dbcode;
	global $userid;

	if(!db_pg_type_exists($pg_type_id)) {
		return false;
	}

	if(!db_rf_mthd_pmnt_exists($rf_mthd_pmnt_id)) {
		return false;
	}

	if(empty($pg_acc_external_yn)) {
		$pg_acc_external_yn = "0";
	} else {
		$pg_acc_external_yn = "1";
	}

	if(empty($pg_acc_internal_yn)) {
		$pg_acc_internal_yn = "0";
	} else {
		$pg_acc_internal_yn = "1";
	}

	if(empty($pg_acc_public_yn)) {
		$pg_acc_public_yn = "0";
	} else {
		$pg_acc_public_yn = "1";
	}

	if(empty($pg_account_inactive_yn)) {
		$pg_account_inactive_yn = "0";
	} else {
		$pg_account_inactive_yn = "1";
	}

	if(empty($pg_account_sys_code)) {
		$pg_account_sys_code = "0";
	} else {
		$pg_account_sys_code = "1";
	}
	

	$ad_create_date = date("Y-m-d H:i:s");
	$ad_create_date_tz = $ad_modify_date_tz = date("e");
	
	$lDB->put("
		INSERT INTO pg_account (
			pg_account_db,
			pg_acc_name,
			pg_acc_external_yn,
			pg_acc_internal_yn,
			pg_acc_public_yn,
			pg_type_id,
			rf_mthd_pmnt_id,
			pg_account_inactive_yn,
			ad_create_date,
			ad_create_date_tz,
			ad_create_user_id,
			ad_modify_date,
			ad_modify_date_tz,
			ad_modify_user_id,
			pg_account_sys_code
		) VALUES (
			'".$lDB->escape($dbcode)."',
			'".$lDB->escape($pg_acc_name)."',
			'".$lDB->escape($pg_acc_external_yn)."',
			'".$lDB->escape($pg_acc_internal_yn)."',
			'".$lDB->escape($pg_acc_public_yn)."',
			'".$lDB->escape($pg_type_id)."',
			'".$lDB->escape($rf_mthd_pmnt_id)."',
			'".$lDB->escape($pg_account_inactive_yn)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_create_date_tz)."',
			'".$lDB->escape($userid)."',
			'".$lDB->escape($ad_create_date)."',
			'".$lDB->escape($ad_modify_date_tz)."',
			'".$lDB->escape($userid)."',
			'".$lDB->escape($pg_account_sys_code)."'
		)
	");

	$pg_account_id = $lDB->insert_id;

	return $pg_account_id;	
}

function db_pg_account_update($pg_account_id,$pg_acc_name,$pg_acc_external_yn,$pg_acc_internal_yn,$pg_acc_public_yn,$rf_mthd_pmnt_id,$pg_account_inactive_yn,$pg_account_sys_code) {
	global $lDB;
	global $userid;

	if(!db_pg_account_exists($pg_account_id)) {
		return false;
	}

	if(!db_rf_mthd_pmnt_exists($rf_mthd_pmnt_id)) {
		return false;
	}

	if(empty($pg_acc_external_yn)) {
		$pg_acc_external_yn = "0";
	} else {
		$pg_acc_external_yn = "1";
	}

	if(empty($pg_acc_internal_yn)) {
		$pg_acc_internal_yn = "0";
	} else {
		$pg_acc_internal_yn = "1";
	}

	if(empty($pg_acc_public_yn)) {
		$pg_acc_public_yn = "0";
	} else {
		$pg_acc_public_yn = "1";
	}

	if(empty($pg_account_inactive_yn)) {
		$pg_account_inactive_yn = "0";
	} else {
		$pg_account_inactive_yn = "1";
	}

	if(empty($pg_account_sys_code)) {
		$pg_account_sys_code = "0";
	} else {
		$pg_account_sys_code = "1";
	}
	
	$ad_modify_date = date("Y-m-d H:i:s");
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE pg_account SET
			pg_acc_name = '".$lDB->escape($pg_acc_name)."',
			pg_acc_external_yn = '".$lDB->escape($pg_acc_external_yn)."',
			pg_acc_internal_yn = '".$lDB->escape($pg_acc_internal_yn)."',
			pg_acc_public_yn = '".$lDB->escape($pg_acc_public_yn)."',
			rf_mthd_pmnt_id = '".$lDB->escape($rf_mthd_pmnt_id)."',
			pg_account_inactive_yn = '".$lDB->escape($pg_account_inactive_yn)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($userid)."',
			pg_account_sys_code = '".$lDB->escape($pg_account_sys_code)."'
		WHERE
			pg_account.pg_account_ix = '$pg_account_id'
	");
}

function db_pg_account_set_inactive($pg_account_id,$pg_account_inactive_yn) {
	global $lDB;
	global $userid;

	if(empty($pg_account_inactive_yn)) {
		$pg_account_inactive_yn = "0";
	} else {
		$pg_account_inactive_yn = "1";
	}

	$ad_modify_date = date("Y-m-d H:i:s");
	$ad_modify_date_tz = date("e");

	$lDB->put("
		UPDATE pg_account SET
			pg_account_inactive_yn = '".$lDB->escape($pg_account_inactive_yn)."',
			ad_modify_date = '".$lDB->escape($ad_modify_date)."',
			ad_modify_date_tz = '".$lDB->escape($ad_modify_date_tz)."',
			ad_modify_user_id = '".$lDB->escape($userid)."'
		WHERE
			pg_account.pg_account_ix = '$pg_account_id'
	");		
}

function db_pg_account_delete($pg_account_id) {
	if(db_rv_payment_gateway_exists_by_account($pg_account_id)) {
		db_pg_account_set_inactive($pg_account_id,"1");
	} else {
		db_pg_acc_obj_data_delete_by_account($pg_account_id);
		db_pg_acc_currency_delete_by_account($pg_account_id);
		db_pg_acc_method_delete_by_account($pg_account_id);
		db_pg_acc_business_delete_by_account($pg_account_id);
		$GLOBALS['lDB']->put("DELETE FROM pg_account WHERE pg_account_ix = '$pg_account_id'");
	}
}

function db_pg_account_get_by_folio($folios, $rf_currency_id=false, $allow_sys_code=false) {
	global $lDB;
	global $userStatusId;

	if(!is_array($folios)) {
		if(empty($folios)) {
			return false;
		}

		$folios = array($folios);
	}
	$folioWhere = "fn_folio.fn_folio_ix IN ('".join("','",$folios)."')";

	$where = array(
		"pg_account.pg_account_inactive_yn = '0'",
	);
	if(!$allow_sys_code) {
		$where[] = "
			(
				pg_account.pg_account_sys_code = '0'
				OR pg_account.pg_account_sys_code IS NULL
			)
		";
	}

	if($userStatusId > 1) {
		$where[] = "pg_account.pg_acc_internal_yn = '1'";
	} elseif($userStatusId == 1) {
		$where[] = "pg_account.pg_acc_external_yn = '1'";
	} else {
		$where[] = "pg_account.pg_acc_public_yn = '1'";
	}

	if($rf_currency_id === false) {
		$rf_currency = $lDB->get("SELECT DISTINCT(rf_currency_id) FROM fn_folio WHERE $folioWhere",3);
		if(sizeof($rf_currency) == 0 || sizeof($rf_currency) > 1) {
			return false;
		}
		$rf_currency_id = $rf_currency[0];
	}
	if(!db_rf_currency_exists($rf_currency_id)) {
		return false;
	}
	$where[] = "pg_acc_currency.rf_currency_id = '$rf_currency_id'";

	$pr_business = $lDB->get("SELECT DISTINCT(pr_business_id) FROM fn_folio WHERE $folioWhere",3);
	if(sizeof($pr_business) == 0) {
		return false;
	} elseif(sizeof($pr_business) > 1) {
		$where[] = "pg_acc_business.pr_business_id = '0'";
	} else {
		$where[] = "pg_acc_business.pr_business_id = '".$pr_business[0]."'";
	}

	$from = "
		FROM
			pg_account
			INNER JOIN pg_acc_business ON pg_acc_business.pg_account_id = pg_account.pg_account_ix
			INNER JOIN pg_acc_currency ON pg_acc_currency.pg_account_id = pg_account.pg_account_ix AND pg_acc_currency_inactive_yn = '0'
		WHERE
			".join("\nAND ",$where)."
	";

	$count = $lDB->get("
		SELECT
			COUNT(*)
		$from
	",4);
	
	if($count == 0) {
		return false;
	}

	$pg_account = $lDB->get("
		SELECT
			pg_account.pg_account_ix
		$from
		ORDER BY
			pg_account.pg_acc_name
	",3);
	return $pg_account;
}
